/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import com.eclipsesource.jaxrs.provider.security.AuthenticationHandler;
import com.eclipsesource.jaxrs.provider.security.AuthorizationHandler;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.internal.rest.provider.AuthenticationProviderHolder;
import org.eclipse.kura.internal.rest.provider.CertificateAuthenticationProvider;
import org.eclipse.kura.internal.rest.provider.PasswordAuthenticationProvider;
import org.eclipse.kura.internal.rest.provider.RestServiceOptions;
import org.eclipse.kura.rest.auth.AuthenticationProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestService
implements AuthenticationHandler,
AuthorizationHandler,
ConfigurableComponent,
ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(RestService.class);
    private static final String KURA_PERMISSION_PREFIX = "kura.permission.";
    private static final String KURA_PERMISSION_REST_PREFIX = "kura.permission.rest.";
    private static final String KURA_USER_PREFIX = "kura.user.";
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private static final Response NOT_FOUND_RESPONSE = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    private CryptoService cryptoService;
    private UserAdmin userAdmin;
    RestServiceOptions options;
    private final List<ServiceRegistration<?>> registeredServices = new ArrayList();
    private final Set<AuthenticationProviderHolder> authenticationProviders = new TreeSet<AuthenticationProviderHolder>();
    private AuthenticationProvider passwordAuthProvider;
    private AuthenticationProvider certificateAuthProvider;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    public void setUserAdmin(UserAdmin userAdmin) {
        this.userAdmin = userAdmin;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindAuthenticationProvider(AuthenticationProvider provider) {
        Set<AuthenticationProviderHolder> set = this.authenticationProviders;
        synchronized (set) {
            AuthenticationProviderHolder holder = new AuthenticationProviderHolder(provider);
            this.authenticationProviders.add(holder);
            holder.onEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAuthenticationProvider(AuthenticationProvider provider) {
        Set<AuthenticationProviderHolder> set = this.authenticationProviders;
        synchronized (set) {
            AuthenticationProviderHolder holder = new AuthenticationProviderHolder(provider);
            if (this.authenticationProviders.remove(holder)) {
                holder.onDisabled();
            }
        }
    }

    public void activate(Map<String, Object> properties) {
        logger.info("activating...");
        BundleContext bundleContext = FrameworkUtil.getBundle(RestService.class).getBundleContext();
        this.registeredServices.add(bundleContext.registerService(ContainerRequestFilter.class, (Object)new IncomingPortCheckFilter(), null));
        this.passwordAuthProvider = new PasswordAuthenticationProvider(bundleContext, this.userAdmin, this.cryptoService);
        this.certificateAuthProvider = new CertificateAuthenticationProvider(this.userAdmin);
        this.update(properties);
        logger.info("activating...done");
    }

    public void update(Map<String, Object> properties) {
        logger.info("updating...");
        RestServiceOptions newOptions = new RestServiceOptions(properties);
        if (!Objects.equals(this.options, newOptions)) {
            this.options = newOptions;
            this.updateBuiltinAuthenticationProviders(newOptions);
        }
        logger.info("updating...done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        logger.info("deactivating...");
        for (ServiceRegistration<?> reg : this.registeredServices) {
            reg.unregister();
        }
        Set<AuthenticationProviderHolder> set = this.authenticationProviders;
        synchronized (set) {
            Iterator<AuthenticationProviderHolder> iter = this.authenticationProviders.iterator();
            while (iter.hasNext()) {
                iter.next().onDisabled();
                iter.remove();
            }
        }
        logger.info("deactivating...done");
    }

    public boolean isUserInRole(Principal requestUser, String role) {
        try {
            User user = (User)this.userAdmin.getRole(KURA_USER_PREFIX + requestUser.getName());
            return RestService.containsBasicMember(this.userAdmin.getRole(KURA_PERMISSION_REST_PREFIX + role), user) || RestService.containsBasicMember(this.userAdmin.getRole("kura.permission.kura.admin"), user);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(ContainerRequestContext requestContext) {
        this.initAuditContext(requestContext);
        Set<AuthenticationProviderHolder> set = this.authenticationProviders;
        synchronized (set) {
            for (AuthenticationProviderHolder provider : this.authenticationProviders) {
                Optional<Principal> principal = provider.authenticate(this.request, requestContext);
                if (!principal.isPresent()) continue;
                return principal.get();
            }
        }
        return null;
    }

    public String getAuthenticationScheme() {
        return null;
    }

    private static boolean containsBasicMember(Role group, User user) {
        if (!(group instanceof Group)) {
            return false;
        }
        Group asGroup = (Group)group;
        Role[] members = asGroup.getMembers();
        if (members == null) {
            return false;
        }
        Role[] roleArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            Role member = roleArray[n2];
            if (member.getName().equals(user.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        int responseStatus = responseContext.getStatus();
        AuditContext auditContext = this.initAuditContext(requestContext);
        try {
            if (responseContext.getStatus() == 404) {
                auditLogger.warn("{} Rest - Failure - Service not found", (Object)auditContext);
                return;
            }
            if (responseContext.getStatus() == 403) {
                if (requestContext.getSecurityContext() == null || requestContext.getSecurityContext().getUserPrincipal() == null) {
                    responseContext.setStatus(401);
                } else {
                    auditLogger.warn("{} Rest - Failure - User not authorized to perform the requested operation", (Object)auditContext);
                    return;
                }
            }
            if (responseContext.getStatus() == 401) {
                auditLogger.warn("{} Rest - Failure - User not authenticated", (Object)auditContext);
                return;
            }
            if (responseStatus >= 200 && responseStatus < 400) {
                auditLogger.info("{} Rest - Success - Rest request succeeded", (Object)auditContext);
            } else {
                auditLogger.warn("{} Rest - Failure - Request failed", (Object)auditContext);
            }
        }
        finally {
            this.closeAuditContext(requestContext);
        }
    }

    private String getRequestPath(ContainerRequestContext request) {
        List pathSegments = request.getUriInfo().getPathSegments();
        Iterator iterator = pathSegments.iterator();
        StringBuilder pathBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            pathBuilder.append(((PathSegment)iterator.next()).getPath());
            if (!iterator.hasNext()) continue;
            pathBuilder.append("/");
        }
        return pathBuilder.toString();
    }

    private AuditContext initAuditContext(ContainerRequestContext request) {
        Object rawContext = request.getProperty("org.eclipse.kura.rest.audit.context");
        if (rawContext != null) {
            return (AuditContext)rawContext;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String requestIp = request.getHeaderString("X-FORWARDED-FOR");
        if (requestIp == null) {
            requestIp = this.request.getRemoteAddr();
        }
        properties.put(AuditConstants.KEY_ENTRY_POINT.getValue(), "RestService");
        properties.put(AuditConstants.KEY_IP.getValue(), requestIp);
        properties.put("rest.method", request.getMethod());
        properties.put("rest.path", this.getRequestPath(request));
        AuditContext result = new AuditContext(properties);
        AuditContext.Scope scope = AuditContext.openScope((AuditContext)result);
        request.setProperty("org.eclipse.kura.rest.audit.context", (Object)result);
        request.setProperty("org.eclipse.kura.rest.audit.scope", (Object)scope);
        return result;
    }

    private void closeAuditContext(ContainerRequestContext request) {
        Object rawScope = request.getProperty("org.eclipse.kura.rest.audit.scope");
        if (rawScope instanceof AuditContext.Scope) {
            ((AuditContext.Scope)rawScope).close();
        }
    }

    private void updateBuiltinAuthenticationProviders(RestServiceOptions options) {
        if (options.isPasswordAuthEnabled()) {
            this.bindAuthenticationProvider(this.passwordAuthProvider);
        } else {
            this.unbindAuthenticationProvider(this.passwordAuthProvider);
        }
        if (options.isCertificateAuthEnabled()) {
            this.bindAuthenticationProvider(this.certificateAuthProvider);
        } else {
            this.unbindAuthenticationProvider(this.certificateAuthProvider);
        }
    }

    @Provider
    @Priority(value=900)
    private class IncomingPortCheckFilter
    implements ContainerRequestFilter {
        @Context
        private HttpServletRequest sr;

        private IncomingPortCheckFilter() {
        }

        public void filter(ContainerRequestContext request) throws IOException {
            RestService.this.initAuditContext(request);
            Set<Integer> allowedPorts = RestService.this.options.getAllowedPorts();
            if (allowedPorts.isEmpty()) {
                return;
            }
            int port = this.sr.getLocalPort();
            if (!allowedPorts.contains(port)) {
                request.abortWith(NOT_FOUND_RESPONSE);
            }
        }
    }
}

