/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.persistence;

import io.moquette.spi.IMatchingCondition;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.persistence.MapDBSessionsStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapDBMessagesStore
implements IMessagesStore {
    private static final Logger LOG = LoggerFactory.getLogger(MapDBMessagesStore.class);
    private DB m_db;
    private ConcurrentMap<String, String> m_retainedStore;
    private ConcurrentMap<String, IMessagesStore.StoredMessage> m_persistentMessageStore;

    MapDBMessagesStore(DB db) {
        this.m_db = db;
    }

    @Override
    public void initStore() {
        this.m_retainedStore = this.m_db.getHashMap("retained");
        this.m_persistentMessageStore = this.m_db.getHashMap("persistedMessages");
    }

    @Override
    public void storeRetained(String topic, String guid) {
        this.m_retainedStore.put(topic, guid);
    }

    @Override
    public Collection<IMessagesStore.StoredMessage> searchMatching(IMatchingCondition condition) {
        LOG.debug("searchMatching scanning all retained messages, presents are {}", (Object)this.m_retainedStore.size());
        ArrayList<IMessagesStore.StoredMessage> results = new ArrayList<IMessagesStore.StoredMessage>();
        for (Map.Entry entry : this.m_retainedStore.entrySet()) {
            String guid = (String)entry.getValue();
            IMessagesStore.StoredMessage storedMsg = (IMessagesStore.StoredMessage)this.m_persistentMessageStore.get(guid);
            if (!condition.match((String)entry.getKey())) continue;
            results.add(storedMsg);
        }
        return results;
    }

    @Override
    public String storePublishForFuture(IMessagesStore.StoredMessage evt) {
        LOG.debug("storePublishForFuture store evt {}", (Object)evt);
        if (evt.getClientID() == null) {
            LOG.error("persisting a message without a clientID, bad programming error msg: {}", (Object)evt);
            throw new IllegalArgumentException("\"persisting a message without a clientID, bad programming error");
        }
        String guid = UUID.randomUUID().toString();
        evt.setGuid(guid);
        this.m_persistentMessageStore.put(guid, evt);
        HTreeMap<Integer, String> messageIdToGuid = this.m_db.getHashMap(MapDBSessionsStore.messageId2GuidsMapName(evt.getClientID()));
        messageIdToGuid.put(evt.getMessageID(), guid);
        return guid;
    }

    @Override
    public List<IMessagesStore.StoredMessage> listMessagesInSession(Collection<String> guids) {
        ArrayList<IMessagesStore.StoredMessage> ret = new ArrayList<IMessagesStore.StoredMessage>();
        for (String guid : guids) {
            ret.add((IMessagesStore.StoredMessage)this.m_persistentMessageStore.get(guid));
        }
        return ret;
    }

    @Override
    public void dropMessagesInSession(String clientID) {
        this.m_db.getHashMap(MapDBSessionsStore.messageId2GuidsMapName(clientID)).clear();
        this.m_persistentMessageStore.remove(clientID);
    }

    @Override
    public IMessagesStore.StoredMessage getMessageByGuid(String guid) {
        return (IMessagesStore.StoredMessage)this.m_persistentMessageStore.get(guid);
    }

    @Override
    public void cleanRetained(String topic) {
        this.m_retainedStore.remove(topic);
    }
}

