/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.type;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireRecord;

@Converter
public final class TypeConverter {
    private static final WireRecord[] EMPTY_RECORDS = new WireRecord[0];

    private TypeConverter() {
    }

    @Converter
    public static KuraPayload fromMap(Map<String, ?> data) {
        if (data == null) {
            return null;
        }
        KuraPayload result = new KuraPayload();
        result.setTimestamp(new Date());
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            result.addMetric(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Converter
    public static WireRecord[] recordsFromEnvelope(WireEnvelope envelope) {
        return TypeConverter.recordsFromList(envelope.getRecords());
    }

    @Converter
    public static WireRecord[] recordsFromRecord(WireRecord record) {
        return new WireRecord[]{record};
    }

    @Converter
    public static WireRecord[] recordsFromList(List<WireRecord> records) {
        return records.toArray(new WireRecord[records.size()]);
    }

    @Converter
    public static WireRecord[] recordsFromMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            return EMPTY_RECORDS;
        }
        HashMap<String, TypedValue> result = new HashMap<String, TypedValue>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object keyValue = entry.getKey();
            if (keyValue == null) continue;
            if (entry.getValue() instanceof TypedValue) {
                result.put(keyValue.toString(), (TypedValue)entry.getValue());
                continue;
            }
            result.put(keyValue.toString(), TypedValues.newTypedValue(entry.getValue()));
        }
        return TypeConverter.recordsFromRecord(new WireRecord(result));
    }

    @Converter
    public static Map<?, ?> mapFromRecord(WireRecord record) {
        HashMap result = new HashMap(record.getProperties().size());
        for (Map.Entry entry : record.getProperties().entrySet()) {
            result.put(entry.getKey(), ((TypedValue)entry.getValue()).getValue());
        }
        return result;
    }

    @Converter
    public static Map<?, ?> mapFromRecords(WireRecord[] records) {
        HashMap result = new HashMap();
        WireRecord[] wireRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            WireRecord record = wireRecordArray[n2];
            for (Map.Entry entry : record.getProperties().entrySet()) {
                result.put(entry.getKey(), ((TypedValue)entry.getValue()).getValue());
            }
            ++n2;
        }
        return result;
    }
}

