/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.commons.SnippetsBuilder;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.MarkupContentFactory;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.MarkupContent;

public class XMLGenerator {
    private final SharedSettings sharedSettings;
    private final String whitespacesIndent;
    private final String lineDelimiter;
    private final boolean canSupportSnippets;
    private final boolean autoCloseTags;
    private int maxLevel;

    public XMLGenerator(SharedSettings sharedSettings, String whitespacesIndent, String lineDelimiter, boolean canSupportSnippets, int maxLevel) {
        this(sharedSettings, true, whitespacesIndent, lineDelimiter, canSupportSnippets, maxLevel);
    }

    public XMLGenerator(SharedSettings sharedSettings, boolean autoCloseTags, String whitespacesIndent, String lineDelimiter, boolean canSupportSnippets, int maxLevel) {
        this.sharedSettings = sharedSettings;
        this.autoCloseTags = autoCloseTags;
        this.whitespacesIndent = whitespacesIndent;
        this.lineDelimiter = lineDelimiter;
        this.canSupportSnippets = canSupportSnippets;
    }

    public String generate(CMElementDeclaration elementDeclaration, String prefix, boolean generateEndTag) {
        XMLBuilder xml = new XMLBuilder(this.sharedSettings, this.whitespacesIndent, this.lineDelimiter);
        this.generate(elementDeclaration, prefix, generateEndTag, 0, 0, xml, new ArrayList<CMElementDeclaration>());
        if (this.canSupportSnippets) {
            xml.addContent(SnippetsBuilder.tabstops(0));
        }
        return xml.toString();
    }

    private int generate(CMElementDeclaration elementDeclaration, String prefix, boolean generateEndTag, int level, int snippetIndex, XMLBuilder xml, List<CMElementDeclaration> generatedElements) {
        if (generatedElements.contains(elementDeclaration)) {
            return snippetIndex;
        }
        boolean autoCloseTags = this.autoCloseTags && generateEndTag;
        generatedElements.add(elementDeclaration);
        if (level > 0) {
            xml.linefeed();
            xml.indent(level);
        }
        xml.startElement(prefix, elementDeclaration.getName(), false);
        Collection<CMAttributeDeclaration> attributes = elementDeclaration.getAttributes();
        snippetIndex = this.generate(attributes, level, snippetIndex, xml, elementDeclaration.getName());
        Collection<CMElementDeclaration> children = elementDeclaration.getElements();
        if (children.size() > 0) {
            xml.closeStartElement();
            if (level > this.maxLevel) {
                ++level;
                for (CMElementDeclaration child : children) {
                    snippetIndex = this.generate(child, prefix, true, level, snippetIndex, xml, generatedElements);
                }
                xml.linefeed();
                xml.indent(--level);
            } else if (this.canSupportSnippets) {
                xml.addContent(SnippetsBuilder.tabstops(++snippetIndex));
            }
            if (autoCloseTags) {
                xml.endElement(prefix, elementDeclaration.getName());
            }
        } else if (elementDeclaration.isEmpty() && autoCloseTags) {
            xml.selfCloseElement();
        } else {
            xml.closeStartElement();
            Collection<String> values = elementDeclaration.getEnumerationValues();
            if (!values.isEmpty()) {
                if (this.canSupportSnippets) {
                    xml.addContent(SnippetsBuilder.choice(++snippetIndex, values));
                } else {
                    xml.addContent(values.iterator().next());
                }
            }
            if (this.canSupportSnippets) {
                xml.addContent(SnippetsBuilder.tabstops(++snippetIndex));
            }
            if (autoCloseTags) {
                xml.endElement(prefix, elementDeclaration.getName());
            }
        }
        return snippetIndex;
    }

    public String generate(Collection<CMAttributeDeclaration> attributes, String tagName) {
        XMLBuilder xml = new XMLBuilder(this.sharedSettings, this.whitespacesIndent, this.lineDelimiter);
        this.generate(attributes, 0, 0, xml, tagName);
        return xml.toString();
    }

    private int generate(Collection<CMAttributeDeclaration> attributes, int level, int snippetIndex, XMLBuilder xml, String tagName) {
        ArrayList<CMAttributeDeclaration> requiredAttributes = new ArrayList<CMAttributeDeclaration>();
        for (CMAttributeDeclaration att : attributes) {
            if (!att.isRequired()) continue;
            requiredAttributes.add(att);
        }
        int attributesSize = requiredAttributes.size();
        for (CMAttributeDeclaration attributeDeclaration : requiredAttributes) {
            if (this.canSupportSnippets) {
                ++snippetIndex;
            }
            String defaultValue = attributeDeclaration.getDefaultValue();
            Collection<String> enumerationValues = attributeDeclaration.getEnumerationValues();
            String value = XMLGenerator.generateAttributeValue(defaultValue, enumerationValues, this.canSupportSnippets, snippetIndex, false, this.sharedSettings);
            if (attributesSize != 1) {
                xml.addAttribute(attributeDeclaration.getName(), value, level, true);
                continue;
            }
            xml.addSingleAttribute(attributeDeclaration.getName(), value, true);
        }
        return snippetIndex;
    }

    public static String generateAttributeValue(String defaultValue, Collection<String> enumerationValues, boolean canSupportSnippets, int snippetIndex, boolean withQuote, SharedSettings sharedSettings) {
        StringBuilder value = new StringBuilder();
        String quotation = sharedSettings.getPreferences().getQuotationAsString();
        if (withQuote) {
            value.append("=" + quotation);
        }
        if (!canSupportSnippets) {
            if (defaultValue != null) {
                value.append(defaultValue);
            }
        } else if (enumerationValues != null && !enumerationValues.isEmpty()) {
            SnippetsBuilder.choice(snippetIndex, enumerationValues, value);
        } else if (defaultValue != null) {
            SnippetsBuilder.placeholders(snippetIndex, defaultValue, value);
        } else {
            SnippetsBuilder.tabstops(snippetIndex, value);
        }
        if (withQuote) {
            value.append(quotation);
            if (canSupportSnippets) {
                SnippetsBuilder.tabstops(0, value);
            }
        }
        return value.toString();
    }

    public static String generateDocumentation(String documentation, String schemaURI, boolean html) {
        if (StringUtils.isBlank(documentation)) {
            return null;
        }
        StringBuilder doc = new StringBuilder(documentation);
        if (schemaURI != null) {
            doc.append(System.lineSeparator());
            doc.append(System.lineSeparator());
            if (html) {
                doc.append("<p>");
            }
            doc.append("Source: ");
            if (html) {
                doc.append("<a href=\"");
                doc.append(schemaURI);
                doc.append("\">");
            }
            doc.append(XMLGenerator.getFileName(schemaURI));
            if (html) {
                doc.append("</a>");
                doc.append("</p>");
            }
        }
        return doc.toString();
    }

    private static String getFileName(String schemaURI) {
        int index = schemaURI.lastIndexOf(47);
        if (index == -1) {
            index = schemaURI.lastIndexOf(92);
        }
        if (index == -1) {
            return schemaURI;
        }
        return schemaURI.substring(index + 1, schemaURI.length());
    }

    public static MarkupContent createMarkupContent(CMElementDeclaration cmElement, ISharedSettingsRequest support) {
        String documentation = XMLGenerator.generateDocumentation(cmElement.getDocumentation(support), cmElement.getDocumentURI(), support.canSupportMarkupKind("markdown"));
        if (documentation != null) {
            return MarkupContentFactory.createMarkupContent(documentation, "markdown", support);
        }
        return null;
    }

    public static MarkupContent createMarkupContent(CMAttributeDeclaration cmAttribute, CMElementDeclaration ownerElement, ISharedSettingsRequest request) {
        String documentation = XMLGenerator.generateDocumentation(cmAttribute.getDocumentation(request), ownerElement.getDocumentURI(), request.canSupportMarkupKind("markdown"));
        if (documentation != null) {
            return MarkupContentFactory.createMarkupContent(documentation, "markdown", request);
        }
        return null;
    }

    public static MarkupContent createMarkupContent(CMAttributeDeclaration cmAttribute, String attributeValue, CMElementDeclaration ownerElement, ISharedSettingsRequest support) {
        String documentation = XMLGenerator.generateDocumentation(cmAttribute.getValueDocumentation(attributeValue, support), ownerElement.getDocumentURI(), support.canSupportMarkupKind("markdown"));
        if (documentation != null) {
            return MarkupContentFactory.createMarkupContent(documentation, "markdown", support);
        }
        return null;
    }

    public static MarkupContent createMarkupContent(CMElementDeclaration cmElement, String textContent, ISharedSettingsRequest support) {
        String documentation = XMLGenerator.generateDocumentation(cmElement.getValueDocumentation(textContent), cmElement.getDocumentURI(), support.canSupportMarkupKind("markdown"));
        if (documentation != null) {
            return MarkupContentFactory.createMarkupContent(documentation, "markdown", support);
        }
        return null;
    }
}

