/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.general.completion;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.ICompletionResponse;
import org.eclipse.lemminx.utils.CompletionSortTextHelper;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.OSUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class FilePathCompletionParticipant
extends CompletionParticipantAdapter {
    private static final Logger LOGGER = Logger.getLogger(FilePathCompletionParticipant.class.getName());

    @Override
    public void onAttributeValue(String value, ICompletionRequest request, ICompletionResponse response) throws Exception {
        FilePathCompletionParticipant.addCompletionItems(value, request, response);
    }

    @Override
    public void onDTDSystemId(String value, ICompletionRequest request, ICompletionResponse response) throws Exception {
        FilePathCompletionParticipant.addCompletionItems(value, request, response);
    }

    private static void addCompletionItems(String value, ICompletionRequest request, ICompletionResponse response) throws Exception {
        Path validAttributePath;
        String originalValuePath;
        String fullValue = value;
        if (StringUtils.isEmpty(fullValue)) {
            return;
        }
        DOMDocument xmlDocument = request.getXMLDocument();
        String text = xmlDocument.getText();
        int valuePathStartOffset = xmlDocument.offsetAt(request.getReplaceRange().getStart());
        int endPathOffset = request.getOffset();
        int startPathOffset = StringUtils.getOffsetAfterWhitespace(fullValue, endPathOffset - valuePathStartOffset) + valuePathStartOffset;
        Range filePathRange = XMLPositionUtility.createRange(startPathOffset, endPathOffset, xmlDocument);
        String valuePath = originalValuePath = text.substring(startPathOffset, endPathOffset);
        String slashInAttribute = FilesUtils.getFilePathSlash(valuePath);
        boolean hasFileScheme = valuePath.startsWith("file://");
        if (hasFileScheme) {
            if ((valuePath = FilesUtils.removeFileScheme(valuePath)).length() == 0 || valuePath.charAt(0) != '/') {
                return;
            }
            if (OSUtils.isWindows && (valuePath = valuePath.substring(1, valuePath.length())).length() == 1) {
                File[] drives;
                Range replaceRange = FilePathCompletionParticipant.adjustReplaceRange(xmlDocument, filePathRange, originalValuePath, "/");
                for (File drive : drives = File.listRoots()) {
                    FilePathCompletionParticipant.createFilePathCompletionItem(drive, replaceRange, response, "/");
                }
                return;
            }
        }
        if (!OSUtils.isWindows && "\\".equals(slashInAttribute)) {
            valuePath = valuePath.replace("\\", "/");
        }
        if ((validAttributePath = FilePathCompletionParticipant.getPath(valuePath, xmlDocument.getTextDocument().getUri())) == null) {
            return;
        }
        Range replaceRange = FilePathCompletionParticipant.adjustReplaceRange(xmlDocument, filePathRange, originalValuePath, slashInAttribute);
        FilePathCompletionParticipant.createNextValidCompletionPaths(validAttributePath, slashInAttribute, replaceRange, response, null);
    }

    private static Path getPath(String valuePath, String xmlFileUri) {
        try {
            Path validAttributePath = FilesUtils.getPath(valuePath);
            if (!validAttributePath.isAbsolute()) {
                Path workingDirectoryPath = FilesUtils.getPath(xmlFileUri).getParent();
                validAttributePath = workingDirectoryPath.resolve(validAttributePath).normalize();
            }
            if (!(".".equals(valuePath) || valuePath.endsWith("/") || valuePath.endsWith("\\"))) {
                validAttributePath = validAttributePath.getParent();
            }
            return Files.exists(validAttributePath, new LinkOption[0]) ? validAttributePath : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Range adjustReplaceRange(DOMDocument xmlDocument, Range fullRange, String attributeValue, String slash) {
        int startOffset;
        Position replaceStart = null;
        Position currentEnd = fullRange.getEnd();
        try {
            startOffset = xmlDocument.offsetAt(fullRange.getStart());
        }
        catch (BadLocationException e) {
            return null;
        }
        int lastSlashIndex = attributeValue.lastIndexOf(slash);
        if (lastSlashIndex > -1) {
            try {
                replaceStart = xmlDocument.positionAt(startOffset + lastSlashIndex);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        Range replaceRange = new Range();
        if (replaceStart != null) {
            replaceRange.setStart(replaceStart);
        } else {
            replaceRange.setStart(currentEnd);
        }
        replaceRange.setEnd(currentEnd);
        return replaceRange;
    }

    private static void createNextValidCompletionPaths(Path pathToAttributeDirectory, String slash, Range replaceRange, ICompletionResponse response, FilenameFilter filter) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pathToAttributeDirectory);){
            for (Path entry : stream) {
                FilePathCompletionParticipant.createFilePathCompletionItem(entry.toFile(), replaceRange, response, slash);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while getting files/directories", e);
        }
    }

    private static void createFilePathCompletionItem(File f, Range replaceRange, ICompletionResponse response, String slash) {
        CompletionItem item = new CompletionItem();
        String fName = FilesUtils.encodePath(f.getName());
        if (OSUtils.isWindows && fName.isEmpty()) {
            fName = f.getPath();
            fName = fName.substring(0, fName.length() - 1);
        }
        String insertText = slash + fName;
        item.setLabel(insertText);
        CompletionItemKind kind = f.isDirectory() ? CompletionItemKind.Folder : CompletionItemKind.File;
        item.setKind(kind);
        item.setSortText(CompletionSortTextHelper.getSortText(kind));
        item.setFilterText(insertText);
        item.setTextEdit(new TextEdit(replaceRange, insertText));
        response.addCompletionItem(item);
    }
}

