/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.services.IXMLDocumentProvider;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class XSLURIResolverExtension
implements URIResolverExtension {
    private static final String XSL_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Transform";
    private static final CacheResourcesManager.ResourceToDeploy XML_SCHEMA_10 = new CacheResourcesManager.ResourceToDeploy("https://www.w3.org/1999/11/xslt10.xsd", "/schemas/xslt/xslt-1.0.xsd");
    private static final Map<String, CacheResourcesManager.ResourceToDeploy> XSL_RESOURCES = new HashMap<String, CacheResourcesManager.ResourceToDeploy>();
    private final IXMLDocumentProvider documentProvider;

    public XSLURIResolverExtension(IXMLDocumentProvider documentProvider) {
        this.documentProvider = documentProvider;
    }

    @Override
    public String resolve(String baseLocation, String publicId, String systemId) {
        if (!XSL_NAMESPACE_URI.equals(publicId)) {
            return null;
        }
        String version = this.getVersion(baseLocation);
        CacheResourcesManager.ResourceToDeploy xmlSchema = XSLURIResolverExtension.getXMLSchemaForXSL(version);
        try {
            Path outFile = CacheResourcesManager.getResourceCachePath(xmlSchema);
            return outFile.toFile().toURI().toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String baseLocation;
        String xslFilePath;
        String publicId = resourceIdentifier.getNamespace();
        if (XSL_NAMESPACE_URI.equals(publicId) && (xslFilePath = this.resolve(baseLocation = resourceIdentifier.getBaseSystemId(), publicId, null)) != null) {
            return new XMLInputSource(publicId, xslFilePath, xslFilePath);
        }
        return null;
    }

    private static CacheResourcesManager.ResourceToDeploy getXMLSchemaForXSL(String version) {
        return XSL_RESOURCES.getOrDefault(version, XML_SCHEMA_10);
    }

    private String getVersion(String uri) {
        String version;
        DOMElement element;
        if (this.documentProvider == null) {
            return null;
        }
        DOMDocument document = this.documentProvider.getDocument(uri);
        if (document != null && (element = document.getDocumentElement()) != null && (version = element.getAttribute("version")) != null) {
            return version;
        }
        return "1.0";
    }

    static {
        XSL_RESOURCES.put("1.0", XML_SCHEMA_10);
        XSL_RESOURCES.put("2.0", new CacheResourcesManager.ResourceToDeploy("https://www.w3.org/2007/schema-for-xslt20.xsd", "/schemas/xslt/xslt-2.0.xsd"));
        XSL_RESOURCES.put("3.0", new CacheResourcesManager.ResourceToDeploy("https://www.w3.org/TR/xslt-30/schema-for-xslt30.xsd", "/schemas/xslt/xslt-3.0.xsd"));
    }
}

