/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.LineIndentInfo;
import org.eclipse.lemminx.services.extensions.IPositionRequest;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lsp4j.Position;

abstract class AbstractPositionRequest
implements IPositionRequest {
    private final DOMDocument xmlDocument;
    private final Position position;
    private final XMLExtensionsRegistry extensionsRegistry;
    private final int offset;
    private final DOMNode node;
    private LineIndentInfo indentInfo;

    public AbstractPositionRequest(DOMDocument xmlDocument, Position position, XMLExtensionsRegistry extensionsRegistry) throws BadLocationException {
        this.xmlDocument = xmlDocument;
        this.position = position;
        this.extensionsRegistry = extensionsRegistry;
        this.offset = xmlDocument.offsetAt(position);
        this.node = this.findNodeAt(xmlDocument, this.offset);
        if (this.node == null) {
            throw new BadLocationException("node is null at offset " + this.offset);
        }
    }

    protected DOMNode findNodeAt(DOMDocument document, int offset) {
        return DOMNode.findNodeOrAttrAt(document, offset);
    }

    @Override
    public DOMNode getNode() {
        return this.node;
    }

    @Override
    public DOMElement getParentElement() {
        DOMNode currentNode = this.getNode();
        if (!currentNode.isElement()) {
            return currentNode.getParentElement();
        }
        DOMElement element = (DOMElement)currentNode;
        if (element.isInStartTag(this.offset) || element.isInEndTag(this.offset) || element.isEndTagClosed() && element.getEnd() <= this.offset) {
            return element.getParentElement();
        }
        return (DOMElement)currentNode;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public DOMDocument getXMLDocument() {
        return this.xmlDocument;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getCurrentTag() {
        if (this.node != null && this.node.isElement() && ((DOMElement)this.node).getTagName() != null) {
            return ((DOMElement)this.node).getTagName();
        }
        return null;
    }

    @Override
    public String getCurrentAttributeName() {
        DOMAttr attr = this.getCurrentAttribute();
        return attr != null ? attr.getName() : null;
    }

    private DOMAttr getCurrentAttribute() {
        if (this.node == null) {
            return null;
        }
        switch (this.node.getNodeType()) {
            case 1: {
                return this.node.findAttrAt(this.offset);
            }
            case 2: {
                return (DOMAttr)this.node;
            }
        }
        return null;
    }

    @Override
    public LineIndentInfo getLineIndentInfo() throws BadLocationException {
        if (this.indentInfo == null) {
            int lineNumber = this.getPosition().getLine();
            this.indentInfo = this.getXMLDocument().getLineIndentInfo(lineNumber);
        }
        return this.indentInfo;
    }

    @Override
    public <T> T getComponent(Class clazz) {
        return this.extensionsRegistry.getComponent(clazz);
    }
}

