/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.utils.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.TypeInfo;

public class DOMAttr
extends DOMNode
implements Attr {
    private final String name;
    private final DOMNode nodeAttrName;
    private DOMNode nodeAttrValue;
    private String quotelessValue;
    private String originalValue;
    private final DOMNode ownerElement;
    private boolean hasDelimiter;
    public static final String XMLNS_ATTR = "xmlns";
    public static final String XMLNS_NO_DEFAULT_ATTR = "xmlns:";

    public DOMAttr(String name, DOMNode ownerElement) {
        this(name, -1, -1, ownerElement);
    }

    public DOMAttr(String name, int start, int end, DOMNode ownerElement) {
        super(-1, -1);
        this.name = name;
        this.nodeAttrName = start != -1 ? new AttrNameOrValue(start, end) : null;
        this.ownerElement = ownerElement;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public String getLocalName() {
        int colonIndex = this.name.indexOf(":");
        if (colonIndex > 0) {
            return this.name.substring(colonIndex + 1);
        }
        return this.name;
    }

    @Override
    public DOMElement getOwnerElement() {
        return this.ownerElement.isElement() ? (DOMElement)this.ownerElement : null;
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return this.ownerElement != null ? this.ownerElement.getOwnerDocument() : null;
    }

    @Override
    public String getValue() {
        return this.quotelessValue;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getSpecified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(String value) throws DOMException {
        this.setValue(value, -1, -1);
    }

    public DOMNode getNodeAttrName() {
        return this.nodeAttrName;
    }

    public void setDelimiter(boolean hasDelimiter) {
        this.hasDelimiter = hasDelimiter;
    }

    public boolean hasDelimiter() {
        return this.hasDelimiter;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setValue(String value, int start, int end) {
        this.originalValue = value;
        this.quotelessValue = StringUtils.convertToQuotelessValue(value);
        this.nodeAttrValue = start != -1 ? new AttrNameOrValue(start, end) : null;
    }

    public DOMNode getNodeAttrValue() {
        return this.nodeAttrValue;
    }

    public void setNodeAttrValue(DOMNode nodeAttrValue) {
        this.nodeAttrValue = nodeAttrValue;
    }

    public boolean valueContainsOffset(int offset) {
        return this.nodeAttrValue != null && offset >= this.nodeAttrValue.getStart() && offset < this.nodeAttrValue.getEnd();
    }

    @Override
    public String getPrefix() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        String prefix = null;
        int index = name.indexOf(":");
        if (index != -1) {
            prefix = name.substring(0, index);
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI() {
        if (this.ownerElement == null || this.ownerElement.getNodeType() != 1) {
            return null;
        }
        String prefix = this.getPrefix();
        return ((DOMElement)this.ownerElement).getNamespaceURI(prefix);
    }

    public boolean isXmlns() {
        return DOMAttr.isXmlns(this.name);
    }

    public static boolean isXmlns(String attributeName) {
        return attributeName.startsWith(XMLNS_ATTR);
    }

    public boolean isDefaultXmlns() {
        return DOMAttr.isDefaultXmlns(this.name);
    }

    public static boolean isDefaultXmlns(String attributeName) {
        return attributeName.equals(XMLNS_ATTR);
    }

    public String extractPrefixFromXmlns() {
        if (this.isDefaultXmlns()) {
            return this.name.substring(XMLNS_ATTR.length(), this.name.length());
        }
        return this.name.substring(XMLNS_NO_DEFAULT_ATTR.length(), this.name.length());
    }

    public String getPrefixIfMatchesURI(String uri) {
        if (this.isXmlns() && this.quotelessValue != null && this.quotelessValue.equals(uri)) {
            if (this.isDefaultXmlns()) {
                return null;
            }
            return this.extractPrefixFromXmlns();
        }
        return null;
    }

    public boolean isNoDefaultXmlns() {
        return DOMAttr.isNoDefaultXmlns(this.name);
    }

    public static boolean isNoDefaultXmlns(String attributeName) {
        return attributeName.startsWith(XMLNS_NO_DEFAULT_ATTR);
    }

    @Override
    public DOMNode getNextSibling() {
        DOMElement parentNode = this.getOwnerElement();
        if (parentNode == null) {
            return null;
        }
        List<DOMAttr> children = parentNode.getAttributeNodes();
        int nextIndex = children.indexOf(this) + 1;
        return nextIndex < children.size() ? (DOMNode)children.get(nextIndex) : null;
    }

    public boolean isIncluded(int offset) {
        return DOMNode.isIncluded(this.getStart(), this.getEnd(), offset);
    }

    @Override
    public int getStart() {
        return this.nodeAttrName.start;
    }

    @Override
    public int getEnd() {
        return this.nodeAttrValue != null ? this.nodeAttrValue.end : this.nodeAttrName.end;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.quotelessValue == null ? 0 : this.quotelessValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMAttr other = (DOMAttr)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.quotelessValue == null ? other.quotelessValue != null : !this.quotelessValue.equals(other.quotelessValue));
    }

    class AttrNameOrValue
    extends DOMNode {
        public AttrNameOrValue(int start, int end) {
            super(start, end);
        }

        @Override
        public String getNodeName() {
            return null;
        }

        @Override
        public short getNodeType() {
            return -1;
        }

        public DOMAttr getOwnerAttr() {
            return DOMAttr.this;
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return this.getOwnerAttr().getOwnerDocument();
        }
    }
}

