/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.util.Properties;
import java.util.ResourceBundle;

public class ServerInfo {
    private Properties sysProps;
    static final String MASTER = "master";
    private static final boolean IS_NATIVE_IMAGE = "Substrate VM".equals(System.getProperty("java.vm.name"));
    private ResourceBundle rb = ResourceBundle.getBundle("git");

    public ServerInfo() {
        this(null);
    }

    ServerInfo(Properties props) {
        this.sysProps = new Properties(props == null ? System.getProperties() : props);
    }

    public String getVersion() {
        return this.rb.getString("git.build.version");
    }

    public String getShortCommitId() {
        return this.rb.getString("git.commit.id.abbrev");
    }

    public String getCommitMessage() {
        return this.rb.getString("git.commit.message.short");
    }

    public String getJava() {
        return this.sysProps.getProperty("java.home", "unknown");
    }

    public String getBranch() {
        return this.rb.getString("git.branch");
    }

    public String toString() {
        return this.getVersion();
    }

    public String details() {
        StringBuilder details = new StringBuilder();
        details.append("LemMinX Server info:");
        this.append(details, "Version", this.getVersion());
        if (IS_NATIVE_IMAGE) {
            this.append(details, "Native Image", null);
        } else {
            this.append(details, "Java", this.getJava());
        }
        this.append(details, "VM Version", System.getProperty("java.vm.version"));
        this.append(details, "Git", null);
        String branch = this.getBranch();
        if (!MASTER.equals(branch)) {
            details.append(" [Branch ").append(branch).append("]");
        }
        details.append(" ").append(this.getShortCommitId()).append(" - ").append(this.getCommitMessage());
        return details.toString();
    }

    private void append(StringBuilder sb, String key, String value) {
        sb.append(System.lineSeparator()).append(" - ").append(key);
        if (value != null) {
            sb.append(" : ").append(value);
        }
    }
}

