/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils.platform;

import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.platform.JVM;
import org.eclipse.lemminx.utils.platform.OS;
import org.eclipse.lemminx.utils.platform.Version;

public class Platform {
    private static final String UNKNOWN_VALUE = "unknown";
    private static final OS os = new OS();
    private static final JVM jvm = new JVM();
    private static final Version version = new Version();
    public static final boolean isWindows = Platform.getOS().isWindows();
    public static String SLASH = isWindows ? "\\" : "/";

    private Platform() {
    }

    public static OS getOS() {
        return os;
    }

    public static JVM getJVM() {
        return jvm;
    }

    public static Version getVersion() {
        return version;
    }

    static String getSystemProperty(String key) {
        try {
            String property = System.getProperty(key);
            return StringUtils.isEmpty(property) ? UNKNOWN_VALUE : property;
        }
        catch (SecurityException e) {
            return UNKNOWN_VALUE;
        }
    }

    public static String details() {
        StringBuilder details = new StringBuilder();
        details.append("LemMinX Server info:");
        Platform.append(details, "Version", version.getVersionNumber());
        if (jvm.isNativeImage()) {
            Platform.append(details, "Native Image", null);
        } else {
            Platform.append(details, "Java", jvm.getJavaHome());
        }
        Platform.append(details, "VM Version", jvm.getVersion());
        Platform.append(details, "Git", null);
        String branch = version.getBranch();
        if (!"master".equals(branch)) {
            details.append(" [Branch ").append(branch).append("]");
        }
        details.append(" ").append(version.getShortCommitId()).append(" - ").append(version.getCommitMessage());
        return details.toString();
    }

    private static void append(StringBuilder sb, String key, String value) {
        sb.append(System.lineSeparator()).append(" - ").append(key);
        if (value != null) {
            sb.append(" : ").append(value);
        }
    }
}

