/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.ExternalResourceErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolvesParticipant;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ContentModelCodeActionParticipant
implements ICodeActionParticipant {
    private final Map<String, ICodeActionParticipant> codeActionParticipants = new HashMap<String, ICodeActionParticipant>();

    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Diagnostic diagnostic = request.getDiagnostic();
        if (diagnostic == null || diagnostic.getCode() == null || !diagnostic.getCode().isLeft()) {
            return;
        }
        SharedSettings sharedSettings = request.getSharedSettings();
        this.registerCodeActionsIfNeeded(sharedSettings);
        ICodeActionParticipant participant = this.codeActionParticipants.get(diagnostic.getCode().getLeft());
        if (participant != null) {
            participant.doCodeAction(request, codeActions, cancelChecker);
        }
    }

    @Override
    public ICodeActionResolvesParticipant getResolveCodeActionParticipant(String participantId) {
        for (ICodeActionParticipant participant : this.codeActionParticipants.values()) {
            ICodeActionResolvesParticipant resolveParticipant = participant.getResolveCodeActionParticipant(participantId);
            if (resolveParticipant == null) continue;
            return resolveParticipant;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCodeActionsIfNeeded(SharedSettings sharedSettings) {
        if (this.codeActionParticipants.isEmpty()) {
            Map<String, ICodeActionParticipant> map = this.codeActionParticipants;
            synchronized (map) {
                if (!this.codeActionParticipants.isEmpty()) {
                    return;
                }
                XMLSyntaxErrorCode.registerCodeActionParticipants(this.codeActionParticipants, sharedSettings);
                DTDErrorCode.registerCodeActionParticipants(this.codeActionParticipants, sharedSettings);
                XMLSchemaErrorCode.registerCodeActionParticipants(this.codeActionParticipants, sharedSettings);
                XSDErrorCode.registerCodeActionParticipants(this.codeActionParticipants);
                ExternalResourceErrorCode.registerCodeActionParticipants(this.codeActionParticipants);
            }
        }
    }
}

