/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMTextFormatter {
    private final XMLFormatterDocumentNew formatterDocument;

    public DOMTextFormatter(XMLFormatterDocumentNew formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatText(DOMText textNode, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        if (this.isPreserveEmptyContent()) {
            return;
        }
        FormatElementCategory formatElementCategory = parentConstraints.getFormatElementCategory();
        String text = this.formatterDocument.getText();
        int availableLineWidth = parentConstraints.getAvailableLineWidth();
        int spaceStart = -1;
        int spaceEnd = -1;
        boolean containsNewLine = false;
        for (int i = textNode.getStart(); i < textNode.getEnd(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (DOMTextFormatter.isLineSeparator(c)) {
                    containsNewLine = true;
                }
                if (spaceStart == -1) {
                    spaceStart = i;
                    continue;
                }
                spaceEnd = i;
                continue;
            }
            spaceEnd = i;
            int contentStart = i;
            while (i + 1 < textNode.getEnd() && !Character.isWhitespace(text.charAt(i + 1))) {
                ++i;
            }
            int contentEnd = i;
            availableLineWidth -= contentEnd + 1 - contentStart;
            if (formatElementCategory != FormatElementCategory.PreserveSpace && formatElementCategory != FormatElementCategory.IgnoreSpace) {
                if (availableLineWidth < 0) {
                    if (spaceStart != -1) {
                        this.insertLineBreak(spaceStart, contentStart, edits);
                        availableLineWidth = this.getMaxLineWidth() - (contentEnd - contentStart + 1);
                    }
                } else if (this.isJoinContentLines() || spaceStart == textNode.getStart() || !containsNewLine) {
                    this.replaceSpacesWithOneSpace(spaceStart, spaceEnd - 1, edits);
                    containsNewLine = false;
                    --availableLineWidth;
                } else {
                    availableLineWidth -= spaceEnd - spaceStart;
                }
            }
            parentConstraints.setAvailableLineWidth(availableLineWidth);
            spaceStart = -1;
            spaceEnd = -1;
        }
        if (formatElementCategory != FormatElementCategory.PreserveSpace && formatElementCategory != FormatElementCategory.IgnoreSpace) {
            this.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
        }
    }

    private static boolean isLineSeparator(char c) {
        return c == '\r' || c == '\n';
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }

    private void insertLineBreak(int start, int end, List<TextEdit> edits) {
        this.formatterDocument.insertLineBreak(start, end, edits);
    }

    private boolean isPreserveEmptyContent() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveEmptyContent();
    }

    private void replaceSpacesWithOneSpace(int spaceStart, int spaceEnd, List<TextEdit> edits) {
        this.formatterDocument.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
    }

    private boolean isJoinContentLines() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isJoinContentLines();
    }
}

