/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Placement;
import org.mandas.docker.client.messages.swarm.Preference;

final class ImmutablePlacement
implements Placement {
    @Nullable
    private final List<String> constraints;
    @Nullable
    private final List<Preference> preferences;
    @Nullable
    private final Integer maxReplicas;

    private ImmutablePlacement(@Nullable List<String> constraints, @Nullable List<Preference> preferences, @Nullable Integer maxReplicas) {
        this.constraints = constraints;
        this.preferences = preferences;
        this.maxReplicas = maxReplicas;
    }

    @Override
    @JsonProperty(value="Constraints")
    @Nullable
    public List<String> constraints() {
        return this.constraints;
    }

    @Override
    @JsonProperty(value="Preferences")
    @Nullable
    public List<Preference> preferences() {
        return this.preferences;
    }

    @Override
    @JsonProperty(value="MaxReplicas")
    @Nullable
    public Integer maxReplicas() {
        return this.maxReplicas;
    }

    public final ImmutablePlacement withConstraints(String ... elements) {
        if (elements == null) {
            return new ImmutablePlacement(null, this.preferences, this.maxReplicas);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutablePlacement.createUnmodifiableList(false, ImmutablePlacement.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlacement(newValue, this.preferences, this.maxReplicas);
    }

    public final ImmutablePlacement withConstraints(@Nullable Iterable<String> elements) {
        if (this.constraints == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutablePlacement.createUnmodifiableList(false, ImmutablePlacement.createSafeList(elements, true, false));
        return new ImmutablePlacement(newValue, this.preferences, this.maxReplicas);
    }

    public final ImmutablePlacement withPreferences(Preference ... elements) {
        if (elements == null) {
            return new ImmutablePlacement(this.constraints, null, this.maxReplicas);
        }
        List<Preference> newValue = Arrays.asList(elements) == null ? null : ImmutablePlacement.createUnmodifiableList(false, ImmutablePlacement.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlacement(this.constraints, newValue, this.maxReplicas);
    }

    public final ImmutablePlacement withPreferences(@Nullable Iterable<? extends Preference> elements) {
        if (this.preferences == elements) {
            return this;
        }
        List<Preference> newValue = elements == null ? null : ImmutablePlacement.createUnmodifiableList(false, ImmutablePlacement.createSafeList(elements, true, false));
        return new ImmutablePlacement(this.constraints, newValue, this.maxReplicas);
    }

    public final ImmutablePlacement withMaxReplicas(@Nullable Integer value) {
        if (Objects.equals(this.maxReplicas, value)) {
            return this;
        }
        return new ImmutablePlacement(this.constraints, this.preferences, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlacement && this.equalTo(0, (ImmutablePlacement)another);
    }

    private boolean equalTo(int synthetic, ImmutablePlacement another) {
        return Objects.equals(this.constraints, another.constraints) && Objects.equals(this.preferences, another.preferences) && Objects.equals(this.maxReplicas, another.maxReplicas);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.constraints);
        h += (h << 5) + Objects.hashCode(this.preferences);
        h += (h << 5) + Objects.hashCode(this.maxReplicas);
        return h;
    }

    public String toString() {
        return "Placement{constraints=" + String.valueOf(this.constraints) + ", preferences=" + String.valueOf(this.preferences) + ", maxReplicas=" + this.maxReplicas + "}";
    }

    public static ImmutablePlacement copyOf(Placement instance) {
        if (instance instanceof ImmutablePlacement) {
            return (ImmutablePlacement)instance;
        }
        return ImmutablePlacement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private List<String> constraints = null;
        private List<Preference> preferences = null;
        private Integer maxReplicas;

        private Builder() {
        }

        public final Builder from(Placement instance) {
            Integer maxReplicasValue;
            List<Preference> preferencesValue;
            Objects.requireNonNull(instance, "instance");
            List<String> constraintsValue = instance.constraints();
            if (constraintsValue != null) {
                this.addAllConstraints(constraintsValue);
            }
            if ((preferencesValue = instance.preferences()) != null) {
                this.addAllPreferences(preferencesValue);
            }
            if ((maxReplicasValue = instance.maxReplicas()) != null) {
                this.maxReplicas(maxReplicasValue);
            }
            return this;
        }

        public final Builder constraint(String element) {
            if (this.constraints == null) {
                this.constraints = new ArrayList<String>();
            }
            this.constraints.add(Objects.requireNonNull(element, "constraints element"));
            return this;
        }

        public final Builder constraints(String ... elements) {
            if (this.constraints == null) {
                this.constraints = new ArrayList<String>();
            }
            for (String element : elements) {
                this.constraints.add(Objects.requireNonNull(element, "constraints element"));
            }
            return this;
        }

        @JsonProperty(value="Constraints")
        public final Builder constraints(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.constraints = null;
                return this;
            }
            this.constraints = new ArrayList<String>();
            return this.addAllConstraints(elements);
        }

        public final Builder addAllConstraints(Iterable<String> elements) {
            Objects.requireNonNull(elements, "constraints element");
            if (this.constraints == null) {
                this.constraints = new ArrayList<String>();
            }
            for (String element : elements) {
                this.constraints.add(Objects.requireNonNull(element, "constraints element"));
            }
            return this;
        }

        public final Builder preference(Preference element) {
            if (this.preferences == null) {
                this.preferences = new ArrayList<Preference>();
            }
            this.preferences.add(Objects.requireNonNull(element, "preferences element"));
            return this;
        }

        public final Builder preferences(Preference ... elements) {
            if (this.preferences == null) {
                this.preferences = new ArrayList<Preference>();
            }
            for (Preference element : elements) {
                this.preferences.add(Objects.requireNonNull(element, "preferences element"));
            }
            return this;
        }

        @JsonProperty(value="Preferences")
        public final Builder preferences(@Nullable Iterable<? extends Preference> elements) {
            if (elements == null) {
                this.preferences = null;
                return this;
            }
            this.preferences = new ArrayList<Preference>();
            return this.addAllPreferences(elements);
        }

        public final Builder addAllPreferences(Iterable<? extends Preference> elements) {
            Objects.requireNonNull(elements, "preferences element");
            if (this.preferences == null) {
                this.preferences = new ArrayList<Preference>();
            }
            for (Preference preference : elements) {
                this.preferences.add(Objects.requireNonNull(preference, "preferences element"));
            }
            return this;
        }

        @JsonProperty(value="MaxReplicas")
        public final Builder maxReplicas(@Nullable Integer maxReplicas) {
            this.maxReplicas = maxReplicas;
            return this;
        }

        public ImmutablePlacement build() {
            return new ImmutablePlacement(this.constraints == null ? null : ImmutablePlacement.createUnmodifiableList(true, this.constraints), this.preferences == null ? null : ImmutablePlacement.createUnmodifiableList(true, this.preferences), this.maxReplicas);
        }
    }
}

