/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.xtend.annotations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.lsat.common.util.BranchIterable;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TypeReferenceUtil {
    private static final Functions.Function2<TypeReference, TypeReference, Integer> TYPE_HIERARCHY_COMPARATOR = (t1, t2) -> {
        boolean _isAssignableFrom_1;
        boolean _isAssignableFrom;
        Object _switchValue = null;
        boolean _matched = false;
        boolean _equals = Objects.equal((Object)t1, (Object)t2);
        if (_equals) {
            _matched = true;
            return 0;
        }
        if (!_matched && (_isAssignableFrom = t1.isAssignableFrom(t2))) {
            _matched = true;
            return 1;
        }
        if (!_matched && (_isAssignableFrom_1 = t2.isAssignableFrom(t1))) {
            _matched = true;
            return -1;
        }
        return 0;
    };

    public static TreeSet<TypeReference> getCommonBaseTypes(Iterable<TypeReference> typeReferences) {
        boolean _not;
        TreeSet commonTypeReferences = CollectionLiterals.newTreeSet((Comparator)new Comparator<TypeReference>(){

            @Override
            public int compare(TypeReference arg0, TypeReference arg1) {
                return (Integer)TYPE_HIERARCHY_COMPARATOR.apply((Object)arg0, (Object)arg1);
            }
        });
        boolean _isEmpty = IterableExtensions.isEmpty(typeReferences);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            BranchIterable<TypeReference> _assignableTypeReferences = TypeReferenceUtil.getAssignableTypeReferences((TypeReference)IterableExtensions.head(typeReferences));
            Iterables.addAll((Collection)commonTypeReferences, _assignableTypeReferences);
            Consumer<TypeReference> _function = it -> commonTypeReferences.retainAll(IterableExtensions.toSet(TypeReferenceUtil.getAssignableTypeReferences(it)));
            IterableExtensions.drop(typeReferences, (int)1).forEach(_function);
        }
        return commonTypeReferences;
    }

    public static BranchIterable<TypeReference> getAssignableTypeReferences(TypeReference typeReference) {
        Functions.Function1 _function = it -> it.getDeclaredSuperTypes();
        return Queries.closure(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{typeReference})), true, _function);
    }

    public static MethodDeclaration findResolvedMethod(TypeReference typeReference, String name, TypeReference ... parameterTypes) {
        Functions.Function1 _function = it -> it.getDeclaration();
        Functions.Function1 _function_1 = it -> {
            String _simpleName = it.getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)name);
        };
        Functions.Function1 _function_2 = it -> {
            Functions.Function1 _function_3 = it_1 -> it_1.getType();
            Iterable _map = IterableExtensions.map((Iterable)it.getParameters(), (Functions.Function1)_function_3);
            return Objects.equal((Object)_map, (Object)parameterTypes);
        };
        return (MethodDeclaration)IterableExtensions.findFirst((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)typeReference.getAllResolvedMethods(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
    }
}

