/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.validation;

import activity.Activity;
import activity.ActivitySet;
import activity.Move;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import machine.ImportContainer;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.emf.common.util.BufferedDiagnosticChain;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.MotionCalculatorHelper;
import org.eclipse.lsat.timing.util.SpecificationException;
import setting.SettingUtil;
import setting.Settings;

public class ActivityEValidator
implements EValidator {
    public static final ActivityEValidator INSTANCE = new ActivityEValidator();

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return eObject == null ? true : this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        BufferedDiagnosticChain bufferedDiagnostics = new BufferedDiagnosticChain(diagnostics);
        if (EcoreUtil.getRootContainer((EObject)eObject) instanceof ActivitySet) {
            this.validateActivitySet((ActivitySet)EcoreUtil.getRootContainer((EObject)eObject), (DiagnosticChain)bufferedDiagnostics);
        }
        return bufferedDiagnostics.getMaxSeverity() < 2;
    }

    private void validateActivitySet(ActivitySet activitySet, DiagnosticChain diagnostics) {
        try {
            Settings settings = SettingUtil.getSettings((ImportContainer)activitySet);
            MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
            MotionCalculatorHelper helper = new MotionCalculatorHelper(settings, motionCalculator);
            for (Activity activity : activitySet.getActivities()) {
                this.validateActivity(activity, helper, diagnostics);
            }
        }
        catch (IOException | MotionException e) {
            this.writeDiagnostic(diagnostics, 1, "Motion calculator validation disabled: " + e.getMessage(), new EObject[]{activitySet});
        }
    }

    private void validateActivity(Activity activity, MotionCalculatorHelper helper, DiagnosticChain diagnostics) {
        LinkedHashSet seen = new LinkedHashSet();
        try {
            activity.allNodesInTopologicalOrder().stream().filter(Move.class::isInstance).map(Move.class::cast).forEach(arg_0 -> this.lambda$2(seen, helper, diagnostics, arg_0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeDiagnostic(DiagnosticChain diagnostics, int severity, String message, EObject ... data) {
        diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.lsat.machine.dsl", 0, message, (Object[])data));
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$2(Set var1_1, MotionCalculatorHelper var2_2, DiagnosticChain var3_3, Move move) {
        block4: {
            if (var1_1.add(move)) {
                concatenatedMove = var2_2.getConcatenatedMove(move);
                var1_1.addAll(concatenatedMove);
                try {
                    var2_2.validate(concatenatedMove);
                    break block4;
                }
                catch (SpecificationException e) {
                    var10_7 = e.getEObjects();
                    var9_8 = var10_7.length;
                    var8_9 = 0;
                    ** while (var8_9 < var9_8)
                }
lbl-1000:
                // 1 sources

                {
                    eObject = var10_7[var8_9];
                    this.writeDiagnostic(var3_3, 4, e.getMessage(), new EObject[]{eObject});
                    ++var8_9;
                    continue;
                }
            }
        }
    }
}

