/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.queries;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.lsat.common.queries.IteratorQueries;
import org.eclipse.lsat.common.util.BranchIterable;
import org.eclipse.lsat.common.util.BranchIterator;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.lsat.common.util.LoggableIterable;
import org.eclipse.lsat.common.util.SuppliedIterable;

public class IterableQueries {
    private IterableQueries() {
    }

    public static <Input> Iterable<Input> including(Iterable<Input> iterable, Iterable<? extends Input> includes) {
        return IterableUtil.join(iterable, includes);
    }

    @SafeVarargs
    public static <Input> Iterable<Input> including(Iterable<Input> iterable, Input ... includes) {
        return IterableQueries.including(iterable, IterableUtil.asList(includes));
    }

    public static <Input> Iterable<Input> excluding(Iterable<Input> iterable, Iterable<?> excludes) {
        return IterableQueries.reject(iterable, i -> IterableUtil.contains(excludes, i));
    }

    @SafeVarargs
    public static <Input> Iterable<Input> excluding(Iterable<Input> iterable, Object ... excludes) {
        return IterableQueries.excluding(iterable, IterableUtil.asList(excludes));
    }

    public static <Input> Iterable<Input> findNearest(BranchIterable<Input> iterable, Predicate<? super Input> predicate) {
        return new SuppliedIterable(() -> IteratorQueries.findNearest(iterable.iterator(), predicate));
    }

    public static <Input, Output> Iterable<Output> findNearest(BranchIterable<Input> iterable, Class<Output> type) {
        return new SuppliedIterable(() -> IteratorQueries.findNearest(iterable.iterator(), type));
    }

    public static <Input> BranchIterable<Input> until(BranchIterable<Input> iterable, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.until((BranchIterator)i, predicate));
    }

    public static <Input> BranchIterable<Input> closure(Iterable<? extends Input> iterable, Function<Input, Iterable<? extends Input>> functor) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.closure(i, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e))));
    }

    public static <Input> BranchIterable<Input> closure(Iterable<? extends Input> iterable, boolean includeSelf, Function<Input, Iterable<? extends Input>> functor) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.closure(i, includeSelf, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e))));
    }

    public static <Input> BranchIterable<Input> closureWhile(Iterable<? extends Input> iterable, Function<Input, Iterable<? extends Input>> functor, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.closureWhile(i, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e)), predicate));
    }

    public static <Input> BranchIterable<Input> closureWhile(Iterable<? extends Input> iterable, boolean includeSelf, Function<Input, Iterable<? extends Input>> functor, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.closureWhile(i, includeSelf, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e)), predicate));
    }

    public static <Input> BranchIterable<Input> closureOne(Iterable<? extends Input> iterable, Function<Input, ? extends Input> functor) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.closureOne(i, functor));
    }

    public static <Input> BranchIterable<Input> closureOne(Iterable<? extends Input> iterable, boolean includeSelf, Function<Input, ? extends Input> functor) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.closureOne(i, includeSelf, functor));
    }

    public static <Input> BranchIterable<Input> closureOneWhile(Iterable<? extends Input> iterable, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.closureOneWhile(i, functor, predicate));
    }

    public static <Input> BranchIterable<Input> closureOneWhile(Iterable<? extends Input> iterable, boolean includeSelf, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.closureOneWhile(i, includeSelf, functor, predicate));
    }

    public static <Input> BranchIterable<Input> climbTree(Iterable<? extends Input> iterable, Function<Input, ? extends Input> functor) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.climbTree(i, functor));
    }

    public static <Input> BranchIterable<Input> climbTree(Iterable<? extends Input> iterable, boolean includeSelf, Function<Input, ? extends Input> functor) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.climbTree(i, includeSelf, functor));
    }

    public static <Input> BranchIterable<Input> climbTreeWhile(Iterable<? extends Input> iterable, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.climbTreeWhile(i, functor, predicate));
    }

    public static <Input> BranchIterable<Input> climbTreeWhile(Iterable<? extends Input> iterable, boolean includeSelf, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.climbTreeWhile(i, includeSelf, functor, predicate));
    }

    public static <Input> BranchIterable<Input> walkTree(Iterable<? extends Input> iterable, Function<Input, Iterable<? extends Input>> functor) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.walkTree(i, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e))));
    }

    public static <Input> BranchIterable<Input> walkTree(Iterable<? extends Input> iterable, boolean includeSelf, Function<Input, Iterable<? extends Input>> functor) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.walkTree(i, includeSelf, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e))));
    }

    public static <Input> BranchIterable<Input> walkTreeWhile(Iterable<? extends Input> iterable, Function<Input, Iterable<? extends Input>> functor, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.walkTreeWhile(i, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e)), predicate));
    }

    public static <Input> BranchIterable<Input> walkTreeWhile(Iterable<? extends Input> iterable, boolean includeSelf, Function<Input, Iterable<? extends Input>> functor, Predicate<? super Input> predicate) {
        return IterableUtil.branchWrap(iterable, i -> IteratorQueries.walkTreeWhile(i, includeSelf, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e)), predicate));
    }

    public static <Input> Iterable<Input> select(Iterable<Input> iterable, Predicate<? super Input> functor) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.select(i, functor));
    }

    public static <Input> Iterable<Input> xselect(Iterable<Input> iterable, Predicate<? super Input> functor) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.xselect(i, functor));
    }

    public static <Input> Iterable<Input> reject(Iterable<Input> iterable, Predicate<? super Input> functor) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.reject(i, functor));
    }

    public static <Input, Output> Iterable<Output> objectsOfKind(Iterable<Input> iterable, Class<Output> outputType) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.objectsOfKind(i, outputType));
    }

    public static <Input, Output> Iterable<Output> objectsOfType(Iterable<Input> iterable, Class<Output> outputType) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.objectsOfType(i, outputType));
    }

    public static <Input, Output> Iterable<Output> asType(Iterable<Input> iterable, Class<Output> outputType) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.asType(i, outputType));
    }

    public static <Input, Output> Iterable<Output> collect(Iterable<? extends Input> iterable, Function<Input, Iterable<? extends Output>> functor) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.collect(i, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e))));
    }

    public static <Input, Output> Iterable<Output> xcollect(Iterable<? extends Input> iterable, Function<Input, Iterable<? extends Output>> functor) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.xcollect(i, (Input e) -> IterableQueries.emptyIfNull((Iterable)functor.apply(e))));
    }

    public static <Input, Output> Iterable<Output> collectOne(Iterable<? extends Input> iterable, Function<Input, Output> functor) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.collectOne(i, functor));
    }

    public static <Input, Output> Iterable<Output> xcollectOne(Iterable<? extends Input> iterable, Function<Input, Output> functor) {
        return IterableUtil.wrap(iterable, i -> IteratorQueries.xcollectOne(i, functor));
    }

    public static <Input> boolean forAll(Iterable<? extends Input> iterable, Predicate<Input> functor) {
        return IteratorQueries.forAll(iterable.iterator(), functor);
    }

    public static <Input> boolean exists(Iterable<? extends Input> iterable, Predicate<Input> functor) {
        return IteratorQueries.exists(iterable.iterator(), functor);
    }

    public static <Input> Input any(Iterable<? extends Input> iterable, Predicate<? super Input> functor) {
        return IteratorQueries.any(iterable.iterator(), functor);
    }

    public static <InputA, InputB> Iterable<Pair<InputA, InputB>> zip(final Iterable<? extends InputA> iterableA, final Iterable<? extends InputB> iterableB) {
        return new LoggableIterable<Pair<InputA, InputB>>(){

            @Override
            public Iterator<Pair<InputA, InputB>> iterator() {
                return IteratorQueries.zip(iterableA.iterator(), iterableB.iterator());
            }
        };
    }

    public static <InputA, InputB> Iterable<Pair<InputA, InputB>> zip(final Iterable<? extends InputA> iterableA, final Iterable<? extends InputB> iterableB, final boolean includeOneSideOnly, final int offset) {
        return new LoggableIterable<Pair<InputA, InputB>>(){

            @Override
            public Iterator<Pair<InputA, InputB>> iterator() {
                return IteratorQueries.zip(iterableA.iterator(), iterableB.iterator(), includeOneSideOnly, offset);
            }
        };
    }

    public static <InputA, InputB> Iterable<Pair<InputA, InputB>> zip(final Iterable<? extends InputA> iterableA, final Iterable<? extends InputB> iterableB, final ToIntBiFunction<? super InputA, ? super InputB> comparator) {
        return new LoggableIterable<Pair<InputA, InputB>>(){

            @Override
            public Iterator<Pair<InputA, InputB>> iterator() {
                return IteratorQueries.zip(iterableA.iterator(), iterableB.iterator(), comparator);
            }
        };
    }

    public static <InputA, InputB> Iterable<Pair<InputA, InputB>> product(final Iterable<? extends InputA> iterableA, final Iterable<? extends InputB> iterableB) {
        return new LoggableIterable<Pair<InputA, InputB>>(){

            @Override
            public Iterator<Pair<InputA, InputB>> iterator() {
                return IteratorQueries.product(iterableA.iterator(), iterableB.iterator());
            }
        };
    }

    public static <Input, K> Map<K, Input> toMap(Iterable<Input> iterable, Function<? super Input, K> computeKeys) {
        return IteratorQueries.toMap(iterable.iterator(), computeKeys);
    }

    public static <Input, K, V> Map<K, V> toMap(Iterable<Input> iterable, Function<? super Input, K> computeKeys, Function<? super Input, V> computeValues) {
        return IteratorQueries.toMap(iterable.iterator(), computeKeys, computeValues);
    }

    public static <Input, K> Map<K, List<Input>> groupBy(Iterable<Input> iterable, Function<? super Input, K> computeKeys) {
        return IteratorQueries.groupBy(iterable.iterator(), computeKeys);
    }

    public static <Input, K, V> Map<K, V> groupByAndReduce(Iterable<Input> iterable, Function<? super Input, K> computeKeys, BiFunction<? super Input, V, ? extends V> computeValues) {
        return IteratorQueries.groupByAndReduce(iterable.iterator(), computeKeys, computeValues);
    }

    private static <T> Iterator<T> emptyIfNull(Iterable<T> iterable) {
        return iterable == null ? Collections.emptyIterator() : iterable.iterator();
    }
}

