/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler.etfgen;

import activity.Activity;
import activity.PeripheralAction;
import activity.TracePoint;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import dispatching.Attribute;
import dispatching.Dispatch;
import dispatching.HasUserAttributes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lsat_graph.ActionTask;
import lsat_graph.ClaimReleaseResource;
import lsat_graph.ClaimTask;
import lsat_graph.ClaimedByScheduledTask;
import lsat_graph.DispatchGraph;
import lsat_graph.DispatchGroupResource;
import lsat_graph.DispatchGroupTask;
import lsat_graph.EventAnnotation;
import lsat_graph.PeripheralActionTask;
import lsat_graph.PeripheralResource;
import lsat_graph.ReleaseTask;
import lsat_graph.StochasticAnnotation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.resources.Resource;
import org.eclipse.lsat.common.scheduler.resources.ResourceContainer;
import org.eclipse.lsat.common.scheduler.schedule.DependencyBoundary;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledDependency;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledDependencyType;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.common.scheduler.schedule.Sequence;
import org.eclipse.lsat.scheduler.etfgen.GanttColor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GenerateAll {
    private static final String PASSING_MOVE_TIMING_GAP = "PassingMoveTimingGap";
    private final Schedule<Task> schedule;
    private final IContainer targetIContainer;
    private final String[] arguments;
    private boolean erroneousPassingMoveColorScheme;
    private boolean criticalPathColorScheme;
    private final boolean stochasticImpactColorScheme;

    public GenerateAll(Schedule<Task> schedule, IContainer targetIContainer, boolean criticalPathColorScheme, boolean stochasticImpactColorScheme, String ... arguments) {
        boolean _not;
        this.schedule = schedule;
        this.targetIContainer = targetIContainer;
        this.arguments = arguments;
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)PASSING_MOVE_TIMING_GAP);
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)schedule.getAspects(), (Functions.Function1)_function));
        this.erroneousPassingMoveColorScheme = _not = !_isEmpty;
        this.criticalPathColorScheme = !this.erroneousPassingMoveColorScheme && criticalPathColorScheme;
        this.stochasticImpactColorScheme = !this.erroneousPassingMoveColorScheme && stochasticImpactColorScheme;
    }

    public IFile generate(IProgressMonitor monitor) throws CoreException, IOException {
        String _name;
        StringConcatenation _builder = new StringConcatenation();
        String _elvis = null;
        String _head = null;
        if ((Iterable)Conversions.doWrapArray((Object)this.arguments) != null) {
            _head = (String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)this.arguments)));
        }
        _elvis = _head != null ? _head : (_name = this.schedule.getName());
        _builder.append(_elvis);
        _builder.append(".etf");
        String etfFileString = _builder.toString();
        Path _path = new Path(etfFileString);
        final IFile etfFile = this.targetIContainer.getFile((IPath)_path);
        Throwable throwable = null;
        Object var9_10 = null;
        try (ByteArrayInputStream contents = new Functions.Function0<ByteArrayInputStream>(){

            public ByteArrayInputStream apply() {
                try {
                    byte[] _bytes = GenerateAll.this.generateETF((Schedule<? extends Task>)GenerateAll.this.schedule).getBytes(etfFile.getCharset(true));
                    return new ByteArrayInputStream(_bytes);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        }.apply();){
            boolean _exists = etfFile.exists();
            if (_exists) {
                etfFile.setContents((InputStream)contents, true, true, monitor);
            } else {
                etfFile.create((InputStream)contents, true, monitor);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(".");
        _builder_1.append(etfFileString);
        _builder_1.append(".view");
        Path _path_1 = new Path(_builder_1.toString());
        final IFile confFile = this.targetIContainer.getFile((IPath)_path_1);
        Throwable throwable3 = null;
        Object var12_16 = null;
        try (ByteArrayInputStream contents = new Functions.Function0<ByteArrayInputStream>(){

            public ByteArrayInputStream apply() {
                try {
                    byte[] _bytes = GenerateAll.this.generateTraceViewConfiguration().getBytes(confFile.getCharset(true));
                    return new ByteArrayInputStream(_bytes);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        }.apply();){
            boolean _not;
            boolean _exists = confFile.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                confFile.create((InputStream)contents, true, monitor);
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        return etfFile;
    }

    public String generateETF(Schedule<? extends Task> schedule) {
        boolean _not;
        Functions.Function1 _function = it -> {
            boolean _isEvent = this.isEvent((Sequence)it);
            return !_isEvent;
        };
        List sequences = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)schedule.getSequences(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> this.isEvent((Sequence)it);
        Iterable eventSequences = IterableExtensions.filter((Iterable)schedule.getSequences(), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> (Sequence)it.getValue();
        Functions.Function1 _function_3 = it -> (Integer)it.getKey();
        Map sequenceIds = IterableExtensions.toMap((Iterable)IterableExtensions.indexed((Iterable)sequences), (Functions.Function1)_function_2, (Functions.Function1)_function_3);
        Functions.Function1 _function_4 = it -> {
            EList _scheduledTasks = it.getScheduledTasks();
            return _scheduledTasks;
        };
        Iterable tasks = IterableExtensions.flatMap((Iterable)schedule.getSequences(), (Functions.Function1)_function_4);
        Functions.Function1 _function_5 = it -> (ScheduledTask)it.getValue();
        Functions.Function1 _function_6 = it -> (Integer)it.getKey();
        Map taskIds = IterableExtensions.toMap((Iterable)IterableExtensions.indexed((Iterable)tasks), (Functions.Function1)_function_5, (Functions.Function1)_function_6);
        Functions.Function1 _function_7 = it -> this.isEvent((ScheduledTask<?>)it);
        Functions.Function1 _function_8 = it -> this.getEventName((ScheduledTask<?>)it);
        List uniqueEvents = IterableExtensions.toList((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)tasks, (Functions.Function1)_function_7), (Functions.Function1)_function_8))));
        Functions.Function1 _function_9 = it -> {
            Functions.Function1 _function_10 = it_1 -> (Integer)taskIds.get(it_1.getTargetNode());
            return IterableExtensions.sortBy((Iterable)it.getOutgoingEdges(), (Functions.Function1)_function_10);
        };
        Iterable dependencies = Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)tasks, (Functions.Function1)_function_9), ScheduledDependency.class);
        Functions.Function1 _function_10 = it -> (ScheduledDependency)it.getValue();
        Functions.Function1 _function_11 = it -> (Integer)it.getKey();
        Map dependencyIds = IterableExtensions.toMap((Iterable)IterableExtensions.indexed((Iterable)dependencies), (Functions.Function1)_function_10, (Functions.Function1)_function_11);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("TU SECONDS");
        _builder.newLine();
        _builder.append("O 0");
        _builder.newLine();
        _builder.append("T");
        _builder.newLine();
        for (Sequence sequence : sequences) {
            _builder.append("R ");
            Integer _get = (Integer)sequenceIds.get(sequence);
            _builder.append((Object)_get);
            _builder.append(" 100.0 true;");
            String _attributes = this.getAttributes(sequence);
            _builder.append(_attributes);
            _builder.newLineIfNotEmpty();
        }
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)eventSequences);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("R ");
            int _size = sequences.size();
            _builder.append((Object)_size);
            _builder.append(" 100.0 true;name=->Events,type=Event");
            _builder.newLineIfNotEmpty();
        }
        for (ScheduledTask task : tasks) {
            _builder.append("C ");
            Integer _get_1 = (Integer)taskIds.get(task);
            _builder.append((Object)_get_1);
            _builder.append(" ");
            String _plainString = task.getStartTime().toPlainString();
            _builder.append(_plainString);
            _builder.append(" ");
            String _plainString_1 = task.getEndTime().toPlainString();
            _builder.append(_plainString_1);
            _builder.append(" ");
            Integer _sequenceId = this.getSequenceId(task, sequenceIds);
            _builder.append((Object)_sequenceId);
            _builder.append(" ");
            String _offsetAndAmount = this.getOffsetAndAmount(task, uniqueEvents);
            _builder.append(_offsetAndAmount);
            _builder.append(";");
            String _attributes_1 = this.getAttributes(task);
            _builder.append(_attributes_1);
            _builder.newLineIfNotEmpty();
        }
        for (ScheduledDependency dependency : dependencies) {
            _builder.append("D ");
            Integer _get_2 = (Integer)dependencyIds.get(dependency);
            _builder.append((Object)_get_2);
            _builder.append(" ");
            int _etfType = this.getEtfType(dependency);
            _builder.append((Object)_etfType);
            _builder.append(" ");
            Integer _get_3 = (Integer)taskIds.get(dependency.getSourceNode());
            _builder.append((Object)_get_3);
            _builder.append(" ");
            Integer _get_4 = (Integer)taskIds.get(dependency.getTargetNode());
            _builder.append((Object)_get_4);
            _builder.append(";");
            String _attributes_2 = this.getAttributes(dependency);
            _builder.append(_attributes_2);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String generateTraceViewConfiguration() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("activityView : false");
        _builder.newLine();
        _builder.append("showClaimLabels : true");
        _builder.newLine();
        _builder.append("claimColoring : color");
        _builder.newLine();
        _builder.append("claimDescribing: name");
        _builder.newLine();
        _builder.append("claimGrouping : description");
        _builder.newLine();
        _builder.append("dependencyColoring : color");
        _builder.newLine();
        _builder.append("dependencyFiltering :  { boundary = Between peripherals within 1 resource , Between peripherals in different resources } ");
        _builder.newLine();
        _builder.append("resourceDescribing: name");
        _builder.newLine();
        _builder.append("resourceFiltering :  { type = Peripheral , Resource, Event }");
        _builder.newLine();
        return _builder.toString();
    }

    private String getAttributes(Sequence<?> sequence) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("name=");
        String _etfName = this.getEtfName(sequence.getResource());
        _builder.append(_etfName);
        _builder.append(",type=");
        String _type = this.getType(sequence.getResource());
        _builder.append(_type);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String _getEtfName(Resource resource) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = resource.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    private String _getEtfName(PeripheralResource resource) {
        StringConcatenation _builder = new StringConcatenation();
        ResourceContainer _container = resource.getContainer();
        String _name = null;
        if (_container != null) {
            _name = _container.getName();
        }
        _builder.append(_name);
        _builder.append(".");
        String _name_1 = resource.getName();
        _builder.append(_name_1);
        return _builder.toString();
    }

    private String getType(Resource resource) {
        String _switchResult = null;
        boolean _matched = false;
        if (resource instanceof DispatchGroupResource) {
            _matched = true;
            _switchResult = "Dispatch offset";
        }
        if (!_matched && resource instanceof PeripheralResource) {
            _matched = true;
            _switchResult = "Peripheral";
        }
        if (!_matched && resource instanceof ClaimReleaseResource) {
            _matched = true;
            _switchResult = "Resource";
        }
        if (!_matched) {
            Class<?> _class = resource.getClass();
            String _plus = "Unsupported type: " + _class;
            throw new IllegalArgumentException(_plus);
        }
        return _switchResult;
    }

    private Integer getSequenceId(ScheduledTask<?> task, Map<Sequence<? extends Task>, Integer> sequenceIds) {
        boolean _isEvent = this.isEvent(task);
        if (_isEvent) {
            return sequenceIds.size();
        }
        return sequenceIds.get(task.getSequence());
    }

    private String getAttributes(ScheduledTask<?> task) {
        boolean _isErroneousPassingMove;
        LinkedHashMap map = CollectionLiterals.newLinkedHashMap();
        String _switchResult = null;
        ScheduledTask<?> it = task;
        boolean _matched = false;
        if (it instanceof ClaimedByScheduledTask && this.stochasticImpactColorScheme) {
            _matched = true;
            _switchResult = "NA";
        }
        if (!_matched && it instanceof ClaimedByScheduledTask && this.criticalPathColorScheme && this.isCritical(((ClaimedByScheduledTask)it).getClaim()) && this.isCritical(((ClaimedByScheduledTask)it).getRelease())) {
            _matched = true;
            _switchResult = "claim and release";
        }
        if (!_matched && it instanceof ClaimedByScheduledTask && this.criticalPathColorScheme && this.isCritical(((ClaimedByScheduledTask)it).getClaim())) {
            _matched = true;
            _switchResult = "claim only";
        }
        if (!_matched && it instanceof ClaimedByScheduledTask && this.criticalPathColorScheme && this.isCritical(((ClaimedByScheduledTask)it).getRelease())) {
            _matched = true;
            _switchResult = "release only";
        }
        if (!_matched && it instanceof ClaimedByScheduledTask && this.criticalPathColorScheme) {
            _matched = true;
            _switchResult = "none";
        }
        if (!_matched && this.stochasticImpactColorScheme) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            BigDecimal _stochasticWeight = this.getStochasticWeight(it);
            BigDecimal _multiply = _stochasticWeight.multiply(BigDecimal.valueOf(100L));
            _builder.append((Object)_multiply);
            _builder.append("%");
            _switchResult = _builder.toString();
        }
        if (!_matched && this.criticalPathColorScheme) {
            _matched = true;
            _switchResult = String.valueOf(this.isCritical(it));
        }
        String critical = _switchResult;
        this.putConditional(map, "name", this.getDisplayName(task));
        map.put("description", this.getDescription(task));
        this.putConditional(map, "type", this.getType(task));
        this.putConditional(map, "color", this.getColor(task));
        this.putConditional(map, "critical", critical);
        this.putConditional(map, "activity", this.getActivityName(task));
        this.putConditional(map, "baseActivity", this.getBaseActivityName(task));
        Task tasktask = task.getTask();
        if (tasktask instanceof ActionTask) {
            TracePoint _outerEntry = ((ActionTask)tasktask).getAction().getOuterEntry();
            String _value = null;
            if (_outerEntry != null) {
                _value = _outerEntry.getValue();
            }
            this.putConditional(map, "outerEntry", _value);
            TracePoint _outerExit = ((ActionTask)tasktask).getAction().getOuterExit();
            String _value_1 = null;
            if (_outerExit != null) {
                _value_1 = _outerExit.getValue();
            }
            this.putConditional(map, "outerExit", _value_1);
            TracePoint _entry = ((ActionTask)tasktask).getAction().getEntry();
            String _value_2 = null;
            if (_entry != null) {
                _value_2 = _entry.getValue();
            }
            this.putConditional(map, "entry", _value_2);
            TracePoint _exit = ((ActionTask)tasktask).getAction().getExit();
            String _value_3 = null;
            if (_exit != null) {
                _value_3 = _exit.getValue();
            }
            this.putConditional(map, "exit", _value_3);
        }
        if (_isErroneousPassingMove = this.isErroneousPassingMove(task)) {
            map.put("error", "Concatenated move is interrupted");
        }
        this.addUserAttributes(task, (Map<String, String>)map);
        Functions.Function1 _function = it_1 -> {
            String _trim = ((String)it_1.getKey()).trim();
            String _plus = String.valueOf(_trim) + "=";
            String _escape = this.escape((String)it_1.getValue());
            return String.valueOf(_plus) + _escape;
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map(map.entrySet(), (Functions.Function1)_function), (CharSequence)",");
    }

    private Map<String, String> putConditional(Map<String, String> map, String key, String value) {
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
        return map;
    }

    private String escape(String string) {
        String _replaceAll = null;
        if (string != null) {
            _replaceAll = string.replaceAll("([=,])", "\\\\$1");
        }
        return _replaceAll.trim();
    }

    private String getDisplayName(ScheduledTask<?> task) {
        return task.getName();
    }

    private String getOffsetAndAmount(ScheduledTask<?> task, List<String> eventNames) {
        boolean _isEvent = this.isEvent(task);
        if (_isEvent) {
            int index = eventNames.indexOf(this.getEventName(task));
            int _size = eventNames.size();
            int _divide = 100 / _size;
            int size = Math.min(30, _divide);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)(size * index));
            _builder.append(" ");
            _builder.append((Object)size);
            return _builder.toString();
        }
        String _switchResult = null;
        Task _task = task.getTask();
        boolean _matched = false;
        if (_task instanceof ClaimTask) {
            _matched = true;
        }
        if (!_matched && _task instanceof ReleaseTask) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = "0.0 20.0";
        }
        if (!_matched) {
            _switchResult = "20.0 80.0";
        }
        return _switchResult;
    }

    private Dispatch getDispatch(ScheduledTask<?> task) {
        DirectedGraph graph = task.getTask().getGraph();
        Dispatch _xifexpression = null;
        if (graph instanceof DispatchGraph) {
            _xifexpression = ((DispatchGraph)graph).getDispatch();
        }
        return _xifexpression;
    }

    private String getActivityName(ScheduledTask<?> task) {
        Dispatch _dispatch = this.getDispatch(task);
        Activity _activity = null;
        if (_dispatch != null) {
            _activity = _dispatch.getActivity();
        }
        String _name = null;
        if (_activity != null) {
            _name = _activity.getName();
        }
        return _name;
    }

    private String getBaseActivityName(ScheduledTask<?> task) {
        Dispatch _dispatch = this.getDispatch(task);
        Activity _activity = null;
        if (_dispatch != null) {
            _activity = _dispatch.getActivity();
        }
        String _originalName = null;
        if (_activity != null) {
            _originalName = _activity.getOriginalName();
        }
        return _originalName;
    }

    private String getDescription(ScheduledTask<?> task) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        Dispatch _dispatch = this.getDispatch(task);
        boolean bl = _tripleNotEquals = _dispatch != null;
        if (_tripleNotEquals) {
            String _descriptionFromUserAttributes;
            String _elvis = null;
            String _elvis_1 = null;
            String _description = this.getDispatch(task).getDescription();
            _elvis_1 = _description != null ? _description : (_descriptionFromUserAttributes = this.getDescriptionFromUserAttributes((EObject)this.getDispatch(task)));
            if (_elvis_1 != null) {
                _elvis = _elvis_1;
            } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Activity: ");
                Activity _activity = this.getDispatch(task).getActivity();
                String _name = null;
                if (_activity != null) {
                    _name = _activity.getName();
                }
                _builder.append(_name);
                _elvis = _builder.toString();
            }
            _xifexpression = _elvis;
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    private String getDescriptionFromUserAttributes(EObject object) {
        if (object instanceof HasUserAttributes) {
            Functions.Function1 _function = it -> {
                String _name = ((Attribute)it.getKey()).getName();
                return Objects.equal((Object)_name, (Object)"description");
            };
            Map.Entry entry = (Map.Entry)IterableExtensions.findFirst((Iterable)((HasUserAttributes)object).getUserAttributes(), (Functions.Function1)_function);
            if (entry != null) {
                return (String)entry.getValue();
            }
        }
        if (object != null) {
            return this.getDescriptionFromUserAttributes(object.eContainer());
        }
        return null;
    }

    private void addUserAttributes(EObject object, Map<String, String> map) {
        if (object != null) {
            this.addUserAttributes(object.eContainer(), map);
        }
        if (object instanceof HasUserAttributes) {
            Functions.Function1 _function = it -> {
                String _name = ((Attribute)it.getKey()).getName();
                return !Objects.equal((Object)"description", (Object)_name);
            };
            Consumer<Map.Entry> _function_1 = it -> this.putConditional(map, ((Attribute)it.getKey()).getName(), (String)it.getValue());
            IterableExtensions.filter((Iterable)((HasUserAttributes)object).getUserAttributes(), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    private void addUserAttributes(ScheduledTask<?> task, Map<String, String> map) {
        boolean _tripleNotEquals;
        Dispatch _dispatch = this.getDispatch(task);
        EMap _userAttributes = null;
        if (_dispatch != null) {
            _userAttributes = _dispatch.getUserAttributes();
        }
        boolean bl = _tripleNotEquals = _userAttributes != null;
        if (_tripleNotEquals) {
            this.addUserAttributes((EObject)this.getDispatch(task), map);
        }
    }

    private String getType(ScheduledTask<?> task) {
        String _xifexpression = null;
        boolean _isEvent = this.isEvent(task);
        if (_isEvent) {
            _xifexpression = "Event";
        } else {
            String _xifexpression_1 = null;
            boolean _isClaimOrRelease = this.isClaimOrRelease(task);
            if (_isClaimOrRelease) {
                _xifexpression_1 = "Claim or release";
            } else {
                String _xifexpression_2 = null;
                Task _task = task.getTask();
                if (_task instanceof DispatchGroupTask) {
                    _xifexpression_2 = "Dispatch offset";
                } else {
                    String _xifexpression_3 = null;
                    Task _task_1 = task.getTask();
                    if (!(_task_1 instanceof PeripheralActionTask)) {
                        throw new IllegalArgumentException("Unsupported task type: " + task);
                    }
                    _xifexpression_3 = "Peripheral task";
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String getColor(ScheduledTask<?> task) {
        String _xifexpression = null;
        if (this.erroneousPassingMoveColorScheme) {
            String _xifexpression_1 = null;
            boolean _isErroneousPassingMove = this.isErroneousPassingMove(task);
            _xifexpression_1 = _isErroneousPassingMove ? "orange" : "light_gray";
            _xifexpression = _xifexpression_1;
        } else {
            String _xifexpression_2 = null;
            if (this.stochasticImpactColorScheme) {
                String _switchResult = null;
                boolean _matched = false;
                if (task instanceof ClaimedByScheduledTask) {
                    _matched = true;
                    _switchResult = GanttColor.ClaimReleaseNotCritical.getColor();
                }
                if (!_matched) {
                    _switchResult = GanttColor.getStochasticColor(this.getStochasticWeight(task)).getColor();
                }
                _xifexpression_2 = _switchResult;
            } else {
                String _xifexpression_3 = null;
                if (this.criticalPathColorScheme) {
                    String _xifexpression_4 = null;
                    if (task instanceof ClaimedByScheduledTask) {
                        String _switchResult_1 = null;
                        boolean _matched_1 = false;
                        if (this.isCritical(((ClaimedByScheduledTask)task).getClaim()) && this.isCritical(((ClaimedByScheduledTask)task).getRelease())) {
                            _matched_1 = true;
                            _switchResult_1 = GanttColor.ClaimAndReleaseCritical.getColor();
                        }
                        if (!_matched_1 && (this.isCritical(((ClaimedByScheduledTask)task).getClaim()) || this.isCritical(((ClaimedByScheduledTask)task).getRelease()))) {
                            _matched_1 = true;
                            _switchResult_1 = GanttColor.ClaimOrReleaseCritical.getColor();
                        }
                        if (!_matched_1) {
                            _switchResult_1 = GanttColor.ClaimReleaseNotCritical.getColor();
                        }
                        _xifexpression_4 = _switchResult_1;
                    } else {
                        String _xifexpression_5 = null;
                        boolean _isCritical = this.isCritical(task);
                        _xifexpression_5 = _isCritical ? GanttColor.TaskCritical.getColor() : GanttColor.TaskNotCritical.getColor();
                        _xifexpression_4 = _xifexpression_5;
                    }
                    _xifexpression_3 = _xifexpression_4;
                } else {
                    _xifexpression_3 = this.getColorKey(task);
                }
                _xifexpression_2 = _xifexpression_3;
            }
            _xifexpression = _xifexpression_2;
        }
        return _xifexpression;
    }

    private String getColorKey(ScheduledTask<?> task) {
        String _xifexpression = null;
        boolean _isEvent = this.isEvent(task);
        if (_isEvent) {
            _xifexpression = this.getEventName(task);
        } else {
            String _xifexpression_1 = null;
            boolean _isClaimOrRelease = this.isClaimOrRelease(task);
            if (_isClaimOrRelease) {
                _xifexpression_1 = this.getDescription(task);
            } else {
                String _xifexpression_2 = null;
                Task _task = task.getTask();
                if (_task instanceof DispatchGroupTask) {
                    _xifexpression_2 = "Dispatch offset";
                } else {
                    String _xifexpression_3 = null;
                    Task _task_1 = task.getTask();
                    if (!(_task_1 instanceof PeripheralActionTask)) {
                        throw new IllegalArgumentException("Unsupported task type: " + task);
                    }
                    Task _task_2 = task.getTask();
                    _xifexpression_3 = ((PeripheralAction)((PeripheralActionTask)_task_2).getAction()).getResource().fqn();
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String getAttributes(ScheduledDependency dependency) {
        boolean _isEvent;
        LinkedHashMap attrs = CollectionLiterals.newLinkedHashMap();
        attrs.put("boundary", this.getEtfBoundary(dependency));
        attrs.put("color", this.getColor(dependency));
        if (this.criticalPathColorScheme) {
            attrs.put("critical", Boolean.valueOf(this.isCritical(dependency)).toString());
        }
        if (_isEvent = this.isEvent(dependency)) {
            attrs.put("name", this.getEventName(dependency));
        }
        Functions.Function1 _function = it -> {
            String _trim = ((String)it.getKey()).trim();
            String _plus = String.valueOf(_trim) + "=";
            String _escape = this.escape((String)it.getValue());
            return String.valueOf(_plus) + _escape;
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map(attrs.entrySet(), (Functions.Function1)_function), (CharSequence)",");
    }

    private int getEtfType(ScheduledDependency dependency) {
        int _switchResult = 0;
        ScheduledDependencyType _type = dependency.getType();
        if (_type != null) {
            switch (_type) {
                case SOURCE_NODE_STARTS_BEFORE_TARGET_NODE_STARTS: {
                    _switchResult = 0;
                    break;
                }
                case SOURCE_NODE_STARTS_BEFORE_TARGET_NODE_ENDS: {
                    _switchResult = 1;
                    break;
                }
                case SOURCE_NODE_ENDS_BEFORE_TARGET_NODE_STARTS: {
                    _switchResult = 2;
                    break;
                }
                case SOURCE_NODE_ENDS_BEFORE_TARGET_NODE_ENDS: {
                    _switchResult = 3;
                    break;
                }
            }
        }
        return _switchResult;
    }

    private String getEtfBoundary(ScheduledDependency dependency) {
        boolean _isEvent = this.isEvent(dependency);
        if (_isEvent) {
            return "Between events";
        }
        String _switchResult = null;
        DependencyBoundary _boundary = dependency.getBoundary();
        if (_boundary != null) {
            switch (_boundary) {
                case CROSS_RESOURCE: {
                    _switchResult = "Between peripherals within 1 resource";
                    break;
                }
                case CROSS_RESOURCE_CONTAINER: {
                    _switchResult = "Between peripherals in different resources";
                    break;
                }
                case IN_RESOURCE: {
                    _switchResult = "Within 1 peripheral";
                    break;
                }
            }
        }
        return _switchResult;
    }

    private String getColor(ScheduledDependency dependency) {
        String _xifexpression = null;
        if (this.erroneousPassingMoveColorScheme) {
            String _xifexpression_1 = null;
            boolean _isEvent = this.isEvent(dependency);
            _xifexpression_1 = _isEvent ? GanttColor.DependencyEvent.getColor() : GanttColor.DependencyNormal.getColor();
            _xifexpression = _xifexpression_1;
        } else {
            String _xifexpression_2 = null;
            if (this.criticalPathColorScheme) {
                String _xifexpression_3 = null;
                boolean _isCritical = this.isCritical(dependency);
                if (_isCritical) {
                    _xifexpression_3 = GanttColor.DependencyCritical.getColor();
                } else {
                    String _xifexpression_4 = null;
                    boolean _isEvent_1 = this.isEvent(dependency);
                    _xifexpression_4 = _isEvent_1 ? GanttColor.DependencyEvent.getColor() : GanttColor.DependencyNotCritical.getColor();
                    _xifexpression_3 = _xifexpression_4;
                }
                _xifexpression_2 = _xifexpression_3;
            } else {
                String _xifexpression_5 = null;
                boolean _isEvent_2 = this.isEvent(dependency);
                if (_isEvent_2) {
                    _xifexpression_5 = GanttColor.DependencyEvent.getColor();
                } else {
                    String _xifexpression_6 = null;
                    _xifexpression_6 = this.isClaimOrRelease((ScheduledTask)dependency.getSourceNode()) || this.isClaimOrRelease((ScheduledTask)dependency.getTargetNode()) ? GanttColor.DependencyClaimRelease.getColor() : GanttColor.DependencyNormal.getColor();
                    _xifexpression_5 = _xifexpression_6;
                }
                _xifexpression_2 = _xifexpression_5;
            }
            _xifexpression = _xifexpression_2;
        }
        return _xifexpression;
    }

    private BigDecimal getStochasticWeight(ScheduledTask<?> task) {
        BigDecimal _elvis = null;
        StochasticAnnotation _last = (StochasticAnnotation)IterableExtensions.last((Iterable)Iterables.filter((Iterable)task.getAspects(), StochasticAnnotation.class));
        BigDecimal _weight = null;
        if (_last != null) {
            _weight = _last.getWeight();
        }
        _elvis = _weight != null ? _weight : BigDecimal.ZERO;
        return _elvis;
    }

    private boolean isCritical(ScheduledTask<?> task) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)"Critical");
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)task.getAspects(), (Functions.Function1)_function));
        return !_isEmpty;
    }

    private boolean isErroneousPassingMove(ScheduledTask<?> task) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)PASSING_MOVE_TIMING_GAP);
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)task.getAspects(), (Functions.Function1)_function));
        return !_isEmpty;
    }

    private boolean isCritical(ScheduledDependency dependency) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)"Critical");
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)dependency.getAspects(), (Functions.Function1)_function));
        return !_isEmpty;
    }

    private boolean isEvent(ScheduledDependency dependency) {
        return this.isEvent((ScheduledTask)dependency.getSourceNode()) || this.isEvent((ScheduledTask)dependency.getTargetNode());
    }

    private boolean isEvent(ScheduledTask<?> task) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)task.getTask().getAspects(), EventAnnotation.class));
        return !_isEmpty;
    }

    private <T extends Task> boolean isEvent(Sequence<T> sequence) {
        Functions.Function1 _function = it -> this.isEvent((ScheduledTask<?>)it);
        return IterableExtensions.exists((Iterable)sequence.getScheduledTasks(), (Functions.Function1)_function);
    }

    private String getEventName(ScheduledTask<?> task) {
        EventAnnotation _head = (EventAnnotation)IterableExtensions.head((Iterable)Iterables.filter((Iterable)task.getTask().getAspects(), EventAnnotation.class));
        String _name = null;
        if (_head != null) {
            _name = _head.getName();
        }
        return _name;
    }

    private String getEventName(ScheduledDependency dependency) {
        String _xifexpression = null;
        Node _sourceNode = dependency.getSourceNode();
        boolean _isEvent = this.isEvent((ScheduledTask)_sourceNode);
        if (_isEvent) {
            Node _sourceNode_1 = dependency.getSourceNode();
            _xifexpression = this.getEventName((ScheduledTask)_sourceNode_1);
        } else {
            String _xifexpression_1 = null;
            Node _targetNode = dependency.getTargetNode();
            boolean _isEvent_1 = this.isEvent((ScheduledTask)_targetNode);
            if (_isEvent_1) {
                Node _targetNode_1 = dependency.getTargetNode();
                _xifexpression_1 = this.getEventName((ScheduledTask)_targetNode_1);
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private boolean isClaimOrRelease(ScheduledTask<?> task) {
        return task instanceof ClaimedByScheduledTask || task.getTask() instanceof ClaimTask || task.getTask() instanceof ReleaseTask;
    }

    private String getEtfName(Resource resource) {
        if (resource instanceof PeripheralResource) {
            return this._getEtfName((PeripheralResource)resource);
        }
        if (resource != null) {
            return this._getEtfName(resource);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(resource).toString());
    }
}

