/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.machine.teditor.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.services.TerminalsGrammarAccess;
import org.eclipse.xtext.service.AbstractElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

@Singleton
public class MachineGrammarAccess extends AbstractElementFinder.AbstractGrammarElementFinder {
	
	public class MachineElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Machine");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cMachineAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cImportsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportsImportParserRuleCall_1_0 = (RuleCall)cImportsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cMachineKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cTypeAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cTypeIDTerminalRuleCall_2_1_0 = (RuleCall)cTypeAssignment_2_1.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cPathAnnotationsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3_1 = (Keyword)cGroup_3.eContents().get(1);
		private final Assignment cPathAnnotationsAssignment_3_2 = (Assignment)cGroup_3.eContents().get(2);
		private final RuleCall cPathAnnotationsPathAnnotationParserRuleCall_3_2_0 = (RuleCall)cPathAnnotationsAssignment_3_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3_3 = (Keyword)cGroup_3.eContents().get(3);
		private final Alternatives cAlternatives_4 = (Alternatives)cGroup.eContents().get(4);
		private final Assignment cPeripheralTypesAssignment_4_0 = (Assignment)cAlternatives_4.eContents().get(0);
		private final RuleCall cPeripheralTypesPeripheralTypeParserRuleCall_4_0_0 = (RuleCall)cPeripheralTypesAssignment_4_0.eContents().get(0);
		private final Assignment cResourcesAssignment_4_1 = (Assignment)cAlternatives_4.eContents().get(1);
		private final RuleCall cResourcesResourceParserRuleCall_4_1_0 = (RuleCall)cResourcesAssignment_4_1.eContents().get(0);
		
		//Machine:
		//	{Machine} imports+=Import* ('Machine' type=ID)? ('PathAnnotations' '{'
		//	pathAnnotations+=PathAnnotation*
		//	'}')? (peripheralTypes+=PeripheralType | resources+=Resource)*;
		@Override public ParserRule getRule() { return rule; }
		
		//{Machine} imports+=Import* ('Machine' type=ID)? ('PathAnnotations' '{' pathAnnotations+=PathAnnotation* '}')?
		//(peripheralTypes+=PeripheralType | resources+=Resource)*
		public Group getGroup() { return cGroup; }
		
		//{Machine}
		public Action getMachineAction_0() { return cMachineAction_0; }
		
		//imports+=Import*
		public Assignment getImportsAssignment_1() { return cImportsAssignment_1; }
		
		//Import
		public RuleCall getImportsImportParserRuleCall_1_0() { return cImportsImportParserRuleCall_1_0; }
		
		//('Machine' type=ID)?
		public Group getGroup_2() { return cGroup_2; }
		
		//'Machine'
		public Keyword getMachineKeyword_2_0() { return cMachineKeyword_2_0; }
		
		//type=ID
		public Assignment getTypeAssignment_2_1() { return cTypeAssignment_2_1; }
		
		//ID
		public RuleCall getTypeIDTerminalRuleCall_2_1_0() { return cTypeIDTerminalRuleCall_2_1_0; }
		
		//('PathAnnotations' '{' pathAnnotations+=PathAnnotation* '}')?
		public Group getGroup_3() { return cGroup_3; }
		
		//'PathAnnotations'
		public Keyword getPathAnnotationsKeyword_3_0() { return cPathAnnotationsKeyword_3_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3_1() { return cLeftCurlyBracketKeyword_3_1; }
		
		//pathAnnotations+=PathAnnotation*
		public Assignment getPathAnnotationsAssignment_3_2() { return cPathAnnotationsAssignment_3_2; }
		
		//PathAnnotation
		public RuleCall getPathAnnotationsPathAnnotationParserRuleCall_3_2_0() { return cPathAnnotationsPathAnnotationParserRuleCall_3_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3_3() { return cRightCurlyBracketKeyword_3_3; }
		
		//(peripheralTypes+=PeripheralType | resources+=Resource)*
		public Alternatives getAlternatives_4() { return cAlternatives_4; }
		
		//peripheralTypes+=PeripheralType
		public Assignment getPeripheralTypesAssignment_4_0() { return cPeripheralTypesAssignment_4_0; }
		
		//PeripheralType
		public RuleCall getPeripheralTypesPeripheralTypeParserRuleCall_4_0_0() { return cPeripheralTypesPeripheralTypeParserRuleCall_4_0_0; }
		
		//resources+=Resource
		public Assignment getResourcesAssignment_4_1() { return cResourcesAssignment_4_1; }
		
		//Resource
		public RuleCall getResourcesResourceParserRuleCall_4_1_0() { return cResourcesResourceParserRuleCall_4_1_0; }
	}
	public class ImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Import");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cImportURIAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportURISTRINGTerminalRuleCall_1_0 = (RuleCall)cImportURIAssignment_1.eContents().get(0);
		
		//Import:
		//	"import" importURI=STRING;
		@Override public ParserRule getRule() { return rule; }
		
		//"import" importURI=STRING
		public Group getGroup() { return cGroup; }
		
		//"import"
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }
		
		//importURI=STRING
		public Assignment getImportURIAssignment_1() { return cImportURIAssignment_1; }
		
		//STRING
		public RuleCall getImportURISTRINGTerminalRuleCall_1_0() { return cImportURISTRINGTerminalRuleCall_1_0; }
	}
	public class PathAnnotationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.PathAnnotation");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPathAnnotationAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//PathAnnotation:
		//	{PathAnnotation} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{PathAnnotation} name=ID
		public Group getGroup() { return cGroup; }
		
		//{PathAnnotation}
		public Action getPathAnnotationAction_0() { return cPathAnnotationAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class PeripheralTypeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.PeripheralType");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPeripheralTypeAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cPeripheralTypeKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cActionsKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Assignment cActionsAssignment_4_2 = (Assignment)cGroup_4.eContents().get(2);
		private final RuleCall cActionsActionTypeParserRuleCall_4_2_0 = (RuleCall)cActionsAssignment_4_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4_3 = (Keyword)cGroup_4.eContents().get(3);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cSetPointsKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cSetPointsAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cSetPointsSetPointParserRuleCall_5_2_0 = (RuleCall)cSetPointsAssignment_5_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		private final Keyword cAxesKeyword_5_4 = (Keyword)cGroup_5.eContents().get(4);
		private final Keyword cLeftCurlyBracketKeyword_5_5 = (Keyword)cGroup_5.eContents().get(5);
		private final Assignment cAxesAssignment_5_6 = (Assignment)cGroup_5.eContents().get(6);
		private final RuleCall cAxesAxisParserRuleCall_5_6_0 = (RuleCall)cAxesAssignment_5_6.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5_7 = (Keyword)cGroup_5.eContents().get(7);
		private final Group cGroup_5_8 = (Group)cGroup_5.eContents().get(8);
		private final Keyword cConversionKeyword_5_8_0 = (Keyword)cGroup_5_8.eContents().get(0);
		private final Assignment cConversionAssignment_5_8_1 = (Assignment)cGroup_5_8.eContents().get(1);
		private final RuleCall cConversionSTRINGTerminalRuleCall_5_8_1_0 = (RuleCall)cConversionAssignment_5_8_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_6 = (Keyword)cGroup.eContents().get(6);
		
		//PeripheralType:
		//	{PeripheralType}
		//	'PeripheralType' name=ID '{' ('Actions' '{' actions+=ActionType* '}')? ('SetPoints' '{' setPoints+=SetPoint* '}'
		//	'Axes' '{' axes+=Axis* '}' ('Conversion' conversion=STRING)?)?
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//{PeripheralType} 'PeripheralType' name=ID '{' ('Actions' '{' actions+=ActionType* '}')? ('SetPoints' '{'
		//setPoints+=SetPoint* '}' 'Axes' '{' axes+=Axis* '}' ('Conversion' conversion=STRING)?)? '}'
		public Group getGroup() { return cGroup; }
		
		//{PeripheralType}
		public Action getPeripheralTypeAction_0() { return cPeripheralTypeAction_0; }
		
		//'PeripheralType'
		public Keyword getPeripheralTypeKeyword_1() { return cPeripheralTypeKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3() { return cLeftCurlyBracketKeyword_3; }
		
		//('Actions' '{' actions+=ActionType* '}')?
		public Group getGroup_4() { return cGroup_4; }
		
		//'Actions'
		public Keyword getActionsKeyword_4_0() { return cActionsKeyword_4_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_4_1() { return cLeftCurlyBracketKeyword_4_1; }
		
		//actions+=ActionType*
		public Assignment getActionsAssignment_4_2() { return cActionsAssignment_4_2; }
		
		//ActionType
		public RuleCall getActionsActionTypeParserRuleCall_4_2_0() { return cActionsActionTypeParserRuleCall_4_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_4_3() { return cRightCurlyBracketKeyword_4_3; }
		
		//('SetPoints' '{' setPoints+=SetPoint* '}' 'Axes' '{' axes+=Axis* '}' ('Conversion' conversion=STRING)?)?
		public Group getGroup_5() { return cGroup_5; }
		
		//'SetPoints'
		public Keyword getSetPointsKeyword_5_0() { return cSetPointsKeyword_5_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_5_1() { return cLeftCurlyBracketKeyword_5_1; }
		
		//setPoints+=SetPoint*
		public Assignment getSetPointsAssignment_5_2() { return cSetPointsAssignment_5_2; }
		
		//SetPoint
		public RuleCall getSetPointsSetPointParserRuleCall_5_2_0() { return cSetPointsSetPointParserRuleCall_5_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_5_3() { return cRightCurlyBracketKeyword_5_3; }
		
		//'Axes'
		public Keyword getAxesKeyword_5_4() { return cAxesKeyword_5_4; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_5_5() { return cLeftCurlyBracketKeyword_5_5; }
		
		//axes+=Axis*
		public Assignment getAxesAssignment_5_6() { return cAxesAssignment_5_6; }
		
		//Axis
		public RuleCall getAxesAxisParserRuleCall_5_6_0() { return cAxesAxisParserRuleCall_5_6_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_5_7() { return cRightCurlyBracketKeyword_5_7; }
		
		//('Conversion' conversion=STRING)?
		public Group getGroup_5_8() { return cGroup_5_8; }
		
		//'Conversion'
		public Keyword getConversionKeyword_5_8_0() { return cConversionKeyword_5_8_0; }
		
		//conversion=STRING
		public Assignment getConversionAssignment_5_8_1() { return cConversionAssignment_5_8_1; }
		
		//STRING
		public RuleCall getConversionSTRINGTerminalRuleCall_5_8_1_0() { return cConversionSTRINGTerminalRuleCall_5_8_1_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_6() { return cRightCurlyBracketKeyword_6; }
	}
	public class ActionTypeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.ActionType");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cActionTypeAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//ActionType:
		//	{ActionType} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{ActionType} name=ID
		public Group getGroup() { return cGroup; }
		
		//{ActionType}
		public Action getActionTypeAction_0() { return cActionTypeAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class SetPointElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.SetPoint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSetPointAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftSquareBracketKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cUnitAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cUnitIDTerminalRuleCall_2_1_0 = (RuleCall)cUnitAssignment_2_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_2_2 = (Keyword)cGroup_2.eContents().get(2);
		
		//SetPoint:
		//	{SetPoint} name=ID ('[' unit=ID ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//{SetPoint} name=ID ('[' unit=ID ']')?
		public Group getGroup() { return cGroup; }
		
		//{SetPoint}
		public Action getSetPointAction_0() { return cSetPointAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('[' unit=ID ']')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_2_0() { return cLeftSquareBracketKeyword_2_0; }
		
		//unit=ID
		public Assignment getUnitAssignment_2_1() { return cUnitAssignment_2_1; }
		
		//ID
		public RuleCall getUnitIDTerminalRuleCall_2_1_0() { return cUnitIDTerminalRuleCall_2_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_2_2() { return cRightSquareBracketKeyword_2_2; }
	}
	public class AxisElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Axis");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cAxisAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftSquareBracketKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cUnitAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cUnitIDTerminalRuleCall_2_1_0 = (RuleCall)cUnitAssignment_2_1.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_2_2 = (Keyword)cGroup_2.eContents().get(2);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cMovesKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cSetPointsAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final CrossReference cSetPointsSetPointCrossReference_3_1_0 = (CrossReference)cSetPointsAssignment_3_1.eContents().get(0);
		private final RuleCall cSetPointsSetPointIDTerminalRuleCall_3_1_0_1 = (RuleCall)cSetPointsSetPointCrossReference_3_1_0.eContents().get(1);
		private final Group cGroup_3_2 = (Group)cGroup_3.eContents().get(2);
		private final Keyword cCommaKeyword_3_2_0 = (Keyword)cGroup_3_2.eContents().get(0);
		private final Assignment cSetPointsAssignment_3_2_1 = (Assignment)cGroup_3_2.eContents().get(1);
		private final CrossReference cSetPointsSetPointCrossReference_3_2_1_0 = (CrossReference)cSetPointsAssignment_3_2_1.eContents().get(0);
		private final RuleCall cSetPointsSetPointIDTerminalRuleCall_3_2_1_0_1 = (RuleCall)cSetPointsSetPointCrossReference_3_2_1_0.eContents().get(1);
		
		//Axis:
		//	{Axis} name=ID ('[' unit=ID ']')? ('moves' setPoints+=[SetPoint] (',' setPoints+=[SetPoint])*)?;
		@Override public ParserRule getRule() { return rule; }
		
		//{Axis} name=ID ('[' unit=ID ']')? ('moves' setPoints+=[SetPoint] (',' setPoints+=[SetPoint])*)?
		public Group getGroup() { return cGroup; }
		
		//{Axis}
		public Action getAxisAction_0() { return cAxisAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('[' unit=ID ']')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_2_0() { return cLeftSquareBracketKeyword_2_0; }
		
		//unit=ID
		public Assignment getUnitAssignment_2_1() { return cUnitAssignment_2_1; }
		
		//ID
		public RuleCall getUnitIDTerminalRuleCall_2_1_0() { return cUnitIDTerminalRuleCall_2_1_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_2_2() { return cRightSquareBracketKeyword_2_2; }
		
		//('moves' setPoints+=[SetPoint] (',' setPoints+=[SetPoint])*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'moves'
		public Keyword getMovesKeyword_3_0() { return cMovesKeyword_3_0; }
		
		//setPoints+=[SetPoint]
		public Assignment getSetPointsAssignment_3_1() { return cSetPointsAssignment_3_1; }
		
		//[SetPoint]
		public CrossReference getSetPointsSetPointCrossReference_3_1_0() { return cSetPointsSetPointCrossReference_3_1_0; }
		
		//ID
		public RuleCall getSetPointsSetPointIDTerminalRuleCall_3_1_0_1() { return cSetPointsSetPointIDTerminalRuleCall_3_1_0_1; }
		
		//(',' setPoints+=[SetPoint])*
		public Group getGroup_3_2() { return cGroup_3_2; }
		
		//','
		public Keyword getCommaKeyword_3_2_0() { return cCommaKeyword_3_2_0; }
		
		//setPoints+=[SetPoint]
		public Assignment getSetPointsAssignment_3_2_1() { return cSetPointsAssignment_3_2_1; }
		
		//[SetPoint]
		public CrossReference getSetPointsSetPointCrossReference_3_2_1_0() { return cSetPointsSetPointCrossReference_3_2_1_0; }
		
		//ID
		public RuleCall getSetPointsSetPointIDTerminalRuleCall_3_2_1_0_1() { return cSetPointsSetPointIDTerminalRuleCall_3_2_1_0_1; }
	}
	public class ResourceItemElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.ResourceItem");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cResourceItemAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIIDParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//ResourceItem:
		//	{ResourceItem} name=IID;
		@Override public ParserRule getRule() { return rule; }
		
		//{ResourceItem} name=IID
		public Group getGroup() { return cGroup; }
		
		//{ResourceItem}
		public Action getResourceItemAction_0() { return cResourceItemAction_0; }
		
		//name=IID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//IID
		public RuleCall getNameIIDParserRuleCall_1_0() { return cNameIIDParserRuleCall_1_0; }
	}
	public class ResourceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Resource");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cResourceKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftParenthesisKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cItemsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cItemsResourceItemParserRuleCall_2_1_0 = (RuleCall)cItemsAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cCommaKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cItemsAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cItemsResourceItemParserRuleCall_2_2_1_0 = (RuleCall)cItemsAssignment_2_2_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		private final Keyword cLeftCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cPeripheralsAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cPeripheralsPeripheralParserRuleCall_4_0 = (RuleCall)cPeripheralsAssignment_4.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//Resource:
		//	'Resource' name=ID ('(' items+=ResourceItem (',' items+=ResourceItem)* ')')? '{'
		//	peripherals+=Peripheral*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//'Resource' name=ID ('(' items+=ResourceItem (',' items+=ResourceItem)* ')')? '{' peripherals+=Peripheral* '}'
		public Group getGroup() { return cGroup; }
		
		//'Resource'
		public Keyword getResourceKeyword_0() { return cResourceKeyword_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('(' items+=ResourceItem (',' items+=ResourceItem)* ')')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2_0() { return cLeftParenthesisKeyword_2_0; }
		
		//items+=ResourceItem
		public Assignment getItemsAssignment_2_1() { return cItemsAssignment_2_1; }
		
		//ResourceItem
		public RuleCall getItemsResourceItemParserRuleCall_2_1_0() { return cItemsResourceItemParserRuleCall_2_1_0; }
		
		//(',' items+=ResourceItem)*
		public Group getGroup_2_2() { return cGroup_2_2; }
		
		//','
		public Keyword getCommaKeyword_2_2_0() { return cCommaKeyword_2_2_0; }
		
		//items+=ResourceItem
		public Assignment getItemsAssignment_2_2_1() { return cItemsAssignment_2_2_1; }
		
		//ResourceItem
		public RuleCall getItemsResourceItemParserRuleCall_2_2_1_0() { return cItemsResourceItemParserRuleCall_2_2_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_2_3() { return cRightParenthesisKeyword_2_3; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3() { return cLeftCurlyBracketKeyword_3; }
		
		//peripherals+=Peripheral*
		public Assignment getPeripheralsAssignment_4() { return cPeripheralsAssignment_4; }
		
		//Peripheral
		public RuleCall getPeripheralsPeripheralParserRuleCall_4_0() { return cPeripheralsPeripheralParserRuleCall_4_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_5() { return cRightCurlyBracketKeyword_5; }
	}
	public class PeripheralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Peripheral");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameIDTerminalRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cTypeAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cTypePeripheralTypeCrossReference_2_0 = (CrossReference)cTypeAssignment_2.eContents().get(0);
		private final RuleCall cTypePeripheralTypeIDTerminalRuleCall_2_0_1 = (RuleCall)cTypePeripheralTypeCrossReference_2_0.eContents().get(1);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cLeftCurlyBracketKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cGroup_3.eContents().get(1);
		private final Group cGroup_3_1_0 = (Group)cGroup_3_1.eContents().get(0);
		private final Keyword cAxisPositionsKeyword_3_1_0_0 = (Keyword)cGroup_3_1_0.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3_1_0_1 = (Keyword)cGroup_3_1_0.eContents().get(1);
		private final Assignment cAxisPositionsAssignment_3_1_0_2 = (Assignment)cGroup_3_1_0.eContents().get(2);
		private final RuleCall cAxisPositionsAxisPositionsMapEntryParserRuleCall_3_1_0_2_0 = (RuleCall)cAxisPositionsAssignment_3_1_0_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3_1_0_3 = (Keyword)cGroup_3_1_0.eContents().get(3);
		private final Group cGroup_3_1_1 = (Group)cGroup_3_1.eContents().get(1);
		private final Keyword cSymbolicPositionsKeyword_3_1_1_0 = (Keyword)cGroup_3_1_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3_1_1_1 = (Keyword)cGroup_3_1_1.eContents().get(1);
		private final Assignment cPositionsAssignment_3_1_1_2 = (Assignment)cGroup_3_1_1.eContents().get(2);
		private final RuleCall cPositionsSymbolicPositionParserRuleCall_3_1_1_2_0 = (RuleCall)cPositionsAssignment_3_1_1_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3_1_1_3 = (Keyword)cGroup_3_1_1.eContents().get(3);
		private final Keyword cProfilesKeyword_3_1_2 = (Keyword)cGroup_3_1.eContents().get(2);
		private final Keyword cLeftParenthesisKeyword_3_1_3 = (Keyword)cGroup_3_1.eContents().get(3);
		private final Assignment cProfilesAssignment_3_1_4 = (Assignment)cGroup_3_1.eContents().get(4);
		private final RuleCall cProfilesProfileParserRuleCall_3_1_4_0 = (RuleCall)cProfilesAssignment_3_1_4.eContents().get(0);
		private final Group cGroup_3_1_5 = (Group)cGroup_3_1.eContents().get(5);
		private final Keyword cCommaKeyword_3_1_5_0 = (Keyword)cGroup_3_1_5.eContents().get(0);
		private final Assignment cProfilesAssignment_3_1_5_1 = (Assignment)cGroup_3_1_5.eContents().get(1);
		private final RuleCall cProfilesProfileParserRuleCall_3_1_5_1_0 = (RuleCall)cProfilesAssignment_3_1_5_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_3_1_6 = (Keyword)cGroup_3_1.eContents().get(6);
		private final Group cGroup_3_1_7 = (Group)cGroup_3_1.eContents().get(7);
		private final Keyword cDistancesKeyword_3_1_7_0 = (Keyword)cGroup_3_1_7.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3_1_7_1 = (Keyword)cGroup_3_1_7.eContents().get(1);
		private final Assignment cDistancesAssignment_3_1_7_2 = (Assignment)cGroup_3_1_7.eContents().get(2);
		private final RuleCall cDistancesDistanceParserRuleCall_3_1_7_2_0 = (RuleCall)cDistancesAssignment_3_1_7_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3_1_7_3 = (Keyword)cGroup_3_1_7.eContents().get(3);
		private final Group cGroup_3_1_8 = (Group)cGroup_3_1.eContents().get(8);
		private final Keyword cPathsKeyword_3_1_8_0 = (Keyword)cGroup_3_1_8.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3_1_8_1 = (Keyword)cGroup_3_1_8.eContents().get(1);
		private final Assignment cPathsAssignment_3_1_8_2 = (Assignment)cGroup_3_1_8.eContents().get(2);
		private final RuleCall cPathsPathParserRuleCall_3_1_8_2_0 = (RuleCall)cPathsAssignment_3_1_8_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3_1_8_3 = (Keyword)cGroup_3_1_8.eContents().get(3);
		private final Keyword cRightCurlyBracketKeyword_3_2 = (Keyword)cGroup_3.eContents().get(2);
		
		//Peripheral:
		//	name=ID ':' type=[PeripheralType] ('{' (('AxisPositions' '{' axisPositions+=AxisPositionsMapEntry* '}')?
		//	('SymbolicPositions' '{' positions+=SymbolicPosition* '}')?
		//	'Profiles' '(' profiles+=Profile (',' profiles+=Profile)* ')' ('Distances' '{' distances+=Distance* '}')? ('Paths' '{'
		//	paths+=Path* '}')?)?
		//	'}')?;
		@Override public ParserRule getRule() { return rule; }
		
		//name=ID ':' type=[PeripheralType] ('{' (('AxisPositions' '{' axisPositions+=AxisPositionsMapEntry* '}')?
		//('SymbolicPositions' '{' positions+=SymbolicPosition* '}')? 'Profiles' '(' profiles+=Profile (',' profiles+=Profile)*
		//')' ('Distances' '{' distances+=Distance* '}')? ('Paths' '{' paths+=Path* '}')?)? '}')?
		public Group getGroup() { return cGroup; }
		
		//name=ID
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_0_0() { return cNameIDTerminalRuleCall_0_0; }
		
		//':'
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }
		
		//type=[PeripheralType]
		public Assignment getTypeAssignment_2() { return cTypeAssignment_2; }
		
		//[PeripheralType]
		public CrossReference getTypePeripheralTypeCrossReference_2_0() { return cTypePeripheralTypeCrossReference_2_0; }
		
		//ID
		public RuleCall getTypePeripheralTypeIDTerminalRuleCall_2_0_1() { return cTypePeripheralTypeIDTerminalRuleCall_2_0_1; }
		
		//('{' (('AxisPositions' '{' axisPositions+=AxisPositionsMapEntry* '}')? ('SymbolicPositions' '{'
		//positions+=SymbolicPosition* '}')? 'Profiles' '(' profiles+=Profile (',' profiles+=Profile)* ')' ('Distances' '{'
		//distances+=Distance* '}')? ('Paths' '{' paths+=Path* '}')?)? '}')?
		public Group getGroup_3() { return cGroup_3; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3_0() { return cLeftCurlyBracketKeyword_3_0; }
		
		//(('AxisPositions' '{' axisPositions+=AxisPositionsMapEntry* '}')? ('SymbolicPositions' '{' positions+=SymbolicPosition*
		//'}')? 'Profiles' '(' profiles+=Profile (',' profiles+=Profile)* ')' ('Distances' '{' distances+=Distance* '}')?
		//('Paths' '{' paths+=Path* '}')?)?
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//('AxisPositions' '{' axisPositions+=AxisPositionsMapEntry* '}')?
		public Group getGroup_3_1_0() { return cGroup_3_1_0; }
		
		//'AxisPositions'
		public Keyword getAxisPositionsKeyword_3_1_0_0() { return cAxisPositionsKeyword_3_1_0_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3_1_0_1() { return cLeftCurlyBracketKeyword_3_1_0_1; }
		
		//axisPositions+=AxisPositionsMapEntry*
		public Assignment getAxisPositionsAssignment_3_1_0_2() { return cAxisPositionsAssignment_3_1_0_2; }
		
		//AxisPositionsMapEntry
		public RuleCall getAxisPositionsAxisPositionsMapEntryParserRuleCall_3_1_0_2_0() { return cAxisPositionsAxisPositionsMapEntryParserRuleCall_3_1_0_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3_1_0_3() { return cRightCurlyBracketKeyword_3_1_0_3; }
		
		//('SymbolicPositions' '{' positions+=SymbolicPosition* '}')?
		public Group getGroup_3_1_1() { return cGroup_3_1_1; }
		
		//'SymbolicPositions'
		public Keyword getSymbolicPositionsKeyword_3_1_1_0() { return cSymbolicPositionsKeyword_3_1_1_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3_1_1_1() { return cLeftCurlyBracketKeyword_3_1_1_1; }
		
		//positions+=SymbolicPosition*
		public Assignment getPositionsAssignment_3_1_1_2() { return cPositionsAssignment_3_1_1_2; }
		
		//SymbolicPosition
		public RuleCall getPositionsSymbolicPositionParserRuleCall_3_1_1_2_0() { return cPositionsSymbolicPositionParserRuleCall_3_1_1_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3_1_1_3() { return cRightCurlyBracketKeyword_3_1_1_3; }
		
		//'Profiles'
		public Keyword getProfilesKeyword_3_1_2() { return cProfilesKeyword_3_1_2; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_3_1_3() { return cLeftParenthesisKeyword_3_1_3; }
		
		//profiles+=Profile
		public Assignment getProfilesAssignment_3_1_4() { return cProfilesAssignment_3_1_4; }
		
		//Profile
		public RuleCall getProfilesProfileParserRuleCall_3_1_4_0() { return cProfilesProfileParserRuleCall_3_1_4_0; }
		
		//(',' profiles+=Profile)*
		public Group getGroup_3_1_5() { return cGroup_3_1_5; }
		
		//','
		public Keyword getCommaKeyword_3_1_5_0() { return cCommaKeyword_3_1_5_0; }
		
		//profiles+=Profile
		public Assignment getProfilesAssignment_3_1_5_1() { return cProfilesAssignment_3_1_5_1; }
		
		//Profile
		public RuleCall getProfilesProfileParserRuleCall_3_1_5_1_0() { return cProfilesProfileParserRuleCall_3_1_5_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_3_1_6() { return cRightParenthesisKeyword_3_1_6; }
		
		//('Distances' '{' distances+=Distance* '}')?
		public Group getGroup_3_1_7() { return cGroup_3_1_7; }
		
		//'Distances'
		public Keyword getDistancesKeyword_3_1_7_0() { return cDistancesKeyword_3_1_7_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3_1_7_1() { return cLeftCurlyBracketKeyword_3_1_7_1; }
		
		//distances+=Distance*
		public Assignment getDistancesAssignment_3_1_7_2() { return cDistancesAssignment_3_1_7_2; }
		
		//Distance
		public RuleCall getDistancesDistanceParserRuleCall_3_1_7_2_0() { return cDistancesDistanceParserRuleCall_3_1_7_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3_1_7_3() { return cRightCurlyBracketKeyword_3_1_7_3; }
		
		//('Paths' '{' paths+=Path* '}')?
		public Group getGroup_3_1_8() { return cGroup_3_1_8; }
		
		//'Paths'
		public Keyword getPathsKeyword_3_1_8_0() { return cPathsKeyword_3_1_8_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3_1_8_1() { return cLeftCurlyBracketKeyword_3_1_8_1; }
		
		//paths+=Path*
		public Assignment getPathsAssignment_3_1_8_2() { return cPathsAssignment_3_1_8_2; }
		
		//Path
		public RuleCall getPathsPathParserRuleCall_3_1_8_2_0() { return cPathsPathParserRuleCall_3_1_8_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3_1_8_3() { return cRightCurlyBracketKeyword_3_1_8_3; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3_2() { return cRightCurlyBracketKeyword_3_2; }
	}
	public class DistanceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Distance");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cDistanceAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftSquareBracketKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cSettlingAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final CrossReference cSettlingAxisCrossReference_2_1_0 = (CrossReference)cSettlingAssignment_2_1.eContents().get(0);
		private final RuleCall cSettlingAxisIDTerminalRuleCall_2_1_0_1 = (RuleCall)cSettlingAxisCrossReference_2_1_0.eContents().get(1);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cCommaKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cSettlingAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final CrossReference cSettlingAxisCrossReference_2_2_1_0 = (CrossReference)cSettlingAssignment_2_2_1.eContents().get(0);
		private final RuleCall cSettlingAxisIDTerminalRuleCall_2_2_1_0_1 = (RuleCall)cSettlingAxisCrossReference_2_2_1_0.eContents().get(1);
		private final Keyword cRightSquareBracketKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		
		//Distance:
		//	{Distance} name=ID ('[' settling+=[Axis] (',' settling+=[Axis])* ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//{Distance} name=ID ('[' settling+=[Axis] (',' settling+=[Axis])* ']')?
		public Group getGroup() { return cGroup; }
		
		//{Distance}
		public Action getDistanceAction_0() { return cDistanceAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('[' settling+=[Axis] (',' settling+=[Axis])* ']')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_2_0() { return cLeftSquareBracketKeyword_2_0; }
		
		//settling+=[Axis]
		public Assignment getSettlingAssignment_2_1() { return cSettlingAssignment_2_1; }
		
		//[Axis]
		public CrossReference getSettlingAxisCrossReference_2_1_0() { return cSettlingAxisCrossReference_2_1_0; }
		
		//ID
		public RuleCall getSettlingAxisIDTerminalRuleCall_2_1_0_1() { return cSettlingAxisIDTerminalRuleCall_2_1_0_1; }
		
		//(',' settling+=[Axis])*
		public Group getGroup_2_2() { return cGroup_2_2; }
		
		//','
		public Keyword getCommaKeyword_2_2_0() { return cCommaKeyword_2_2_0; }
		
		//settling+=[Axis]
		public Assignment getSettlingAssignment_2_2_1() { return cSettlingAssignment_2_2_1; }
		
		//[Axis]
		public CrossReference getSettlingAxisCrossReference_2_2_1_0() { return cSettlingAxisCrossReference_2_2_1_0; }
		
		//ID
		public RuleCall getSettlingAxisIDTerminalRuleCall_2_2_1_0_1() { return cSettlingAxisIDTerminalRuleCall_2_2_1_0_1; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_2_3() { return cRightSquareBracketKeyword_2_3; }
	}
	public class AxisPositionsMapEntryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.AxisPositionsMapEntry");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cAxisPositionsMapEntryAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cKeyAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cKeyAxisCrossReference_1_0 = (CrossReference)cKeyAssignment_1.eContents().get(0);
		private final RuleCall cKeyAxisIDTerminalRuleCall_1_0_1 = (RuleCall)cKeyAxisCrossReference_1_0.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftParenthesisKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cValueAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cValuePositionParserRuleCall_2_1_0 = (RuleCall)cValueAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cCommaKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cValueAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cValuePositionParserRuleCall_2_2_1_0 = (RuleCall)cValueAssignment_2_2_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		
		//AxisPositionsMapEntry:
		//	{AxisPositionsMapEntry} key=[Axis] ('(' value+=Position (',' value+=Position)* ')')?;
		@Override public ParserRule getRule() { return rule; }
		
		//{AxisPositionsMapEntry} key=[Axis] ('(' value+=Position (',' value+=Position)* ')')?
		public Group getGroup() { return cGroup; }
		
		//{AxisPositionsMapEntry}
		public Action getAxisPositionsMapEntryAction_0() { return cAxisPositionsMapEntryAction_0; }
		
		//key=[Axis]
		public Assignment getKeyAssignment_1() { return cKeyAssignment_1; }
		
		//[Axis]
		public CrossReference getKeyAxisCrossReference_1_0() { return cKeyAxisCrossReference_1_0; }
		
		//ID
		public RuleCall getKeyAxisIDTerminalRuleCall_1_0_1() { return cKeyAxisIDTerminalRuleCall_1_0_1; }
		
		//('(' value+=Position (',' value+=Position)* ')')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2_0() { return cLeftParenthesisKeyword_2_0; }
		
		//value+=Position
		public Assignment getValueAssignment_2_1() { return cValueAssignment_2_1; }
		
		//Position
		public RuleCall getValuePositionParserRuleCall_2_1_0() { return cValuePositionParserRuleCall_2_1_0; }
		
		//(',' value+=Position)*
		public Group getGroup_2_2() { return cGroup_2_2; }
		
		//','
		public Keyword getCommaKeyword_2_2_0() { return cCommaKeyword_2_2_0; }
		
		//value+=Position
		public Assignment getValueAssignment_2_2_1() { return cValueAssignment_2_2_1; }
		
		//Position
		public RuleCall getValuePositionParserRuleCall_2_2_1_0() { return cValuePositionParserRuleCall_2_2_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_2_3() { return cRightParenthesisKeyword_2_3; }
	}
	public class PositionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Position");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPositionAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//Position:
		//	{Position} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{Position} name=ID
		public Group getGroup() { return cGroup; }
		
		//{Position}
		public Action getPositionAction_0() { return cPositionAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class SymbolicPositionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.SymbolicPosition");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSymbolicPositionAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftParenthesisKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cAxisPositionAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cAxisPositionAxisPositionMapEntryParserRuleCall_2_1_0 = (RuleCall)cAxisPositionAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cCommaKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cAxisPositionAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cAxisPositionAxisPositionMapEntryParserRuleCall_2_2_1_0 = (RuleCall)cAxisPositionAssignment_2_2_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		
		//SymbolicPosition:
		//	{SymbolicPosition} name=ID ('(' axisPosition+=AxisPositionMapEntry (',' axisPosition+=AxisPositionMapEntry)* ')')?;
		@Override public ParserRule getRule() { return rule; }
		
		//{SymbolicPosition} name=ID ('(' axisPosition+=AxisPositionMapEntry (',' axisPosition+=AxisPositionMapEntry)* ')')?
		public Group getGroup() { return cGroup; }
		
		//{SymbolicPosition}
		public Action getSymbolicPositionAction_0() { return cSymbolicPositionAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('(' axisPosition+=AxisPositionMapEntry (',' axisPosition+=AxisPositionMapEntry)* ')')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2_0() { return cLeftParenthesisKeyword_2_0; }
		
		//axisPosition+=AxisPositionMapEntry
		public Assignment getAxisPositionAssignment_2_1() { return cAxisPositionAssignment_2_1; }
		
		//AxisPositionMapEntry
		public RuleCall getAxisPositionAxisPositionMapEntryParserRuleCall_2_1_0() { return cAxisPositionAxisPositionMapEntryParserRuleCall_2_1_0; }
		
		//(',' axisPosition+=AxisPositionMapEntry)*
		public Group getGroup_2_2() { return cGroup_2_2; }
		
		//','
		public Keyword getCommaKeyword_2_2_0() { return cCommaKeyword_2_2_0; }
		
		//axisPosition+=AxisPositionMapEntry
		public Assignment getAxisPositionAssignment_2_2_1() { return cAxisPositionAssignment_2_2_1; }
		
		//AxisPositionMapEntry
		public RuleCall getAxisPositionAxisPositionMapEntryParserRuleCall_2_2_1_0() { return cAxisPositionAxisPositionMapEntryParserRuleCall_2_2_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_2_3() { return cRightParenthesisKeyword_2_3; }
	}
	public class AxisPositionMapEntryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.AxisPositionMapEntry");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cAxisPositionMapEntryAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cKeyAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cKeyAxisCrossReference_1_0 = (CrossReference)cKeyAssignment_1.eContents().get(0);
		private final RuleCall cKeyAxisIDTerminalRuleCall_1_0_1 = (RuleCall)cKeyAxisCrossReference_1_0.eContents().get(1);
		private final Keyword cFullStopKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cValueAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cValuePositionCrossReference_3_0 = (CrossReference)cValueAssignment_3.eContents().get(0);
		private final RuleCall cValuePositionIDTerminalRuleCall_3_0_1 = (RuleCall)cValuePositionCrossReference_3_0.eContents().get(1);
		
		//AxisPositionMapEntry:
		//	{AxisPositionMapEntry} key=[Axis] '.' value=[Position];
		@Override public ParserRule getRule() { return rule; }
		
		//{AxisPositionMapEntry} key=[Axis] '.' value=[Position]
		public Group getGroup() { return cGroup; }
		
		//{AxisPositionMapEntry}
		public Action getAxisPositionMapEntryAction_0() { return cAxisPositionMapEntryAction_0; }
		
		//key=[Axis]
		public Assignment getKeyAssignment_1() { return cKeyAssignment_1; }
		
		//[Axis]
		public CrossReference getKeyAxisCrossReference_1_0() { return cKeyAxisCrossReference_1_0; }
		
		//ID
		public RuleCall getKeyAxisIDTerminalRuleCall_1_0_1() { return cKeyAxisIDTerminalRuleCall_1_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_2() { return cFullStopKeyword_2; }
		
		//value=[Position]
		public Assignment getValueAssignment_3() { return cValueAssignment_3; }
		
		//[Position]
		public CrossReference getValuePositionCrossReference_3_0() { return cValuePositionCrossReference_3_0; }
		
		//ID
		public RuleCall getValuePositionIDTerminalRuleCall_3_0_1() { return cValuePositionIDTerminalRuleCall_3_0_1; }
	}
	public class ProfileElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Profile");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cProfileAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//Profile:
		//	{Profile} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{Profile} name=ID
		public Group getGroup() { return cGroup; }
		
		//{Profile}
		public Action getProfileAction_0() { return cProfileAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class PathElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.Path");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cUnidirectionalPathParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cBidirectionalPathParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cFullMeshPathParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//Path:
		//	UnidirectionalPath | BidirectionalPath | FullMeshPath;
		@Override public ParserRule getRule() { return rule; }
		
		//UnidirectionalPath | BidirectionalPath | FullMeshPath
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//UnidirectionalPath
		public RuleCall getUnidirectionalPathParserRuleCall_0() { return cUnidirectionalPathParserRuleCall_0; }
		
		//BidirectionalPath
		public RuleCall getBidirectionalPathParserRuleCall_1() { return cBidirectionalPathParserRuleCall_1; }
		
		//FullMeshPath
		public RuleCall getFullMeshPathParserRuleCall_2() { return cFullMeshPathParserRuleCall_2; }
	}
	public class UnidirectionalPathElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.UnidirectionalPath");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cUnidirectionalPathAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cSourceSymbolicPositionCrossReference_1_0 = (CrossReference)cSourceAssignment_1.eContents().get(0);
		private final RuleCall cSourceSymbolicPositionIDTerminalRuleCall_1_0_1 = (RuleCall)cSourceSymbolicPositionCrossReference_1_0.eContents().get(1);
		private final Keyword cHyphenMinusHyphenMinusGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cTargetAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cTargetPathTargetReferenceParserRuleCall_3_0 = (RuleCall)cTargetAssignment_3.eContents().get(0);
		private final Alternatives cAlternatives_4 = (Alternatives)cGroup.eContents().get(4);
		private final Group cGroup_4_0 = (Group)cAlternatives_4.eContents().get(0);
		private final Keyword cProfilesKeyword_4_0_0 = (Keyword)cGroup_4_0.eContents().get(0);
		private final Assignment cProfilesAssignment_4_0_1 = (Assignment)cGroup_4_0.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_4_0_1_0 = (CrossReference)cProfilesAssignment_4_0_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_4_0_1_0_1 = (RuleCall)cProfilesProfileCrossReference_4_0_1_0.eContents().get(1);
		private final Group cGroup_4_0_2 = (Group)cGroup_4_0.eContents().get(2);
		private final Keyword cCommaKeyword_4_0_2_0 = (Keyword)cGroup_4_0_2.eContents().get(0);
		private final Assignment cProfilesAssignment_4_0_2_1 = (Assignment)cGroup_4_0_2.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_4_0_2_1_0 = (CrossReference)cProfilesAssignment_4_0_2_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1 = (RuleCall)cProfilesProfileCrossReference_4_0_2_1_0.eContents().get(1);
		private final Group cGroup_4_1 = (Group)cAlternatives_4.eContents().get(1);
		private final Keyword cProfileKeyword_4_1_0 = (Keyword)cGroup_4_1.eContents().get(0);
		private final Assignment cProfilesAssignment_4_1_1 = (Assignment)cGroup_4_1.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_4_1_1_0 = (CrossReference)cProfilesAssignment_4_1_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_4_1_1_0_1 = (RuleCall)cProfilesProfileCrossReference_4_1_1_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cCommercialAtKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cAnnotationsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final CrossReference cAnnotationsPathAnnotationCrossReference_5_1_0 = (CrossReference)cAnnotationsAssignment_5_1.eContents().get(0);
		private final RuleCall cAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1 = (RuleCall)cAnnotationsPathAnnotationCrossReference_5_1_0.eContents().get(1);
		
		//UnidirectionalPath:
		//	{UnidirectionalPath} source=[SymbolicPosition] '-->' target=PathTargetReference ('profiles' profiles+=[Profile] (','
		//	profiles+=[Profile])* | 'profile' profiles+=[Profile]) ('@' annotations+=[PathAnnotation])*;
		@Override public ParserRule getRule() { return rule; }
		
		//{UnidirectionalPath} source=[SymbolicPosition] '-->' target=PathTargetReference ('profiles' profiles+=[Profile] (','
		//profiles+=[Profile])* | 'profile' profiles+=[Profile]) ('@' annotations+=[PathAnnotation])*
		public Group getGroup() { return cGroup; }
		
		//{UnidirectionalPath}
		public Action getUnidirectionalPathAction_0() { return cUnidirectionalPathAction_0; }
		
		//source=[SymbolicPosition]
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }
		
		//[SymbolicPosition]
		public CrossReference getSourceSymbolicPositionCrossReference_1_0() { return cSourceSymbolicPositionCrossReference_1_0; }
		
		//ID
		public RuleCall getSourceSymbolicPositionIDTerminalRuleCall_1_0_1() { return cSourceSymbolicPositionIDTerminalRuleCall_1_0_1; }
		
		//'-->'
		public Keyword getHyphenMinusHyphenMinusGreaterThanSignKeyword_2() { return cHyphenMinusHyphenMinusGreaterThanSignKeyword_2; }
		
		//target=PathTargetReference
		public Assignment getTargetAssignment_3() { return cTargetAssignment_3; }
		
		//PathTargetReference
		public RuleCall getTargetPathTargetReferenceParserRuleCall_3_0() { return cTargetPathTargetReferenceParserRuleCall_3_0; }
		
		//('profiles' profiles+=[Profile] (',' profiles+=[Profile])* | 'profile' profiles+=[Profile])
		public Alternatives getAlternatives_4() { return cAlternatives_4; }
		
		//'profiles' profiles+=[Profile] (',' profiles+=[Profile])*
		public Group getGroup_4_0() { return cGroup_4_0; }
		
		//'profiles'
		public Keyword getProfilesKeyword_4_0_0() { return cProfilesKeyword_4_0_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_4_0_1() { return cProfilesAssignment_4_0_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_4_0_1_0() { return cProfilesProfileCrossReference_4_0_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_4_0_1_0_1() { return cProfilesProfileIDTerminalRuleCall_4_0_1_0_1; }
		
		//(',' profiles+=[Profile])*
		public Group getGroup_4_0_2() { return cGroup_4_0_2; }
		
		//','
		public Keyword getCommaKeyword_4_0_2_0() { return cCommaKeyword_4_0_2_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_4_0_2_1() { return cProfilesAssignment_4_0_2_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_4_0_2_1_0() { return cProfilesProfileCrossReference_4_0_2_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1() { return cProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1; }
		
		//'profile' profiles+=[Profile]
		public Group getGroup_4_1() { return cGroup_4_1; }
		
		//'profile'
		public Keyword getProfileKeyword_4_1_0() { return cProfileKeyword_4_1_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_4_1_1() { return cProfilesAssignment_4_1_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_4_1_1_0() { return cProfilesProfileCrossReference_4_1_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_4_1_1_0_1() { return cProfilesProfileIDTerminalRuleCall_4_1_1_0_1; }
		
		//('@' annotations+=[PathAnnotation])*
		public Group getGroup_5() { return cGroup_5; }
		
		//'@'
		public Keyword getCommercialAtKeyword_5_0() { return cCommercialAtKeyword_5_0; }
		
		//annotations+=[PathAnnotation]
		public Assignment getAnnotationsAssignment_5_1() { return cAnnotationsAssignment_5_1; }
		
		//[PathAnnotation]
		public CrossReference getAnnotationsPathAnnotationCrossReference_5_1_0() { return cAnnotationsPathAnnotationCrossReference_5_1_0; }
		
		//ID
		public RuleCall getAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1() { return cAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1; }
	}
	public class BidirectionalPathElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.BidirectionalPath");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cBidirectionalPathAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cEndPointsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cEndPointsPathTargetReferenceParserRuleCall_1_0 = (RuleCall)cEndPointsAssignment_1.eContents().get(0);
		private final Keyword cLessThanSignHyphenMinusGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cEndPointsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cEndPointsPathTargetReferenceParserRuleCall_3_0 = (RuleCall)cEndPointsAssignment_3.eContents().get(0);
		private final Alternatives cAlternatives_4 = (Alternatives)cGroup.eContents().get(4);
		private final Group cGroup_4_0 = (Group)cAlternatives_4.eContents().get(0);
		private final Keyword cProfilesKeyword_4_0_0 = (Keyword)cGroup_4_0.eContents().get(0);
		private final Assignment cProfilesAssignment_4_0_1 = (Assignment)cGroup_4_0.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_4_0_1_0 = (CrossReference)cProfilesAssignment_4_0_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_4_0_1_0_1 = (RuleCall)cProfilesProfileCrossReference_4_0_1_0.eContents().get(1);
		private final Group cGroup_4_0_2 = (Group)cGroup_4_0.eContents().get(2);
		private final Keyword cCommaKeyword_4_0_2_0 = (Keyword)cGroup_4_0_2.eContents().get(0);
		private final Assignment cProfilesAssignment_4_0_2_1 = (Assignment)cGroup_4_0_2.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_4_0_2_1_0 = (CrossReference)cProfilesAssignment_4_0_2_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1 = (RuleCall)cProfilesProfileCrossReference_4_0_2_1_0.eContents().get(1);
		private final Group cGroup_4_1 = (Group)cAlternatives_4.eContents().get(1);
		private final Keyword cProfileKeyword_4_1_0 = (Keyword)cGroup_4_1.eContents().get(0);
		private final Assignment cProfilesAssignment_4_1_1 = (Assignment)cGroup_4_1.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_4_1_1_0 = (CrossReference)cProfilesAssignment_4_1_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_4_1_1_0_1 = (RuleCall)cProfilesProfileCrossReference_4_1_1_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cCommercialAtKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cAnnotationsAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final CrossReference cAnnotationsPathAnnotationCrossReference_5_1_0 = (CrossReference)cAnnotationsAssignment_5_1.eContents().get(0);
		private final RuleCall cAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1 = (RuleCall)cAnnotationsPathAnnotationCrossReference_5_1_0.eContents().get(1);
		
		//BidirectionalPath:
		//	{BidirectionalPath} endPoints+=PathTargetReference '<->' endPoints+=PathTargetReference ('profiles'
		//	profiles+=[Profile] (',' profiles+=[Profile])* | 'profile' profiles+=[Profile]) ('@' annotations+=[PathAnnotation])*;
		@Override public ParserRule getRule() { return rule; }
		
		//{BidirectionalPath} endPoints+=PathTargetReference '<->' endPoints+=PathTargetReference ('profiles' profiles+=[Profile]
		//(',' profiles+=[Profile])* | 'profile' profiles+=[Profile]) ('@' annotations+=[PathAnnotation])*
		public Group getGroup() { return cGroup; }
		
		//{BidirectionalPath}
		public Action getBidirectionalPathAction_0() { return cBidirectionalPathAction_0; }
		
		//endPoints+=PathTargetReference
		public Assignment getEndPointsAssignment_1() { return cEndPointsAssignment_1; }
		
		//PathTargetReference
		public RuleCall getEndPointsPathTargetReferenceParserRuleCall_1_0() { return cEndPointsPathTargetReferenceParserRuleCall_1_0; }
		
		//'<->'
		public Keyword getLessThanSignHyphenMinusGreaterThanSignKeyword_2() { return cLessThanSignHyphenMinusGreaterThanSignKeyword_2; }
		
		//endPoints+=PathTargetReference
		public Assignment getEndPointsAssignment_3() { return cEndPointsAssignment_3; }
		
		//PathTargetReference
		public RuleCall getEndPointsPathTargetReferenceParserRuleCall_3_0() { return cEndPointsPathTargetReferenceParserRuleCall_3_0; }
		
		//('profiles' profiles+=[Profile] (',' profiles+=[Profile])* | 'profile' profiles+=[Profile])
		public Alternatives getAlternatives_4() { return cAlternatives_4; }
		
		//'profiles' profiles+=[Profile] (',' profiles+=[Profile])*
		public Group getGroup_4_0() { return cGroup_4_0; }
		
		//'profiles'
		public Keyword getProfilesKeyword_4_0_0() { return cProfilesKeyword_4_0_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_4_0_1() { return cProfilesAssignment_4_0_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_4_0_1_0() { return cProfilesProfileCrossReference_4_0_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_4_0_1_0_1() { return cProfilesProfileIDTerminalRuleCall_4_0_1_0_1; }
		
		//(',' profiles+=[Profile])*
		public Group getGroup_4_0_2() { return cGroup_4_0_2; }
		
		//','
		public Keyword getCommaKeyword_4_0_2_0() { return cCommaKeyword_4_0_2_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_4_0_2_1() { return cProfilesAssignment_4_0_2_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_4_0_2_1_0() { return cProfilesProfileCrossReference_4_0_2_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1() { return cProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1; }
		
		//'profile' profiles+=[Profile]
		public Group getGroup_4_1() { return cGroup_4_1; }
		
		//'profile'
		public Keyword getProfileKeyword_4_1_0() { return cProfileKeyword_4_1_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_4_1_1() { return cProfilesAssignment_4_1_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_4_1_1_0() { return cProfilesProfileCrossReference_4_1_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_4_1_1_0_1() { return cProfilesProfileIDTerminalRuleCall_4_1_1_0_1; }
		
		//('@' annotations+=[PathAnnotation])*
		public Group getGroup_5() { return cGroup_5; }
		
		//'@'
		public Keyword getCommercialAtKeyword_5_0() { return cCommercialAtKeyword_5_0; }
		
		//annotations+=[PathAnnotation]
		public Assignment getAnnotationsAssignment_5_1() { return cAnnotationsAssignment_5_1; }
		
		//[PathAnnotation]
		public CrossReference getAnnotationsPathAnnotationCrossReference_5_1_0() { return cAnnotationsPathAnnotationCrossReference_5_1_0; }
		
		//ID
		public RuleCall getAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1() { return cAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1; }
	}
	public class FullMeshPathElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.FullMeshPath");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cFullMeshPathAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cFullMeshKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Group cGroup_3_0 = (Group)cAlternatives_3.eContents().get(0);
		private final Keyword cProfilesKeyword_3_0_0 = (Keyword)cGroup_3_0.eContents().get(0);
		private final Assignment cProfilesAssignment_3_0_1 = (Assignment)cGroup_3_0.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_3_0_1_0 = (CrossReference)cProfilesAssignment_3_0_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_3_0_1_0_1 = (RuleCall)cProfilesProfileCrossReference_3_0_1_0.eContents().get(1);
		private final Group cGroup_3_0_2 = (Group)cGroup_3_0.eContents().get(2);
		private final Keyword cCommaKeyword_3_0_2_0 = (Keyword)cGroup_3_0_2.eContents().get(0);
		private final Assignment cProfilesAssignment_3_0_2_1 = (Assignment)cGroup_3_0_2.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_3_0_2_1_0 = (CrossReference)cProfilesAssignment_3_0_2_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_3_0_2_1_0_1 = (RuleCall)cProfilesProfileCrossReference_3_0_2_1_0.eContents().get(1);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Keyword cProfileKeyword_3_1_0 = (Keyword)cGroup_3_1.eContents().get(0);
		private final Assignment cProfilesAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final CrossReference cProfilesProfileCrossReference_3_1_1_0 = (CrossReference)cProfilesAssignment_3_1_1.eContents().get(0);
		private final RuleCall cProfilesProfileIDTerminalRuleCall_3_1_1_0_1 = (RuleCall)cProfilesProfileCrossReference_3_1_1_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cCommercialAtKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cAnnotationsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final CrossReference cAnnotationsPathAnnotationCrossReference_4_1_0 = (CrossReference)cAnnotationsAssignment_4_1.eContents().get(0);
		private final RuleCall cAnnotationsPathAnnotationIDTerminalRuleCall_4_1_0_1 = (RuleCall)cAnnotationsPathAnnotationCrossReference_4_1_0.eContents().get(1);
		private final Assignment cEndPointsAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cEndPointsPathTargetReferenceParserRuleCall_5_0 = (RuleCall)cEndPointsAssignment_5.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_6 = (Keyword)cGroup.eContents().get(6);
		
		//FullMeshPath:
		//	{FullMeshPath}
		//	'FullMesh' '{' ('profiles' profiles+=[Profile] (',' profiles+=[Profile])* | 'profile' profiles+=[Profile]) ('@'
		//	annotations+=[PathAnnotation])*
		//	endPoints+=PathTargetReference*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//{FullMeshPath} 'FullMesh' '{' ('profiles' profiles+=[Profile] (',' profiles+=[Profile])* | 'profile'
		//profiles+=[Profile]) ('@' annotations+=[PathAnnotation])* endPoints+=PathTargetReference* '}'
		public Group getGroup() { return cGroup; }
		
		//{FullMeshPath}
		public Action getFullMeshPathAction_0() { return cFullMeshPathAction_0; }
		
		//'FullMesh'
		public Keyword getFullMeshKeyword_1() { return cFullMeshKeyword_1; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }
		
		//('profiles' profiles+=[Profile] (',' profiles+=[Profile])* | 'profile' profiles+=[Profile])
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//'profiles' profiles+=[Profile] (',' profiles+=[Profile])*
		public Group getGroup_3_0() { return cGroup_3_0; }
		
		//'profiles'
		public Keyword getProfilesKeyword_3_0_0() { return cProfilesKeyword_3_0_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_3_0_1() { return cProfilesAssignment_3_0_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_3_0_1_0() { return cProfilesProfileCrossReference_3_0_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_3_0_1_0_1() { return cProfilesProfileIDTerminalRuleCall_3_0_1_0_1; }
		
		//(',' profiles+=[Profile])*
		public Group getGroup_3_0_2() { return cGroup_3_0_2; }
		
		//','
		public Keyword getCommaKeyword_3_0_2_0() { return cCommaKeyword_3_0_2_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_3_0_2_1() { return cProfilesAssignment_3_0_2_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_3_0_2_1_0() { return cProfilesProfileCrossReference_3_0_2_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_3_0_2_1_0_1() { return cProfilesProfileIDTerminalRuleCall_3_0_2_1_0_1; }
		
		//'profile' profiles+=[Profile]
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//'profile'
		public Keyword getProfileKeyword_3_1_0() { return cProfileKeyword_3_1_0; }
		
		//profiles+=[Profile]
		public Assignment getProfilesAssignment_3_1_1() { return cProfilesAssignment_3_1_1; }
		
		//[Profile]
		public CrossReference getProfilesProfileCrossReference_3_1_1_0() { return cProfilesProfileCrossReference_3_1_1_0; }
		
		//ID
		public RuleCall getProfilesProfileIDTerminalRuleCall_3_1_1_0_1() { return cProfilesProfileIDTerminalRuleCall_3_1_1_0_1; }
		
		//('@' annotations+=[PathAnnotation])*
		public Group getGroup_4() { return cGroup_4; }
		
		//'@'
		public Keyword getCommercialAtKeyword_4_0() { return cCommercialAtKeyword_4_0; }
		
		//annotations+=[PathAnnotation]
		public Assignment getAnnotationsAssignment_4_1() { return cAnnotationsAssignment_4_1; }
		
		//[PathAnnotation]
		public CrossReference getAnnotationsPathAnnotationCrossReference_4_1_0() { return cAnnotationsPathAnnotationCrossReference_4_1_0; }
		
		//ID
		public RuleCall getAnnotationsPathAnnotationIDTerminalRuleCall_4_1_0_1() { return cAnnotationsPathAnnotationIDTerminalRuleCall_4_1_0_1; }
		
		//endPoints+=PathTargetReference*
		public Assignment getEndPointsAssignment_5() { return cEndPointsAssignment_5; }
		
		//PathTargetReference
		public RuleCall getEndPointsPathTargetReferenceParserRuleCall_5_0() { return cEndPointsPathTargetReferenceParserRuleCall_5_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_6() { return cRightCurlyBracketKeyword_6; }
	}
	public class PathTargetReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.PathTargetReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPathTargetReferenceAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cPositionAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cPositionSymbolicPositionCrossReference_1_0 = (CrossReference)cPositionAssignment_1.eContents().get(0);
		private final RuleCall cPositionSymbolicPositionIDTerminalRuleCall_1_0_1 = (RuleCall)cPositionSymbolicPositionCrossReference_1_0.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftSquareBracketKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cSettlingAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final CrossReference cSettlingAxisCrossReference_2_1_0 = (CrossReference)cSettlingAssignment_2_1.eContents().get(0);
		private final RuleCall cSettlingAxisIDTerminalRuleCall_2_1_0_1 = (RuleCall)cSettlingAxisCrossReference_2_1_0.eContents().get(1);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cCommaKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cSettlingAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final CrossReference cSettlingAxisCrossReference_2_2_1_0 = (CrossReference)cSettlingAssignment_2_2_1.eContents().get(0);
		private final RuleCall cSettlingAxisIDTerminalRuleCall_2_2_1_0_1 = (RuleCall)cSettlingAxisCrossReference_2_2_1_0.eContents().get(1);
		private final Keyword cRightSquareBracketKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		
		//PathTargetReference:
		//	{PathTargetReference} position=[SymbolicPosition] ('[' settling+=[Axis] (',' settling+=[Axis])* ']')?;
		@Override public ParserRule getRule() { return rule; }
		
		//{PathTargetReference} position=[SymbolicPosition] ('[' settling+=[Axis] (',' settling+=[Axis])* ']')?
		public Group getGroup() { return cGroup; }
		
		//{PathTargetReference}
		public Action getPathTargetReferenceAction_0() { return cPathTargetReferenceAction_0; }
		
		//position=[SymbolicPosition]
		public Assignment getPositionAssignment_1() { return cPositionAssignment_1; }
		
		//[SymbolicPosition]
		public CrossReference getPositionSymbolicPositionCrossReference_1_0() { return cPositionSymbolicPositionCrossReference_1_0; }
		
		//ID
		public RuleCall getPositionSymbolicPositionIDTerminalRuleCall_1_0_1() { return cPositionSymbolicPositionIDTerminalRuleCall_1_0_1; }
		
		//('[' settling+=[Axis] (',' settling+=[Axis])* ']')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_2_0() { return cLeftSquareBracketKeyword_2_0; }
		
		//settling+=[Axis]
		public Assignment getSettlingAssignment_2_1() { return cSettlingAssignment_2_1; }
		
		//[Axis]
		public CrossReference getSettlingAxisCrossReference_2_1_0() { return cSettlingAxisCrossReference_2_1_0; }
		
		//ID
		public RuleCall getSettlingAxisIDTerminalRuleCall_2_1_0_1() { return cSettlingAxisIDTerminalRuleCall_2_1_0_1; }
		
		//(',' settling+=[Axis])*
		public Group getGroup_2_2() { return cGroup_2_2; }
		
		//','
		public Keyword getCommaKeyword_2_2_0() { return cCommaKeyword_2_2_0; }
		
		//settling+=[Axis]
		public Assignment getSettlingAssignment_2_2_1() { return cSettlingAssignment_2_2_1; }
		
		//[Axis]
		public CrossReference getSettlingAxisCrossReference_2_2_1_0() { return cSettlingAxisCrossReference_2_2_1_0; }
		
		//ID
		public RuleCall getSettlingAxisIDTerminalRuleCall_2_2_1_0_1() { return cSettlingAxisIDTerminalRuleCall_2_2_1_0_1; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_2_3() { return cRightSquareBracketKeyword_2_3; }
	}
	public class IIDElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.machine.teditor.Machine.IID");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cINTTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIDTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//IID:
		//	INT | ID;
		@Override public ParserRule getRule() { return rule; }
		
		//INT | ID
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_0() { return cINTTerminalRuleCall_0; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_1() { return cIDTerminalRuleCall_1; }
	}
	
	
	private final MachineElements pMachine;
	private final ImportElements pImport;
	private final PathAnnotationElements pPathAnnotation;
	private final PeripheralTypeElements pPeripheralType;
	private final ActionTypeElements pActionType;
	private final SetPointElements pSetPoint;
	private final AxisElements pAxis;
	private final ResourceItemElements pResourceItem;
	private final ResourceElements pResource;
	private final PeripheralElements pPeripheral;
	private final DistanceElements pDistance;
	private final AxisPositionsMapEntryElements pAxisPositionsMapEntry;
	private final PositionElements pPosition;
	private final SymbolicPositionElements pSymbolicPosition;
	private final AxisPositionMapEntryElements pAxisPositionMapEntry;
	private final ProfileElements pProfile;
	private final PathElements pPath;
	private final UnidirectionalPathElements pUnidirectionalPath;
	private final BidirectionalPathElements pBidirectionalPath;
	private final FullMeshPathElements pFullMeshPath;
	private final PathTargetReferenceElements pPathTargetReference;
	private final IIDElements pIID;
	
	private final Grammar grammar;
	
	private final TerminalsGrammarAccess gaTerminals;

	@Inject
	public MachineGrammarAccess(GrammarProvider grammarProvider,
			TerminalsGrammarAccess gaTerminals) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaTerminals = gaTerminals;
		this.pMachine = new MachineElements();
		this.pImport = new ImportElements();
		this.pPathAnnotation = new PathAnnotationElements();
		this.pPeripheralType = new PeripheralTypeElements();
		this.pActionType = new ActionTypeElements();
		this.pSetPoint = new SetPointElements();
		this.pAxis = new AxisElements();
		this.pResourceItem = new ResourceItemElements();
		this.pResource = new ResourceElements();
		this.pPeripheral = new PeripheralElements();
		this.pDistance = new DistanceElements();
		this.pAxisPositionsMapEntry = new AxisPositionsMapEntryElements();
		this.pPosition = new PositionElements();
		this.pSymbolicPosition = new SymbolicPositionElements();
		this.pAxisPositionMapEntry = new AxisPositionMapEntryElements();
		this.pProfile = new ProfileElements();
		this.pPath = new PathElements();
		this.pUnidirectionalPath = new UnidirectionalPathElements();
		this.pBidirectionalPath = new BidirectionalPathElements();
		this.pFullMeshPath = new FullMeshPathElements();
		this.pPathTargetReference = new PathTargetReferenceElements();
		this.pIID = new IIDElements();
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.lsat.machine.teditor.Machine".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public TerminalsGrammarAccess getTerminalsGrammarAccess() {
		return gaTerminals;
	}

	
	//Machine:
	//	{Machine} imports+=Import* ('Machine' type=ID)? ('PathAnnotations' '{'
	//	pathAnnotations+=PathAnnotation*
	//	'}')? (peripheralTypes+=PeripheralType | resources+=Resource)*;
	public MachineElements getMachineAccess() {
		return pMachine;
	}
	
	public ParserRule getMachineRule() {
		return getMachineAccess().getRule();
	}
	
	//Import:
	//	"import" importURI=STRING;
	public ImportElements getImportAccess() {
		return pImport;
	}
	
	public ParserRule getImportRule() {
		return getImportAccess().getRule();
	}
	
	//PathAnnotation:
	//	{PathAnnotation} name=ID;
	public PathAnnotationElements getPathAnnotationAccess() {
		return pPathAnnotation;
	}
	
	public ParserRule getPathAnnotationRule() {
		return getPathAnnotationAccess().getRule();
	}
	
	//PeripheralType:
	//	{PeripheralType}
	//	'PeripheralType' name=ID '{' ('Actions' '{' actions+=ActionType* '}')? ('SetPoints' '{' setPoints+=SetPoint* '}'
	//	'Axes' '{' axes+=Axis* '}' ('Conversion' conversion=STRING)?)?
	//	'}';
	public PeripheralTypeElements getPeripheralTypeAccess() {
		return pPeripheralType;
	}
	
	public ParserRule getPeripheralTypeRule() {
		return getPeripheralTypeAccess().getRule();
	}
	
	//ActionType:
	//	{ActionType} name=ID;
	public ActionTypeElements getActionTypeAccess() {
		return pActionType;
	}
	
	public ParserRule getActionTypeRule() {
		return getActionTypeAccess().getRule();
	}
	
	//SetPoint:
	//	{SetPoint} name=ID ('[' unit=ID ']')?;
	public SetPointElements getSetPointAccess() {
		return pSetPoint;
	}
	
	public ParserRule getSetPointRule() {
		return getSetPointAccess().getRule();
	}
	
	//Axis:
	//	{Axis} name=ID ('[' unit=ID ']')? ('moves' setPoints+=[SetPoint] (',' setPoints+=[SetPoint])*)?;
	public AxisElements getAxisAccess() {
		return pAxis;
	}
	
	public ParserRule getAxisRule() {
		return getAxisAccess().getRule();
	}
	
	//ResourceItem:
	//	{ResourceItem} name=IID;
	public ResourceItemElements getResourceItemAccess() {
		return pResourceItem;
	}
	
	public ParserRule getResourceItemRule() {
		return getResourceItemAccess().getRule();
	}
	
	//Resource:
	//	'Resource' name=ID ('(' items+=ResourceItem (',' items+=ResourceItem)* ')')? '{'
	//	peripherals+=Peripheral*
	//	'}';
	public ResourceElements getResourceAccess() {
		return pResource;
	}
	
	public ParserRule getResourceRule() {
		return getResourceAccess().getRule();
	}
	
	//Peripheral:
	//	name=ID ':' type=[PeripheralType] ('{' (('AxisPositions' '{' axisPositions+=AxisPositionsMapEntry* '}')?
	//	('SymbolicPositions' '{' positions+=SymbolicPosition* '}')?
	//	'Profiles' '(' profiles+=Profile (',' profiles+=Profile)* ')' ('Distances' '{' distances+=Distance* '}')? ('Paths' '{'
	//	paths+=Path* '}')?)?
	//	'}')?;
	public PeripheralElements getPeripheralAccess() {
		return pPeripheral;
	}
	
	public ParserRule getPeripheralRule() {
		return getPeripheralAccess().getRule();
	}
	
	//Distance:
	//	{Distance} name=ID ('[' settling+=[Axis] (',' settling+=[Axis])* ']')?;
	public DistanceElements getDistanceAccess() {
		return pDistance;
	}
	
	public ParserRule getDistanceRule() {
		return getDistanceAccess().getRule();
	}
	
	//AxisPositionsMapEntry:
	//	{AxisPositionsMapEntry} key=[Axis] ('(' value+=Position (',' value+=Position)* ')')?;
	public AxisPositionsMapEntryElements getAxisPositionsMapEntryAccess() {
		return pAxisPositionsMapEntry;
	}
	
	public ParserRule getAxisPositionsMapEntryRule() {
		return getAxisPositionsMapEntryAccess().getRule();
	}
	
	//Position:
	//	{Position} name=ID;
	public PositionElements getPositionAccess() {
		return pPosition;
	}
	
	public ParserRule getPositionRule() {
		return getPositionAccess().getRule();
	}
	
	//SymbolicPosition:
	//	{SymbolicPosition} name=ID ('(' axisPosition+=AxisPositionMapEntry (',' axisPosition+=AxisPositionMapEntry)* ')')?;
	public SymbolicPositionElements getSymbolicPositionAccess() {
		return pSymbolicPosition;
	}
	
	public ParserRule getSymbolicPositionRule() {
		return getSymbolicPositionAccess().getRule();
	}
	
	//AxisPositionMapEntry:
	//	{AxisPositionMapEntry} key=[Axis] '.' value=[Position];
	public AxisPositionMapEntryElements getAxisPositionMapEntryAccess() {
		return pAxisPositionMapEntry;
	}
	
	public ParserRule getAxisPositionMapEntryRule() {
		return getAxisPositionMapEntryAccess().getRule();
	}
	
	//Profile:
	//	{Profile} name=ID;
	public ProfileElements getProfileAccess() {
		return pProfile;
	}
	
	public ParserRule getProfileRule() {
		return getProfileAccess().getRule();
	}
	
	//Path:
	//	UnidirectionalPath | BidirectionalPath | FullMeshPath;
	public PathElements getPathAccess() {
		return pPath;
	}
	
	public ParserRule getPathRule() {
		return getPathAccess().getRule();
	}
	
	//UnidirectionalPath:
	//	{UnidirectionalPath} source=[SymbolicPosition] '-->' target=PathTargetReference ('profiles' profiles+=[Profile] (','
	//	profiles+=[Profile])* | 'profile' profiles+=[Profile]) ('@' annotations+=[PathAnnotation])*;
	public UnidirectionalPathElements getUnidirectionalPathAccess() {
		return pUnidirectionalPath;
	}
	
	public ParserRule getUnidirectionalPathRule() {
		return getUnidirectionalPathAccess().getRule();
	}
	
	//BidirectionalPath:
	//	{BidirectionalPath} endPoints+=PathTargetReference '<->' endPoints+=PathTargetReference ('profiles'
	//	profiles+=[Profile] (',' profiles+=[Profile])* | 'profile' profiles+=[Profile]) ('@' annotations+=[PathAnnotation])*;
	public BidirectionalPathElements getBidirectionalPathAccess() {
		return pBidirectionalPath;
	}
	
	public ParserRule getBidirectionalPathRule() {
		return getBidirectionalPathAccess().getRule();
	}
	
	//FullMeshPath:
	//	{FullMeshPath}
	//	'FullMesh' '{' ('profiles' profiles+=[Profile] (',' profiles+=[Profile])* | 'profile' profiles+=[Profile]) ('@'
	//	annotations+=[PathAnnotation])*
	//	endPoints+=PathTargetReference*
	//	'}';
	public FullMeshPathElements getFullMeshPathAccess() {
		return pFullMeshPath;
	}
	
	public ParserRule getFullMeshPathRule() {
		return getFullMeshPathAccess().getRule();
	}
	
	//PathTargetReference:
	//	{PathTargetReference} position=[SymbolicPosition] ('[' settling+=[Axis] (',' settling+=[Axis])* ']')?;
	public PathTargetReferenceElements getPathTargetReferenceAccess() {
		return pPathTargetReference;
	}
	
	public ParserRule getPathTargetReferenceRule() {
		return getPathTargetReferenceAccess().getRule();
	}
	
	//IID:
	//	INT | ID;
	public IIDElements getIIDAccess() {
		return pIID;
	}
	
	public ParserRule getIIDRule() {
		return getIIDAccess().getRule();
	}
	
	//terminal ID:
	//	'^'? ('a'..'z' | 'A'..'Z' | '_') ('a'..'z' | 'A'..'Z' | '_' | '0'..'9')*;
	public TerminalRule getIDRule() {
		return gaTerminals.getIDRule();
	}
	
	//terminal INT returns ecore::EInt:
	//	'0'..'9'+;
	public TerminalRule getINTRule() {
		return gaTerminals.getINTRule();
	}
	
	//terminal STRING:
	//	'"' ('\\' . | !('\\' | '"'))* '"' |
	//	"'" ('\\' . | !('\\' | "'"))* "'";
	public TerminalRule getSTRINGRule() {
		return gaTerminals.getSTRINGRule();
	}
	
	//terminal ML_COMMENT:
	//	'/*'->'*/';
	public TerminalRule getML_COMMENTRule() {
		return gaTerminals.getML_COMMENTRule();
	}
	
	//terminal SL_COMMENT:
	//	'//' !('\n' | '\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return gaTerminals.getSL_COMMENTRule();
	}
	
	//terminal WS:
	//	' ' | '\t' | '\r' | '\n'+;
	public TerminalRule getWSRule() {
		return gaTerminals.getWSRule();
	}
	
	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaTerminals.getANY_OTHERRule();
	}
}
