/*
 * Decompiled with CFR 0.152.
 */
package timing;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import timing.Distribution;
import timing.EnumeratedDistribution;
import timing.NormalDistribution;
import timing.PertDistribution;
import timing.TriangularDistribution;
import timing.distribution.EnumeratedModeDistribution;
import timing.distribution.ModeDistribution;
import timing.distribution.NormalModeDistribution;
import timing.distribution.TriangularModeDistribution;

public final class DistributionsFactory {
    private static final RandomGenerator DEFAULT_RANDOM = new JDKRandomGenerator();

    private DistributionsFactory() {
    }

    public static ModeDistribution createRealDistribution(Distribution distribution) {
        return DistributionsFactory.createRealDistribution(distribution, DEFAULT_RANDOM);
    }

    public static ModeDistribution createRealDistribution(Distribution distribution, RandomGenerator random) {
        switch (distribution.eClass().getClassifierID()) {
            case 3: {
                TriangularDistribution td = (TriangularDistribution)distribution;
                return new TriangularModeDistribution(random, td.getMin().doubleValue(), td.getMode().doubleValue(), td.getMax().doubleValue(), DistributionsFactory.getDefault(distribution));
            }
            case 6: {
                NormalDistribution nd = (NormalDistribution)distribution;
                return new NormalModeDistribution(random, nd.getMean().doubleValue(), nd.getSd().doubleValue(), 1.0E-9, DistributionsFactory.getDefault(distribution));
            }
            case 7: {
                EnumeratedDistribution ed = (EnumeratedDistribution)distribution;
                return new EnumeratedModeDistribution(random, DistributionsFactory.toDouble(ed.getValues()), DistributionsFactory.getDefault(distribution));
            }
            case 5: {
                PertDistribution pd = (PertDistribution)distribution;
                return new timing.distribution.PertDistribution(random, pd.getMin().doubleValue(), pd.getMax().doubleValue(), pd.getMode().doubleValue(), pd.getGamma().doubleValue(), DistributionsFactory.getDefault(distribution));
            }
        }
        throw new IllegalArgumentException("Distribution type not supported: " + distribution.getClass());
    }

    private static double[] toDouble(List<BigDecimal> values) {
        double[] result = new double[values.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = values.get(i).doubleValue();
            ++i;
        }
        return result;
    }

    private static Double getDefault(Distribution distribution) {
        return distribution.getDefault() == null ? null : Double.valueOf(distribution.getDefault().doubleValue());
    }
}

