/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClassUtil {
    private static final @NonNull Iterator<?> EMPTY_ITERATOR = new EmptyIterator();

    public static <T> @Nullable T asClassOrNull(Object object, Class<T> requiredClass) {
        if (object == null) {
            return null;
        }
        if (requiredClass == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        if (!objectClass.isAssignableFrom(objectClass)) {
            return null;
        }
        return (T)object;
    }

    public static <T> T asClassUnchecked(Object object, T requiredClassObject) {
        return (T)object;
    }

    public static <T> T asClassUnchecked(Object object) {
        return (T)object;
    }

    public static @Nullable EAnnotation basicGetMetamodelAnnotation(@NonNull EPackage ePackage) {
        EAnnotation asMetamodelAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/OCL/ASMetamodel");
        return asMetamodelAnnotation;
    }

    public static <T> @NonNull Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> @Nullable T getAdapter(@Nullable IAdaptable iAdaptable, @NonNull Class<T> adapterClass) {
        return (T)(iAdaptable != null ? iAdaptable.getAdapter(adapterClass) : null);
    }

    public static <T> @Nullable T getAdapter(@NonNull Class<T> adapterClass, @NonNull Notifier notifier) {
        List eAdapters = (List)ClassUtil.nonNullEMF(notifier.eAdapters());
        return ClassUtil.getAdapter(adapterClass, eAdapters);
    }

    public static <T> @Nullable T getAdapter(@NonNull Class<T> adapterClass, @NonNull List<Adapter> eAdapters) {
        Adapter adapter = EcoreUtil.getAdapter(eAdapters, adapterClass);
        if (adapter == null) {
            return null;
        }
        if (!adapterClass.isAssignableFrom(adapter.getClass())) {
            throw new ClassCastException(String.valueOf(adapter.getClass().getName()) + " is not assignable to " + adapterClass.getName());
        }
        Adapter castAdapter = adapter;
        return (T)castAdapter;
    }

    public static <T> Class<T> getClass(T object) {
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    public static @NonNull EAnnotation getEAnnotation(@NonNull EModelElement eModelElement, String sourceURI) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(sourceURI);
            eModelElement.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static @NonNull EAnnotation getMetamodelAnnotation(@NonNull EPackage ePackage) {
        EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/OCL/ASMetamodel");
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/OCL/ASMetamodel");
            ePackage.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static <T> @Nullable T isInstanceOf(Object anObject, Class<T> aClass) {
        if (anObject == null) {
            return null;
        }
        Class<?> objectClass = anObject.getClass();
        if (aClass.isAssignableFrom(objectClass)) {
            return (T)anObject;
        }
        return null;
    }

    public static boolean isRegistered(Resource resource) {
        if (resource == null) {
            return false;
        }
        return resource.getResourceSet() == null;
    }

    public static <T> @NonNull T nonNull(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    public static <T> @NonNull T nonNullEMF(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    public static <T> @NonNull T nonNullModel(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    public static <T> @NonNull T nonNullPivot(@Nullable T aT) {
        assert (aT != null);
        return aT;
    }

    public static <T> @NonNull T nonNullState(@Nullable T aT) {
        if (aT == null) {
            throw new IllegalStateException();
        }
        return aT;
    }

    public static <T> @NonNull List<@NonNull T> nullFree(@Nullable List<T> nullFreeList) {
        return nullFreeList != null ? nullFreeList : Collections.emptyList();
    }

    public static <T> @NonNull EList<@NonNull T> nullFree(@Nullable EList<T> nullFreeList) {
        return nullFreeList != null ? nullFreeList : ECollections.EMPTY_ELIST;
    }

    public static <T> @NonNull Iterable<@NonNull T> nullFree(@Nullable Iterable<T> nullFreeList) {
        return nullFreeList != null ? nullFreeList : ECollections.EMPTY_ELIST;
    }

    public static <T extends Comparable<T>> int safeCompareTo(@Nullable T object, @Nullable T otherObject) {
        if (object == null) {
            return otherObject == null ? 0 : 1;
        }
        return otherObject == null ? -1 : object.compareTo(otherObject);
    }

    public static boolean safeEquals(@Nullable Object object, @Nullable Object otherObject) {
        return object == null ? otherObject == null : object.equals(otherObject);
    }

    public static <T> void sort(@NonNull List<? extends T> aList, @NonNull Comparator<T> comparator) {
        if (aList.size() > 1) {
            if (aList instanceof EList) {
                ECollections.sort((EList)((EList)aList), comparator);
            } else {
                Collections.sort(aList, comparator);
            }
        }
    }

    @Deprecated
    public static @NonNull String toString(Object anObject) {
        return String.valueOf(anObject);
    }

    private static final class EmptyIterator
    implements Iterator<Object> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    }
}

