/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.FixedLayouterOptions;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class FixedLayoutProvider
extends AbstractLayoutProvider {
    @Override
    public void layout(ElkNode layoutNode, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Fixed Layout", 1.0f);
        EdgeRouting edgeRouting = (EdgeRouting)((Object)layoutNode.getProperty(CoreOptions.EDGE_ROUTING));
        double maxx = 0.0;
        double maxy = 0.0;
        for (ElkNode node : layoutNode.getChildren()) {
            KVector pos = (KVector)node.getProperty(FixedLayouterOptions.POSITION);
            if (pos != null) {
                node.setLocation(pos.x, pos.y);
                if (((EnumSet)node.getProperty(FixedLayouterOptions.NODE_SIZE_CONSTRAINTS)).contains((Object)SizeConstraint.MINIMUM_SIZE)) {
                    double height;
                    double width;
                    KVector minSize = (KVector)node.getProperty(FixedLayouterOptions.NODE_SIZE_MINIMUM);
                    if (minSize == null) {
                        width = (Double)node.getProperty(FixedLayouterOptions.NODE_SIZE_MIN_WIDTH);
                        height = (Double)node.getProperty(FixedLayouterOptions.NODE_SIZE_MIN_HEIGHT);
                    } else {
                        width = minSize.x;
                        height = minSize.y;
                    }
                    if (width > 0.0 && height > 0.0) {
                        ElkUtil.resizeNode(node, width, height, true, true);
                    }
                }
            }
            maxx = Math.max(maxx, node.getX() + node.getWidth());
            maxy = Math.max(maxy, node.getY() + node.getHeight());
            for (ElkLabel label : node.getLabels()) {
                pos = (KVector)label.getProperty(FixedLayouterOptions.POSITION);
                if (pos != null) {
                    label.setLocation(pos.x, pos.y);
                }
                maxx = Math.max(maxx, node.getX() + label.getX() + label.getWidth());
                maxy = Math.max(maxy, node.getY() + label.getY() + label.getHeight());
            }
            for (ElkPort port : node.getPorts()) {
                pos = (KVector)port.getProperty(FixedLayouterOptions.POSITION);
                if (pos != null) {
                    port.setLocation(pos.x, pos.y);
                }
                double portx = node.getX() + port.getX();
                double porty = node.getY() + port.getY();
                maxx = Math.max(maxx, portx + port.getWidth());
                maxy = Math.max(maxy, porty + port.getHeight());
                for (ElkLabel label : port.getLabels()) {
                    pos = (KVector)label.getProperty(FixedLayouterOptions.POSITION);
                    if (pos != null) {
                        label.setLocation(pos.x, pos.y);
                    }
                    maxx = Math.max(maxx, portx + label.getX() + label.getWidth());
                    maxy = Math.max(maxy, porty + label.getY() + label.getHeight());
                }
            }
            for (Iterator edge : node.getOutgoingEdges()) {
                KVector maxv = this.processEdge((ElkEdge)edge, edgeRouting);
                maxx = Math.max(maxx, maxv.x);
                maxy = Math.max(maxy, maxv.y);
            }
            for (Iterator edge : node.getIncomingEdges()) {
                if (ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getSources().get(0))) == layoutNode) continue;
                KVector maxv = this.processEdge((ElkEdge)edge, edgeRouting);
                maxx = Math.max(maxx, maxv.x);
                maxy = Math.max(maxy, maxv.y);
            }
        }
        if (edgeRouting == EdgeRouting.ORTHOGONAL) {
            for (ElkNode node : layoutNode.getChildren()) {
                for (ElkEdge edge : node.getOutgoingEdges()) {
                    this.generateJunctionPoints(edge);
                }
            }
        }
        ElkPadding padding = (ElkPadding)layoutNode.getProperty(FixedLayouterOptions.PADDING);
        double newWidth = maxx + padding.getLeft() + padding.getRight();
        double newHeight = maxy + padding.getTop() + padding.getBottom();
        ElkUtil.resizeNode(layoutNode, newWidth, newHeight, true, true);
        progressMonitor.done();
    }

    private KVector processEdge(ElkEdge edge, EdgeRouting edgeRouting) {
        ElkNode targetParent;
        ElkNode sourceParent = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getSources().get(0))).getParent();
        boolean sameHierarchy = sourceParent == (targetParent = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0))).getParent());
        KVector maxv = new KVector();
        KVectorChain bendPoints = (KVectorChain)edge.getProperty(FixedLayouterOptions.BEND_POINTS);
        if (bendPoints != null && bendPoints.size() >= 2) {
            if (edge.getSections().isEmpty()) {
                ElkEdgeSection edgeSection = ElkGraphFactory.eINSTANCE.createElkEdgeSection();
                edge.getSections().add((Object)edgeSection);
            } else if (edge.getSections().size() > 1) {
                ListIterator sections = edge.getSections().listIterator();
                while (sections.hasNext()) {
                    sections.remove();
                }
            }
            ElkUtil.applyVectorChain(bendPoints, (ElkEdgeSection)edge.getSections().get(0));
        }
        if (sameHierarchy) {
            for (ElkEdgeSection edgeSection : edge.getSections()) {
                for (ElkBendPoint point : edgeSection.getBendPoints()) {
                    maxv.x = Math.max(maxv.x, point.getX());
                    maxv.y = Math.max(maxv.y, point.getY());
                }
            }
        }
        for (ElkLabel label : edge.getLabels()) {
            KVector pos = (KVector)label.getProperty(FixedLayouterOptions.POSITION);
            if (pos != null) {
                label.setLocation(pos.x, pos.y);
            }
            if (!sameHierarchy) continue;
            maxv.x = Math.max(maxv.x, label.getX() + label.getWidth());
            maxv.y = Math.max(maxv.y, label.getY() + label.getHeight());
        }
        return maxv;
    }

    private void generateJunctionPoints(ElkEdge edge) {
        KVectorChain junctionPoints = ElkUtil.determineJunctionPoints(edge);
        if (junctionPoints.isEmpty()) {
            edge.setProperty(CoreOptions.JUNCTION_POINTS, null);
        } else {
            edge.setProperty(CoreOptions.JUNCTION_POINTS, (Object)junctionPoints);
        }
    }
}

