/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.BoolTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.EnumTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.IntTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.NegateOperation;
import org.eclipse.escet.cif.codegen.typeinfos.OrderingOperations;
import org.eclipse.escet.cif.codegen.typeinfos.RealTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.StringTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public abstract class ExprCodeGen {
    protected ExprCode predsToTarget(List<Expression> preds, CodeContext ctxt) {
        List txts = Lists.listc((int)preds.size());
        for (Expression pred : preds) {
            txts.add(this.exprToTarget(pred, null, ctxt));
        }
        return this.predTextsToTarget(txts, ctxt);
    }

    protected abstract ExprCode predTextsToTarget(List<ExprCode> var1, CodeContext var2);

    protected ExprCode exprToTarget(Expression expr, Destination dest, CodeContext ctxt) {
        ExprCode result = this.internalExprToTarget(expr, dest, ctxt);
        if (dest == null) {
            Assert.check((boolean)result.hasDataValue());
        } else {
            Assert.check((!result.hasDataValue() ? 1 : 0) != 0);
        }
        return result;
    }

    private ExprCode internalExprToTarget(Expression expr, Destination dest, CodeContext ctxt) {
        if (expr instanceof BoolExpression) {
            return this.convertBoolExpression((BoolExpression)expr, dest, ctxt);
        }
        if (expr instanceof IntExpression) {
            return this.convertIntExpression((IntExpression)expr, dest, ctxt);
        }
        if (expr instanceof RealExpression) {
            return this.convertRealExpression((RealExpression)expr, dest, ctxt);
        }
        if (expr instanceof StringExpression) {
            return this.convertStringExpression((StringExpression)expr, dest, ctxt);
        }
        if (expr instanceof TimeExpression) {
            return this.convertTimeExpression((TimeExpression)expr, dest, ctxt);
        }
        if (expr instanceof CastExpression) {
            return this.convertCastExpression((CastExpression)expr, dest, ctxt);
        }
        if (expr instanceof UnaryExpression) {
            return this.convertUnaryExpression((UnaryExpression)expr, dest, ctxt);
        }
        if (expr instanceof BinaryExpression) {
            return this.convertBinaryExpression((BinaryExpression)expr, dest, ctxt);
        }
        if (expr instanceof IfExpression) {
            return this.convertIfExpression((IfExpression)expr, dest, ctxt);
        }
        if (expr instanceof ProjectionExpression) {
            return this.convertProjectionExpression((ProjectionExpression)expr, dest, ctxt);
        }
        if (expr instanceof FunctionCallExpression) {
            return this.convertFunctionCallExpression((FunctionCallExpression)expr, dest, ctxt);
        }
        if (expr instanceof ListExpression) {
            return this.convertListExpression((ListExpression)expr, dest, ctxt);
        }
        if (expr instanceof TupleExpression) {
            return this.convertTupleExpression((TupleExpression)expr, dest, ctxt);
        }
        if (expr instanceof ConstantExpression) {
            return this.convertConstantExpression((ConstantExpression)expr, dest, ctxt);
        }
        if (expr instanceof DiscVariableExpression) {
            return this.convertDiscVariableExpression((DiscVariableExpression)expr, dest, ctxt);
        }
        if (expr instanceof AlgVariableExpression) {
            return this.convertAlgVariableExpression((AlgVariableExpression)expr, dest, ctxt);
        }
        if (expr instanceof ContVariableExpression) {
            return this.convertContVariableExpression((ContVariableExpression)expr, dest, ctxt);
        }
        if (expr instanceof EnumLiteralExpression) {
            return this.convertEnumLiteralExpression((EnumLiteralExpression)expr, dest, ctxt);
        }
        if (expr instanceof InputVariableExpression) {
            return this.convertInputVariableExpression((InputVariableExpression)expr, dest, ctxt);
        }
        throw new RuntimeException("Unexpected expr: " + expr);
    }

    protected ExprCode convertBoolExpression(BoolExpression expr, Destination dest, CodeContext ctxt) {
        BoolTypeInfo ti = (BoolTypeInfo)ctxt.typeToTarget(expr.getType());
        return ti.convertLiteral(expr.isValue(), dest, ctxt);
    }

    protected ExprCode convertIntExpression(IntExpression expr, Destination dest, CodeContext ctxt) {
        String resultText = Integer.toString(expr.getValue());
        IntTypeInfo ti = (IntTypeInfo)ctxt.typeToTarget(expr.getType());
        return ti.convertLiteral(resultText, dest, ctxt);
    }

    protected ExprCode convertRealExpression(RealExpression expr, Destination dest, CodeContext ctxt) {
        String valueTxt = expr.getValue();
        double value = Double.parseDouble(valueTxt);
        Assert.check((boolean)Double.isFinite(value));
        String resultText = Double.toString(value);
        RealTypeInfo ti = (RealTypeInfo)ctxt.typeToTarget(expr.getType());
        return ti.convertLiteral(resultText, dest, ctxt);
    }

    protected ExprCode convertStringExpression(StringExpression expr, Destination dest, CodeContext ctxt) {
        String resultText = Strings.stringToJava((String)expr.getValue());
        StringTypeInfo ti = (StringTypeInfo)ctxt.typeToTarget(expr.getType());
        return ti.convertLiteral(resultText, dest, ctxt);
    }

    protected ExprCode convertTimeExpression(TimeExpression expr, Destination dest, CodeContext ctxt) {
        RealTypeInfo ti = (RealTypeInfo)ctxt.typeToTarget(expr.getType());
        return ti.convertTimeExpression(dest, ctxt);
    }

    private boolean isBoolIntRealType(CifType type) {
        return type instanceof BoolType || type instanceof IntType || type instanceof RealType;
    }

    protected ExprCode convertCastExpression(CastExpression expr, Destination dest, CodeContext ctxt) {
        Expression child = expr.getChild();
        Assert.check((!CifTypeUtils.isAutRefExpr((Expression)child) ? 1 : 0) != 0);
        CifType childType = CifTypeUtils.normalizeType((CifType)child.getType());
        CifType exprType = CifTypeUtils.normalizeType((CifType)expr.getType());
        if (childType instanceof IntType && exprType instanceof RealType || this.isBoolIntRealType(childType) && exprType instanceof StringType || childType instanceof StringType && this.isBoolIntRealType(exprType)) {
            return this.convertCastExpression(exprType, childType, child, dest, ctxt);
        }
        if (CifTypeUtils.checkTypeCompat((CifType)childType, (CifType)exprType, (RangeCompat)RangeCompat.EQUAL)) {
            return this.exprToTarget(child, dest, ctxt);
        }
        String msg = "Unknown cast: " + childType + ", " + exprType;
        throw new RuntimeException(msg);
    }

    protected abstract ExprCode convertCastExpression(CifType var1, CifType var2, Expression var3, Destination var4, CodeContext var5);

    protected ExprCode convertUnaryExpression(UnaryExpression expr, Destination dest, CodeContext ctxt) {
        TypeInfo ti = ctxt.typeToTarget(expr.getType());
        switch (expr.getOperator()) {
            case INVERSE: {
                BoolTypeInfo boolTi = (BoolTypeInfo)ti;
                return boolTi.convertInvert(expr.getChild(), dest, ctxt);
            }
            case NEGATE: {
                NegateOperation negateOp = (NegateOperation)((Object)ti);
                return negateOp.convertNegate(expr, dest, ctxt);
            }
            case PLUS: {
                return this.exprToTarget(expr.getChild(), dest, ctxt);
            }
            case SAMPLE: {
                break;
            }
        }
        throw new RuntimeException("Unsupported unary operator: " + expr.getOperator());
    }

    protected ExprCode convertBinaryExpression(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        TypeInfo resultTI = ctxt.typeToTarget(expr.getType());
        switch (expr.getOperator()) {
            case DISJUNCTION: 
            case IMPLICATION: 
            case CONJUNCTION: {
                BoolTypeInfo boolTI = (BoolTypeInfo)resultTI;
                return boolTI.convertShortCircuit(expr, dest, ctxt);
            }
            case BI_CONDITIONAL: 
            case EQUAL: {
                TypeInfo leftTI = ctxt.typeToTarget(expr.getLeft().getType());
                return leftTI.convertEqualsExpression(expr, dest, ctxt);
            }
            case UNEQUAL: {
                TypeInfo leftTI = ctxt.typeToTarget(expr.getLeft().getType());
                return leftTI.convertUnequalsExpression(expr, dest, ctxt);
            }
            case GREATER_EQUAL: {
                return this.getOrderingOperation(expr, ctxt).convertGreaterEqual(expr, dest, ctxt);
            }
            case GREATER_THAN: {
                return this.getOrderingOperation(expr, ctxt).convertGreaterThan(expr, dest, ctxt);
            }
            case LESS_EQUAL: {
                return this.getOrderingOperation(expr, ctxt).convertLessEqual(expr, dest, ctxt);
            }
            case LESS_THAN: {
                return this.getOrderingOperation(expr, ctxt).convertLessThan(expr, dest, ctxt);
            }
            case INTEGER_DIVISION: {
                IntTypeInfo ti = (IntTypeInfo)resultTI;
                return ti.convertDiv(expr, dest, ctxt);
            }
            case MODULUS: {
                IntTypeInfo ti = (IntTypeInfo)resultTI;
                return ti.convertMod(expr, dest, ctxt);
            }
            case MULTIPLICATION: {
                if (resultTI instanceof IntTypeInfo) {
                    IntTypeInfo ti = (IntTypeInfo)resultTI;
                    return ti.convertMultiplication(expr, dest, ctxt);
                }
                RealTypeInfo ti = (RealTypeInfo)resultTI;
                return ti.convertMultiplication(expr, dest, ctxt);
            }
            case DIVISION: {
                RealTypeInfo ti = (RealTypeInfo)resultTI;
                return ti.convertDivision(expr, dest, ctxt);
            }
            case ADDITION: {
                if (resultTI instanceof IntTypeInfo) {
                    IntTypeInfo ti = (IntTypeInfo)resultTI;
                    return ti.convertAddition(expr, dest, ctxt);
                }
                if (resultTI instanceof RealTypeInfo) {
                    RealTypeInfo ti = (RealTypeInfo)resultTI;
                    return ti.convertAddition(expr, dest, ctxt);
                }
                Assert.check((boolean)(resultTI instanceof StringTypeInfo));
                StringTypeInfo ti = (StringTypeInfo)resultTI;
                return ti.convertConcatenation(expr, dest, ctxt);
            }
            case SUBTRACTION: {
                if (resultTI instanceof IntTypeInfo) {
                    IntTypeInfo ti = (IntTypeInfo)resultTI;
                    return ti.convertSubtraction(expr, dest, ctxt);
                }
                Assert.check((boolean)(resultTI instanceof RealTypeInfo));
                RealTypeInfo ti = (RealTypeInfo)resultTI;
                return ti.convertSubtraction(expr, dest, ctxt);
            }
        }
        String msg = "Unexpected binary expression: " + Strings.str((Object)expr.getOperator());
        throw new RuntimeException(msg);
    }

    private OrderingOperations getOrderingOperation(BinaryExpression expr, CodeContext ctxt) {
        CifType leftType = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
        if (leftType instanceof RealType) {
            return (OrderingOperations)((Object)ctxt.typeToTarget(leftType));
        }
        return (OrderingOperations)((Object)ctxt.typeToTarget(expr.getRight().getType()));
    }

    protected abstract ExprCode convertIfExpression(IfExpression var1, Destination var2, CodeContext var3);

    protected ExprCode convertProjectionExpression(ProjectionExpression expr, Destination dest, CodeContext ctxt) {
        Expression child = expr.getChild();
        CifType nctype = CifTypeUtils.normalizeType((CifType)child.getType());
        Expression idxExpr = expr.getIndex();
        ExprCode childCode = this.exprToTarget(child, null, ctxt);
        TypeInfo childTi = ctxt.typeToTarget(child.getType());
        if (nctype instanceof TupleType) {
            int idx;
            TupleType tupleType = (TupleType)nctype;
            TupleTypeInfo tupleTi = (TupleTypeInfo)ctxt.typeToTarget((CifType)tupleType);
            if (idxExpr instanceof FieldExpression) {
                FieldExpression fieldExpr = (FieldExpression)idxExpr;
                int idx2 = tupleType.getFields().indexOf((Object)fieldExpr.getField());
                return tupleTi.getProjectedValue(childCode, idx2, dest, ctxt);
            }
            try {
                idx = (Integer)CifEvalUtils.eval((Expression)idxExpr, (boolean)false);
            }
            catch (CifEvalException e) {
                throw new RuntimeException(e);
            }
            return tupleTi.getProjectedValue(childCode, idx, dest, ctxt);
        }
        if (nctype instanceof ListType) {
            ExprCode indexCode = this.exprToTarget(idxExpr, null, ctxt);
            ArrayTypeInfo arrayTi = (ArrayTypeInfo)childTi;
            return arrayTi.getProjectedValue(childCode, indexCode, dest, ctxt);
        }
        Assert.check((boolean)(nctype instanceof StringType));
        ExprCode indexCode = this.exprToTarget(idxExpr, null, ctxt);
        StringTypeInfo strTi = (StringTypeInfo)childTi;
        return strTi.getProjectedValue(childCode, indexCode, dest, ctxt);
    }

    protected ExprCode convertFunctionCallExpression(FunctionCallExpression expr, Destination dest, CodeContext ctxt) {
        EList params = expr.getParams();
        Expression funcRef = expr.getFunction();
        if (funcRef instanceof FunctionExpression) {
            Function func = ((FunctionExpression)funcRef).getFunction();
            Assert.check((boolean)(func instanceof InternalFunction));
            List paramTexts = Lists.listc((int)params.size());
            for (Expression param : params) {
                paramTexts.add(this.exprToTarget(param, null, ctxt));
            }
            return this.convertInternalFunctionCall((InternalFunction)func, paramTexts, dest, ctxt);
        }
        StdLibFunctionExpression stdLibExpr = (StdLibFunctionExpression)funcRef;
        StdLibFunction stdLib = stdLibExpr.getFunction();
        if (stdLib == StdLibFunction.FORMAT) {
            StringTypeInfo ti = (StringTypeInfo)ctxt.typeToTarget(expr.getType());
            return ti.convertFormatStdLib((List<Expression>)params, dest, ctxt);
        }
        return this.convertStdLibFunctionCall((Expression)expr, stdLib, (List<Expression>)params, dest, ctxt);
    }

    protected abstract ExprCode convertInternalFunctionCall(InternalFunction var1, List<ExprCode> var2, Destination var3, CodeContext var4);

    protected ExprCode convertStdLibFunctionCall(Expression expr, StdLibFunction stdLib, List<Expression> params, Destination dest, CodeContext ctxt) {
        TypeInfo ti = ctxt.typeToTarget(expr.getType());
        switch (stdLib) {
            case ABS: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                if (ti instanceof IntTypeInfo) {
                    IntTypeInfo intTi = (IntTypeInfo)ti;
                    return intTi.convertAbsStdLib(params.get(0), dest, ctxt);
                }
                Assert.check((boolean)(ti instanceof RealTypeInfo));
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertAbsStdLib(params.get(0), dest, ctxt);
            }
            case MAXIMUM: {
                if (ti instanceof IntTypeInfo) {
                    IntTypeInfo intTi = (IntTypeInfo)ti;
                    return intTi.convertMaximumStdLib(params, dest, ctxt);
                }
                Assert.check((boolean)(ti instanceof RealTypeInfo));
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertMaximumStdLib(params, dest, ctxt);
            }
            case MINIMUM: {
                if (ti instanceof IntTypeInfo) {
                    IntTypeInfo intTi = (IntTypeInfo)ti;
                    return intTi.convertMinimumStdLib(params, dest, ctxt);
                }
                Assert.check((boolean)(ti instanceof RealTypeInfo));
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertMinimumStdLib(params, dest, ctxt);
            }
            case SIGN: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                if (ti instanceof IntTypeInfo) {
                    IntTypeInfo intTi = (IntTypeInfo)ti;
                    return intTi.convertSignStdLib(params.get(0), dest, ctxt);
                }
                Assert.check((boolean)(ti instanceof RealTypeInfo));
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertSignStdLib(params.get(0), dest, ctxt);
            }
            case POWER: {
                if (ti instanceof IntTypeInfo) {
                    IntTypeInfo intTi = (IntTypeInfo)ti;
                    return intTi.convertPowerStdLib(params, dest, ctxt);
                }
                Assert.check((boolean)(ti instanceof RealTypeInfo));
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertPowerStdLib(params, dest, ctxt);
            }
            case SQRT: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertSqrtStdLib(params.get(0), dest, ctxt);
            }
            case CBRT: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertCbrtStdLib(params.get(0), dest, ctxt);
            }
            case CEIL: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                IntTypeInfo intTi = (IntTypeInfo)ti;
                return intTi.convertCeilStdLib(params.get(0), dest, ctxt);
            }
            case FLOOR: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                IntTypeInfo intTi = (IntTypeInfo)ti;
                return intTi.convertFloorStdLib(params.get(0), dest, ctxt);
            }
            case ROUND: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                IntTypeInfo intTi = (IntTypeInfo)ti;
                return intTi.convertRoundStdLib(params.get(0), dest, ctxt);
            }
            case ACOS: 
            case ASIN: 
            case ATAN: 
            case COS: 
            case SIN: 
            case TAN: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertTrigonometryStdLib(stdLib, params.get(0), dest, ctxt);
            }
            case EXP: 
            case LN: 
            case LOG: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertLogarithmicStdLib(stdLib, params.get(0), dest, ctxt);
            }
            case SCALE: {
                RealTypeInfo realTi = (RealTypeInfo)ti;
                return realTi.convertScaleStdLib(params, dest, ctxt);
            }
            case SIZE: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                TypeInfo paramTi = ctxt.typeToTarget(params.get(0).getType());
                if (paramTi instanceof ArrayTypeInfo) {
                    ArrayTypeInfo listTi = (ArrayTypeInfo)paramTi;
                    return listTi.convertSizeStdLib(params.get(0), dest, ctxt);
                }
                StringTypeInfo listTi = (StringTypeInfo)paramTi;
                return listTi.convertSizeStdLib(params.get(0), dest, ctxt);
            }
            case EMPTY: {
                Assert.check((params.size() == 1 ? 1 : 0) != 0);
                ArrayTypeInfo arrayTi = (ArrayTypeInfo)ctxt.typeToTarget(params.get(0).getType());
                return arrayTi.convertEmptyStdLib(params.get(0), dest, ctxt);
            }
            case FORMAT: {
                StringTypeInfo stringTi = (StringTypeInfo)ti;
                return stringTi.convertFormatStdLib(params, dest, ctxt);
            }
            case ACOSH: 
            case ASINH: 
            case ATANH: 
            case COSH: 
            case SINH: 
            case TANH: {
                break;
            }
            case BERNOULLI: 
            case BETA: 
            case BINOMIAL: 
            case CONSTANT: 
            case ERLANG: 
            case EXPONENTIAL: 
            case GAMMA: 
            case GEOMETRIC: 
            case LOG_NORMAL: 
            case NORMAL: 
            case POISSON: 
            case RANDOM: 
            case TRIANGLE: 
            case UNIFORM: 
            case WEIBULL: {
                break;
            }
            case DELETE: 
            case POP: {
                break;
            }
        }
        throw new RuntimeException("Untranslated standard library function call: " + stdLib);
    }

    protected ExprCode convertListExpression(ListExpression expr, Destination dest, CodeContext ctxt) {
        ArrayTypeInfo listTi = (ArrayTypeInfo)ctxt.typeToTarget(expr.getType());
        return listTi.convertLiteral(expr, dest, ctxt);
    }

    protected ExprCode convertTupleExpression(TupleExpression expr, Destination dest, CodeContext ctxt) {
        TupleTypeInfo tupleTi = (TupleTypeInfo)ctxt.typeToTarget(expr.getType());
        return tupleTi.convertLiteral(expr, dest, ctxt);
    }

    protected abstract ExprCode convertConstantExpression(ConstantExpression var1, Destination var2, CodeContext var3);

    protected ExprCode convertDiscVariableExpression(DiscVariableExpression expr, Destination dest, CodeContext ctxt) {
        return this.convertDiscVariableExpression(expr.getVariable(), dest, ctxt);
    }

    public abstract ExprCode convertDiscVariableExpression(DiscVariable var1, Destination var2, CodeContext var3);

    protected ExprCode convertAlgVariableExpression(AlgVariableExpression expr, Destination dest, CodeContext ctxt) {
        return this.convertAlgVariableExpression(expr.getVariable(), dest, ctxt);
    }

    protected abstract ExprCode convertAlgVariableExpression(AlgVariable var1, Destination var2, CodeContext var3);

    protected ExprCode convertContVariableExpression(ContVariableExpression expr, Destination dest, CodeContext ctxt) {
        return this.convertContVariableExpression(expr.getVariable(), expr.isDerivative(), dest, ctxt);
    }

    protected abstract ExprCode convertContVariableExpression(ContVariable var1, boolean var2, Destination var3, CodeContext var4);

    protected ExprCode convertEnumLiteralExpression(EnumLiteralExpression expr, Destination dest, CodeContext ctxt) {
        EnumTypeInfo enumTi = (EnumTypeInfo)ctxt.typeToTarget(expr.getType());
        return enumTi.convertEnumLiteral(expr, dest, ctxt);
    }

    protected abstract ExprCode convertInputVariableExpression(InputVariableExpression var1, Destination var2, CodeContext var3);
}

