/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.plcdata;

import java.util.List;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcGlobalVarList;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcObject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPouInstance;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTask;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Lists;

public class PlcResource
extends PlcObject {
    public final String name;
    public final List<PlcGlobalVarList> globalVarLists = Lists.list();
    public List<PlcTask> tasks = Lists.list();
    public List<PlcPouInstance> pouInstances = Lists.list();

    public PlcResource(String name) {
        this.name = name;
    }

    public Box toBox() {
        MemoryCodeBox c = new MemoryCodeBox(4);
        for (PlcGlobalVarList globalVarList : this.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            c.add(globalVarList.toBox());
        }
        for (PlcTask task : this.tasks) {
            c.add(task.toBox());
        }
        for (PlcPouInstance pouInstance : this.pouInstances) {
            c.add(pouInstance.toBox(null));
        }
        for (PlcTask task : this.tasks) {
            for (PlcPouInstance pouInstance : task.pouInstances) {
                c.add(pouInstance.toBox(task.name));
            }
        }
        return c;
    }
}

