/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c99.typeinfos;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c99.C99DataValue;
import org.eclipse.escet.cif.codegen.c99.typeinfos.C99TypeInfo;
import org.eclipse.escet.cif.codegen.c99.typeinfos.C99TypeInfoHelper;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class C99TupleTypeInfo
extends TupleTypeInfo
implements C99TypeInfo {
    public final boolean genLocalFunctions;

    public C99TupleTypeInfo(boolean genLocalFunctions, CifType cifType, TypeInfo[] fieldTypes) {
        super(cifType, fieldTypes);
        this.genLocalFunctions = genLocalFunctions;
    }

    @Override
    public boolean supportRawMemCmp() {
        return false;
    }

    @Override
    public boolean useValues() {
        return false;
    }

    @Override
    public String getTypePrintName(boolean rawString) {
        return Strings.fmt((String)"%sTypePrint", (Object[])new Object[]{this.getTypeName()});
    }

    @Override
    public ExprCode convertLiteral(TupleExpression expr, Destination dest, CodeContext ctxt) {
        String storeVar;
        ExprCode result = new ExprCode();
        if (dest == null) {
            VariableInformation tempVarInfo = ctxt.makeTempVariable(expr.getType(), "tuple_tmp");
            storeVar = tempVarInfo.targetName;
            result.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{this.getTargetType(), storeVar}));
            result.setDataValue(C99DataValue.makeValue(storeVar));
        } else {
            storeVar = dest.getData();
        }
        Assert.check((expr.getFields().size() == this.childInfos.length ? 1 : 0) != 0);
        int i = 0;
        while (i < this.childInfos.length) {
            String elementVar = Strings.fmt((String)"(%s)._field%d", (Object[])new Object[]{storeVar, i});
            Destination elmDest = new Destination(null, this.childInfos[0], C99DataValue.makeValue(elementVar));
            ExprCode elmCode = ctxt.exprToTarget((Expression)expr.getFields().get(i), elmDest);
            result.add(elmCode);
            ++i;
        }
        return result;
    }

    @Override
    public CodeBox modifyContainer(VariableInformation containerVar, ExprCode partCode, int index, CodeContext ctxt) {
        MemoryCodeBox code = ctxt.makeCodeBox();
        code.add((Box)partCode.getCode());
        String fieldText = Strings.fmt((String)"%s._field%d", (Object[])new Object[]{containerVar.targetName, index});
        Destination dest = new Destination(null, this.childInfos[index], C99DataValue.makeValue(fieldText));
        this.childInfos[index].storeValue((CodeBox)code, partCode.getRawDataValue(), dest);
        return code;
    }

    @Override
    public ExprCode getProjectedValue(ExprCode childCode, int index, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.add(childCode);
        result.setDestination(dest);
        DataValue dataValue = childCode.getRawDataValue();
        if (dataValue.isReferenceValue()) {
            result.setDataValue(C99DataValue.makeValue(Strings.fmt((String)"(%s)->_field%d", (Object[])new Object[]{dataValue.getReference(), index})));
        } else {
            result.setDataValue(C99DataValue.makeValue(Strings.fmt((String)"(%s)._field%d", (Object[])new Object[]{dataValue.getData(), index})));
        }
        return result;
    }

    @Override
    public String appendProjection(String value, boolean safe, int index) {
        return safe ? Strings.fmt((String)"%s._field%d", (Object[])new Object[]{value, index}) : Strings.fmt((String)"(%s)._field%d", (Object[])new Object[]{value, index});
    }

    @Override
    public int getSize() {
        return this.childInfos.length;
    }

    @Override
    public String getTargetType() {
        return Strings.fmt((String)"%sType", (Object[])new Object[]{this.getTypeName()});
    }

    @Override
    public void generateCode(CodeContext ctxt) {
        TypeInfo childTi;
        String declarationPrefix;
        String definitionPrefix;
        if (this.genLocalFunctions) {
            definitionPrefix = "static ";
            declarationPrefix = "static ";
        } else {
            definitionPrefix = "";
            declarationPrefix = "extern ";
        }
        String typeName = this.getTypeName();
        MemoryCodeBox declCode = ctxt.makeCodeBox();
        String cifTypeText = CifTextUtils.typeToStr((CifType)this.cifType);
        declCode.add("/* CIF type: %s */", new Object[]{cifTypeText});
        declCode.add("struct %s_struct {", new Object[]{typeName});
        declCode.indent();
        int i = 0;
        while (i < this.childInfos.length) {
            declCode.add("%s _field%s;", new Object[]{this.childInfos[i].getTargetType(), i});
            ++i;
        }
        declCode.dedent();
        declCode.add("};");
        declCode.add("typedef struct %s_struct %sType;", new Object[]{typeName, typeName});
        declCode.add();
        MemoryCodeBox defCode = ctxt.makeCodeBox();
        String header = Strings.fmt((String)"BoolType %sTypeEquals(%s *left, %s *right)", (Object[])new Object[]{typeName, this.getTargetType(), this.getTargetType()});
        defCode.add("/**");
        defCode.add(" * Compare two tuples for equality.");
        defCode.add(" * @param left First tuple to compare.");
        defCode.add(" * @param right Second tuple to compare.");
        defCode.add(" * @return Whether both tuples are the same.");
        defCode.add(" */");
        defCode.add("%s%s {", new Object[]{definitionPrefix, header});
        declCode.add("%s%s;", new Object[]{declarationPrefix, header});
        defCode.indent();
        defCode.add("if (left == right) return TRUE;");
        int i2 = 0;
        while (i2 < this.childInfos.length) {
            childTi = this.childInfos[i2];
            String leftField = Strings.fmt((String)"left->_field%d", (Object[])new Object[]{i2});
            String rightField = Strings.fmt((String)"right->_field%d", (Object[])new Object[]{i2});
            if (C99TypeInfoHelper.typeSupportsRawMemCmp(childTi)) {
                defCode.add("if (memcmp(&%s, &%s, sizeof(%s)) != 0) return FALSE;", new Object[]{leftField, rightField, childTi.getTargetType()});
            } else {
                String elmEqualsTemplate = childTi.getBinaryExpressionTemplate(BinaryOperator.EQUAL);
                C99DataValue leftValue = C99DataValue.makeValue(leftField);
                C99DataValue rightValue = C99DataValue.makeValue(rightField);
                String check = TypeInfoHelper.convertBinaryExpressionValues(leftValue, rightValue, elmEqualsTemplate);
                defCode.add("if (!(%s)) return FALSE;", new Object[]{check});
            }
            ++i2;
        }
        defCode.add("return TRUE;");
        defCode.dedent();
        defCode.add("}");
        defCode.add();
        header = Strings.fmt((String)"int %sTypePrint(%s *tuple, char *dest, int start, int end)", (Object[])new Object[]{typeName, this.getTargetType()});
        defCode.add("/**");
        defCode.add(" * Append textual representation of the tuple value into the provided");
        defCode.add(" * destination, space permitting.");
        defCode.add(" * @param tuple Tuple to print.");
        defCode.add(" * @param dest Destination to write text to.");
        defCode.add(" * @param start First available offset in \\a dest for new text.");
        defCode.add(" * @param end Fist offset behind \\a dest.");
        defCode.add(" * @return First free offset in \\a dest, mat be \\a end.");
        defCode.add(" */");
        defCode.add("%s%s {", new Object[]{definitionPrefix, header});
        declCode.add("%s%s;", new Object[]{declarationPrefix, header});
        defCode.indent();
        defCode.add("int last = end - 1;");
        defCode.add("if (start < last) { dest[start++] = '('; }");
        i2 = 0;
        while (i2 < this.childInfos.length) {
            childTi = this.childInfos[i2];
            if (i2 > 0) {
                defCode.add("if (start < last) { dest[start++] = ','; }");
                defCode.add("if (start < last) { dest[start++] = ' '; }");
            }
            String childArgument = Strings.fmt((String)"tuple->_field%d", (Object[])new Object[]{i2});
            if (!C99TypeInfoHelper.typeUsesValues(childTi)) {
                childArgument = "&" + childArgument;
            }
            defCode.add("start = %s(%s, dest, start, end);", new Object[]{C99TypeInfoHelper.typeGetTypePrintName(childTi, false), childArgument});
            ++i2;
        }
        defCode.add("if (start < last) { dest[start++] = ')'; }");
        defCode.add("dest[start] = '\\0';");
        defCode.add("return start;");
        defCode.dedent();
        defCode.add("}");
        defCode.add();
        declCode.add();
        ctxt.appendReplacement("generated-types", declCode.toString());
        ctxt.appendReplacement("type-support-code", defCode.toString());
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return Strings.fmt((String)"%sTypeEquals(${left-ref}, ${right-ref})", (Object[])new Object[]{this.getTypeName()});
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return Strings.fmt((String)"!%sTypeEquals(${left-ref}, ${right-ref})", (Object[])new Object[]{this.getTypeName()});
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof C99TupleTypeInfo)) {
            return false;
        }
        C99TupleTypeInfo otherTuple = (C99TupleTypeInfo)other;
        if (this.childInfos.length != otherTuple.childInfos.length) {
            return false;
        }
        int i = 0;
        while (i < this.childInfos.length) {
            if (!this.childInfos[i].equals(otherTuple.childInfos[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = C99TupleTypeInfo.class.hashCode();
        int i = 0;
        while (i < this.childInfos.length) {
            hash += this.childInfos[i].hashCode() * (i + 16);
            ++i;
        }
        return hash;
    }

    @Override
    public void checkRange(CifType lhsType, CifType rhsType, DataValue rhsValue, CifType varType, String varName, List<RangeCheckErrorLevelText> errorTexts, int level, CodeBox code, CodeContext ctxt) {
        TupleType lhsTuple = (TupleType)lhsType;
        TupleType rhsTuple = (TupleType)rhsType;
        int last = errorTexts.size();
        errorTexts.add(null);
        int i = 0;
        while (i < this.childInfos.length) {
            errorTexts.set(last, new RangeCheckErrorLevelText(false, ((Field)lhsTuple.getFields().get(i)).getName()));
            this.childInfos[i].checkRange(((Field)lhsTuple.getFields().get(i)).getType(), ((Field)rhsTuple.getFields().get(i)).getType(), C99DataValue.makeValue(this.appendProjection(rhsValue.getData(), false, i)), varType, varName, errorTexts, level, code, ctxt);
            ++i;
        }
        errorTexts.remove(last);
        Assert.check((last == errorTexts.size() ? 1 : 0) != 0);
    }
}

