/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.edge;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.ext.base.Option;

public class SlidableAnchor {
    private static final char TERMINAL_START_CHAR = '(';
    private static final char TERMINAL_DELIMITER_CHAR = ',';
    private static final char TERMINAL_END_CHAR = ')';
    private static final int STRAIGHT_LINE_TOLERANCE = 3;
    private PrecisionPoint relativeReference;
    private View owner;

    public static String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append(p.preciseX());
        s.append(',');
        s.append(p.preciseY());
        s.append(')');
        return s.toString();
    }

    public SlidableAnchor(View owner, PrecisionPoint relativeReference) {
        this.owner = owner;
        this.relativeReference = relativeReference;
    }

    protected Rectangle getBox() {
        Option<Rectangle> optionalRect;
        Rectangle box = null;
        if (this.owner instanceof Node) {
            Node node = (Node)this.owner;
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Bounds) {
                Bounds bounds = (Bounds)layoutConstraint;
                box = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                Node parentNode = node;
                while (parentNode.eContainer() instanceof Node) {
                    LayoutConstraint parentLayoutConstraint = (parentNode = (Node)parentNode.eContainer()).getLayoutConstraint();
                    if (!(parentLayoutConstraint instanceof Bounds)) continue;
                    Bounds parentBounds = (Bounds)parentLayoutConstraint;
                    box.x += parentBounds.getX();
                    box.y += parentBounds.getY();
                }
            }
        } else if (this.owner instanceof Edge && (optionalRect = GMFHelper.getAbsoluteBounds((Edge)this.owner)).some()) {
            box = (Rectangle)optionalRect.get();
        }
        return box;
    }

    public String getTerminal() {
        if (this.isDefaultAnchor()) {
            return "";
        }
        return SlidableAnchor.composeTerminalString(this.relativeReference);
    }

    public Point getReferencePoint() {
        return this.getAnchorPosition();
    }

    private Point getAnchorPosition() {
        PrecisionRectangle rBox = new PrecisionRectangle(this.getBox());
        if (this.isDefaultAnchor()) {
            return rBox.getCenter();
        }
        return new PrecisionPoint(this.relativeReference.preciseX() * rBox.preciseWidth() + rBox.preciseX(), this.relativeReference.preciseY() * rBox.preciseHeight() + rBox.preciseY());
    }

    protected Point getLocation(Point ownReference, Point foreignReference) {
        PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
        if (intersections != null && intersections.size() != 0) {
            Point location = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)foreignReference);
            return location;
        }
        return null;
    }

    public Point getLocation(Point reference) {
        Point ownReference = this.normalizeToStraightlineTolerance(reference, this.getReferencePoint(), 3);
        Point location = this.getLocation(ownReference, reference);
        if (location == null && (location = this.getLocation((Point)new PrecisionPoint(this.getBox().getCenter()), reference)) == null) {
            location = this.getBox().getCenter();
        }
        return location;
    }

    protected Point normalizeToStraightlineTolerance(Point foreignReference, Point ownReference, int tolerance) {
        PrecisionPoint preciseOwnReference = new PrecisionPoint(ownReference);
        PrecisionPoint normalizedReference = (PrecisionPoint)preciseOwnReference.getCopy();
        PrecisionPoint preciseForeignReference = new PrecisionPoint(foreignReference);
        if (Math.abs(preciseForeignReference.preciseX() - preciseOwnReference.preciseX()) < (double)tolerance) {
            normalizedReference.setPreciseX(preciseForeignReference.preciseX());
            return normalizedReference;
        }
        if (Math.abs(preciseForeignReference.preciseY() - preciseOwnReference.preciseY()) < (double)tolerance) {
            normalizedReference.setPreciseY(preciseForeignReference.preciseY());
        }
        return normalizedReference;
    }

    protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
        PointList polygon = this.getPolygonPoints();
        return new LineSeg(ownReference, foreignReference).getLineIntersectionsWithLineSegs(polygon);
    }

    protected PointList getPolygonPoints() {
        PrecisionRectangle r = new PrecisionRectangle(this.getBox());
        PointList ptList = new PointList(5);
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX(), r.preciseY()));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX() + r.preciseWidth(), r.preciseY()));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX() + r.preciseWidth(), r.preciseY() + r.preciseHeight()));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX(), r.preciseY() + r.preciseHeight()));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX(), r.preciseY()));
        return ptList;
    }

    public View getOwner() {
        return this.owner;
    }

    public boolean isDefaultAnchor() {
        return this.relativeReference == null;
    }

    public static PrecisionPoint parseTerminalString(String terminal) {
        try {
            return new PrecisionPoint(Double.parseDouble(terminal.substring(terminal.indexOf(40) + 1, terminal.indexOf(44))), Double.parseDouble(terminal.substring(terminal.indexOf(44) + 1, terminal.indexOf(41))));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Point getOrthogonalLocation(Point orthoReference) {
        PrecisionPoint ownReference = new PrecisionPoint(this.getReferencePoint());
        PrecisionRectangle bounds = new PrecisionRectangle(this.getBox());
        PrecisionPoint preciseOrthoReference = new PrecisionPoint(orthoReference);
        int orientation = 0;
        if (preciseOrthoReference.preciseX() >= bounds.preciseX() && preciseOrthoReference.preciseX() <= bounds.preciseX() + bounds.preciseWidth()) {
            ownReference.setPreciseX(preciseOrthoReference.preciseX());
            orientation = 128;
        } else if (preciseOrthoReference.preciseY() >= bounds.preciseY() && preciseOrthoReference.preciseY() <= bounds.preciseY() + bounds.preciseHeight()) {
            ownReference.setPreciseY(preciseOrthoReference.preciseY());
            orientation = 64;
        }
        Point location = this.getLocation((Point)ownReference, (Point)preciseOrthoReference);
        if (location == null) {
            location = this.getLocation(orthoReference);
            orientation = 0;
        }
        if (orientation != 0) {
            PrecisionPoint loc = new PrecisionPoint(location);
            if (orientation == 128) {
                loc.setPreciseX(preciseOrthoReference.preciseX());
            } else {
                loc.setPreciseY(preciseOrthoReference.preciseY());
            }
            location = loc;
        }
        return location;
    }
}

