/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.graph;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.force.graph.FBendpoint;
import org.eclipse.elk.alg.force.graph.FEdge;
import org.eclipse.elk.alg.force.graph.FLabel;
import org.eclipse.elk.alg.force.graph.FNode;
import org.eclipse.elk.alg.force.graph.FParticle;
import org.eclipse.elk.alg.force.properties.ForceOptions;
import org.eclipse.elk.graph.properties.MapPropertyHolder;

public final class FGraph
extends MapPropertyHolder {
    private static final long serialVersionUID = -2396315570561498425L;
    private List<FNode> nodes = new ArrayList<FNode>();
    private List<FEdge> edges = new ArrayList<FEdge>();
    private List<FLabel> labels = new ArrayList<FLabel>();
    private List<FBendpoint> bendPoints = new ArrayList<FBendpoint>();
    private int[][] adjacency;

    public List<FEdge> getEdges() {
        return this.edges;
    }

    public List<FNode> getNodes() {
        return this.nodes;
    }

    public List<FLabel> getLabels() {
        return this.labels;
    }

    public List<FBendpoint> getBendpoints() {
        return this.bendPoints;
    }

    public Iterable<FParticle> getParticles() {
        return Iterables.concat(this.nodes, this.labels, this.bendPoints);
    }

    public int getConnection(FParticle particle1, FParticle particle2) {
        if (particle1 instanceof FNode && particle2 instanceof FNode) {
            FNode node1 = (FNode)particle1;
            FNode node2 = (FNode)particle2;
            return this.adjacency[node1.id][node2.id] + this.adjacency[node2.id][node1.id];
        }
        if (particle1 instanceof FBendpoint && particle2 instanceof FBendpoint) {
            FBendpoint bpoint1 = (FBendpoint)particle1;
            FBendpoint bpoint2 = (FBendpoint)particle2;
            if (bpoint1.getEdge() == bpoint2.getEdge()) {
                return (Integer)bpoint2.getEdge().getProperty(ForceOptions.PRIORITY);
            }
        }
        return 0;
    }

    public void calcAdjacency() {
        int n = this.nodes.size();
        this.adjacency = new int[n][n];
        for (FEdge edge : this.edges) {
            int[] nArray = this.adjacency[edge.getSource().id];
            int n2 = edge.getTarget().id;
            nArray[n2] = nArray[n2] + (Integer)edge.getProperty(ForceOptions.PRIORITY);
        }
    }
}

