/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import java.util.Locale;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class AutoAlgoOption
extends Option<Integer> {
    public AutoAlgoOption() {
        super("Automatic mode choice algorithm", "The automatic mode choice algorithm specifies how the automatic input mode chooses which transition to take. Specify \"random\" (default), \"first\", \"last\", or \"random:NNN\". Random with a number NNN in the interval [0..2^30], uses NNN as the seed of the random generator. If the number is omitted, a random seed is used.", Character.valueOf('a'), "auto-algo", "AUTOALGO", true);
    }

    public static int getAutoAlgo() {
        return (Integer)Options.get(AutoAlgoOption.class);
    }

    public Integer getDefault() {
        return -1;
    }

    public Integer parseValue(String optName, String value) {
        int nr;
        if (value.toLowerCase(Locale.US).equals("random")) {
            return -1;
        }
        if (value.toLowerCase(Locale.US).equals("first")) {
            return -2;
        }
        if (value.toLowerCase(Locale.US).equals("last")) {
            return -3;
        }
        AutoAlgoOption.checkValue((boolean)value.startsWith("random:"), (String)"Unknown automatic mode choice algorithm.");
        String v = value.substring("random:".length());
        try {
            nr = Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Invalid seed value \"%s\".", (Object[])new Object[]{value});
            throw new InvalidOptionException(msg);
        }
        if (nr < 0 || 0x40000000 < nr) {
            String msg = Strings.fmt((String)"Seed value %d is not in the interval [0..2^30].", (Object[])new Object[]{nr});
            throw new InvalidOptionException(msg);
        }
        return nr;
    }

    public String[] getCmdLine(Object value) {
        int nr = (Integer)value;
        if (nr == -1) {
            return new String[]{"--auto-algo=random"};
        }
        if (nr == -2) {
            return new String[]{"--auto-algo=first"};
        }
        if (nr == -3) {
            return new String[]{"--auto-algo=last"};
        }
        Assert.check((nr >= 0 ? 1 : 0) != 0);
        Assert.check((nr <= 0x40000000 ? 1 : 0) != 0);
        return new String[]{"--auto-algo=random:" + nr};
    }

    public OptionGroup<Integer> createOptionGroup(Composite page) {
        return new AutoAlgoOptionGroup(page);
    }

    private class AutoAlgoOptionGroup
    extends OptionGroup<Integer>
    implements SelectionListener {
        Button firstButton;
        Button lastButton;
        Button randomButton;
        Button seedButton;
        Label seedLabel;
        Spinner seedSpinner;

        public AutoAlgoOptionGroup(Composite page) {
            super(page, (Option)AutoAlgoOption.this);
        }

        protected void addComponents(Group group) {
            this.firstButton = new Button((Composite)group, 16);
            this.lastButton = new Button((Composite)group, 16);
            this.randomButton = new Button((Composite)group, 16);
            this.seedButton = new Button((Composite)group, 16);
            this.firstButton.setText("First transition");
            this.lastButton.setText("Last transition");
            this.randomButton.setText("Random transition (random seed)");
            this.seedButton.setText("Random transition (specific seed)");
            this.firstButton.addSelectionListener((SelectionListener)this);
            this.lastButton.addSelectionListener((SelectionListener)this);
            this.randomButton.addSelectionListener((SelectionListener)this);
            this.seedButton.addSelectionListener((SelectionListener)this);
            this.seedLabel = new Label((Composite)group, 0);
            this.seedLabel.setText("Seed:");
            this.seedSpinner = new Spinner((Composite)group, 2048);
            this.seedSpinner.setMinimum(0);
            this.seedSpinner.setMaximum(0x40000000);
            this.layoutGeneric(new Object[]{this.firstButton, this.lastButton, this.randomButton, this.seedButton, new Control[]{this.seedLabel, this.seedSpinner}});
        }

        public String getDescription() {
            return "The automatic mode choice algorithm specifies how the automatic input mode chooses which transition to take.";
        }

        public void setToValue(Integer value) {
            Button button = value == -1 ? this.randomButton : (value == -2 ? this.firstButton : (value == -3 ? this.lastButton : this.seedButton));
            button.setSelection(true);
            Event event = new Event();
            event.widget = button;
            this.widgetSelected(new SelectionEvent(event));
            int spinnerValue = button != this.seedButton ? 0 : value;
            Assert.check((spinnerValue >= 0 ? 1 : 0) != 0);
            Assert.check((spinnerValue <= 0x40000000 ? 1 : 0) != 0);
            this.seedSpinner.setSelection(spinnerValue);
        }

        public String[] getCmdLine() {
            if (this.randomButton.getSelection()) {
                return new String[]{"--auto-algo=random"};
            }
            if (this.firstButton.getSelection()) {
                return new String[]{"--auto-algo=first"};
            }
            if (this.lastButton.getSelection()) {
                return new String[]{"--auto-algo=last"};
            }
            Assert.check((boolean)this.seedButton.getSelection());
            return new String[]{"--auto-algo=random:" + this.seedSpinner.getSelection()};
        }

        public void widgetSelected(SelectionEvent e) {
            this.seedSpinner.setEnabled(e.widget == this.seedButton);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

