/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class PolylineEdgeRouter
implements ILayoutPhase {
    public static final Predicate<LNode> PRED_EXTERNAL_WEST_OR_EAST_PORT = new Predicate<LNode>(){

        public boolean apply(LNode node) {
            PortSide extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
            return node.getType() == LNode.NodeType.EXTERNAL_PORT && (extPortSide == PortSide.WEST || extPortSide == PortSide.EAST);
        }
    };
    private static final IntermediateProcessingConfiguration INVERTED_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.INVERTED_PORT_PROCESSOR);
    private static final IntermediateProcessingConfiguration NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.NORTH_SOUTH_PORT_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.NORTH_SOUTH_PORT_POSTPROCESSOR);
    private static final IntermediateProcessingConfiguration CENTER_EDGE_LABEL_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase2(IntermediateProcessorStrategy.LABEL_DUMMY_INSERTER).addBeforePhase3(IntermediateProcessorStrategy.LABEL_DUMMY_SWITCHER).addBeforePhase4(IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfterPhase5(IntermediateProcessorStrategy.LABEL_DUMMY_REMOVER);
    private static final IntermediateProcessingConfiguration END_EDGE_LABEL_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfterPhase5(IntermediateProcessorStrategy.END_LABEL_PROCESSOR);
    private static final double MIN_VERT_DIFF = 1.0;
    private static final double LAYER_SPACE_FAC = 0.4;
    private final Set<KVector> createdJunctionPoints = Sets.newHashSet();

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        Set graphProperties = (Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.createEmpty();
        if (graphProperties.contains((Object)GraphProperties.NON_FREE_PORTS) || ((Boolean)graph.getProperty(LayeredOptions.FEEDBACK_EDGES)).booleanValue()) {
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
            if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
                configuration.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.CENTER_LABELS)) {
            configuration.addAll(CENTER_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.END_LABELS)) {
            configuration.addAll(END_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        return configuration;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Polyline edge routing", 1.0f);
        double nodeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double edgeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        float edgeSpaceFac = Math.min(1.0f, (float)(edgeSpacing / nodeSpacing));
        double xpos = 0.0;
        double layerSpacing = 0.0;
        if (!layeredGraph.getLayers().isEmpty()) {
            double yDiff = this.calculateWestInLayerEdgeYDiff(layeredGraph.getLayers().get(0));
            xpos = 0.4 * (double)edgeSpaceFac * yDiff;
        }
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            boolean externalLayer = Iterables.all((Iterable)layer, PRED_EXTERNAL_WEST_OR_EAST_PORT);
            if (externalLayer && xpos > 0.0) {
                xpos -= nodeSpacing;
            }
            LGraphUtil.placeNodesHorizontally(layer, xpos);
            double maxVertDiff = 0.0;
            for (LNode node : layer) {
                double maxCurrOutputYDiff = 0.0;
                for (LEdge outgoingEdge : node.getOutgoingEdges()) {
                    double sourcePos = outgoingEdge.getSource().getAbsoluteAnchor().y;
                    double targetPos = outgoingEdge.getTarget().getAbsoluteAnchor().y;
                    if (layer == outgoingEdge.getTarget().getNode().getLayer()) {
                        this.processInLayerEdge(outgoingEdge, xpos, 0.4 * (double)edgeSpaceFac * Math.abs(sourcePos - targetPos));
                        if (outgoingEdge.getSource().getSide() == PortSide.WEST) {
                            sourcePos = 0.0;
                            targetPos = 0.0;
                        }
                    }
                    maxCurrOutputYDiff = Math.max(maxCurrOutputYDiff, Math.abs(targetPos - sourcePos));
                }
                switch (node.getType()) {
                    case NORMAL: 
                    case LONG_EDGE: 
                    case NORTH_SOUTH_PORT: 
                    case LABEL: {
                        this.processNode(node, xpos);
                    }
                }
                maxVertDiff = Math.max(maxVertDiff, maxCurrOutputYDiff);
            }
            if (layerIter.hasNext()) {
                double yDiff = this.calculateWestInLayerEdgeYDiff(layerIter.next());
                maxVertDiff = Math.max(maxVertDiff, yDiff);
                layerIter.previous();
            }
            layerSpacing = 0.4 * (double)edgeSpaceFac * maxVertDiff;
            if (!externalLayer && layerIter.hasNext()) {
                layerSpacing += nodeSpacing;
            }
            xpos += layer.getSize().x + layerSpacing;
        }
        this.createdJunctionPoints.clear();
        layeredGraph.getSize().x = xpos;
        monitor.done();
    }

    private void processNode(LNode node, double layerLeftXPos) {
        double layerRightXPos = layerLeftXPos + node.getLayer().getSize().x;
        for (LPort port : node.getPorts()) {
            KVector absolutePortAnchor = port.getAbsoluteAnchor();
            KVector bendPoint = new KVector(0.0, absolutePortAnchor.y);
            if (port.getSide() == PortSide.EAST) {
                bendPoint.x = layerRightXPos;
            } else {
                if (port.getSide() != PortSide.WEST) continue;
                bendPoint.x = layerLeftXPos;
            }
            if (absolutePortAnchor.x == bendPoint.x && !this.isInLayerDummy(node)) continue;
            boolean addJunctionPoint = port.getOutgoingEdges().size() + port.getIncomingEdges().size() > 1;
            for (LEdge e : port.getConnectedEdges()) {
                LPort otherPort;
                LPort lPort = otherPort = e.getSource() == port ? e.getTarget() : e.getSource();
                if (!(Math.abs(otherPort.getAbsoluteAnchor().y - bendPoint.y) > 1.0)) continue;
                this.addBendPoint(e, bendPoint, addJunctionPoint, port);
            }
        }
    }

    private void processInLayerEdge(LEdge edge, double layerXPos, double edgeSpacing) {
        LPort sourcePort = edge.getSource();
        LPort targetPort = edge.getTarget();
        double midY = (sourcePort.getAbsoluteAnchor().y + targetPort.getAbsoluteAnchor().y) / 2.0;
        KVector bendPoint = null;
        bendPoint = sourcePort.getSide() == PortSide.EAST ? new KVector(layerXPos + sourcePort.getNode().getLayer().getSize().x + edgeSpacing, midY) : new KVector(layerXPos - edgeSpacing, midY);
        edge.getBendPoints().add(0, (Object)bendPoint);
    }

    private double calculateWestInLayerEdgeYDiff(Layer layer) {
        double maxYDiff = 0.0;
        for (LNode node : layer) {
            for (LEdge outgoingEdge : node.getOutgoingEdges()) {
                if (layer != outgoingEdge.getTarget().getNode().getLayer() || outgoingEdge.getSource().getSide() != PortSide.WEST) continue;
                double sourcePos = outgoingEdge.getSource().getAbsoluteAnchor().y;
                double targetPos = outgoingEdge.getTarget().getAbsoluteAnchor().y;
                maxYDiff = Math.max(maxYDiff, Math.abs(targetPos - sourcePos));
            }
        }
        return maxYDiff;
    }

    private void addBendPoint(LEdge edge, KVector bendPoint, boolean addJunctionPoint, LPort currPort) {
        if (edge.isInLayerEdge() || !currPort.getAbsoluteAnchor().equals((Object)bendPoint)) {
            if (edge.getSource() == currPort) {
                edge.getBendPoints().add(0, (Object)new KVector(bendPoint));
            } else {
                edge.getBendPoints().add((Object)new KVector(bendPoint));
            }
            if (addJunctionPoint && !this.createdJunctionPoints.contains(bendPoint)) {
                KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                if (junctionPoints == null) {
                    junctionPoints = new KVectorChain();
                    edge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
                }
                KVector jpoint = new KVector(bendPoint);
                junctionPoints.add((Object)jpoint);
                this.createdJunctionPoints.add(jpoint);
            }
        }
    }

    private boolean isInLayerDummy(LNode node) {
        if (node.getType() == LNode.NodeType.LONG_EDGE) {
            for (LEdge e : node.getConnectedEdges()) {
                if (!e.isInLayerEdge()) continue;
                return true;
            }
        }
        return false;
    }
}

