/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.cif2mcrl2.storage.AutomatonData;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.cif2mcrl2.tree.AutomatonProcessNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.CombinedProcessNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.CombinedTextNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.ElementaryTextNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.ProcessNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.TextNode;
import org.eclipse.escet.cif.cif2mcrl2.tree.VariableProcessNode;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;

public class InstanceTreeBuilder {
    private InstanceTreeBuilder() {
    }

    public static ProcessNode buildProcessTree(TextNode node, List<AutomatonData> autDatas, Set<VariableData> sharedVars, Set<VariableData> singleUseVars) {
        Map autNames = Maps.map();
        for (AutomatonData autData : autDatas) {
            autNames.put(autData.name, autData);
        }
        Map varNames = Maps.map();
        for (VariableData dv : sharedVars) {
            varNames.put(dv.name, dv);
        }
        for (VariableData dv : singleUseVars) {
            varNames.put(dv.name, dv);
        }
        return InstanceTreeBuilder.buildProcessNode("1", node, autNames, varNames);
    }

    private static ProcessNode buildProcessNode(String name, TextNode node, Map<String, AutomatonData> autNames, Map<String, VariableData> varNames) {
        if (node instanceof ElementaryTextNode) {
            ElementaryTextNode etn = (ElementaryTextNode)node;
            AutomatonData autData = autNames.get(etn.name);
            if (autData != null) {
                return new AutomatonProcessNode(name, autData);
            }
            return new VariableProcessNode(name, varNames.get(etn.name));
        }
        Assert.check((boolean)(node instanceof CombinedTextNode));
        CombinedTextNode ctn = (CombinedTextNode)node;
        List processes = Lists.listc((int)ctn.children.size());
        int i = 1;
        for (TextNode n : ctn.children) {
            String childName = Strings.fmt((String)"%s.%d", (Object[])new Object[]{name, i});
            processes.add(InstanceTreeBuilder.buildProcessNode(childName, n, autNames, varNames));
            ++i;
        }
        return new CombinedProcessNode(name, processes);
    }

    public static ProcessNode buildDefaultTree(List<AutomatonData> autDatas, Set<VariableData> sharedVars) {
        ProcessNode node;
        String name = "1";
        int i = 1;
        while (i < autDatas.size() + sharedVars.size()) {
            name = String.valueOf(name) + ".1";
            ++i;
        }
        ProcessNode root = null;
        for (AutomatonData ad : autDatas) {
            if (root == null) {
                root = new AutomatonProcessNode(name, ad);
            } else {
                node = new AutomatonProcessNode(String.valueOf(name) + ".2", ad);
                root = new CombinedProcessNode(name, Lists.list((Object[])new ProcessNode[]{root, node}));
            }
            if (name.length() <= 1) continue;
            name = name.substring(0, name.length() - 2);
        }
        for (VariableData dv : sharedVars) {
            if (root == null) {
                root = new VariableProcessNode(name, dv);
            } else {
                node = new VariableProcessNode(String.valueOf(name) + ".2", dv);
                root = new CombinedProcessNode(name, Lists.list((Object[])new ProcessNode[]{root, node}));
            }
            if (name.length() <= 1) continue;
            name = name.substring(0, name.length() - 2);
        }
        return root;
    }
}

