/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c89;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CodeGen;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.TypeCodeGen;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.C89ExprCodeGen;
import org.eclipse.escet.cif.codegen.c89.C89FunctionCodeGen;
import org.eclipse.escet.cif.codegen.c89.C89TypeCodeGen;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfoHelper;
import org.eclipse.escet.cif.codegen.options.TargetLanguage;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.LhsListProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsTupleProjection;
import org.eclipse.escet.cif.codegen.updates.tree.SingleVariableAssignment;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class C89CodeGen
extends CodeGen {
    private static final int INDENT = 4;
    public static final String[] RESERVED_C89_WORDS = new String[]{"auto", "break", "case", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "float", "for", "goto", "if", "int", "long", "register", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "void", "volatile", "while"};
    public static final String INITIAL_EVENT_NAME = "EVT_INITIAL_";
    public static final String DELAY_EVENT_NAME = "EVT_DELAY_";
    public static final String TAU_EVENT_NAME = "EVT_TAU_";
    public static final String ENUM_NAMES_LIST = "enum_names";

    public C89CodeGen() {
        super(TargetLanguage.C89, 4);
    }

    @Override
    protected ExprCodeGen getExpressionCodeGenerator() {
        return new C89ExprCodeGen();
    }

    @Override
    protected TypeCodeGen getTypeCodeGenerator() {
        return new C89TypeCodeGen();
    }

    @Override
    protected void init() {
        super.init();
        this.replacements.put("generated-types", "");
        this.replacements.put("algvar-declarations", "");
        this.replacements.put("algvar-functions", "");
        this.replacements.put("constant-declarations", "");
        this.replacements.put("constant-definitions", "");
        this.replacements.put("constant-initialization", "");
        this.replacements.put("contvars-update", "");
        this.replacements.put("derivative-declarations", "");
        this.replacements.put("derivative-functions", "");
        this.replacements.put("enum-names-list", "");
        this.replacements.put("event-calls-code", "");
        this.replacements.put("event-declarations", "");
        this.replacements.put("event-methods-code", "");
        this.replacements.put("event-name-list", "");
        this.replacements.put("functions-code", "");
        this.replacements.put("functions-declarations", "");
        this.replacements.put("generated-types", "");
        this.replacements.put("initial-print-calls", "");
        this.replacements.put("initialize-statevars", "");
        this.replacements.put("inputvar-declarations", "");
        this.replacements.put("inputvar-definitions", "");
        this.replacements.put("inputvar-function-call", "");
        this.replacements.put("inputvar-function-declaration", "");
        this.replacements.put("input-vars-test-inputvalues", "");
        this.replacements.put("print-function", "");
        this.replacements.put("statevar-declarations", "");
        this.replacements.put("statevar-definitions", "");
        this.replacements.put("time-pre-print-call", "");
        this.replacements.put("time-post-print-call", "");
        this.replacements.put("type-support-code", "");
        String prefix = (String)this.replacements.get("prefix");
        this.replacements.put("PREFIX", Strings.makeUppercase((String)prefix));
    }

    @Override
    protected Set<String> getReservedTargetNames() {
        Set reserved = Sets.setc((int)RESERVED_C89_WORDS.length);
        int i = 0;
        while (i < RESERVED_C89_WORDS.length) {
            reserved.add(RESERVED_C89_WORDS[i]);
            ++i;
        }
        return reserved;
    }

    @Override
    public void performSingleAssign(CodeBox code, SingleVariableAssignment asgn, Expression value, CodeContext readCtxt, CodeContext writeCtxt) {
        Assert.check((asgn.rhsProjections == null ? 1 : 0) != 0);
        Assert.check((asgn.lhsProjections == null ? 1 : 0) != 0);
        Assert.check((!asgn.needsRangeBoundCheck() ? 1 : 0) != 0);
        VariableInformation varInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        ExprCode assignment = readCtxt.exprToTarget(value, writeCtxt.makeDestination(varInfo));
        code.add((Box)assignment.getCode());
        Assert.check((!assignment.hasDataValue() ? 1 : 0) != 0);
    }

    @Override
    public void performAssign(CodeBox code, SingleVariableAssignment asgn, String rhsText, CodeContext readCtxt, CodeContext writeCtxt) {
        ArrayTypeInfo arrayTi;
        LhsTupleProjection tupleLhs;
        TupleTypeInfo tupleTi;
        LhsProjection lhsProj;
        VariableInformation fullVarInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        C89DataValue rhsValue = C89DataValue.makeValue(rhsText);
        if (asgn.lhsProjections == null) {
            CifType assignedType = asgn.getAssignedType();
            TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
            MemoryCodeBox rangeCode = this.makeCodeBox();
            rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, Lists.list(), 0, (CodeBox)rangeCode, readCtxt);
            this.insertRangecheckCode(code, (CodeBox)rangeCode);
            fullVarInfo.typeInfo.storeValue(code, rhsValue, writeCtxt.makeDestination(fullVarInfo));
            return;
        }
        String[] indexTexts = new String[asgn.lhsProjections.length];
        List rangeErrorTexts = Lists.list();
        int i = 0;
        while (i < asgn.lhsProjections.length) {
            LhsProjection lhsProj2 = asgn.lhsProjections[i];
            if (lhsProj2 instanceof LhsTupleProjection) {
                LhsTupleProjection tupleProj = (LhsTupleProjection)lhsProj2;
                indexTexts[i] = Integer.toString(tupleProj.fieldNumber);
                rangeErrorTexts.add(new RangeCheckErrorLevelText(false, tupleProj.getSelectedFieldName()));
            } else {
                LhsListProjection listProj = (LhsListProjection)lhsProj2;
                VariableInformation indexVarInfo = writeCtxt.makeTempVariable((CifType)CifConstructors.newIntType(), "index");
                indexTexts[i] = indexVarInfo.targetName;
                rangeErrorTexts.add(new RangeCheckErrorLevelText(true, indexVarInfo.targetName));
                ExprCode indexCode = readCtxt.exprToTarget(listProj.index, null);
                indexVarInfo.typeInfo.declareInit(code, indexCode.getRawDataValue(), writeCtxt.makeDestination(indexVarInfo));
            }
            ++i;
        }
        CifType assignedType = asgn.getAssignedType();
        TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
        MemoryCodeBox rangeCode = this.makeCodeBox();
        rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, rangeErrorTexts, 0, (CodeBox)rangeCode, readCtxt);
        this.insertRangecheckCode(code, (CodeBox)rangeCode);
        int last = asgn.lhsProjections.length - 1;
        VariableInformation[] partVariables = new VariableInformation[last];
        int i2 = 0;
        while (i2 < last) {
            ExprCode projectRhs;
            lhsProj = asgn.lhsProjections[i2];
            CifType elementType = CifTypeUtils.normalizeType((CifType)lhsProj.getPartType());
            partVariables[i2] = readCtxt.makeTempVariable(elementType, "part");
            VariableInformation containerInfo = i2 == 0 ? readCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerValue = new ExprCode();
            containerValue.setDataValue(C89DataValue.makeValue(containerInfo.targetName));
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                projectRhs = tupleTi.getProjectedValue(containerValue, tupleLhs.fieldNumber, null, readCtxt);
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexVar = new ExprCode();
                indexVar.setDataValue(C89DataValue.makeComputed(indexTexts[i2]));
                projectRhs = arrayTi.getProjectedValue(containerValue, indexVar, null, readCtxt);
            }
            code.add((Box)projectRhs.getCode());
            partVariables[i2].typeInfo.declareInit(code, projectRhs.getRawDataValue(), readCtxt.makeDestination(partVariables[i2]));
            ++i2;
        }
        i2 = last;
        while (i2 >= 0) {
            MemoryCodeBox modify;
            lhsProj = asgn.lhsProjections[i2];
            VariableInformation containerInfo = i2 == 0 ? writeCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerCode = new ExprCode();
            containerCode.setDataValue(C89DataValue.makeValue(containerInfo.targetName));
            ExprCode partCode = new ExprCode();
            if (i2 == last) {
                partCode.setDataValue(rhsValue);
            } else {
                partCode.setDataValue(C89DataValue.makeValue(partVariables[i2].targetName));
            }
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                modify = readCtxt.makeCodeBox();
                modify.add((Box)tupleTi.modifyContainer(containerInfo, partCode, tupleLhs.fieldNumber, readCtxt));
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexCode = new ExprCode();
                indexCode.setDataValue(C89DataValue.makeComputed(indexTexts[i2]));
                modify = arrayTi.modifyContainer(containerInfo, partCode, indexCode, readCtxt);
            }
            code.add((Box)modify);
            --i2;
        }
    }

    void insertRangecheckCode(CodeBox surrounding, CodeBox rangeCode) {
        if (rangeCode.isEmpty()) {
            return;
        }
        surrounding.add("#if CHECK_RANGES");
        surrounding.add((Box)rangeCode);
        surrounding.add("#endif");
    }

    @Override
    public Destination makeDestination(VariableInformation varInfo) {
        return new Destination(null, varInfo.typeInfo, C89DataValue.makeValue(varInfo.targetName));
    }

    @Override
    protected void addConstants(CodeContext ctxt) {
        MemoryCodeBox defCode = this.makeCodeBox();
        MemoryCodeBox declCode = this.makeCodeBox();
        MemoryCodeBox initCode = this.makeCodeBox(1);
        for (Constant constant : this.constants) {
            VariableWrapper varWrap = new VariableWrapper((Declaration)constant, false);
            VariableInformation constInfo = ctxt.getReadVarInfo(varWrap);
            String typeName = constInfo.typeInfo.getTargetType();
            String varName = constInfo.targetName;
            defCode.add("%s %s; /**< Constant \"%s\". */", new Object[]{typeName, varName, constInfo.name});
            declCode.add("extern %s %s; /**< Constant \"%s\". */", new Object[]{typeName, varName, constInfo.name});
            ExprCode constantCode = ctxt.exprToTarget(constant.getValue(), ctxt.makeDestination((Declaration)constant));
            initCode.add((Box)constantCode.getCode());
        }
        this.replacements.put("constant-definitions", defCode.toString());
        this.replacements.put("constant-declarations", declCode.toString());
        this.replacements.put("constant-initialization", initCode.toString());
    }

    @Override
    protected void addEvents(CodeContext ctxt) {
        String prefix = (String)this.replacements.get("prefix");
        MemoryCodeBox evtDeclsCode = this.makeCodeBox();
        evtDeclsCode.add("enum %sEventEnum_ {", new Object[]{prefix});
        evtDeclsCode.indent();
        GridBox evtDecls = new GridBox(3 + this.events.size(), 2, 0, 1);
        evtDecls.set(0, 0, "EVT_INITIAL_,");
        evtDecls.set(0, 1, "/**< Initial step. */");
        evtDecls.set(1, 0, "EVT_DELAY_,");
        evtDecls.set(1, 1, "/**< Delay step. */");
        evtDecls.set(2, 0, "EVT_TAU_,");
        evtDecls.set(2, 1, "/**< Tau step. */");
        int i = 0;
        while (i < this.events.size()) {
            Event evt = (Event)this.events.get(i);
            evtDecls.set(3 + i, 0, Strings.fmt((String)"%s,", (Object[])new Object[]{this.getTargetName((PositionObject)evt)}));
            evtDecls.set(3 + i, 1, Strings.fmt((String)"/**< Event %s. */", (Object[])new Object[]{evt.getName()}));
            ++i;
        }
        evtDeclsCode.add((Box)evtDecls);
        evtDeclsCode.dedent();
        evtDeclsCode.add("};");
        evtDeclsCode.add("typedef enum %sEventEnum_ %s_Event_;", new Object[]{prefix, prefix});
        this.replacements.put("event-declarations", evtDeclsCode.toString());
        MemoryCodeBox evtNamesCode = this.makeCodeBox(1);
        GridBox evtNames = new GridBox(3 + this.events.size(), 2, 0, 1);
        evtNames.set(0, 0, "\"initial-step\",");
        evtNames.set(0, 1, "/**< Initial step. */");
        evtNames.set(1, 0, "\"delay-step\",");
        evtNames.set(1, 1, "/**< Delay step. */");
        evtNames.set(2, 0, "\"tau\",");
        evtNames.set(2, 1, "/**< Tau step. */");
        int i2 = 0;
        while (i2 < this.events.size()) {
            Event evt = (Event)this.events.get(i2);
            evtNames.set(3 + i2, 0, Strings.fmt((String)"\"%s\",", (Object[])new Object[]{evt.getName()}));
            evtNames.set(3 + i2, 1, Strings.fmt((String)"/**< Event %s. */", (Object[])new Object[]{evt.getName()}));
            ++i2;
        }
        evtNamesCode.add((Box)evtNames);
        this.replacements.put("event-name-list", evtNamesCode.toString());
    }

    @Override
    protected void addStateVars(CodeContext ctxt) {
        GridBox varDefCode = new GridBox(this.stateVars.size(), 2, 0, 1);
        GridBox varDeclCode = new GridBox(this.stateVars.size(), 2, 0, 1);
        int i = 0;
        while (i < this.stateVars.size()) {
            String kindText;
            String typeText;
            Declaration decl = (Declaration)this.stateVars.get(i);
            if (decl instanceof DiscVariable) {
                DiscVariable dv = (DiscVariable)decl;
                typeText = CifTextUtils.typeToStr((CifType)dv.getType());
                kindText = "Discrete";
            } else {
                typeText = "real";
                kindText = "Continuous";
            }
            VariableInformation declVarInfo = ctxt.getWriteVarInfo(decl);
            String declaration = Strings.fmt((String)"%s %s;", (Object[])new Object[]{declVarInfo.typeInfo.getTargetType(), declVarInfo.targetName});
            String comment = Strings.fmt((String)"/**< %s variable \"%s %s\". */", (Object[])new Object[]{kindText, typeText, declVarInfo.name});
            varDefCode.set(i, 0, declaration);
            varDefCode.set(i, 1, comment);
            varDeclCode.set(i, 0, "extern " + declaration);
            varDeclCode.set(i, 1, comment);
            ++i;
        }
        this.replacements.put("statevar-definitions", varDefCode.toString());
        this.replacements.put("statevar-declarations", varDeclCode.toString());
        MemoryCodeBox code = this.makeCodeBox(1);
        for (Declaration decl : this.stateVars) {
            Expression rhs;
            VariableInformation declVarInfo = ctxt.getWriteVarInfo(decl);
            if (decl instanceof DiscVariable) {
                DiscVariable dv = (DiscVariable)decl;
                Assert.check((dv.getValue() != null ? 1 : 0) != 0);
                Assert.check((dv.getValue().getValues().size() == 1 ? 1 : 0) != 0);
                rhs = (Expression)dv.getValue().getValues().get(0);
            } else {
                ContVariable cv = (ContVariable)decl;
                rhs = cv.getValue();
            }
            ExprCode initValCode = ctxt.exprToTarget(rhs, this.makeDestination(declVarInfo));
            code.add((Box)initValCode.getCode());
        }
        this.replacements.put("initialize-statevars", code.toString());
    }

    @Override
    protected void addContVars(CodeContext ctxt) {
        MemoryCodeBox derivDeclCode = this.makeCodeBox();
        MemoryCodeBox derivDefCode = this.makeCodeBox();
        boolean first = true;
        for (ContVariable cv : this.contVars) {
            VariableInformation cvVarInfo = ctxt.getWriteVarInfo((Declaration)cv);
            if (!first) {
                derivDefCode.add();
            }
            first = false;
            String header = Strings.fmt((String)"RealType %sderiv(void)", (Object[])new Object[]{cvVarInfo.targetName});
            derivDeclCode.add("%s;", new Object[]{header});
            derivDefCode.add("/** Derivative of \"%s\". */", new Object[]{cvVarInfo.name});
            derivDefCode.add("%s {", new Object[]{header});
            derivDefCode.indent();
            ExprCode derCode = ctxt.exprToTarget(cv.getDerivative(), null);
            derivDefCode.add((Box)derCode.getCode());
            derivDefCode.add("return %s;", new Object[]{derCode.getData()});
            derivDefCode.dedent();
            derivDefCode.add("}");
        }
        this.replacements.put("derivative-declarations", derivDeclCode.toString());
        this.replacements.put("derivative-functions", derivDefCode.toString());
        if (this.contVars.isEmpty()) {
            this.replacements.put("contvars-update", "");
            return;
        }
        MemoryCodeBox code = this.makeCodeBox(2);
        int i = 0;
        while (i < this.contVars.size()) {
            ContVariable cv = (ContVariable)this.contVars.get(i);
            VariableInformation cvVarInfo = ctxt.getWriteVarInfo((Declaration)cv);
            code.add("RealType deriv%d = %sderiv();", new Object[]{i, cvVarInfo.targetName});
            ++i;
        }
        code.add();
        i = 0;
        while (i < this.contVars.size()) {
            ContVariable var = (ContVariable)this.contVars.get(i);
            String name = this.getTargetName((PositionObject)var);
            String origName = (String)this.origDeclNames.get(var);
            code.add("errno = 0;");
            code.add("%s = UpdateContValue(%s + delta * deriv%d, %s, errno == 0);", new Object[]{name, name, i, Strings.stringToJava((String)origName)});
            ++i;
        }
        this.replacements.put("contvars-update", code.toString());
    }

    @Override
    protected void addAlgVars(CodeContext ctxt) {
        MemoryCodeBox defCode = this.makeCodeBox();
        MemoryCodeBox declCode = this.makeCodeBox();
        boolean first = true;
        for (AlgVariable algVar : this.algVars) {
            VariableInformation algVarInfo = ctxt.getWriteVarInfo((Declaration)algVar);
            if (!first) {
                defCode.add();
            }
            first = false;
            TypeInfo ti = ctxt.typeToTarget(algVar.getType());
            String header = Strings.fmt((String)"%s %s(void)", (Object[])new Object[]{ti.getTargetType(), algVarInfo.targetName});
            declCode.add("%s;", new Object[]{header});
            defCode.add("/**");
            defCode.add(" * Algebraic variable %s = %s;\n", new Object[]{algVar.getName(), CifTextUtils.exprToStr((Expression)algVar.getValue())});
            defCode.add(" */");
            defCode.add("%s {", new Object[]{header});
            defCode.indent();
            ExprCode valueCode = ctxt.exprToTarget(algVar.getValue(), null);
            defCode.add((Box)valueCode.getCode());
            defCode.add("return %s;", new Object[]{valueCode.getData()});
            defCode.dedent();
            defCode.add("}");
        }
        if (!this.algVars.isEmpty()) {
            declCode.add();
        }
        this.replacements.put("algvar-declarations", declCode.toString());
        this.replacements.put("algvar-functions", defCode.toString());
    }

    @Override
    protected void addInputVars(CodeContext ctxt) {
        String fillInputCall;
        String fillInputDeclaration;
        String prefix = (String)this.replacements.get("prefix");
        GridBox varDefCode = new GridBox(this.inputVars.size(), 2, 0, 1);
        GridBox varDeclCode = new GridBox(this.inputVars.size(), 2, 0, 1);
        int i = 0;
        while (i < this.inputVars.size()) {
            InputVariable decl = (InputVariable)this.inputVars.get(i);
            String typeText = CifTextUtils.typeToStr((CifType)decl.getType());
            VariableInformation declVarInfo = ctxt.getWriteVarInfo((Declaration)decl);
            String declaration = Strings.fmt((String)"%s %s;", (Object[])new Object[]{declVarInfo.typeInfo.getTargetType(), declVarInfo.targetName});
            String comment = Strings.fmt((String)"/**< Input variable \"%s %s\". */", (Object[])new Object[]{typeText, declVarInfo.name});
            varDefCode.set(i, 0, declaration);
            varDefCode.set(i, 1, comment);
            varDeclCode.set(i, 0, "extern " + declaration);
            varDeclCode.set(i, 1, comment);
            ++i;
        }
        this.replacements.put("inputvar-definitions", varDefCode.toString());
        this.replacements.put("inputvar-declarations", varDeclCode.toString());
        if (this.inputVars.isEmpty()) {
            fillInputDeclaration = "";
            fillInputCall = "";
        } else {
            fillInputDeclaration = Strings.fmt((String)"extern void %s_AssignInputVariables();", (Object[])new Object[]{prefix});
            fillInputCall = String.valueOf(Strings.spaces((int)4)) + Strings.fmt((String)"%s_AssignInputVariables();", (Object[])new Object[]{prefix});
        }
        this.replacements.put("inputvar-function-declaration", fillInputDeclaration);
        this.replacements.put("inputvar-function-call", fillInputCall);
        MemoryCodeBox inputTestCode = this.makeCodeBox(1);
        if (!this.inputVars.isEmpty()) {
            boolean first = true;
            List funcs = Lists.list();
            for (InputVariable var : this.inputVars) {
                VariableInformation inputVar = ctxt.getWriteVarInfo((Declaration)var);
                Expression value = CifValueUtils.getDefaultValue((CifType)var.getType(), (List)funcs);
                Destination dest = new Destination(null, inputVar.typeInfo, C89DataValue.makeValue(inputVar.targetName));
                ExprCode initCode = ctxt.exprToTarget(value, dest);
                if (!first) {
                    inputTestCode.add();
                }
                first = false;
                inputTestCode.add("/* Input variable \"%s\". */", new Object[]{inputVar.name});
                inputTestCode.add((Box)initCode.getCode());
            }
            Assert.check((boolean)funcs.isEmpty());
        }
        this.replacements.put("input-vars-test-inputvalues", inputTestCode.toString());
    }

    @Override
    protected void addFunctions(CodeContext ctxt) {
        MemoryCodeBox declCode = this.makeCodeBox(0);
        MemoryCodeBox defCode = this.makeCodeBox(0);
        boolean first = true;
        for (InternalFunction func : this.functions) {
            if (!first) {
                defCode.add();
            }
            first = false;
            C89FunctionCodeGen funcGen = new C89FunctionCodeGen(false, func);
            funcGen.generate((CodeBox)declCode, (CodeBox)defCode, ctxt);
        }
        this.replacements.put("functions-declarations", declCode.toString());
        this.replacements.put("functions-code", defCode.toString());
    }

    @Override
    protected void addEnum(EnumDecl enumDecl, CodeContext ctxt) {
        EnumType enumType = CifConstructors.newEnumType((EnumDecl)enumDecl, null);
        ctxt.typeToTarget((CifType)enumType);
        MemoryCodeBox enumNames = ctxt.makeCodeBox();
        enumNames.add("const char *%s[] = {", new Object[]{ENUM_NAMES_LIST});
        enumNames.indent();
        for (EnumLiteral eLit : enumDecl.getLiterals()) {
            enumNames.add("%s,", new Object[]{Strings.stringToJava((String)eLit.getName())});
        }
        enumNames.dedent();
        enumNames.add("};");
        this.replacements.put("enum-names-list", enumNames.toString());
    }

    @Override
    protected void addPrints(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox();
        code.add("#if PRINT_OUTPUT");
        String prefix = (String)this.replacements.get("prefix");
        code.add("static void PrintOutput(%s_Event_ event, BoolType pre) {", new Object[]{prefix});
        code.indent();
        VariableInformation txtVarInfo = ctxt.makeTempVariable((CifType)CifConstructors.newStringType(), "text_var");
        List preCodes = Lists.listc((int)this.printDecls.size());
        List postCodes = Lists.listc((int)this.printDecls.size());
        for (Print print : this.printDecls) {
            String targetFile = Strings.stringToJava((String)print.getFile().getPath());
            CodeBox printCode = this.genPrint(print.getWhenPre(), (List<PrintFor>)print.getFors(), print.getTxtPre(), txtVarInfo, targetFile, ctxt);
            if (printCode != null) {
                preCodes.add(printCode);
            }
            if ((printCode = this.genPrint(print.getWhenPost(), (List<PrintFor>)print.getFors(), print.getTxtPost(), txtVarInfo, targetFile, ctxt)) == null) continue;
            postCodes.add(printCode);
        }
        if (!preCodes.isEmpty() || !postCodes.isEmpty()) {
            code.add("%s %s;", new Object[]{txtVarInfo.typeInfo.getTargetType(), txtVarInfo.targetName});
            code.add();
            if (!preCodes.isEmpty()) {
                code.add("if (pre) {");
                code.indent();
                boolean first = true;
                for (CodeBox box : preCodes) {
                    if (!first) {
                        code.add();
                    }
                    first = false;
                    code.add((Box)box);
                }
                code.dedent();
            }
            if (!postCodes.isEmpty()) {
                code.add(preCodes.isEmpty() ? "if (!pre) {" : "} else {");
                code.indent();
                boolean first = true;
                for (CodeBox box : postCodes) {
                    if (!first) {
                        code.add();
                    }
                    first = false;
                    code.add((Box)box);
                }
                code.dedent();
            }
            code.add("}");
        }
        code.dedent();
        code.add("}");
        code.add("#endif");
        this.replacements.put("print-function", code.toString());
    }

    private String makeForPrintConditions(String eventVar, List<PrintFor> fors) {
        if (fors.isEmpty()) {
            return "TRUE";
        }
        List conds = Lists.listc((int)fors.size());
        for (PrintFor pf : fors) {
            switch (pf.getKind()) {
                case EVENT: {
                    conds.add(Strings.fmt((String)"%s >= %s", (Object[])new Object[]{eventVar, TAU_EVENT_NAME}));
                    break;
                }
                case FINAL: {
                    break;
                }
                case INITIAL: {
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, INITIAL_EVENT_NAME}));
                    break;
                }
                case NAME: {
                    Expression eventRef = pf.getEvent();
                    Assert.check((boolean)(eventRef instanceof EventExpression));
                    Event event = ((EventExpression)eventRef).getEvent();
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, this.getTargetName((PositionObject)event)}));
                    break;
                }
                case TIME: {
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, DELAY_EVENT_NAME}));
                    break;
                }
                default: {
                    Assert.fail((String)"Unexpected kind of print event.");
                }
            }
        }
        if (conds.isEmpty()) {
            return null;
        }
        if (conds.size() == 1) {
            return (String)conds.get(0);
        }
        return StringUtils.join((Collection)conds, (String)" || ");
    }

    private CodeBox genPrint(Expression whenPred, List<PrintFor> fors, Expression txtExpr, VariableInformation txtVarInfo, String targetFile, CodeContext ctxt) {
        if (txtExpr == null) {
            return null;
        }
        String forConds = this.makeForPrintConditions("event", fors);
        if (forConds == null) {
            return null;
        }
        MemoryCodeBox valueCode = ctxt.makeCodeBox();
        CifType valueType = CifTypeUtils.normalizeType((CifType)txtExpr.getType());
        if (valueType instanceof StringType) {
            ExprCode strCode = ctxt.exprToTarget(txtExpr, this.makeDestination(txtVarInfo));
            valueCode.add((Box)strCode.getCode());
        } else {
            String valueText;
            TypeInfo ti = ctxt.typeToTarget(valueType);
            ExprCode strCode = ctxt.exprToTarget(txtExpr, null);
            valueCode.add((Box)strCode.getCode());
            DataValue dataValue = strCode.getRawDataValue();
            if (C89TypeInfoHelper.typeUsesValues(ti)) {
                valueText = dataValue.getData();
            } else if (dataValue.canBeReferenced()) {
                valueText = dataValue.getReference();
            } else {
                VariableInformation tempVar = ctxt.makeTempVariable(ti, "print_temp");
                valueCode.add(Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{ti.getTargetType(), tempVar.targetName, dataValue.getData()}));
                valueText = "&" + tempVar.targetName;
            }
            valueCode.add("%s(%s, %s.data, 0, MAX_STRING_SIZE);", new Object[]{C89TypeInfoHelper.typeGetTypePrintName(ti, true), valueText, txtVarInfo.targetName});
        }
        MemoryCodeBox result = ctxt.makeCodeBox();
        boolean unconditional = forConds.equals("TRUE");
        if (whenPred != null) {
            ExprCode whenCondCode = ctxt.exprToTarget(whenPred, null);
            result.add((Box)whenCondCode.getCode());
            if (unconditional) {
                forConds = whenCondCode.getData();
                unconditional = false;
            } else {
                forConds = Strings.fmt((String)"(%s) && (%s)", (Object[])new Object[]{forConds, whenCondCode.getData()});
            }
        }
        if (!unconditional) {
            result.add("if (%s) {", new Object[]{forConds});
            result.indent();
        }
        result.add((Box)valueCode);
        String prefix = (String)this.replacements.get("prefix");
        result.add("%s_PrintOutput(%s.data, %s);", new Object[]{prefix, txtVarInfo.targetName, targetFile});
        if (!unconditional) {
            result.dedent();
            result.add("}");
        }
        return result;
    }

    @Override
    protected void addEdges(CodeContext ctxt) {
        MemoryCodeBox codeCalls = this.makeCodeBox(2);
        MemoryCodeBox codeMethods = this.makeCodeBox(0);
        String prefix = (String)this.replacements.get("prefix");
        int i = 0;
        while (i < this.edges.size()) {
            Expression guard;
            String eventTargetName;
            String eventName;
            Event event;
            Edge edge = (Edge)this.edges.get(i);
            Assert.check((edge.getEvents().size() == 1 ? 1 : 0) != 0);
            Expression eventRef = ((EdgeEvent)Lists.first((List)edge.getEvents())).getEvent();
            Event event2 = event = eventRef instanceof TauExpression ? null : ((EventExpression)eventRef).getEvent();
            if (event == null) {
                eventName = "tau";
                eventTargetName = TAU_EVENT_NAME;
            } else {
                eventName = (String)this.origDeclNames.get(event);
                eventTargetName = this.getTargetName((PositionObject)event);
            }
            codeCalls.add("if (execEvent%d()) continue;  /* (Try to) perform event \"%s\". */", new Object[]{i, eventName});
            codeMethods.add();
            codeMethods.add("/**");
            codeMethods.add(" * Execute code for event \"%s\".", new Object[]{eventName});
            codeMethods.add(" *");
            codeMethods.add(" * @return Whether the event was performed.");
            codeMethods.add(" */");
            codeMethods.add("static BoolType execEvent%d(void) {", new Object[]{i});
            codeMethods.indent();
            EList guards = edge.getGuards();
            Assert.check((guards.size() <= 1 ? 1 : 0) != 0);
            Expression expression = guard = guards.isEmpty() ? null : (Expression)Lists.first((List)guards);
            if (guard != null) {
                ExprCode guardCode = ctxt.exprToTarget(guard, null);
                codeMethods.add((Box)guardCode.getCode());
                codeMethods.add("BoolType guard = %s;", new Object[]{guardCode.getData()});
                codeMethods.add("if (!guard) return FALSE;");
                codeMethods.add();
            }
            if (!this.printDecls.isEmpty()) {
                codeMethods.add("#if PRINT_OUTPUT");
                codeMethods.indent();
                codeMethods.add("PrintOutput(%s, TRUE);", new Object[]{eventTargetName});
                codeMethods.dedent();
                codeMethods.add("#endif");
            }
            codeMethods.add("#if EVENT_OUTPUT");
            codeMethods.indent();
            codeMethods.add("%s_InfoEvent(%s, TRUE);", new Object[]{prefix, eventTargetName});
            codeMethods.dedent();
            codeMethods.add("#endif");
            codeMethods.add();
            if (!edge.getUpdates().isEmpty()) {
                this.addUpdates((List<Update>)edge.getUpdates(), (CodeBox)codeMethods, ctxt);
                codeMethods.add();
            }
            codeMethods.add("#if EVENT_OUTPUT");
            codeMethods.indent();
            codeMethods.add("%s_InfoEvent(%s, FALSE);", new Object[]{prefix, eventTargetName});
            codeMethods.dedent();
            codeMethods.add("#endif");
            if (!this.printDecls.isEmpty()) {
                codeMethods.add("#if PRINT_OUTPUT");
                codeMethods.indent();
                codeMethods.add("PrintOutput(%s, FALSE);", new Object[]{eventTargetName});
                codeMethods.dedent();
                codeMethods.add("#endif");
            }
            codeMethods.add("return TRUE;");
            codeMethods.dedent();
            codeMethods.add("}");
            ++i;
        }
        this.replacements.put("event-calls-code", codeCalls.toString());
        this.replacements.put("event-methods-code", codeMethods.toString());
        MemoryCodeBox code = this.makeCodeBox(1);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* pre-initial and post-initial prints. */");
        code.add("PrintOutput(%s, TRUE);", new Object[]{INITIAL_EVENT_NAME});
        code.add("PrintOutput(%s, FALSE);", new Object[]{INITIAL_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("initial-print-calls", code.toString());
        code = this.makeCodeBox(1);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* pre-timestep print. */");
        code.add("PrintOutput(%s, TRUE);", new Object[]{DELAY_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("time-pre-print-call", code.toString());
        code = this.makeCodeBox(1);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* post-timestep print. */");
        code.add("PrintOutput(%s, FALSE);", new Object[]{DELAY_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("time-post-print-call", code.toString());
    }

    @Override
    protected IfElseGenerator getIfElseUpdateGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    protected void addUpdatesBeginScope(CodeBox code) {
        code.add("{");
        code.indent();
    }

    @Override
    protected void addUpdatesEndScope(CodeBox code) {
        code.dedent();
        code.add("}");
    }

    @Override
    protected Map<String, String> getTemplates() {
        Map templates = Maps.map();
        templates.put("compile.sh", "_compile.sh");
        templates.put("library.h", "_library.h");
        templates.put("library.c", "_library.c");
        templates.put("engine.h", "_engine.h");
        templates.put("engine.c", "_engine.c");
        templates.put("test_code.c", "_test_code.c");
        templates.put("readme.txt", "_readme.txt");
        return templates;
    }
}

