/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.simulink;

import org.eclipse.escet.cif.codegen.CodeGenPreChecker;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class SimulinkCodeGenPreChecker
extends CodeGenPreChecker {
    public static boolean isGoodType(CifType type) {
        ListType ltype;
        if ((type = CifTypeUtils.normalizeType((CifType)type)) instanceof ListType) {
            ltype = (ListType)type;
            type = CifTypeUtils.normalizeType((CifType)ltype.getElementType());
        }
        if (type instanceof ListType) {
            ltype = (ListType)type;
            type = CifTypeUtils.normalizeType((CifType)ltype.getElementType());
        }
        if (type instanceof BoolType) {
            return true;
        }
        if (type instanceof IntType) {
            return true;
        }
        if (type instanceof EnumType) {
            return true;
        }
        return type instanceof RealType;
    }

    public static int getRowCount(CifType type) {
        ListType ltype;
        type = CifTypeUtils.normalizeType((CifType)type);
        Assert.check((boolean)SimulinkCodeGenPreChecker.isGoodType(type));
        if (type instanceof ListType && CifTypeUtils.isArrayType((ListType)(ltype = (ListType)type))) {
            return ltype.getLower();
        }
        return 0;
    }

    public static int getColumnCount(CifType type) {
        ListType ltype;
        type = CifTypeUtils.normalizeType((CifType)type);
        Assert.check((boolean)SimulinkCodeGenPreChecker.isGoodType(type));
        if (type instanceof ListType) {
            ltype = (ListType)type;
            type = CifTypeUtils.normalizeType((CifType)ltype.getElementType());
        }
        if (type instanceof ListType && CifTypeUtils.isArrayType((ListType)(ltype = (ListType)type))) {
            return ltype.getLower();
        }
        return 0;
    }

    protected void walkInputVariable(InputVariable var) {
        if (!SimulinkCodeGenPreChecker.isGoodType(var.getType())) {
            String msg = Strings.fmt((String)"Unsupported type \"%s\" found with input variable \"%s\".", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)var.getType()), var.getName()});
            this.problems.add(msg);
            return;
        }
        super.walkInputVariable(var);
    }

    protected void walkDiscVariable(DiscVariable var) {
        if (!SimulinkCodeGenPreChecker.isGoodType(var.getType())) {
            String msg = Strings.fmt((String)"Unsupported output type \"%s\" found in discrete variable \"%s\", variable will be omitted from the output.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)var.getType()), var.getName()});
            OutputProvider.warn((String)msg);
        }
        super.walkDiscVariable(var);
    }

    protected void walkAlgVariable(AlgVariable var) {
        if (!SimulinkCodeGenPreChecker.isGoodType(var.getType())) {
            String msg = Strings.fmt((String)"Unsupported output type \"%s\" found in algebraic variable \"%s\", variable will be omitted from the output.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)var.getType()), var.getName()});
            OutputProvider.warn((String)msg);
        }
        super.walkAlgVariable(var);
    }
}

