/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.plotviz;

import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.cif.simulator.options.InputModeOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationMode;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class PlotVisualizationModeOption
extends EnumOption<PlotVisualizationMode> {
    public PlotVisualizationModeOption() {
        super("Plot visualization mode", "The plot visualization mode indicates when the plot should appear. Specify \"live\" for live plotting during the simulation, \"postponed\" to postpone plotting until after the simulation, or \"auto\" (default) for postponed plotting in case of interactive simulation without real-time mode, and live plotting otherwise.", null, "plotviz-mode", "MODE", (Enum)PlotVisualizationMode.AUTO, true, "The plot visualization mode indicates when the plot should appear. The automatic choice uses postponed plotting in case of interactive simulation without real-time mode, and live plotting otherwise.");
    }

    public static PlotVisualizationMode getPlotVizMode() {
        PlotVisualizationMode rslt = (PlotVisualizationMode)((Object)Options.get(PlotVisualizationModeOption.class));
        if (rslt != PlotVisualizationMode.AUTO) {
            return rslt;
        }
        if (FrameRateOption.isRealTimeEnabled()) {
            return PlotVisualizationMode.LIVE;
        }
        if (InputModeOption.isPurelyInteractive()) {
            return PlotVisualizationMode.LIVE;
        }
        return PlotVisualizationMode.POSTPONED;
    }

    protected String getDialogText(PlotVisualizationMode value) {
        switch (value) {
            case AUTO: {
                return "Automatically choose between live and postponed";
            }
            case LIVE: {
                return "Live plotting during simulation";
            }
            case POSTPONED: {
                return "Postpone plotting until after the simulation";
            }
        }
        throw new RuntimeException("Unknown mode: " + (Object)((Object)value));
    }
}

