/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.console;

import java.io.InputStream;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.console.ConsolePageParticipant;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.EclipseConsoleAppStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class Console
extends IOConsole {
    private static final Color COLOR_IN = new Color(null, 0, 200, 125);
    private static final Color COLOR_OUT = new Color(null, 0, 0, 0);
    private static final Color COLOR_ERR = new Color(null, 255, 0, 0);
    protected final AppStreams streams;
    private Application<?> application;
    private ConsolePageParticipant consolePageParticipant;

    public Console(String title) {
        super(title, null);
        IOConsoleInputStream in = this.getInputStream();
        IOConsoleOutputStream out = this.newOutputStream();
        IOConsoleOutputStream err = this.newOutputStream();
        in.setColor(COLOR_IN);
        out.setColor(COLOR_OUT);
        err.setColor(COLOR_ERR);
        EclipseConsoleAppStream appOut = new EclipseConsoleAppStream(out);
        EclipseConsoleAppStream appErr = new EclipseConsoleAppStream(err);
        this.streams = new AppStreams((InputStream)in, appOut, appErr);
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{this});
        manager.showConsoleView((IConsole)this);
    }

    public void setConsolePageParticipant(ConsolePageParticipant participant) {
        this.consolePageParticipant = participant;
    }

    public AppStreams getStreams() {
        return this.streams;
    }

    public Application<?> getApplication() {
        return this.application;
    }

    public void setNameSync(final String name) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Console.super.setName(name);
            }
        });
    }

    public void setNameAsync(final String name) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Console.super.setName(name);
            }
        });
    }

    public void setApplication(Application<?> application) {
        this.application = application;
        application.getAppEnvData().setConsole(this);
    }

    public void cleanup() {
        if (this.consolePageParticipant != null) {
            this.consolePageParticipant.disable();
        }
        if (this.application != null) {
            this.application.getAppEnvData().setConsole(null);
        }
        this.application = null;
        this.consolePageParticipant = null;
    }
}

