/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.RefreshLayoutCommand;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.RefreshLayoutScope;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.RefreshLayoutTrigger;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.SequenceCanonicalSynchronizerAdapter;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.SequenceCanonicalSynchronizerAdapterScope;
import org.eclipse.sirius.diagram.sequence.ui.business.internal.refresh.VisibilityEventHandler;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.command.SequenceEMFCommandFactory;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ExecutionOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceContainerCreationPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceLaunchToolEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.LabelsOverlayFigure;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceZOrderingRefresher;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ContainerCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.properties.PropertiesService;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;

public class SequenceDiagramEditPart
extends DDiagramEditPart {
    private final VisibilityEventHandler semanticOrderingSynchronizer;
    private IDiagramCommandFactoryProvider previousProvider;
    private ModelChangeTrigger refreshLayout;
    private ModelChangeTrigger sequenceCanonicalSynchronizer;
    private ResourceSetListener refreshZorder = new ResourceSetListenerImpl(){

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            new SequenceZOrderingRefresher(SequenceDiagramEditPart.this).run();
            SequenceDiagramEditPart.this.refreshConnectionsBendpoints();
        }
    };
    private IPropertyChangeListener snapDisabler;
    private IFigure labelsOverlayFigure;

    public SequenceDiagramEditPart(View diagramView) {
        super(diagramView);
        this.semanticOrderingSynchronizer = new VisibilityEventHandler();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        ExecutionOperations.replaceEditPolicy((IGraphicalEditPart)this, "ContainerEditPolicy", (EditPolicy)new SequenceContainerCreationPolicy(), ContainerCreationEditPolicy.class);
        this.installEditPolicy("launchTool", (EditPolicy)new SequenceLaunchToolEditPolicy());
    }

    public void addNotify() {
        SequenceEditPartsOperations.registerDiagramElement((IGraphicalEditPart)this, this.resolveSemanticElement());
        super.addNotify();
        Object property = this.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (property instanceof DDiagramEditor) {
            DDiagramEditor diagramEditor = (DDiagramEditor)property;
            this.setCustomCommandFactoryProvider(diagramEditor);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        SequenceEditPartsOperations.unregisterDiagramElement((IGraphicalEditPart)this, this.resolveSemanticElement());
        Object property = this.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (property instanceof DDiagramEditor && this.previousProvider != null) {
            DDiagramEditor diagramEditor = (DDiagramEditor)property;
            diagramEditor.setEmfCommandFactoryProvider(this.previousProvider);
            this.previousProvider = null;
        }
    }

    public void activate() {
        IFigure overlayLayer;
        IPreferenceStore workspaceViewerPreferenceStore;
        super.activate();
        EditPartViewer viewer = this.getViewer();
        if (viewer instanceof DiagramGraphicalViewer && (workspaceViewerPreferenceStore = ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore()) != null) {
            workspaceViewerPreferenceStore.setDefault("rulergrid.snaptogrid", false);
            workspaceViewerPreferenceStore.setValue("rulergrid.snaptogrid", false);
            workspaceViewerPreferenceStore.setDefault("rulergrid.snaptogeometry", false);
            workspaceViewerPreferenceStore.setValue("rulergrid.snaptogeometry", false);
            this.snapDisabler = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getNewValue() instanceof Boolean && ((Boolean)event.getNewValue()).booleanValue()) {
                        if ("rulergrid.snaptogeometry".equals(event.getProperty())) {
                            EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    workspaceViewerPreferenceStore.setValue("rulergrid.snaptogeometry", Boolean.FALSE.booleanValue());
                                }
                            });
                        } else if ("rulergrid.snaptogrid".equals(event.getProperty())) {
                            EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    workspaceViewerPreferenceStore.setValue("rulergrid.snaptogrid", Boolean.FALSE.booleanValue());
                                }
                            });
                        }
                    }
                }
            };
            workspaceViewerPreferenceStore.addPropertyChangeListener(this.snapDisabler);
        }
        boolean autoRefresh = PropertiesService.getInstance().getPropertiesProvider().getProperty(1);
        boolean refreshOnOpen = DialectUIManager.INSTANCE.isRefreshActivatedOnRepresentationOpening();
        this.getEditingDomain().getCommandStack().execute((Command)new RefreshLayoutCommand(this.getEditingDomain(), this.getDiagramView(), autoRefresh || refreshOnOpen));
        this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.semanticOrderingSynchronizer);
        this.getEditingDomain().addResourceSetListener(this.refreshZorder);
        Option<SessionEventBroker> broker = this.getSessionBroker();
        if (broker.some()) {
            SessionEventBroker sessionEventBroker = (SessionEventBroker)broker.get();
            RefreshLayoutScope refreshLayoutScope = new RefreshLayoutScope();
            this.refreshLayout = new RefreshLayoutTrigger(this.getDiagramView());
            sessionEventBroker.addLocalTrigger(SessionEventBrokerImpl.asFilter((Predicate)refreshLayoutScope), this.refreshLayout);
            SequenceCanonicalSynchronizerAdapterScope sequenceCanonicalSynchronizerLayoutScope = new SequenceCanonicalSynchronizerAdapterScope();
            this.sequenceCanonicalSynchronizer = new SequenceCanonicalSynchronizerAdapter();
            sessionEventBroker.addLocalTrigger(SessionEventBrokerImpl.asFilter((Predicate)sequenceCanonicalSynchronizerLayoutScope), this.sequenceCanonicalSynchronizer);
        }
        if ((overlayLayer = this.getLayer("Overlay Layer")) != null) {
            this.labelsOverlayFigure = new LabelsOverlayFigure(this.getFigure(), (IGraphicalEditPart)this);
            overlayLayer.add(this.labelsOverlayFigure);
        }
    }

    private Option<SessionEventBroker> getSessionBroker() {
        Session session;
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor != null && (session = diagramEditor.getSession()) != null && session.isOpen()) {
            return Options.newSome((Object)diagramEditor.getSession().getEventBroker());
        }
        return Options.newNone();
    }

    private void setCustomCommandFactoryProvider(DDiagramEditor diagramEditor) {
        this.previousProvider = diagramEditor.getEmfCommandFactoryProvider();
        diagramEditor.setEmfCommandFactoryProvider(new IDiagramCommandFactoryProvider(){
            private IDiagramCommandFactory commandFactory;

            public IDiagramCommandFactory getCommandFactory(TransactionalEditingDomain editingDomain) {
                if (this.commandFactory == null) {
                    this.commandFactory = new SequenceEMFCommandFactory(SequenceDiagramEditPart.this);
                }
                return this.commandFactory;
            }
        });
    }

    public void deactivate() {
        EditPartViewer viewer = this.getViewer();
        if (this.snapDisabler != null && viewer instanceof DiagramGraphicalViewer && ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore() != null) {
            ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore().removePropertyChangeListener(this.snapDisabler);
            this.snapDisabler = null;
        }
        IFigure overlayLayer = this.getLayer("Overlay Layer");
        if (this.labelsOverlayFigure != null && overlayLayer != null) {
            overlayLayer.remove(this.labelsOverlayFigure);
            this.labelsOverlayFigure = null;
        }
        this.getEditingDomain().removeResourceSetListener(this.refreshZorder);
        this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.semanticOrderingSynchronizer);
        Option<SessionEventBroker> broker = this.getSessionBroker();
        if (broker.some()) {
            SessionEventBroker sessionEventBroker = (SessionEventBroker)broker.get();
            sessionEventBroker.removeLocalTrigger(this.refreshLayout);
            sessionEventBroker.removeLocalTrigger(this.sequenceCanonicalSynchronizer);
        }
        super.deactivate();
    }

    public void reorderChild(EditPart child, int index) {
        super.reorderChild(child, index);
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.refreshConnectionsBendpoints();
        new SequenceZOrderingRefresher(this).run();
    }

    protected void refreshConnectionsBendpoints() {
        for (SequenceMessageEditPart connectionEditPart : Iterables.filter((Iterable)this.getConnections(), SequenceMessageEditPart.class)) {
            connectionEditPart.refreshBendpoints();
        }
    }

    public SequenceDiagram getSequenceDiagram() {
        return (SequenceDiagram)ISequenceElementAccessor.getSequenceDiagram((Diagram)this.getDiagramView()).get();
    }
}

