/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.diagram.sequence.business.internal.util.ISequenceElementSwitch;
import org.eclipse.sirius.diagram.sequence.business.internal.util.ParentOperandFinder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractSequenceInteractionValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.CombinedFragmentMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.InteractionUseMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.PositionsChecker;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;

public class ISEComplexMoveValidator
extends AbstractSequenceInteractionValidator {
    private static final String VALIDATOR = "org.eclipse.sirius.sequence.move.validator";
    protected final Set<ISequenceEvent> topLevelElements = new HashSet<ISequenceEvent>();
    protected final Set<ISequenceEvent> otherEntryPoints = new HashSet<ISequenceEvent>();
    protected Range globalMovedRange = Range.emptyRange();
    protected ISequenceEvent primarySelected;
    private final int vMove;
    private LinkedHashSet<ISequenceNode> sequenceNodesToMove = new LinkedHashSet();
    private Collection<Message> messagesToMove = new LinkedHashSet<Message>();
    private Function<ISequenceEvent, Range> rangeFunction = new Function<ISequenceEvent, Range>(){

        public Range apply(ISequenceEvent from) {
            Range range = from.getVerticalRange();
            if (ISEComplexMoveValidator.this.movedElements.contains(from)) {
                range = range.shifted(ISEComplexMoveValidator.this.vMove);
            } else if (ISEComplexMoveValidator.this.startReflexiveMessageToResize.contains(from)) {
                int minExecStart = Math.max(range.getLowerBound(), range.getUpperBound() + ISEComplexMoveValidator.this.vMove);
                range = new Range(range.getLowerBound(), minExecStart);
            } else if (ISEComplexMoveValidator.this.endReflexiveMessageToResize.contains(from)) {
                int maxExecEnd = Math.min(range.getUpperBound(), range.getLowerBound() + ISEComplexMoveValidator.this.vMove);
                range = new Range(maxExecEnd, range.getUpperBound());
                if (ISEComplexMoveValidator.this.expansionZone != null && !ISEComplexMoveValidator.this.expansionZone.isEmpty() && range.includes(ISEComplexMoveValidator.this.expansionZone.getUpperBound())) {
                    range = new Range(range.getLowerBound(), range.getUpperBound() + ISEComplexMoveValidator.this.expansionZone.width());
                }
            } else if (ISEComplexMoveValidator.this.expansionZone != null && !ISEComplexMoveValidator.this.expansionZone.isEmpty()) {
                if (range.includes(ISEComplexMoveValidator.this.expansionZone.getLowerBound())) {
                    range = new Range(range.getLowerBound(), range.getUpperBound() + ISEComplexMoveValidator.this.expansionZone.width());
                } else if (range.getLowerBound() >= ISEComplexMoveValidator.this.expansionZone.getLowerBound()) {
                    range = range.shifted(ISEComplexMoveValidator.this.expansionZone.width());
                }
            }
            return range;
        }
    };

    protected ISEComplexMoveValidator(ISequenceEvent host, RequestQuery request) {
        super(request);
        this.primarySelected = host;
        Preconditions.checkArgument((boolean)request.isMove());
        this.vMove = request.getLogicalDelta().y;
    }

    @Override
    public Function<ISequenceEvent, Range> getRangeFunction() {
        return this.rangeFunction;
    }

    @Override
    public SequenceDiagram getDiagram() {
        return this.primarySelected.getDiagram();
    }

    public Range getMovedRange() {
        return this.globalMovedRange;
    }

    public LinkedHashSet<ISequenceNode> getSequenceNodeToMove() {
        return this.sequenceNodesToMove;
    }

    public Set<ISequenceEvent> getTopLevelElements() {
        return this.topLevelElements;
    }

    public Collection<Message> getMessageToMove() {
        return this.messagesToMove;
    }

    public void addAdditionalEntryPoints(Collection<ISequenceEvent> sequenceElements) {
        if (sequenceElements != null && !sequenceElements.isEmpty()) {
            this.otherEntryPoints.addAll(sequenceElements);
        }
    }

    @Override
    protected void doValidation() {
        this.populateMoves();
        this.populateMessageToResize();
        this.categorizeMoves();
        this.checkMoves();
        if (!this.startReflexiveMessageToResize.isEmpty() || !this.endReflexiveMessageToResize.isEmpty()) {
            this.valid = this.valid && (this.expansionZone == null || this.expansionZone.isEmpty());
        }
    }

    private void populateMoves() {
        Set movedEvents = new ISequenceEventQuery(this.primarySelected).getAllSequenceEventToMoveWith(this.otherEntryPoints);
        if (movedEvents != null && !movedEvents.isEmpty()) {
            this.movedElements.addAll(movedEvents);
        }
    }

    private void populateMessageToResize() {
        for (Execution movedExec : Iterables.filter((Iterable)this.movedElements, Execution.class)) {
            Option endMessage;
            Option startMessage = movedExec.getStartMessage();
            if (startMessage.some() && ((Message)startMessage.get()).surroundsEventOnSameLifeline()) {
                this.startReflexiveMessageToResize.add((Message)startMessage.get());
            }
            if (!(endMessage = movedExec.getEndMessage()).some() || !((Message)endMessage.get()).surroundsEventOnSameLifeline()) continue;
            this.endReflexiveMessageToResize.add((Message)endMessage.get());
        }
    }

    private void categorizeMoves() {
        MoveSwitch moveAnalyzer = new MoveSwitch();
        for (ISequenceEvent movedEvent : new ArrayList(this.movedElements)) {
            Range extendedRange = (Range)moveAnalyzer.doSwitch((ISequenceElement)movedEvent);
            this.globalMovedRange = this.globalMovedRange.union(extendedRange);
        }
        HashSet<ISequenceEvent> move = new HashSet<ISequenceEvent>();
        move.add(this.primarySelected);
        move.addAll(this.otherEntryPoints);
        Iterables.retainAll(move, this.sequenceNodesToMove);
        Iterables.addAll(this.topLevelElements, move);
        Rectangle movedRange = new Rectangle(0, this.globalMovedRange.getLowerBound(), 0, this.globalMovedRange.width());
        this.globalMovedRange = RangeHelper.verticalRange((Rectangle)this.request.getLogicalTransformedRectangle(movedRange));
    }

    private void checkMoves() {
        for (ISequenceEvent ise : this.topLevelElements) {
            if (this.moveIsValid(ise, true)) continue;
            this.valid = false;
            this.eventInError.add(ise);
        }
        if (this.valid) {
            Iterable otherMovedElements = Iterables.filter((Iterable)this.movedElements, (Predicate)Predicates.not((Predicate)Predicates.in(this.topLevelElements)));
            for (ISequenceEvent ise : otherMovedElements) {
                if (ise instanceof Operand || this.moveIsValid(ise, false)) continue;
                this.valid = false;
                this.eventInError.add(ise);
            }
        }
        for (Message resizedMsg : Iterables.concat((Iterable)this.startReflexiveMessageToResize, (Iterable)this.endReflexiveMessageToResize)) {
            boolean currentResizeIsValid = ((Range)this.rangeFunction.apply((Object)resizedMsg)).width() >= 10;
            boolean bl = this.valid = this.valid && currentResizeIsValid;
            if (currentResizeIsValid) continue;
            this.eventInError.add(resizedMsg);
        }
        this.valid = this.valid && this.checkConflictesInFinalPositions() && this.checkTitleZonesInFinalPositions();
    }

    private boolean checkConflictesInFinalPositions() {
        ArrayList<Integer> conflicts = new ArrayList<Integer>();
        conflicts.addAll(new PositionsChecker(this.getDiagram(), this.rangeFunction).getInvalidPositions());
        if (!conflicts.isEmpty() && !this.expansionZone.isEmpty() && this.globalMovedRange != this.expansionZone) {
            this.expansionZone = this.globalMovedRange;
            conflicts = new ArrayList();
            conflicts.addAll(new PositionsChecker(this.getDiagram(), this.rangeFunction).getInvalidPositions());
        }
        this.invalidPositions.addAll(conflicts);
        return conflicts.isEmpty();
    }

    private boolean checkTitleZonesInFinalPositions() {
        SequenceDiagram diagram = this.getDiagram();
        ArrayList<Range> conflicts = new ArrayList<Range>();
        Collection<Range> titleZones = this.getTitleZoneRanges(diagram);
        for (ISequenceEvent movedElement : this.movedElements) {
            Range movedRange = (Range)this.rangeFunction.apply((Object)movedElement);
            if (movedElement instanceof State && movedElement.isLogicallyInstantaneous()) {
                movedRange = new Range(movedRange.middleValue(), movedRange.middleValue());
            }
            for (Range title : titleZones) {
                if (!title.includes(movedRange.getLowerBound()) && !title.includes(movedRange.getUpperBound())) continue;
                conflicts.add(title);
            }
        }
        this.invalidRanges.addAll(conflicts);
        return conflicts.isEmpty();
    }

    private Collection<Range> getTitleZoneRanges(SequenceDiagram diagram) {
        ArrayList<Range> titleZones = new ArrayList<Range>();
        for (CombinedFragment unmovedCF : Iterables.filter((Iterable)diagram.getAllCombinedFragments(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)this.movedElements)))) {
            int titleZoneLowerBound = ((Range)this.rangeFunction.apply((Object)unmovedCF)).getLowerBound();
            int titleZoneUpperBound = ((Range)this.rangeFunction.apply((Object)unmovedCF.getFirstOperand())).getLowerBound();
            titleZones.add(new Range(titleZoneLowerBound, titleZoneUpperBound));
        }
        return titleZones;
    }

    private boolean moveIsValid(ISequenceEvent ise, boolean topLevel) {
        Range futureExtRange = this.getFutureExtendedRange(ise);
        Option lifeline = ise.getLifeline();
        boolean result = true;
        if (lifeline.some()) {
            boolean stableOperand;
            EventFinder futureParentFinder = new EventFinder((Lifeline)lifeline.get());
            futureParentFinder.setEventsToIgnore(Predicates.equalTo((Object)ise));
            futureParentFinder.setVerticalRangefunction(this.rangeFunction);
            Range insertionPoint = this.getInsertionPoint(ise, futureExtRange);
            ISequenceEvent insertionParent = futureParentFinder.findMostSpecificEvent(insertionPoint);
            if (insertionParent == null) {
                if (((Lifeline)lifeline.get()).isExplicitlyCreated() || ((Lifeline)lifeline.get()).isExplicitlyDestroyed()) {
                    return false;
                }
                insertionParent = (ISequenceEvent)lifeline.get();
            }
            boolean validExpansion = (stableOperand = this.checkOperandStability(ise, topLevel, insertionParent)) && this.checkExpansionNeed(ise, topLevel, insertionParent, futureExtRange, insertionPoint, Collections.singletonList((Lifeline)lifeline.get()));
            boolean validRemoteExpansion = validExpansion && this.checkRemoteExpansion(ise, topLevel, futureExtRange, insertionPoint);
            result = stableOperand && validExpansion && validRemoteExpansion;
        } else if (ise instanceof InteractionUse) {
            InteractionUseMoveValidator subValidator = new InteractionUseMoveValidator((InteractionUse)ise, this.request);
            subValidator.setMovedElements(this.movedElements);
            result = subValidator.isValid();
            this.expansionZone = this.expansionZone.union(subValidator.getExpansionZone());
        } else if (ise instanceof CombinedFragment) {
            CombinedFragmentMoveValidator subValidator = new CombinedFragmentMoveValidator((CombinedFragment)ise, this.request);
            subValidator.setMovedElements(this.movedElements);
            result = subValidator.isValid();
            this.expansionZone = this.expansionZone.union(subValidator.getExpansionZone());
        } else if (ise instanceof Message) {
            result = this.messageMoveIsValid((Message)ise);
        }
        return result;
    }

    private Range getInsertionPoint(ISequenceEvent ise, Range futureExtRange) {
        int insertionY = futureExtRange.getLowerBound();
        if (ise instanceof State && ise.isLogicallyInstantaneous()) {
            insertionY = futureExtRange.middleValue();
        }
        return new Range(insertionY, insertionY);
    }

    private boolean messageMoveIsValid(Message message) {
        boolean result = true;
        Option parentOperand = message.getParentOperand();
        if (!parentOperand.some() || !this.movedElements.contains(parentOperand.get())) {
            ISequenceEvent potentialSource = this.getMessageEnd(message, (Option<Lifeline>)message.getSourceLifeline(), (Option<Operand>)parentOperand);
            ISequenceEvent potentialTarget = this.getMessageEnd(message, (Option<Lifeline>)message.getTargetLifeline(), (Option<Operand>)parentOperand);
            if (potentialSource instanceof AbstractFrame || potentialSource instanceof State || potentialTarget instanceof AbstractFrame || potentialTarget instanceof State) {
                result = false;
            } else if (potentialSource != null && potentialTarget != null) {
                Range finalRange = (Range)this.rangeFunction.apply((Object)message);
                int lBound = finalRange.getLowerBound();
                int uBound = finalRange.getUpperBound();
                Operand srcOperand = null;
                if (potentialSource instanceof Operand) {
                    srcOperand = (Operand)potentialSource;
                } else if (potentialSource instanceof Execution) {
                    srcOperand = (Operand)new ParentOperandFinder(potentialSource, this.rangeFunction).getParentOperand(new Range(lBound, lBound)).get();
                }
                Operand tgtOperand = null;
                if (potentialTarget instanceof Operand) {
                    tgtOperand = (Operand)potentialTarget;
                } else if (potentialTarget instanceof Execution) {
                    tgtOperand = (Operand)new ParentOperandFinder(potentialTarget, this.rangeFunction).getParentOperand(new Range(uBound, uBound)).get();
                }
                result = srcOperand == tgtOperand;
            }
        }
        return result;
    }

    private ISequenceEvent getMessageEnd(Message message, Option<Lifeline> lifeline, Option<Operand> parentOperand) {
        if (lifeline.some()) {
            EventFinder newEndFinder = new EventFinder((Lifeline)lifeline.get());
            newEndFinder.setReconnection(false);
            Range lookedRange = (Range)this.rangeFunction.apply((Object)message);
            newEndFinder.setVerticalRangefunction(this.rangeFunction);
            return newEndFinder.findMostSpecificEvent(lookedRange);
        }
        return null;
    }

    private boolean checkOperandStability(ISequenceEvent ise, boolean topLevel, ISequenceEvent insertionParent) {
        ise.getParentOperand();
        if (insertionParent instanceof Operand) {
            Operand cfr_ignored_0 = (Operand)insertionParent;
        } else {
            Operand cfr_ignored_1 = (Operand)insertionParent.getParentOperand().get();
        }
        return true;
    }

    private boolean checkExpansionNeed(ISequenceEvent ise, boolean topLevel, ISequenceEvent insertionParent, Range futureExtRange, Range insertionPoint, Collection<Lifeline> lifelines) {
        boolean canChildOccupy;
        ArrayList toIgnore = new ArrayList(this.movedElements);
        toIgnore.addAll(this.startReflexiveMessageToResize);
        toIgnore.addAll(this.endReflexiveMessageToResize);
        boolean bl = canChildOccupy = this.movedElements.contains(insertionParent) || insertionParent.canChildOccupy(ise, futureExtRange, toIgnore, lifelines);
        if (!canChildOccupy) {
            if (topLevel && !this.expansionZone.isEmpty()) {
                this.expansionZone = this.globalMovedRange;
                canChildOccupy = true;
            } else if (topLevel || this.expansionZone.isEmpty()) {
                if (insertionParent.canChildOccupy(ise, insertionPoint, toIgnore, lifelines)) {
                    if (!(ise instanceof State) || !ise.isLogicallyInstantaneous()) {
                        this.expansionZone = this.expansionZone.union(futureExtRange);
                    }
                    canChildOccupy = true;
                }
            } else if (this.expansionZone.includes(futureExtRange)) {
                canChildOccupy = true;
            }
        }
        return canChildOccupy;
    }

    private boolean checkRemoteExpansion(ISequenceEvent ise, boolean topLevel, Range futureExtRange, Range insertionPoint) {
        if (ise instanceof Execution) {
            Execution exec = (Execution)ise;
            Option startMessage = exec.getStartMessage();
            Option endMessage = exec.getEndMessage();
            if (startMessage.some() && endMessage.some() && !this.startReflexiveMessageToResize.contains(startMessage.get()) && !this.endReflexiveMessageToResize.contains(endMessage.get())) {
                boolean canExpandedChildOccupy;
                Option startLifeline = ((Message)startMessage.get()).getSourceLifeline();
                Option targetLifeline = ((Message)endMessage.get()).getTargetLifeline();
                Range srcInsertionRange = (Range)this.rangeFunction.apply((Object)((ISequenceEvent)startMessage.get()));
                ISequenceEvent remoteSource = this.getRemoteEnd((Option<Message>)startMessage, (Option<Lifeline>)startLifeline, srcInsertionRange);
                Range tgtInsertionRange = (Range)this.rangeFunction.apply((Object)((ISequenceEvent)endMessage.get()));
                ISequenceEvent remoteTarget = this.getRemoteEnd((Option<Message>)endMessage, (Option<Lifeline>)targetLifeline, tgtInsertionRange);
                boolean remoteCanChildOccupy = startLifeline.some() && remoteSource != null && remoteTarget == remoteSource || !startLifeline.some();
                boolean tryExpand = topLevel || this.expansionZone.isEmpty();
                boolean bl = canExpandedChildOccupy = remoteSource != null && remoteSource.canChildOccupy(ise, srcInsertionRange);
                if (!remoteCanChildOccupy && tryExpand && canExpandedChildOccupy) {
                    this.expansionZone = this.expansionZone.union(futureExtRange);
                    remoteCanChildOccupy = true;
                }
                return remoteCanChildOccupy;
            }
        }
        return true;
    }

    private ISequenceEvent getRemoteEnd(Option<Message> message, Option<Lifeline> lifeline, Range insertionRange) {
        ISequenceEvent remoteEnd = null;
        if (lifeline.some()) {
            EventFinder remoteSrcFinder = new EventFinder((Lifeline)lifeline.get());
            remoteSrcFinder.setEventsToIgnore(Predicates.equalTo((Object)((ISequenceEvent)message.get())));
            remoteSrcFinder.setVerticalRangefunction(this.rangeFunction);
            remoteSrcFinder.setExpansionZone(this.expansionZone);
            remoteSrcFinder.setReconnection(true);
            remoteEnd = remoteSrcFinder.findMostSpecificEvent(insertionRange);
        }
        return remoteEnd;
    }

    private Range getFutureExtendedRange(ISequenceEvent ise) {
        Range futureExtRange = (Range)this.rangeFunction.apply((Object)ise);
        if (ise instanceof Execution) {
            Option endMessage;
            Execution exec = (Execution)ise;
            Option startMessage = exec.getStartMessage();
            if (startMessage.some() && !this.startReflexiveMessageToResize.contains(startMessage.get())) {
                futureExtRange = futureExtRange.union((Range)this.rangeFunction.apply((Object)((ISequenceEvent)startMessage.get())));
            }
            if ((endMessage = exec.getEndMessage()).some() && !this.endReflexiveMessageToResize.contains(endMessage.get())) {
                futureExtRange = futureExtRange.union((Range)this.rangeFunction.apply((Object)((ISequenceEvent)endMessage.get())));
            }
        }
        return futureExtRange;
    }

    public static ISEComplexMoveValidator getOrCreateValidator(ChangeBoundsRequest cbr, RequestQuery requestQuery, ISequenceEvent host) {
        ISEComplexMoveValidator validator = null;
        Object object = cbr.getExtendedData().get(VALIDATOR);
        if (object instanceof ISEComplexMoveValidator) {
            validator = (ISEComplexMoveValidator)object;
            if (validator.request == null || !validator.request.getLogicalDelta().equals((Object)requestQuery.getLogicalDelta())) {
                validator = null;
            }
        }
        if (validator == null && requestQuery.isMove()) {
            Set<ISequenceEvent> selectedIses = new RequestQuery((Request)cbr).getISequenceEvents();
            validator = new ISEComplexMoveValidator(host, requestQuery);
            validator.addAdditionalEntryPoints(selectedIses);
            cbr.getExtendedData().put(VALIDATOR, validator);
        }
        return validator;
    }

    public class MoveSwitch
    extends ISequenceElementSwitch<Range> {
        public Range caseMessage(Message movedEvent) {
            Predicate<Message> toMove = new Predicate<Message>(){

                public boolean apply(Message input) {
                    boolean movedBySrc = ((MoveSwitch)MoveSwitch.this).ISEComplexMoveValidator.this.movedElements.contains(input.getSourceElement());
                    boolean movedByTgt = ((MoveSwitch)MoveSwitch.this).ISEComplexMoveValidator.this.movedElements.contains(input.getTargetElement());
                    return !movedBySrc || !movedByTgt;
                }
            };
            if (toMove.apply((Object)movedEvent)) {
                if (ISEComplexMoveValidator.this.startReflexiveMessageToResize.contains(movedEvent) || ISEComplexMoveValidator.this.endReflexiveMessageToResize.contains(movedEvent)) {
                    ISEComplexMoveValidator.this.movedElements.remove(movedEvent);
                    return Range.emptyRange();
                }
                ISEComplexMoveValidator.this.messagesToMove.add(movedEvent);
            } else {
                ISEComplexMoveValidator.this.startReflexiveMessageToResize.remove(movedEvent);
                ISEComplexMoveValidator.this.endReflexiveMessageToResize.remove(movedEvent);
            }
            return movedEvent.getVerticalRange();
        }

        public Range caseExecution(Execution movedEvent) {
            Option endMessage;
            ISequenceEvent hierarchicalParentEvent = movedEvent.getHierarchicalParentEvent();
            if (hierarchicalParentEvent instanceof ISequenceNode && !ISEComplexMoveValidator.this.movedElements.contains(hierarchicalParentEvent)) {
                ISEComplexMoveValidator.this.sequenceNodesToMove.add(movedEvent);
            }
            Range extendedVerticalRange = movedEvent.getExtendedVerticalRange();
            Option startMessage = movedEvent.getStartMessage();
            if (startMessage.some() && ISEComplexMoveValidator.this.startReflexiveMessageToResize.contains(startMessage.get())) {
                extendedVerticalRange = new Range(((Message)startMessage.get()).getVerticalRange().getUpperBound(), extendedVerticalRange.getUpperBound());
            }
            if ((endMessage = movedEvent.getEndMessage()).some() && ISEComplexMoveValidator.this.endReflexiveMessageToResize.contains(endMessage.get())) {
                extendedVerticalRange = new Range(extendedVerticalRange.getLowerBound(), ((Message)endMessage.get()).getVerticalRange().getLowerBound());
            }
            return extendedVerticalRange;
        }

        public Range caseState(State movedEvent) {
            ISequenceEvent hierarchicalParentEvent = movedEvent.getHierarchicalParentEvent();
            if (hierarchicalParentEvent instanceof ISequenceNode && !ISEComplexMoveValidator.this.movedElements.contains(hierarchicalParentEvent)) {
                ISEComplexMoveValidator.this.sequenceNodesToMove.add(movedEvent);
            }
            return movedEvent.getVerticalRange();
        }

        public Range caseFrame(AbstractFrame movedEvent) {
            ISEComplexMoveValidator.this.sequenceNodesToMove.add(movedEvent);
            return movedEvent.getVerticalRange();
        }

        public Range caseOperand(Operand movedEvent) {
            return movedEvent.getVerticalRange();
        }
    }
}

