/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.business.api.diagramtype;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.dialect.description.DefaultInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.diagramtype.HeaderData;
import org.eclipse.sirius.diagram.business.api.diagramtype.ICollapseUpdater;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramDescriptionProvider;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.query.InstanceRoleQuery;
import org.eclipse.sirius.diagram.sequence.description.DescriptionFactory;
import org.eclipse.sirius.diagram.sequence.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.sequence.description.tool.CombinedFragmentCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ExecutionCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InstanceRoleCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InstanceRoleReorderTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InteractionUseCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ObservationPointCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.OperandCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ReorderTool;
import org.eclipse.sirius.diagram.sequence.description.tool.SequenceDiagramToolDescription;
import org.eclipse.sirius.diagram.sequence.description.tool.StateCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ToolFactory;
import org.eclipse.sirius.diagram.sequence.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.sequence.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.sequence.ordering.provider.OrderingItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.sequence.provider.SequenceItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.sequence.template.provider.TemplateItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.business.api.diagramtype.SequenceDiagramInterpretedExpressionSwitch;
import org.eclipse.sirius.diagram.sequence.ui.business.internal.diagramtype.SequenceCollapseUpdater;
import org.eclipse.sirius.diagram.sequence.ui.business.internal.diagramtype.SequenceToolInterpretedExpressionSwitch;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;

public class SequenceDiagramTypeProvider
implements IDiagramDescriptionProvider {
    private final Predicate<DSemanticDecorator> isSequenceSemanticDecorator = new Predicate<DSemanticDecorator>(){

        public boolean apply(DSemanticDecorator input) {
            boolean result = false;
            if (input instanceof DDiagram) {
                result = SequenceDiagramTypeProvider.this.checkSequenceDescriptionPackage(((DDiagram)input).getDescription().eClass());
            } else if (input instanceof DDiagramElement) {
                result = SequenceDiagramTypeProvider.this.isSequenceDDiagramElement.apply((Object)((DDiagramElement)input));
            }
            return result;
        }
    };
    private final Predicate<DDiagramElement> isSequenceDDiagramElement = new Predicate<DDiagramElement>(){

        public boolean apply(DDiagramElement input) {
            DiagramElementMapping mappingToCheck = new DiagramElementMappingQuery(input.getDiagramElementMapping()).getRootMapping();
            return SequenceDiagramTypeProvider.this.checkSequenceDescriptionPackage(mappingToCheck.eClass()) || LostMessageEnd.viewpointElementPredicate().apply((Object)input);
        }
    };

    private boolean checkSequenceDescriptionPackage(EClass eClass) {
        return org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.equals(eClass.getEPackage());
    }

    public DiagramDescription createDiagramDescription() {
        return DescriptionFactory.eINSTANCE.createSequenceDiagramDescription();
    }

    public Collection<? extends CommandParameter> collectToolCommands(EObject context) {
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
        List<EReference> refs = Arrays.asList(ToolPackage.Literals.TOOL_SECTION__OWNED_TOOLS, ToolPackage.Literals.TOOL_GROUP__TOOLS);
        for (EReference ref : refs) {
            if (!ref.getEContainingClass().equals(context.eClass())) continue;
            this.collectInstanceRoleCreation(result, ref);
            this.collectExecutionCreation(result, ref);
            this.collectStateCreation(result, ref);
            this.collectMessageCreation(result, ref);
            this.collectInteractionUse(result, ref);
            this.collectCombinedFragmentCreation(result, ref);
            this.collectOperandCreation(result, ref);
            this.collectReorderCreations(result, ref);
            this.collectObservationPointCreation(result, ref);
        }
        return result;
    }

    public Collection<? extends CommandParameter> collectMappingsCommands() {
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__NODE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createInstanceRoleMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__NODE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createExecutionMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__NODE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createStateMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__NODE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createEndOfLifeMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__NODE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createObservationPointMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__CONTAINER_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createInteractionUseMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__CONTAINER_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createCombinedFragmentMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__CONTAINER_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createOperandMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__EDGE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createBasicMessageMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__EDGE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createReturnMessageMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__EDGE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createCreationMessageMapping()));
        result.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.LAYER__EDGE_MAPPINGS, (Object)DescriptionFactory.eINSTANCE.createDestructionMessageMapping()));
        return result;
    }

    public AdapterFactory getAdapterFactory() {
        ComposedAdapterFactory composed = new ComposedAdapterFactory();
        composed.addAdapterFactory((AdapterFactory)new SequenceItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new TemplateItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new DescriptionItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new OrderingItemProviderAdapterFactory());
        composed.addAdapterFactory((AdapterFactory)new ToolItemProviderAdapterFactory());
        return composed;
    }

    public boolean handles(EPackage ePackage) {
        return org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getNsURI().equals(ePackage.getNsURI()) || ToolPackage.eINSTANCE.getNsURI().equals(ePackage.getNsURI());
    }

    public IInterpretedExpressionTargetSwitch createInterpretedExpressionSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch parentSwitch) {
        return new SequenceGlobalInterpretedTargetSwitch(feature, parentSwitch);
    }

    public boolean allowsLayoutingModeActivation() {
        return false;
    }

    public boolean allowsVisibilityModeActivation() {
        return false;
    }

    public boolean allowsPinUnpin(DDiagramElement element) {
        return !this.isSequenceDDiagramElement.apply((Object)element);
    }

    public boolean allowsHideReveal(DDiagramElement element) {
        return !this.isSequenceDDiagramElement.apply((Object)element);
    }

    public boolean allowsCopyPasteLayout(DSemanticDecorator element) {
        return this.allowsCopyPasteFormat(element);
    }

    public boolean allowsCopyPasteFormat(DSemanticDecorator element) {
        return !this.isSequenceSemanticDecorator.apply((Object)element);
    }

    private void collectInstanceRoleCreation(Collection<CommandParameter> result, EReference ref) {
        InstanceRoleCreationTool instanceRoleCreationTool = ToolFactory.eINSTANCE.createInstanceRoleCreationTool();
        this.addVariables((SequenceDiagramToolDescription)instanceRoleCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)instanceRoleCreationTool));
    }

    private void collectExecutionCreation(Collection<CommandParameter> result, EReference ref) {
        ExecutionCreationTool executionCreationTool = ToolFactory.eINSTANCE.createExecutionCreationTool();
        this.addVariables((SequenceDiagramToolDescription)executionCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)executionCreationTool));
    }

    private void collectStateCreation(Collection<CommandParameter> result, EReference ref) {
        StateCreationTool stateCreationTool = ToolFactory.eINSTANCE.createStateCreationTool();
        this.addVariables((SequenceDiagramToolDescription)stateCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)stateCreationTool));
    }

    private void collectMessageCreation(Collection<CommandParameter> result, EReference ref) {
        MessageCreationTool messageCreationTool = ToolFactory.eINSTANCE.createMessageCreationTool();
        this.addVariables((SequenceDiagramToolDescription)messageCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)messageCreationTool));
    }

    private void collectCombinedFragmentCreation(Collection<CommandParameter> result, EReference ref) {
        CombinedFragmentCreationTool combinedFragmentCreationTool = ToolFactory.eINSTANCE.createCombinedFragmentCreationTool();
        this.addVariables((SequenceDiagramToolDescription)combinedFragmentCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)combinedFragmentCreationTool));
    }

    private void collectOperandCreation(Collection<CommandParameter> result, EReference ref) {
        OperandCreationTool operandCreationTool = ToolFactory.eINSTANCE.createOperandCreationTool();
        this.addVariables((SequenceDiagramToolDescription)operandCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)operandCreationTool));
    }

    private void collectReorderCreations(Collection<CommandParameter> result, EReference ref) {
        ReorderTool reorderCreationTool = ToolFactory.eINSTANCE.createReorderTool();
        this.addVariables((SequenceDiagramToolDescription)reorderCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)reorderCreationTool));
        InstanceRoleReorderTool irReorderCreationTool = ToolFactory.eINSTANCE.createInstanceRoleReorderTool();
        this.addVariables((SequenceDiagramToolDescription)irReorderCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)irReorderCreationTool));
    }

    private void collectInteractionUse(Collection<CommandParameter> result, EReference ref) {
        InteractionUseCreationTool interactionUseCreationTool = ToolFactory.eINSTANCE.createInteractionUseCreationTool();
        this.addVariables((SequenceDiagramToolDescription)interactionUseCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)interactionUseCreationTool));
    }

    private void collectObservationPointCreation(Collection<CommandParameter> result, EReference ref) {
        ObservationPointCreationTool obsPointCreationTool = ToolFactory.eINSTANCE.createObservationPointCreationTool();
        this.addVariables((SequenceDiagramToolDescription)obsPointCreationTool);
        result.add(new CommandParameter(null, (Object)ref, (Object)obsPointCreationTool));
    }

    private void addVariables(SequenceDiagramToolDescription sequenceDiagramTool) {
        for (EReference ref : sequenceDiagramTool.eClass().getEAllReferences()) {
            if (!ref.isContainment() || !(ref.getEType() instanceof EClass)) continue;
            EClass k = (EClass)ref.getEType();
            EClass variable = DescriptionPackage.eINSTANCE.getAbstractVariable();
            if (!variable.isSuperTypeOf(k)) continue;
            AbstractVariable var = (AbstractVariable)k.getEPackage().getEFactoryInstance().create(k);
            EAnnotation annotation = ref.getEAnnotation("toolVariable");
            if (annotation != null) {
                var.setName((String)annotation.getDetails().get((Object)"name"));
            } else {
                var.setName(ref.getName());
            }
            sequenceDiagramTool.eSet((EStructuralFeature)ref, (Object)var);
        }
    }

    public boolean supportHeader() {
        return true;
    }

    public boolean requiresNonStandardFormatDataManagers() {
        return true;
    }

    public LinkedList<HeaderData> getHeaderData(DDiagram diagram) {
        Option optionalSequenceDiagram;
        Diagram gmfDiagram;
        LinkedList<HeaderData> result = new LinkedList<HeaderData>();
        if (diagram instanceof SequenceDDiagram && (gmfDiagram = this.getGmfDiagram(diagram)) != null && (optionalSequenceDiagram = ISequenceElementAccessor.getSequenceDiagram((Diagram)gmfDiagram)).some()) {
            List instanceRoles = ((SequenceDiagram)optionalSequenceDiagram.get()).getSortedInstanceRole();
            for (InstanceRole instanceRole : instanceRoles) {
                result.add(new InstanceRoleQuery(instanceRole).getHeaderData());
            }
        }
        return result;
    }

    private Diagram getGmfDiagram(DDiagram diagram) {
        Diagram gmfDiagram = null;
        SequenceDDiagram sequenceDDiagram = (SequenceDDiagram)diagram;
        Option optionDiagram = new DDiagramGraphicalQuery((DDiagram)sequenceDDiagram).getAssociatedGMFDiagram();
        if (optionDiagram.some()) {
            gmfDiagram = (Diagram)optionDiagram.get();
        } else {
            Resource eResource = diagram.eResource();
            if (eResource != null) {
                for (Diagram diag : Iterables.filter((Iterable)eResource.getContents(), Diagram.class)) {
                    if (!diagram.equals(diag.getElement())) continue;
                    gmfDiagram = diag;
                    break;
                }
            }
        }
        return gmfDiagram;
    }

    public Option<? extends ICollapseUpdater> getCollapseUpdater(DDiagram diagram) {
        if (diagram != null && diagram.getDescription() != null && this.handles(diagram.getDescription().eClass().getEPackage())) {
            return Options.newSome((Object)((Object)new SequenceCollapseUpdater()));
        }
        return Options.newNone();
    }

    public String completeToolTipText(String toolTipText, EObject eObject) {
        return this.completeToolTipText(toolTipText, eObject, null);
    }

    public String completeToolTipText(String toolTipText, EObject eObject, EStructuralFeature feature) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)toolTipText)) {
            sb.append(String.valueOf(toolTipText) + "\n");
            sb.append("\n");
        }
        sb.append(Messages.SequenceDiagramTypeProvider_sequenceAdditionalVariablesTooltip);
        sb.append("\n . ");
        sb.append("endBefore");
        sb.append(": ");
        sb.append(Messages.SequenceDiagramTypeProvider_endBeforeVariableDescription);
        return sb.toString();
    }

    public boolean eventShouldTriggerArrange(OperationHistoryEvent event) {
        EMFCommandOperation command;
        boolean result = true;
        if (event.getOperation() instanceof EMFCommandOperation && org.eclipse.sirius.diagram.sequence.tool.internal.Messages.RefreshLayoutCommand_commandName.equals((command = (EMFCommandOperation)event.getOperation()).getLabel())) {
            result = false;
        }
        return result;
    }

    private class SequenceGlobalInterpretedTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private final DefaultInterpretedExpressionTargetSwitch defaultSwitch;
        private final SequenceDiagramInterpretedExpressionSwitch sequenceSwitch;
        private final SequenceToolInterpretedExpressionSwitch toolSwitch;

        SequenceGlobalInterpretedTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch parentSwitch) {
            this.defaultSwitch = new DefaultInterpretedExpressionTargetSwitch(feature, parentSwitch);
            this.sequenceSwitch = new SequenceDiagramInterpretedExpressionSwitch(feature, parentSwitch);
            this.toolSwitch = new SequenceToolInterpretedExpressionSwitch(feature, parentSwitch);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = new LinkedHashSet();
            Option expressionTarget = Options.newSome(targetTypes);
            if (target != null) {
                this.sequenceSwitch.setConsiderFeature(considerFeature);
                expressionTarget = this.sequenceSwitch.doSwitch(target);
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.toolSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.toolSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    expressionTarget = this.defaultSwitch.doSwitch(target, considerFeature);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            return this.defaultSwitch != null ? this.defaultSwitch.getFirstRelevantContainer(obj) : null;
        }
    }
}

