/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies;

import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;

public class DelegatingMouseEventsEditPolicy
extends AbstractEditPolicy
implements MouseMotionListener {
    private final String editPolicyRole;

    public DelegatingMouseEventsEditPolicy(String editPolicyRole) {
        this.editPolicyRole = editPolicyRole;
    }

    public void activate() {
        super.activate();
        ((IGraphicalEditPart)this.getHost()).getFigure().addMouseMotionListener((MouseMotionListener)this);
    }

    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeMouseMotionListener((MouseMotionListener)this);
        super.deactivate();
    }

    private EditPolicy getParentEditPolicy() {
        EditPart parentEP = this.getHost().getParent();
        while (parentEP != null) {
            EditPolicy editPolicy = parentEP.getEditPolicy((Object)this.editPolicyRole);
            if (editPolicy != null && editPolicy instanceof MouseMotionListener) {
                return editPolicy;
            }
            if (parentEP instanceof TopGraphicEditPart) {
                return null;
            }
            parentEP = parentEP.getParent();
        }
        return null;
    }

    public void mouseEntered(MouseEvent me) {
        MouseMotionListener parentPolicy = (MouseMotionListener)this.getParentEditPolicy();
        if (parentPolicy != null) {
            this.translateLocation(me);
            parentPolicy.mouseEntered(me);
        }
    }

    public void mouseExited(MouseEvent me) {
        MouseMotionListener parentPolicy = (MouseMotionListener)this.getParentEditPolicy();
        if (parentPolicy != null) {
            this.translateLocation(me);
            parentPolicy.mouseExited(me);
        }
    }

    public void mouseHover(MouseEvent me) {
        MouseMotionListener parentPolicy = (MouseMotionListener)this.getParentEditPolicy();
        if (parentPolicy != null) {
            this.translateLocation(me);
            parentPolicy.mouseHover(me);
        }
    }

    public void mouseMoved(MouseEvent me) {
        MouseMotionListener parentPolicy = (MouseMotionListener)this.getParentEditPolicy();
        if (parentPolicy != null) {
            this.translateLocation(me);
            parentPolicy.mouseMoved(me);
        }
    }

    public void mouseDragged(MouseEvent me) {
        MouseMotionListener parentPolicy = (MouseMotionListener)this.getParentEditPolicy();
        if (parentPolicy != null) {
            this.translateLocation(me);
            parentPolicy.mouseDragged(me);
        }
    }

    private void translateLocation(MouseEvent mouseEvent) {
        Point location = mouseEvent.getLocation();
        ((IGraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)location);
        ((IGraphicalEditPart)this.getParentEditPolicy().getHost()).getFigure().translateToRelative((Translatable)location);
        mouseEvent.x = location.x;
        mouseEvent.y = location.y;
    }
}

