/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.arduino.platform;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformEventLoopGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;

public class EventLoopGenerator
implements IPlatformEventLoopGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;

    public CodeFragment generateEventloopInject(final String functionName, String userParam1, String userParam2) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)functionName);
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateEventloopInject(String functionName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("NULL");
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("0");
        return this.generateEventloopInject(functionName, _builder.toString(), _builder_1.toString());
    }

    public CodeFragment generateEventLoopInject(CompilationContext context, String functionName) {
        return this.generateEventloopInject(functionName);
    }

    public CodeFragment generateEventLoopStart(CompilationContext context) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateEventHeaderPreamble(final CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _tripleNotEquals;
                int _length = ((Object[])Conversions.unwrapArray((Object)EventLoopGenerator.this._generatorUtils.getAllTimeEvents(context), Object.class)).length;
                boolean bl = _tripleNotEquals = _length != 0;
                if (_tripleNotEquals) {
                    _builder.append((Object)"#define TIMED_APPLICATION");
                    _builder.newLine();
                }
                Iterable _allEventHandlers = context.getAllEventHandlers();
                for (EventHandlerDeclaration handler : _allEventHandlers) {
                    _builder.newLine();
                    _builder.append((Object)"volatile bool ");
                    String _handlerName = EventLoopGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName);
                    _builder.append((Object)"_flag;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"bool get");
                    String _handlerName_1 = EventLoopGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName_1);
                    _builder.append((Object)"_flag();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"void set");
                    String _handlerName_2 = EventLoopGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName_2);
                    _builder.append((Object)"(bool val);");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateEventLoopHandlerSignature(CompilationContext context) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateEventLoopHandlerPreamble(CompilationContext context, EventHandlerDeclaration handler) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateSetupPreamble(CompilationContext context) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateEnablePreamble(CompilationContext context) {
        return CodeFragment.EMPTY;
    }
}

