/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class RestClientValidator
implements IResourceValidator {
    public void validate(Program program, EObject context, ValidationMessageAcceptor acceptor) {
        if (context instanceof SystemResourceSetup) {
            Procedures.Procedure1<EObject> _function_1;
            Object endpointValue;
            Expression rawEndpointBase;
            acceptor.acceptWarning("The HttpRestClient connectivity is experimental. Things might not work as expected.", context, (EStructuralFeature)ProgramPackage.Literals.SYSTEM_RESOURCE_SETUP__TYPE, 0, "restclient_is_experimental", new String[0]);
            Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                public Boolean apply(ConfigurationItemValue it) {
                    String _name = it.getItem().getName();
                    return Objects.equal((Object)_name, (Object)"endpointBase");
                }
            };
            ConfigurationItemValue rawEndpointBaseItem = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)((SystemResourceSetup)context).getConfigurationItemValues(), (Functions.Function1)_function);
            Expression _value = null;
            if (rawEndpointBaseItem != null) {
                _value = rawEndpointBaseItem.getValue();
            }
            if ((rawEndpointBase = _value) != null && (endpointValue = StaticValueInferrer.infer((EObject)rawEndpointBase, (Procedures.Procedure1)(_function_1 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            }))) instanceof String) {
                try {
                    URL endpointUrl = new URL((String)endpointValue);
                    boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)endpointUrl.getProtocol());
                    if (_isNullOrEmpty) {
                        acceptor.acceptError("Please include the protocol. Start with http://", (EObject)rawEndpointBaseItem, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "no_protocol_in_url", new String[0]);
                    } else {
                        boolean _notEquals;
                        String _protocol = endpointUrl.getProtocol();
                        boolean bl = _notEquals = !Objects.equal((Object)_protocol, (Object)"http");
                        if (_notEquals) {
                            acceptor.acceptError("Only http is supported as protocol", (EObject)rawEndpointBaseItem, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "only_http_supported", new String[0]);
                        } else {
                            boolean _isNullOrEmpty_1 = Strings.isNullOrEmpty((String)endpointUrl.getHost());
                            if (_isNullOrEmpty_1) {
                                acceptor.acceptError("Host part of the URL is required", (EObject)rawEndpointBaseItem, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "host_required", new String[0]);
                            } else {
                                boolean _endsWith = ((String)endpointValue).endsWith("/");
                                if (_endsWith) {
                                    acceptor.acceptWarning("Endpoint base should not end with a trailing slash. Remove the last /", (EObject)rawEndpointBaseItem, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "no_trailing_slash", new String[0]);
                                }
                            }
                        }
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof MalformedURLException) {
                        MalformedURLException e = (MalformedURLException)_t;
                        String _message = e.getMessage();
                        String _firstUpper = null;
                        if (_message != null) {
                            _firstUpper = StringExtensions.toFirstUpper((String)_message);
                        }
                        String _plus = "URL is malformed. " + _firstUpper;
                        acceptor.acceptError(_plus, (EObject)rawEndpointBaseItem, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "malformed_endpoint_base", new String[0]);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }
}

