/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.platform;

import com.google.inject.Inject;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class ExceptionGenerator
implements IPlatformExceptionGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateExceptionCodeFor(CompilationContext context, Type exception) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("EXCEPTION_");
        String _upperCase = exception.getName().toUpperCase();
        _builder.append(_upperCase);
        String exceptionName = _builder.toString();
        final int exceptionValue = Math.abs(exceptionName.hashCode());
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"RETCODE(RETCODE_SEVERITY_ERROR, UINT32_C(");
                _builder.append((Object)exceptionValue);
                _builder.append((Object)"))");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Retcode.h", true);
    }

    public CodeFragment getExceptionType() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Retcode.h", true);
    }

    public CodeFragment getNoExceptionStatement() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"RETCODE_OK");
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"#ifndef BCDS_MODULE_ID");
                _builder.newLine();
                _builder.append((Object)"#define BCDS_MODULE_ID 0xCAFE");
                _builder.newLine();
                _builder.append((Object)"#endif");
                _builder.newLine();
            }
        };
        return _create.setPreamble(_client_1).addHeader("BCDS_Retcode.h", true);
    }

    public CodeFragment generateRaiseException(CompilationContext context, final String exceptionVariableName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_raiseError(");
                _builder.append((Object)exceptionVariableName);
                _builder.append((Object)");");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Retcode.h", true);
    }
}

