/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.platform;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.ExpressionsPackage;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Property;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.Signal;
import org.eclipse.mita.platform.xdk110.sensors.NoiseSensorValidator;
import org.eclipse.mita.program.GeneratedFunctionDefinition;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.mita.program.validation.MethodCall;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class Validation
implements IResourceValidator {
    @Inject
    private ElementSizeInferrer sizeInferrer;

    public void validate(Program program, EObject context, final ValidationMessageAcceptor acceptor) {
        Functions.Function1<String, Iterable<MethodCall.MethodCallModality>> _function_5;
        Functions.Function1<String, Iterable<MethodCall.MethodCallSigInst>> _function_4;
        Functions.Function1<FeatureCall, Boolean> _function = new Functions.Function1<FeatureCall, Boolean>(){

            public Boolean apply(FeatureCall it) {
                return it.isOperationCall();
            }
        };
        List functionCalls1 = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)program.eAllContents(), FeatureCall.class), (Functions.Function1)_function));
        Functions.Function1<ElementReferenceExpression, Boolean> _function_1 = new Functions.Function1<ElementReferenceExpression, Boolean>(){

            public Boolean apply(ElementReferenceExpression it) {
                return it.isOperationCall();
            }
        };
        List functionCalls2 = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)program.eAllContents(), ElementReferenceExpression.class), (Functions.Function1)_function_1));
        Functions.Function1<FeatureCall, MethodCall<? extends Property>> _function_2 = new Functions.Function1<FeatureCall, MethodCall<? extends Property>>(){

            public MethodCall<? extends Property> apply(FeatureCall it) {
                FeatureCall source = it;
                EObject method = it.getFeature();
                Expression owner = it.getOwner();
                if (owner instanceof FeatureCall) {
                    EObject sigInst = ((FeatureCall)owner).getFeature();
                    if (source == null || method == null || sigInst == null) {
                        return null;
                    }
                    return MethodCall.cons((Object)source, (Object)method, (Object)sigInst, (Object)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE);
                }
                return null;
            }
        };
        List _map = ListExtensions.map((List)functionCalls1, (Functions.Function1)_function_2);
        Functions.Function1<ElementReferenceExpression, MethodCall<? extends Property>> _function_3 = new Functions.Function1<ElementReferenceExpression, MethodCall<? extends Property>>(){

            public MethodCall<? extends Property> apply(ElementReferenceExpression it) {
                ElementReferenceExpression source = it;
                EObject method = it.getReference();
                if (method instanceof Operation) {
                    Expression sigInst = ModelUtils.getArgumentValue((Operation)((Operation)method), (ArgumentExpression)it, (String)"self");
                    if (source == null || method == null || sigInst == null) {
                        return null;
                    }
                    return MethodCall.cons((Object)source, (Object)method, (Object)sigInst, (Object)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE);
                }
                return null;
            }
        };
        List _map_1 = ListExtensions.map((List)functionCalls2, (Functions.Function1)_function_3);
        Iterable sigInstOrModalityAccesses = IterableExtensions.filterNull((Iterable)Iterables.concat((Iterable)_map, (Iterable)_map_1));
        final Iterable sigInstAccesses = Iterables.filter((Iterable)sigInstOrModalityAccesses, MethodCall.MethodCallSigInst.class);
        final Iterable modalityAccesses = Iterables.filter((Iterable)sigInstOrModalityAccesses, MethodCall.MethodCallModality.class);
        Functions.Function1<String, Iterable<MethodCall.MethodCallSigInst>> filterSigInstName = _function_4 = new Functions.Function1<String, Iterable<MethodCall.MethodCallSigInst>>(){

            public Iterable<MethodCall.MethodCallSigInst> apply(final String name) {
                Functions.Function1<MethodCall.MethodCallSigInst, Boolean> _function = new Functions.Function1<MethodCall.MethodCallSigInst, Boolean>(){

                    public Boolean apply(MethodCall.MethodCallSigInst it) {
                        EObject res;
                        EObject ref;
                        Expression init = it.getSigInst().getInitialization();
                        if (init instanceof ElementReferenceExpression && (ref = ((ElementReferenceExpression)init).getReference()) instanceof Signal && (res = ((Signal)ref).eContainer()) instanceof AbstractSystemResource) {
                            String _name = ((AbstractSystemResource)res).getName();
                            return Objects.equal((Object)_name, (Object)name);
                        }
                        return false;
                    }
                };
                return IterableExtensions.filter((Iterable)sigInstAccesses, (Functions.Function1)_function);
            }
        };
        Functions.Function1<String, Iterable<MethodCall.MethodCallModality>> filterModalityName = _function_5 = new Functions.Function1<String, Iterable<MethodCall.MethodCallModality>>(){

            public Iterable<MethodCall.MethodCallModality> apply(final String name) {
                Functions.Function1<MethodCall.MethodCallModality, Boolean> _function = new Functions.Function1<MethodCall.MethodCallModality, Boolean>(){

                    public Boolean apply(MethodCall.MethodCallModality it) {
                        Modality modality = it.getModality();
                        EObject res = modality.eContainer();
                        if (res instanceof AbstractSystemResource) {
                            String _name = ((AbstractSystemResource)res).getName();
                            return Objects.equal((Object)_name, (Object)name);
                        }
                        return false;
                    }
                };
                return IterableExtensions.filter((Iterable)modalityAccesses, (Functions.Function1)_function);
            }
        };
        Set i2cs = IterableExtensions.toSet((Iterable)((Iterable)filterSigInstName.apply((Object)"I2C")));
        Set gpios = IterableExtensions.toSet((Iterable)((Iterable)filterSigInstName.apply((Object)"GPIO")));
        Set sdcard = IterableExtensions.toSet((Iterable)((Iterable)filterSigInstName.apply((Object)"SDCard")));
        Set loras = IterableExtensions.toSet((Iterable)((Iterable)filterSigInstName.apply((Object)"LoRa")));
        final Set noises = IterableExtensions.toSet((Iterable)((Iterable)filterModalityName.apply((Object)"noise_sensor")));
        Functions.Function1<MethodCall.MethodCallSigInst, Boolean> _function_6 = new Functions.Function1<MethodCall.MethodCallSigInst, Boolean>(){

            public Boolean apply(MethodCall.MethodCallSigInst it) {
                boolean _xifexpression = false;
                Operation _method = it.getMethod();
                if (_method instanceof GeneratedFunctionDefinition) {
                    String _name = it.getMethod().getName();
                    _xifexpression = Objects.equal((Object)_name, (Object)"read");
                } else {
                    _xifexpression = false;
                }
                return _xifexpression;
            }
        };
        final Set reads = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)sigInstAccesses, (Functions.Function1)_function_6));
        Functions.Function1<MethodCall.MethodCallSigInst, Boolean> _function_7 = new Functions.Function1<MethodCall.MethodCallSigInst, Boolean>(){

            public Boolean apply(MethodCall.MethodCallSigInst it) {
                boolean _xifexpression = false;
                Operation _method = it.getMethod();
                if (_method instanceof GeneratedFunctionDefinition) {
                    String _name = it.getMethod().getName();
                    _xifexpression = Objects.equal((Object)_name, (Object)"write");
                } else {
                    _xifexpression = false;
                }
                return _xifexpression;
            }
        };
        final Set writes = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)sigInstAccesses, (Functions.Function1)_function_7));
        HashSet _hashSet = new HashSet(i2cs);
        Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>> _function_8 = new Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>>(){

            public void apply(HashSet<MethodCall.MethodCallSigInst> it) {
                it.retainAll(reads);
            }
        };
        HashSet i2cReads = (HashSet)ObjectExtensions.operator_doubleArrow(_hashSet, (Procedures.Procedure1)_function_8);
        HashSet _hashSet_1 = new HashSet(i2cs);
        Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>> _function_9 = new Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>>(){

            public void apply(HashSet<MethodCall.MethodCallSigInst> it) {
                it.retainAll(writes);
            }
        };
        HashSet i2cWrites = (HashSet)ObjectExtensions.operator_doubleArrow(_hashSet_1, (Procedures.Procedure1)_function_9);
        HashSet _hashSet_2 = new HashSet(gpios);
        Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>> _function_10 = new Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>>(){

            public void apply(HashSet<MethodCall.MethodCallSigInst> it) {
                it.retainAll(reads);
            }
        };
        HashSet gpioReads = (HashSet)ObjectExtensions.operator_doubleArrow(_hashSet_2, (Procedures.Procedure1)_function_10);
        HashSet _hashSet_3 = new HashSet(gpios);
        Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>> _function_11 = new Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>>(){

            public void apply(HashSet<MethodCall.MethodCallSigInst> it) {
                it.retainAll(writes);
            }
        };
        HashSet gpioWrites = (HashSet)ObjectExtensions.operator_doubleArrow(_hashSet_3, (Procedures.Procedure1)_function_11);
        HashSet _hashSet_4 = new HashSet(sdcard);
        Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>> _function_12 = new Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>>(){

            public void apply(HashSet<MethodCall.MethodCallSigInst> it) {
                it.retainAll(reads);
            }
        };
        HashSet sdCardReads = (HashSet)ObjectExtensions.operator_doubleArrow(_hashSet_4, (Procedures.Procedure1)_function_12);
        HashSet _hashSet_5 = new HashSet(sdcard);
        Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>> _function_13 = new Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>>(){

            public void apply(HashSet<MethodCall.MethodCallSigInst> it) {
                it.retainAll(writes);
            }
        };
        HashSet sdCardWrites = (HashSet)ObjectExtensions.operator_doubleArrow(_hashSet_5, (Procedures.Procedure1)_function_13);
        HashSet _hashSet_6 = new HashSet(loras);
        Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>> _function_14 = new Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>>(){

            public void apply(HashSet<MethodCall.MethodCallSigInst> it) {
                it.retainAll(reads);
            }
        };
        HashSet loraReads = (HashSet)ObjectExtensions.operator_doubleArrow(_hashSet_6, (Procedures.Procedure1)_function_14);
        Consumer<MethodCall.MethodCallSigInst> _function_15 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateI2cReadWrite((EObject)it.getSource(), it.getSigInst(), it.getStructFeature(), "Read", "read from", acceptor);
            }
        };
        i2cReads.forEach(_function_15);
        Consumer<MethodCall.MethodCallSigInst> _function_16 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateI2cReadWrite((EObject)it.getSource(), it.getSigInst(), it.getStructFeature(), "Write", "write to", acceptor);
            }
        };
        i2cWrites.forEach(_function_16);
        Consumer<MethodCall.MethodCallSigInst> _function_17 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateI2cWriteLength(it.getSource(), it.getMethod(), it.getSigInst(), acceptor);
            }
        };
        i2cWrites.forEach(_function_17);
        Consumer<MethodCall.MethodCallSigInst> _function_18 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateGpioRead(it, acceptor);
            }
        };
        gpioReads.forEach(_function_18);
        Consumer<MethodCall.MethodCallSigInst> _function_19 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateGpioWrite(it, acceptor);
            }
        };
        gpioWrites.forEach(_function_19);
        Consumer<MethodCall.MethodCallModality> _function_20 = new Consumer<MethodCall.MethodCallModality>(){

            @Override
            public void accept(MethodCall.MethodCallModality it) {
                NoiseSensorValidator.validateNoiseRead(noises, it, acceptor);
            }
        };
        noises.forEach(_function_20);
        Consumer<MethodCall.MethodCallSigInst> _function_21 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateSdCardRead(it, acceptor);
            }
        };
        sdCardReads.forEach(_function_21);
        Consumer<MethodCall.MethodCallSigInst> _function_22 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateSdCardWrite(it, acceptor);
            }
        };
        sdCardWrites.forEach(_function_22);
        Consumer<MethodCall.MethodCallSigInst> _function_23 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateNoReads(it, acceptor);
            }
        };
        loraReads.forEach(_function_23);
    }

    public void validateNoWrites(MethodCall.MethodCallSigInst call, ValidationMessageAcceptor acceptor) {
        Expression _initialization = call.getSigInst().getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        EObject _reference = init.getReference();
        Signal signal = (Signal)_reference;
        String _name = signal.getName();
        String _plus = "Can not write to " + _name;
        String _upperCase = signal.getName().toUpperCase();
        String _plus_1 = "CANT_WRITE_TO_" + _upperCase;
        acceptor.acceptError(_plus, (EObject)call.getSource(), call.getStructFeature(), 0, _plus_1, new String[0]);
    }

    public void validateNoReads(MethodCall.MethodCallSigInst call, ValidationMessageAcceptor acceptor) {
        Expression _initialization = call.getSigInst().getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        EObject _reference = init.getReference();
        Signal signal = (Signal)_reference;
        String _name = signal.getName();
        String _plus = "Can not read from " + _name;
        String _upperCase = signal.getName().toUpperCase();
        String _plus_1 = "CANT_WRITE_TO_" + _upperCase;
        acceptor.acceptError(_plus, (EObject)call.getSource(), call.getStructFeature(), 0, _plus_1, new String[0]);
    }

    public void validateGpioRead(MethodCall.MethodCallSigInst call, ValidationMessageAcceptor acceptor) {
        Expression _initialization = call.getSigInst().getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        EObject _reference = init.getReference();
        Signal signal = (Signal)_reference;
        boolean _contains = signal.getName().contains("Out");
        if (_contains) {
            String _name = signal.getName();
            String _plus = "Can not read from " + _name;
            String _upperCase = signal.getName().toUpperCase();
            String _plus_1 = "CANT_READ_FROM_" + _upperCase;
            acceptor.acceptError(_plus, (EObject)call.getSource(), call.getStructFeature(), 0, _plus_1, new String[0]);
        }
    }

    public void validateGpioWrite(MethodCall.MethodCallSigInst call, ValidationMessageAcceptor acceptor) {
        Expression _initialization = call.getSigInst().getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        EObject _reference = init.getReference();
        Signal signal = (Signal)_reference;
        boolean _contains = signal.getName().contains("In");
        if (_contains) {
            String _name = signal.getName();
            String _plus = "Can not write to " + _name;
            String _upperCase = signal.getName().toUpperCase();
            String _plus_1 = "CANT_WRITE_TO_" + _upperCase;
            acceptor.acceptError(_plus, (EObject)call.getSource(), call.getStructFeature(), 0, _plus_1, new String[0]);
        }
    }

    public void validateI2cReadWrite(EObject source, SignalInstance sigInst, EStructuralFeature structFeature, String which, String msg, ValidationMessageAcceptor acceptor) {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object mode = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)sigInst, (String)"mode"), (Procedures.Procedure1)_function);
        if (mode instanceof Enumerator) {
            boolean _not;
            boolean _contains = ((Enumerator)mode).getName().contains(which);
            boolean bl = _not = !_contains;
            if (_not) {
                String _replace = msg.toUpperCase().replace(" ", "_");
                String _plus = "CANT_" + _replace;
                String _plus_1 = String.valueOf(_plus) + "_SIGINST";
                acceptor.acceptError("Can not " + msg + " signal instance", source, structFeature, 0, _plus_1, new String[0]);
            }
        }
    }

    public void validateI2cWriteLength(ArgumentExpression source, Operation writeMethod, SignalInstance sigInst, ValidationMessageAcceptor acceptor) {
        int actualLength;
        Expression argumentArray;
        ElementSizeInferenceResult arraySize;
        boolean _not;
        Expression _initialization = sigInst.getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        EObject _reference = init.getReference();
        Signal signal = (Signal)_reference;
        boolean _startsWith = signal.getName().startsWith("array_register");
        boolean bl = _not = !_startsWith;
        if (_not) {
            return;
        }
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object specifiedLength = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)sigInst, (String)"length"), (Procedures.Procedure1)_function);
        if (specifiedLength instanceof Integer && (arraySize = this.sizeInferrer.infer((EObject)(argumentArray = ModelUtils.getArgumentValue((Operation)writeMethod, (ArgumentExpression)source, (String)"value")))) instanceof ValidElementSizeInferenceResult && (actualLength = ((ValidElementSizeInferenceResult)arraySize).getElementCount()) != (Integer)specifiedLength) {
            acceptor.acceptError("passed array has invalid size: " + Integer.valueOf(actualLength) + ", should be: " + specifiedLength, (EObject)argumentArray, null, 0, "PASSED_ARRAY_HAS_INVALID_SIZE", new String[0]);
        }
    }

    public void validateSdCardRead(MethodCall.MethodCallSigInst call, ValidationMessageAcceptor acceptor) {
        Expression _initialization = call.getSigInst().getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        EObject _reference = init.getReference();
        Signal signal = (Signal)_reference;
        boolean _contains = signal.getName().contains("Write");
        if (_contains) {
            String _name = signal.getName();
            String _plus = "Can not read from " + _name;
            String _upperCase = signal.getName().toUpperCase();
            String _plus_1 = "CANT_READ_FROM_" + _upperCase;
            acceptor.acceptError(_plus, (EObject)call.getSource(), call.getStructFeature(), 0, _plus_1, new String[0]);
        }
    }

    public void validateSdCardWrite(MethodCall.MethodCallSigInst call, ValidationMessageAcceptor acceptor) {
        Expression _initialization = call.getSigInst().getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        EObject _reference = init.getReference();
        Signal signal = (Signal)_reference;
        boolean _contains = signal.getName().contains("Read");
        if (_contains) {
            String _name = signal.getName();
            String _plus = "Can not write to " + _name;
            String _upperCase = signal.getName().toUpperCase();
            String _plus_1 = "CANT_WRITE_TO_" + _upperCase;
            acceptor.acceptError(_plus, (EObject)call.getSource(), call.getStructFeature(), 0, _plus_1, new String[0]);
        }
    }
}

