/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Bme280Generator
extends AbstractSystemResourceGenerator {
    public static final String CONFIG_ITEM_POWER_MODE = "power_mode";
    public static final String CONFIG_ITEM_STANDBY_TIME = "standby_time";
    public static final String CONFIG_ITEM_TEMPERATURE_OVERSAMPLING = "temperature_oversampling";
    public static final String CONFIG_ITEM_PRESSURE_OVERSAMPLING = "pressure_oversampling";
    public static final String CONFIG_ITEM_HUMIDITY_OVERSAMPLING = "humidity_oversampling";
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateSetup() {
        boolean _equals;
        CodeFragment _xblockexpression = null;
        String _xifexpression = null;
        Enumerator _enumerator = this.configuration.getEnumerator(CONFIG_ITEM_POWER_MODE);
        String _name = null;
        if (_enumerator != null) {
            _name = _enumerator.getName();
        }
        _xifexpression = (_equals = Objects.equal((Object)_name, (Object)"Forced")) ? "ENVIRONMENTAL_BME280_POWERMODE_FORCED" : "ENVIRONMENTAL_BME280_POWERMODE_NORMAL";
        final String powerMode = _xifexpression;
        Integer standbyTimeRaw = this.configuration.getInteger(CONFIG_ITEM_STANDBY_TIME);
        String _xifexpression_1 = null;
        if (standbyTimeRaw == null) {
            _xifexpression_1 = null;
        } else {
            Pair<Integer, String> _clipStandbyTime = Bme280Generator.clipStandbyTime(standbyTimeRaw);
            String _value = null;
            if (_clipStandbyTime != null) {
                _value = (String)_clipStandbyTime.getValue();
            }
            _xifexpression_1 = _value;
        }
        final String standbyTime = _xifexpression_1;
        Enumerator _enumerator_1 = this.configuration.getEnumerator(CONFIG_ITEM_TEMPERATURE_OVERSAMPLING);
        String _oversamplingConstant = null;
        if (_enumerator_1 != null) {
            _oversamplingConstant = this.getOversamplingConstant(_enumerator_1);
        }
        final String temperatureOversampling = _oversamplingConstant;
        Enumerator _enumerator_2 = this.configuration.getEnumerator(CONFIG_ITEM_PRESSURE_OVERSAMPLING);
        String _oversamplingConstant_1 = null;
        if (_enumerator_2 != null) {
            _oversamplingConstant_1 = this.getOversamplingConstant(_enumerator_2);
        }
        final String pressureOversampling = _oversamplingConstant_1;
        Enumerator _enumerator_3 = this.configuration.getEnumerator(CONFIG_ITEM_HUMIDITY_OVERSAMPLING);
        String _oversamplingConstant_2 = null;
        if (_enumerator_3 != null) {
            _oversamplingConstant_2 = this.getOversamplingConstant(_enumerator_3);
        }
        final String humidityOversampling = _oversamplingConstant_2;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = Environmental_init(xdkEnvironmental_BME280_Handle);");
                _builder.newLine();
                CharSequence _generateExceptionHandler = Bme280Generator.this._generatorUtils.generateExceptionHandler((EObject)Bme280Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"exception = Environmental_setPowerMode(xdkEnvironmental_BME280_Handle, ");
                _builder.append((Object)powerMode);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler_1 = Bme280Generator.this._generatorUtils.generateExceptionHandler((EObject)Bme280Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler_1);
                _builder.newLineIfNotEmpty();
                if (standbyTime != null) {
                    _builder.newLine();
                    _builder.append((Object)"exception = Environmental_setStandbyDuration(xdkEnvironmental_BME280_Handle, ");
                    _builder.append((Object)standbyTime);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    CharSequence _generateExceptionHandler_2 = Bme280Generator.this._generatorUtils.generateExceptionHandler((EObject)Bme280Generator.this.component, "exception");
                    _builder.append((Object)_generateExceptionHandler_2);
                    _builder.newLineIfNotEmpty();
                }
                if (temperatureOversampling != null) {
                    _builder.newLine();
                    _builder.append((Object)"exception = Environmental_setOverSamplingTemperature(xdkEnvironmental_BME280_Handle, ");
                    _builder.append((Object)temperatureOversampling);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    CharSequence _generateExceptionHandler_3 = Bme280Generator.this._generatorUtils.generateExceptionHandler((EObject)Bme280Generator.this.component, "exception");
                    _builder.append((Object)_generateExceptionHandler_3);
                    _builder.newLineIfNotEmpty();
                }
                if (pressureOversampling != null) {
                    _builder.newLine();
                    _builder.append((Object)"exception = Environmental_setOverSamplingPressure(xdkEnvironmental_BME280_Handle, ");
                    _builder.append((Object)pressureOversampling);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    CharSequence _generateExceptionHandler_4 = Bme280Generator.this._generatorUtils.generateExceptionHandler((EObject)Bme280Generator.this.component, "exception");
                    _builder.append((Object)_generateExceptionHandler_4);
                    _builder.newLineIfNotEmpty();
                }
                if (humidityOversampling != null) {
                    _builder.newLine();
                    _builder.append((Object)"exception = Environmental_setOverSamplingHumidity(xdkEnvironmental_BME280_Handle, ");
                    _builder.append((Object)humidityOversampling);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    CharSequence _generateExceptionHandler_5 = Bme280Generator.this._generatorUtils.generateExceptionHandler((EObject)Bme280Generator.this.component, "exception");
                    _builder.append((Object)_generateExceptionHandler_5);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 1000).addHeader("BCDS_Retcode.h", true, 750).addHeader("BCDS_Environmental.h", true).addHeader("XdkSensorHandle.h", true);
        return _xblockexpression;
    }

    protected String getOversamplingConstant(Enumerator value) {
        String _switchResult = null;
        String _name = null;
        if (value != null) {
            _name = value.getName();
        }
        boolean _matched = false;
        if (Objects.equal((Object)_name, (Object)"OVERSAMPLE_1X")) {
            _matched = true;
            _switchResult = "ENVIRONMENTAL_BME280_OVERSAMP_1X";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"OVERSAMPLE_2X")) {
            _matched = true;
            _switchResult = "ENVIRONMENTAL_BME280_OVERSAMP_2X";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"OVERSAMPLE_4X")) {
            _matched = true;
            _switchResult = "ENVIRONMENTAL_BME280_OVERSAMP_4X";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"OVERSAMPLE_8X")) {
            _matched = true;
            _switchResult = "ENVIRONMENTAL_BME280_OVERSAMP_8X";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"OVERSAMPLE_16X")) {
            _matched = true;
            _switchResult = "ENVIRONMENTAL_BME280_OVERSAMP_16X";
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateAccessPreparationFor(final ModalityAccessPreparation accessPreparation) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Environmental_Data_T ");
                String _dataVariable = Bme280Generator.this.getDataVariable(accessPreparation);
                _builder.append((Object)_dataVariable);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = Environmental_readData(xdkEnvironmental_BME280_Handle, &");
                String _dataVariable_1 = Bme280Generator.this.getDataVariable(accessPreparation);
                _builder.append((Object)_dataVariable_1);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler = Bme280Generator.this._generatorUtils.generateExceptionHandler((EObject)Bme280Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Environmental.h", true).addHeader("XdkSensorHandle.h", true);
    }

    public String getDataVariable(ModalityAccessPreparation preparation) {
        return StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)preparation));
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess modalityAccess) {
        final String dataVariable = this.getDataVariable(modalityAccess.getPreparation());
        String modalityName = modalityAccess.getModality().getName();
        CodeFragment _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)modalityName, (Object)"temperature")) {
            _matched = true;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".temperature");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"pressure")) {
            _matched = true;
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".pressure");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_1);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"humidity")) {
            _matched = true;
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".humidity");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_2);
        }
        return _switchResult;
    }

    public static Pair<Integer, String> clipStandbyTime(final int standbyTime) {
        List supportedValuesInMs = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{1, 10, 20, 63, 125, 250, 500, 1000}));
        Functions.Function1<Integer, Integer> _function = new Functions.Function1<Integer, Integer>(){

            public Integer apply(Integer x) {
                return Math.abs(x - standbyTime);
            }
        };
        Integer nearestStandbyTime = (Integer)IterableExtensions.minBy(supportedValuesInMs, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ENVIRONMENTAL_BME280_STANDBY_TIME_");
        _builder.append((Object)nearestStandbyTime);
        _builder.append("_MS");
        String constantName = _builder.toString();
        return Pair.of((Object)nearestStandbyTime, (Object)constantName);
    }
}

