/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.unittest;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.IPlatformMakefileGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MakefileGenerator
implements IPlatformMakefileGenerator {
    @Inject
    private CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateMakefile(Iterable<Program> program, final List<String> sourceFiles) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"export CC=gcc");
                _builder.newLine();
                _builder.append((Object)"export CCFLAGS=-Wall -std=c99");
                _builder.newLine();
                _builder.append((Object)"export BUILDDIR=./build");
                _builder.newLine();
                _builder.append((Object)"export SOURCE_INCLUDES = -I. -I./base");
                _builder.newLine();
                _builder.append((Object)"export SOURCE_DIR=.");
                _builder.newLine();
                _builder.append((Object)"export SOURCE_FILES = \\");
                _builder.newLine();
                _builder.append((Object)"\t");
                Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String x) {
                        return x.endsWith(".c");
                    }
                };
                Functions.Function1<String, String> _function_1 = new Functions.Function1<String, String>(){

                    public String apply(String x) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("$(SOURCE_DIR)/");
                        _builder.append(x);
                        return _builder.toString();
                    }
                };
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)sourceFiles, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)" \\\n");
                _builder.append((Object)_join, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)".PHONY: clean build");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"build:");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"mkdir -p $(BUILDDIR)");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"$(CC) $(CCFLAGS) $(SOURCE_INCLUDES) -o$(BUILDDIR)/unittest $(SOURCE_FILES)");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"clean:");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"rm $(BUILDDIR)/*");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }
}

