/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.unittest;

import com.google.inject.Inject;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.platform.unittest.MakefileGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.EmptyPlatformGeneratorModule;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.mita.program.generator.IPlatformMakefileGenerator;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class UnitTestPlatformGeneratorModule
extends EmptyPlatformGeneratorModule {
    public Class<? extends IPlatformExceptionGenerator> bindIPlatformExceptionGenerator() {
        return ExceptionGenerator.class;
    }

    public Class<? extends IPlatformMakefileGenerator> bindIPlatformMakefileGenerator() {
        return MakefileGenerator.class;
    }

    public static class ExceptionGenerator
    implements IPlatformExceptionGenerator {
        @Inject
        private CodeFragmentProvider code;
        public static final String EXCEPTION_TYPE = "int32_t";
        public static final String NO_EXCEPTION = "0";

        public CodeFragment generateExceptionCodeFor(CompilationContext context, Type exception) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)ExceptionGenerator.NO_EXCEPTION);
                }
            };
            return this.code.create(_client);
        }

        public CodeFragment generateRaiseException(CompilationContext context, String exceptionVariableName) {
            return CodeFragment.EMPTY;
        }

        public CodeFragment getExceptionType() {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)ExceptionGenerator.EXCEPTION_TYPE);
                }
            };
            return this.code.create(_client).addHeader("stdint.h", true);
        }

        public CodeFragment getNoExceptionStatement() {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)ExceptionGenerator.NO_EXCEPTION);
                }
            };
            return this.code.create(_client).addHeader("stdint.h", true);
        }
    }
}

