/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AdditiveOperator implements Enumerator
{
    PLUS(0, "plus", "+"),
    MINUS(1, "minus", "-");

    public static final int PLUS_VALUE = 0;
    public static final int MINUS_VALUE = 1;
    private static final AdditiveOperator[] VALUES_ARRAY;
    public static final List<AdditiveOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AdditiveOperator[]{PLUS, MINUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AdditiveOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AdditiveOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AdditiveOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AdditiveOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AdditiveOperator get(int value) {
        switch (value) {
            case 0: {
                return PLUS;
            }
            case 1: {
                return MINUS;
            }
        }
        return null;
    }

    private AdditiveOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

