/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PostFixOperator implements Enumerator
{
    INCREMENT(0, "increment", "++"),
    DECREMENT(1, "decrement", "--");

    public static final int INCREMENT_VALUE = 0;
    public static final int DECREMENT_VALUE = 1;
    private static final PostFixOperator[] VALUES_ARRAY;
    public static final List<PostFixOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PostFixOperator[]{INCREMENT, DECREMENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PostFixOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PostFixOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PostFixOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PostFixOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PostFixOperator get(int value) {
        switch (value) {
            case 0: {
                return INCREMENT;
            }
            case 1: {
                return DECREMENT;
            }
        }
        return null;
    }

    private PostFixOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

