/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.ui.labeling;

import com.google.inject.Inject;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.Event;
import org.eclipse.mita.base.types.ExceptionTypeDeclaration;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.base.types.ImportStatement;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.PackageAssociation;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Singleton;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Connectivity;
import org.eclipse.mita.platform.Sensor;
import org.eclipse.mita.platform.Signal;
import org.eclipse.mita.platform.SystemResourceAlias;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ProgramDslLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private ITypeSystemInferrer typeInferrer;

    @Inject
    public ProgramDslLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected Object _image(EObject ele) {
        return super.image((Object)ele);
    }

    protected Object _image(SystemResourceAlias ele) {
        AbstractSystemResource _delegate = ele.getDelegate();
        Object _image = null;
        if (_delegate != null) {
            _image = this.image((EObject)_delegate);
        }
        return _image;
    }

    protected Object _image(SystemResourceSetup ele) {
        AbstractSystemResource _type = ele.getType();
        Object _image = null;
        if (_type != null) {
            _image = this.image((EObject)_type);
        }
        return _image;
    }

    protected Object _image(Connectivity ele) {
        return this.loadImage("connectivity.png");
    }

    protected Object _image(Sensor ele) {
        return this.loadImage("sensor.png");
    }

    protected Object _image(VariableDeclaration ele) {
        return this.loadImage("variable.png");
    }

    protected Object _image(FunctionDefinition ele) {
        return this.loadImage("function.png");
    }

    protected Object _image(Operation ele) {
        return this.loadImage("function.png");
    }

    protected Object _image(Enumerator ele) {
        return this.loadImage("enumerator.png");
    }

    protected Object _image(EnumerationType ele) {
        return this.loadImage("enumerator.png");
    }

    protected Object _image(Event ele) {
        return this.loadImage("event.png");
    }

    protected Object _image(EventHandlerDeclaration ele) {
        return this.loadImage("event.png");
    }

    protected Object _image(ExceptionTypeDeclaration ele) {
        return this.loadImage("variable.png");
    }

    public CharSequence text(PackageAssociation it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(ImportStatement it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import ");
        String _importedNamespace = it.getImportedNamespace();
        _builder.append(_importedNamespace);
        return _builder;
    }

    public CharSequence text(SystemResourceSetup ele) {
        StringConcatenation _xifexpression = null;
        AbstractSystemResource _type = ele.getType();
        if (_type instanceof Connectivity) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("connectivity ");
            String _name = ele.getName();
            _builder.append(_name);
            _builder.append(" : ");
            String _iD = EcoreUtil.getID((EObject)ele.getType());
            _builder.append(_iD);
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("resource ");
            String _name_1 = ele.getName();
            _builder_1.append(_name_1);
            _builder_1.append(" : ");
            String _iD_1 = EcoreUtil.getID((EObject)ele.getType());
            _builder_1.append(_iD_1);
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public CharSequence text(EventHandlerDeclaration it) {
        EventSource _event_2;
        EventSource _event_1;
        StringConcatenation _builder;
        StringConcatenation _switchResult = null;
        EventSource _event = it.getEvent();
        boolean _matched = false;
        if (_event instanceof SystemEventSource) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("every ");
            _event_1 = it.getEvent();
            String _name = ((SystemEventSource)_event_1).getOrigin().getName();
            _builder.append(_name);
            _builder.append(".");
            _event_2 = it.getEvent();
            String _name_1 = ((SystemEventSource)_event_2).getSource().getName();
            _builder.append(_name_1);
            _switchResult = _builder;
        }
        if (!_matched && _event instanceof TimeIntervalEvent) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("every ");
            _event_1 = it.getEvent();
            int _value = ((TimeIntervalEvent)_event_1).getInterval().getValue();
            _builder.append((Object)_value);
            _builder.append(" ");
            _event_2 = it.getEvent();
            String _firstLower = StringExtensions.toFirstLower((String)((TimeIntervalEvent)_event_2).getUnit().getLiteral());
            _builder.append(_firstLower);
            _switchResult = _builder;
        }
        return _switchResult;
    }

    public String text(FunctionDefinition ele) {
        String _xblockexpression = null;
        ITypeSystemInferrer.InferenceResult typeIR = this.typeInferrer.infer((EObject)ele);
        Functions.Function1<Parameter, String> _function = new Functions.Function1<Parameter, String>(){

            public String apply(Parameter it) {
                String _name = it.getName();
                String _plus = String.valueOf(_name) + " : ";
                String _name_1 = it.getType().getName();
                return String.valueOf(_plus) + _name_1;
            }
        };
        List params = ListExtensions.map((List)ele.getParameters(), (Functions.Function1)_function);
        String _name = ele.getName();
        String _plus = String.valueOf(_name) + "(";
        String _replace = params.toString().replace("[", "").replace("]", "");
        String _plus_1 = String.valueOf(_plus) + _replace;
        String _plus_2 = String.valueOf(_plus_1) + ")";
        String _plus_3 = String.valueOf(_plus_2) + " : ";
        String _text = this.getText(typeIR);
        _xblockexpression = String.valueOf(_plus_3) + _text;
        return _xblockexpression;
    }

    public CharSequence text(SignalInstance ele) {
        StringConcatenation _xblockexpression = null;
        Signal vci = ele.getInstanceOf();
        ITypeSystemInferrer.InferenceResult _infer = this.typeInferrer.infer((EObject)ele);
        Type _type = null;
        if (_infer != null) {
            _type = _infer.getType();
        }
        Type type = _type;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isWriteable = ele.isWriteable();
        if (_isWriteable) {
            _builder.append("read/write");
        } else {
            _builder.append("read-only");
        }
        _builder.append(" ");
        String _name = vci.getName();
        _builder.append(_name);
        _builder.append(" ");
        String _name_1 = ele.getName();
        _builder.append(_name_1);
        _builder.append(" : ");
        _builder.append((Object)type);
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence text(VariableDeclaration ele) {
        StringConcatenation _xblockexpression = null;
        ITypeSystemInferrer.InferenceResult typeIR = this.typeInferrer.infer((EObject)ele);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isWriteable = ele.isWriteable();
        if (_isWriteable) {
            _builder.append("variable");
        } else {
            _builder.append("constant");
        }
        _builder.append(" ");
        String _name = ele.getName();
        _builder.append(_name);
        _builder.append(" : ");
        String _text = this.getText(typeIR);
        _builder.append(_text);
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence text(ITypeSystemInferrer.InferenceResult ir) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = ir.getType().getName();
        _builder.append(_name);
        boolean _isEmpty = ir.getBindings().isEmpty();
        boolean bl = _tripleEquals = Boolean.valueOf(_isEmpty) == Boolean.valueOf(false);
        if (_tripleEquals) {
            _builder.append("<");
            List _bindings = ir.getBindings();
            boolean _hasElements = false;
            for (ITypeSystemInferrer.InferenceResult t : _bindings) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _text = this.getText(t);
                _builder.append(_text);
            }
            _builder.append(">");
        }
        return _builder;
    }

    public CharSequence text(ExceptionTypeDeclaration it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("exception ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(StructureType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(Parameter it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = it.getName();
        _builder.append(_name);
        TypeSpecifier _typeSpecifier = it.getTypeSpecifier();
        boolean bl = _tripleNotEquals = _typeSpecifier != null;
        if (_tripleNotEquals) {
            _builder.append(" : ");
            TypeSpecifier _typeSpecifier_1 = it.getTypeSpecifier();
            _builder.append((Object)_typeSpecifier_1);
        }
        return _builder;
    }

    public CharSequence text(EnumerationType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("enum ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(SumType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("alt ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(Singleton it) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(NamedProductType it) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(AnonymousProductType it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = it.getName();
        _builder.append(_name);
        EList _typeSpecifiers = it.getTypeSpecifiers();
        boolean bl = _tripleNotEquals = _typeSpecifiers != null;
        if (_tripleNotEquals) {
            _builder.append(" : ");
            EList _typeSpecifiers_1 = it.getTypeSpecifiers();
            boolean _hasElements = false;
            for (TypeSpecifier typeSepc : _typeSpecifiers_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                _builder.append((Object)typeSepc);
            }
        }
        return _builder;
    }

    public CharSequence text(GeneratedType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("generated type ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(Operation it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("constructor ");
        String _name = it.getName();
        _builder.append(_name);
        EList _parameters = it.getParameters();
        boolean bl = _tripleNotEquals = _parameters != null;
        if (_tripleNotEquals) {
            _builder.append("(");
            EList _parameters_1 = it.getParameters();
            boolean _hasElements = false;
            for (Parameter param : _parameters_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name_1 = param.getName();
                _builder.append(_name_1);
                _builder.append(" : ");
                TypeSpecifier _typeSpecifier = param.getTypeSpecifier();
                _builder.append((Object)_typeSpecifier);
            }
        }
        _builder.append(")");
        return _builder;
    }

    protected String convertToString(Object text) {
        if (text instanceof CharSequence) {
            return ((CharSequence)text).toString();
        }
        return super.convertToString(text);
    }

    private ImageDescriptor loadImage(String imageName) {
        try {
            String bundleIconUrl = "platform:/plugin/org.eclipse.mita.program.ui/icons/";
            URL _uRL = new URL("platform:/plugin/org.eclipse.mita.program.ui/icons/" + imageName);
            return ImageDescriptor.createFromURL((URL)_uRL);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected StyledString convertToStyledString(Object text) {
        if (text instanceof CharSequence) {
            String _string = ((CharSequence)text).toString();
            return new StyledString(_string);
        }
        return super.convertToStyledString(text);
    }

    public Object image(EObject ele) {
        if (ele instanceof FunctionDefinition) {
            return this._image((FunctionDefinition)ele);
        }
        if (ele instanceof EnumerationType) {
            return this._image((EnumerationType)ele);
        }
        if (ele instanceof Connectivity) {
            return this._image((Connectivity)ele);
        }
        if (ele instanceof Sensor) {
            return this._image((Sensor)ele);
        }
        if (ele instanceof SystemResourceAlias) {
            return this._image((SystemResourceAlias)ele);
        }
        if (ele instanceof VariableDeclaration) {
            return this._image((VariableDeclaration)ele);
        }
        if (ele instanceof Enumerator) {
            return this._image((Enumerator)ele);
        }
        if (ele instanceof Event) {
            return this._image((Event)ele);
        }
        if (ele instanceof ExceptionTypeDeclaration) {
            return this._image((ExceptionTypeDeclaration)ele);
        }
        if (ele instanceof Operation) {
            return this._image((Operation)ele);
        }
        if (ele instanceof EventHandlerDeclaration) {
            return this._image((EventHandlerDeclaration)ele);
        }
        if (ele instanceof SystemResourceSetup) {
            return this._image((SystemResourceSetup)ele);
        }
        if (ele != null) {
            return this._image(ele);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ele).toString());
    }
}

