/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.IComponentConfiguration;
import org.eclipse.mita.program.generator.IGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public abstract class AbstractSystemResourceGenerator
implements IGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    protected CompilationContext context;
    protected AbstractSystemResource component;
    protected SystemResourceSetup setup;
    protected IComponentConfiguration configuration;
    protected Iterable<EventHandlerDeclaration> eventHandler;

    public void prepare(CompilationContext context, AbstractSystemResource component, SystemResourceSetup setup, IComponentConfiguration config, Iterable<EventHandlerDeclaration> eventHandler) {
        this.context = context;
        this.component = component;
        this.setup = setup;
        this.configuration = config;
        this.eventHandler = eventHandler;
    }

    public abstract CodeFragment generateSetup();

    public abstract CodeFragment generateEnable();

    public CodeFragment generateAdditionalHeaderContent() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateAdditionalImplementation() {
        return CodeFragment.EMPTY;
    }

    public Iterable<String> generateAdditionalFiles(IFileSystemAccess2 fsa) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    public CodeFragment generateAccessPreparationFor(ModalityAccessPreparation accessPreparation) {
        throw new UnsupportedOperationException("This generator does not support modalities. This is a problem of the platform implementation.");
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess modality) {
        throw new UnsupportedOperationException("This generator does not support modalities. This is a problem of the platform implementation.");
    }

    public CodeFragment generateSignalInstanceSetter(SignalInstance signalInstance, String valueVariableName) {
        throw new UnsupportedOperationException("This generator does not support signals. This is a problem of the platform implementation.");
    }

    public CodeFragment generateSignalInstanceGetter(SignalInstance signalInstance, String resultName) {
        throw new UnsupportedOperationException("This generator does not support signals. This is a problem of the platform implementation.");
    }
}

