/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.Event;
import org.eclipse.mita.base.types.ExceptionTypeDeclaration;
import org.eclipse.mita.base.types.NamedElement;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Singleton;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Bus;
import org.eclipse.mita.platform.Connectivity;
import org.eclipse.mita.platform.InputOutput;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.platform.Sensor;
import org.eclipse.mita.platform.SystemResourceAlias;
import org.eclipse.mita.platform.SystemResourceEvent;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.NativeFunctionDefinition;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.IPlatformLoggingGenerator;
import org.eclipse.mita.program.generator.internal.ProgramCopier;
import org.eclipse.mita.program.generator.internal.UserCodeFileGenerator;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.generator.trace.node.TextNode;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class GeneratorUtils {
    @Inject
    @Extension
    protected ProgramCopier _programCopier;
    @Inject
    protected IScopeProvider scopeProvider;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject(optional=true)
    protected IPlatformLoggingGenerator loggingGenerator;

    public Stream<String> getFileContents(Resource resourceInProject, String fileLoc) {
        try {
            Path path = Paths.get(fileLoc, new String[0]);
            BufferedReader _xifexpression = null;
            boolean _isAbsolute = path.isAbsolute();
            if (_isAbsolute) {
                BufferedReader _xifexpression_1 = null;
                boolean _exists = Files.exists(path, new LinkOption[0]);
                boolean _not = !_exists;
                _xifexpression_1 = _not ? null : Files.newBufferedReader(path);
                _xifexpression = _xifexpression_1;
            } else {
                BufferedReader _xblockexpression = null;
                IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
                BufferedReader _xifexpression_2 = null;
                if (workspaceRoot == null) {
                    _xifexpression_2 = Files.newBufferedReader(path);
                } else {
                    boolean _not_1;
                    BufferedReader _xblockexpression_1 = null;
                    IFile file = workspaceRoot.getProject(resourceInProject.getURI().segment(1)).getFile(fileLoc);
                    BufferedReader _xifexpression_3 = null;
                    boolean _exists_1 = file.exists();
                    boolean bl = _not_1 = !_exists_1;
                    if (_not_1) {
                        _xifexpression_3 = null;
                    } else {
                        InputStream _contents = file.getContents();
                        String _charset = file.getCharset();
                        InputStreamReader _inputStreamReader = new InputStreamReader(_contents, _charset);
                        _xifexpression_3 = new BufferedReader(_inputStreamReader);
                    }
                    _xifexpression_2 = _xblockexpression_1 = _xifexpression_3;
                }
                _xifexpression = _xblockexpression = _xifexpression_2;
            }
            Stream<String> _lines = null;
            if (_xifexpression != null) {
                _lines = _xifexpression.lines();
            }
            return _lines;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getGlobalInitName(Program program) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("initGlobalVariables_");
        String _replace = program.eResource().getURI().lastSegment().replace(".mita", "");
        _builder.append(_replace);
        return _builder.toString();
    }

    public CodeFragment generateLoggingExceptionHandler(final String resourceName, final String action) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if(exception == NO_EXCEPTION)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateLogStatement = GeneratorUtils.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, String.valueOf(action) + " " + resourceName + " succeeded", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateLogStatement_1 = GeneratorUtils.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "failed to " + action + " " + resourceName, new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public int getOccurrence(final EObject obj) {
        Object _elvis = null;
        Object _elvis_1 = null;
        FunctionDefinition _containerOfType = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)obj, FunctionDefinition.class);
        if (_containerOfType != null) {
            _elvis_1 = _containerOfType;
        } else {
            EventHandlerDeclaration _containerOfType_1 = (EventHandlerDeclaration)EcoreUtil2.getContainerOfType((EObject)obj, EventHandlerDeclaration.class);
            _elvis_1 = _containerOfType_1;
        }
        if (_elvis_1 != null) {
            _elvis = _elvis_1;
        } else {
            Program _containerOfType_2 = (Program)EcoreUtil2.getContainerOfType((EObject)obj, Program.class);
            _elvis = _containerOfType_2;
        }
        FunctionDefinition funDef = _elvis;
        Integer _elvis_2 = null;
        TreeIterator _eAllContents = null;
        if (funDef != null) {
            _eAllContents = funDef.eAllContents();
        }
        UnmodifiableIterator _filter = null;
        if (_eAllContents != null) {
            _filter = Iterators.filter((Iterator)_eAllContents, obj.getClass());
        }
        Iterator _indexed = null;
        if (_filter != null) {
            _indexed = IteratorExtensions.indexed((Iterator)_filter);
        }
        Pair _findFirst = null;
        if (_indexed != null) {
            Functions.Function1<Pair<Integer, EObject>, Boolean> _function = new Functions.Function1<Pair<Integer, EObject>, Boolean>(){

                public Boolean apply(Pair<Integer, EObject> it) {
                    return ((EObject)it.getValue()).equals(obj);
                }
            };
            _findFirst = (Pair)IteratorExtensions.findFirst((Iterator)_indexed, (Functions.Function1)_function);
        }
        Integer _key = null;
        if (_findFirst != null) {
            _key = (Integer)_findFirst.getKey();
        }
        _elvis_2 = _key != null ? _key : Integer.valueOf(-1);
        Integer result = _elvis_2;
        return result + 1;
    }

    public String getUniqueIdentifier(EObject obj) {
        String _replace = this.getUniqueIdentifierInternal(obj).replace(".", "_");
        String _plus = String.valueOf(_replace) + "_";
        String _string = Integer.valueOf(this.getOccurrence(obj)).toString();
        return String.valueOf(_plus) + _string;
    }

    private String _getUniqueIdentifierInternal(Program p) {
        return this.getBaseName(p);
    }

    private String _getUniqueIdentifierInternal(EventHandlerDeclaration decl) {
        String _uniqueIdentifierInternal = this.getUniqueIdentifierInternal(decl.eContainer());
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getHandlerName(decl));
        return String.valueOf(_uniqueIdentifierInternal) + _firstUpper;
    }

    private String _getUniqueIdentifierInternal(FunctionDefinition funDef) {
        String _uniqueIdentifierInternal = this.getUniqueIdentifierInternal(funDef.eContainer());
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getBaseName(funDef));
        return String.valueOf(_uniqueIdentifierInternal) + _firstUpper;
    }

    private String _getUniqueIdentifierInternal(VariableDeclaration decl) {
        String _uniqueIdentifierInternal = this.getUniqueIdentifierInternal(decl.eContainer());
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getBaseName(decl));
        return String.valueOf(_uniqueIdentifierInternal) + _firstUpper;
    }

    private String _getUniqueIdentifierInternal(ElementReferenceExpression expr) {
        return this.getUniqueIdentifierInternal(expr.getReference());
    }

    private String _getUniqueIdentifierInternal(FeatureCall feature) {
        EObject _feature = feature.getFeature();
        if (_feature instanceof SignalInstance) {
            return StringExtensions.toFirstLower((String)this.getBaseName(feature.getFeature()));
        }
        String _uniqueIdentifierInternal = this.getUniqueIdentifierInternal((EObject)feature.getOwner());
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getBaseName(feature.getFeature()));
        return String.valueOf(_uniqueIdentifierInternal) + _firstUpper;
    }

    private String _getUniqueIdentifierInternal(ProgramBlock pb) {
        String _uniqueIdentifierInternal = this.getUniqueIdentifierInternal(pb.eContainer());
        String _string = Integer.valueOf(IteratorExtensions.toList((Iterator)pb.eContainer().eAllContents()).indexOf(pb)).toString();
        return String.valueOf(_uniqueIdentifierInternal) + _string;
    }

    private String _getUniqueIdentifierInternal(ReturnStatement rt) {
        String _uniqueIdentifierInternal = this.getUniqueIdentifierInternal(rt.eContainer());
        return String.valueOf(_uniqueIdentifierInternal) + "_result";
    }

    private String _getUniqueIdentifierInternal(EObject obj) {
        String _name;
        String _elvis = null;
        String _baseName = this.getBaseName(obj);
        _elvis = _baseName != null ? _baseName : (_name = obj.eClass().getName());
        return _elvis;
    }

    protected String _getHandlerName(EventHandlerDeclaration event) {
        Program program = (Program)EcoreUtil2.getContainerOfType((EObject)event, Program.class);
        if (program != null) {
            int occurence = 1;
            boolean found = false;
            EList<EventHandlerDeclaration> _eventHandlers = program.getEventHandlers();
            for (EventHandlerDeclaration e : _eventHandlers) {
                boolean _equals = e.equals(event);
                if (_equals) {
                    found = true;
                }
                if (found || !this.getBaseName(e).equals(this.getBaseName(event))) continue;
                ++occurence;
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("HandleEvery");
            String _baseName = this.getBaseName(event);
            _builder.append(_baseName);
            _builder.append((Object)occurence);
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("HandleEvery");
        String _baseName_1 = this.getBaseName(event);
        _builder_1.append(_baseName_1);
        return _builder_1.toString();
    }

    protected String _getHandlerName(EObject event) {
        EventHandlerDeclaration e = (EventHandlerDeclaration)EcoreUtil2.getContainerOfType((EObject)event, EventHandlerDeclaration.class);
        if (e != null) {
            return this.getHandlerName(e);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("HandleEvery");
        String _baseName = this.getBaseName(event);
        _builder.append(_baseName);
        return _builder.toString();
    }

    public String getSetupName(EObject sensor) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(sensor);
        _builder.append(_baseName);
        _builder.append("_Setup");
        return _builder.toString();
    }

    protected String _getEnableName(AbstractSystemResource resource) {
        StringConcatenation _builder = new StringConcatenation();
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getBaseName(resource));
        _builder.append(_firstUpper);
        _builder.append("_Enable");
        return _builder.toString();
    }

    protected String _getEnableName(SystemResourceSetup resource) {
        StringConcatenation _builder = new StringConcatenation();
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getBaseName(resource));
        _builder.append(_firstUpper);
        _builder.append("_Enable");
        return _builder.toString();
    }

    protected String _getEnableName(EventHandlerDeclaration handler) {
        return this.getEnableName(handler.getEvent());
    }

    protected String _getEnableName(TimeIntervalEvent event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Every");
        String _handlerName = this.getHandlerName(event);
        _builder.append(_handlerName);
        _builder.append("_Enable");
        return _builder.toString();
    }

    protected String _getEnableName(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Every");
        String _baseName = this.getBaseName(event);
        _builder.append(_baseName);
        _builder.append("_Enable");
        return _builder.toString();
    }

    public String getReadAccessName(SignalInstance sira) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(sira);
        _builder.append(_baseName);
        _builder.append("_Read");
        return _builder.toString();
    }

    public String getWriteAccessName(SignalInstance siwa) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(siwa);
        _builder.append(_baseName);
        _builder.append("_Write");
        return _builder.toString();
    }

    public Pair<AbstractSystemResource, SystemResourceSetup> getComponentAndSetup(EObject componentOrSetup, CompilationContext context) {
        AbstractSystemResource _xifexpression = null;
        if (componentOrSetup instanceof AbstractSystemResource) {
            _xifexpression = (AbstractSystemResource)componentOrSetup;
        } else {
            AbstractSystemResource _xifexpression_1 = null;
            if (componentOrSetup instanceof SystemResourceSetup) {
                _xifexpression_1 = ((SystemResourceSetup)componentOrSetup).getType();
            }
            _xifexpression = _xifexpression_1;
        }
        AbstractSystemResource component = _xifexpression;
        SystemResourceSetup _xifexpression_2 = null;
        if (componentOrSetup instanceof AbstractSystemResource) {
            _xifexpression_2 = context.getSetupFor(component);
        } else {
            SystemResourceSetup _xifexpression_3 = null;
            if (componentOrSetup instanceof SystemResourceSetup) {
                _xifexpression_3 = (SystemResourceSetup)componentOrSetup;
            }
            _xifexpression_2 = _xifexpression_3;
        }
        SystemResourceSetup setup = _xifexpression_2;
        return Pair.of((Object)component, (Object)setup);
    }

    protected String _getFileBasename(AbstractSystemResource resource) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(resource);
        String _firstUpper = null;
        if (_baseName != null) {
            _firstUpper = StringExtensions.toFirstUpper((String)_baseName);
        }
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    protected String _getFileBasename(SystemResourceSetup setup) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(setup);
        _builder.append(_baseName);
        return _builder.toString();
    }

    protected String _getResourceTypeName(Bus sensor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Bus");
        return _builder.toString();
    }

    protected String _getResourceTypeName(Connectivity sensor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Connectivity");
        return _builder.toString();
    }

    protected String _getResourceTypeName(InputOutput sensor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("InputOutput");
        return _builder.toString();
    }

    protected String _getResourceTypeName(Platform sensor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Platform");
        return _builder.toString();
    }

    protected String _getResourceTypeName(Sensor sensor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Sensor");
        return _builder.toString();
    }

    protected String _getResourceTypeName(SystemResourceAlias alias) {
        return this.getResourceTypeName(alias.getDelegate());
    }

    protected String _getBaseName(Program p) {
        String _elvis = null;
        String _name = p.getName();
        _elvis = _name != null ? _name : "";
        return _elvis;
    }

    protected String _getBaseName(ElementReferenceExpression eref) {
        EObject _reference = eref.getReference();
        String _baseName = null;
        if (_reference != null) {
            _baseName = this.getBaseName(_reference);
        }
        return _baseName;
    }

    protected String _getBaseName(Operation element) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = element.getName();
        _builder.append(_name);
        EList _parameters = element.getParameters();
        boolean _hasElements = false;
        for (Parameter p : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("_");
            } else {
                _builder.appendImmediate((Object)"_", "");
            }
            String _name_1 = p.getType().getName();
            _builder.append(_name_1);
        }
        return _builder.toString();
    }

    protected String _getBaseName(AbstractSystemResource resource) {
        StringConcatenation _builder = new StringConcatenation();
        String _resourceTypeName = this.getResourceTypeName(resource);
        _builder.append(_resourceTypeName);
        String _firstUpper = StringExtensions.toFirstUpper((String)resource.getName());
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    protected String _getBaseName(SystemResourceSetup setup) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(setup.getType());
        _builder.append(_baseName);
        String _name = setup.getName();
        String _firstUpper = null;
        if (_name != null) {
            _firstUpper = StringExtensions.toFirstUpper((String)_name);
        }
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    protected String _getBaseName(NamedElement element) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = element.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    protected String _getBaseName(ExceptionTypeDeclaration event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("EXCEPTION_");
        String _upperCase = event.getName().toUpperCase();
        _builder.append(_upperCase);
        return _builder.toString();
    }

    protected String _getBaseName(EventHandlerDeclaration event) {
        return this.getBaseName(event.getEvent());
    }

    protected String _getBaseName(SystemEventSource event) {
        AbstractSystemResource origin = event.getOrigin();
        String _xifexpression = null;
        if (origin instanceof SystemResourceAlias) {
            String _xblockexpression = null;
            String instanceName = ((SystemResourceAlias)origin).getName();
            StringConcatenation _builder = new StringConcatenation();
            String _firstUpper = StringExtensions.toFirstUpper((String)instanceName);
            _builder.append(_firstUpper);
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)event.getSource().getName());
            _builder.append(_firstUpper_1);
            _xifexpression = _xblockexpression = _builder.toString();
        } else {
            _xifexpression = this.getBaseName(event.getSource());
        }
        return _xifexpression;
    }

    protected String _getBaseName(SystemResourceEvent event) {
        StringConcatenation _builder = new StringConcatenation();
        EObject _eContainer = event.eContainer();
        String _firstUpper = StringExtensions.toFirstUpper((String)((AbstractSystemResource)_eContainer).getName());
        _builder.append(_firstUpper);
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)event.getName());
        _builder.append(_firstUpper_1);
        return _builder.toString();
    }

    protected String _getBaseName(TimeIntervalEvent event) {
        StringConcatenation _builder = new StringConcatenation();
        int _value = event.getInterval().getValue();
        _builder.append((Object)_value);
        String _firstUpper = StringExtensions.toFirstUpper((String)event.getUnit().getLiteral());
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    protected String _getBaseName(Event event) {
        String parentName = StringExtensions.toFirstUpper((String)EcoreUtil2.getID((EObject)event.eContainer()));
        String eventName = StringExtensions.toFirstUpper((String)event.getName());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(parentName);
        _builder.append(eventName);
        return _builder.toString();
    }

    protected String _getBaseName(Modality modality) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(modality.eContainer());
        _builder.append(_baseName);
        _builder.append("_");
        String _firstUpper = StringExtensions.toFirstUpper((String)modality.getName());
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    protected String _getBaseName(SignalInstance vci) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(vci.eContainer());
        _builder.append(_baseName);
        _builder.append("_");
        String _firstUpper = StringExtensions.toFirstUpper((String)vci.getName());
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    protected String _getBaseName(NativeFunctionDefinition fd) {
        return fd.getName();
    }

    protected String _getBaseName(Object ob) {
        return null;
    }

    protected CodeFragment _getEnumName(final SumType sumType) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = sumType.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"_enum");
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)sumType));
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        return _create.addHeader(_plus, false);
    }

    protected CodeFragment _getEnumName(final SumAlternative singleton) {
        final SumType parent = (SumType)EcoreUtil2.getContainerOfType((EObject)singleton, SumType.class);
        if (parent == null) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"ERROR: Model broken");
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = parent.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"_");
                String _name_1 = singleton.getName();
                _builder.append((Object)_name_1);
                _builder.append((Object)"_e");
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client_1);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)singleton));
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        return _create.addHeader(_plus, false);
    }

    protected CodeFragment _getStructName(final SumType sumType) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = sumType.getName();
                _builder.append((Object)_name);
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)sumType));
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        return _create.addHeader(_plus, false);
    }

    protected CodeFragment _getStructName(final SumAlternative sumAlternative) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = sumAlternative.getName();
                _builder.append((Object)_name);
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)sumAlternative));
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        return _create.addHeader(_plus, false);
    }

    protected CodeFragment _getStructName(final StructureType structureType) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _baseName = GeneratorUtils.this.getBaseName(structureType);
                _builder.append((Object)_baseName);
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)structureType));
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        return _create.addHeader(_plus, false);
    }

    protected CodeFragment _getStructType(Singleton singleton) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"void");
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)singleton));
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        return _create.addHeader(_plus, false);
    }

    protected CodeFragment _getStructType(final AnonymousProductType productType) {
        boolean _greaterThan;
        int _length = ((Object[])Conversions.unwrapArray((Object)productType.getTypeSpecifiers(), Object.class)).length;
        boolean bl = _greaterThan = _length > 1;
        if (_greaterThan) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _baseName = GeneratorUtils.this.getBaseName(productType);
                    _builder.append((Object)_baseName);
                    _builder.append((Object)"_t");
                }
            };
            CodeFragment _create = this.codeFragmentProvider.create(_client);
            String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)productType));
            String _plus = String.valueOf(_resourceTypesName) + ".h";
            return _create.addHeader(_plus, false);
        }
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"ERROR: ONLY ONE MEMBER, SO USE THAT ONE'S SPECIFIER");
            }
        };
        return this.codeFragmentProvider.create(_client_1);
    }

    protected CodeFragment _getStructType(final NamedProductType productType) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _baseName = GeneratorUtils.this.getBaseName(productType);
                _builder.append((Object)_baseName);
                _builder.append((Object)"_t");
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)productType));
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        return _create.addHeader(_plus, false);
    }

    protected CodeFragment _getStructType(final SumType sumType) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = sumType.getName();
                _builder.append((Object)_name);
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(ModelUtils.getPackageAssociation((EObject)sumType));
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        return _create.addHeader(_plus, false);
    }

    protected String _getBaseName(Sensor sensor) {
        return StringExtensions.toFirstUpper((String)sensor.getName());
    }

    protected String _getBaseName(ModalityAccess modalityAccess) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(modalityAccess.getPreparation());
        _builder.append(_baseName);
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getBaseName(modalityAccess.getModality()));
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    protected String _getBaseName(ModalityAccessPreparation modality) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseName = this.getBaseName(modality.getSystemResource());
        _builder.append(_baseName);
        _builder.append("ModalityPreparation");
        return _builder.toString();
    }

    public CharSequence generateHeaderComment(CompilationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Generated by Eclipse Mita ");
        _builder.append(context.mitaVersion, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @date ");
        SimpleDateFormat _simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date _date = new Date();
        String _format = _simpleDateFormat.format(_date);
        _builder.append(_format, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateExceptionHandler(EObject context, String variableName) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)variableName, (Object)"exception");
        if (_notEquals) {
            _builder.append("exception = ");
            _builder.append(variableName);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("if(exception != NO_EXCEPTION) ");
        boolean _isInTryCatchFinally = ModelUtils.isInTryCatchFinally(context);
        if (_isInTryCatchFinally) {
            _builder.append("break");
        } else {
            _builder.append("return ");
            _builder.append(variableName);
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public IGeneratorNode trim(IGeneratorNode stmt, boolean lastOccurance, Function<CharSequence, CharSequence> trimmer) {
        if (stmt instanceof TextNode) {
            ((TextNode)stmt).setText(trimmer.apply(((TextNode)stmt).getText()));
        } else if (stmt instanceof CompositeGeneratorNode) {
            Functions.Function1<IGeneratorNode, Boolean> _function;
            Functions.Function1<IGeneratorNode, Boolean> trimmableNodePrefix = _function = new Functions.Function1<IGeneratorNode, Boolean>(){

                public Boolean apply(IGeneratorNode node) {
                    boolean isNewLineNode = node instanceof NewLineNode;
                    boolean _xifexpression = false;
                    if (node instanceof TextNode) {
                        int _length = ((TextNode)node).getText().length();
                        _xifexpression = _length == 0;
                    } else {
                        boolean _xifexpression_1 = false;
                        _xifexpression_1 = node instanceof CodeFragment ? Objects.equal((Object)node, (Object)((Object)CodeFragment.EMPTY)) : false;
                        _xifexpression = _xifexpression_1;
                    }
                    boolean isEmptyTextNode = _xifexpression;
                    return !isNewLineNode && !isEmptyTextNode;
                }
            };
            IGeneratorNode _xifexpression = null;
            if (!lastOccurance) {
                Functions.Function1<IGeneratorNode, Boolean> _function_1 = new Functions.Function1<IGeneratorNode, Boolean>((Functions.Function1)trimmableNodePrefix){
                    private final /* synthetic */ Functions.Function1 val$trimmableNodePrefix;
                    {
                        this.val$trimmableNodePrefix = function1;
                    }

                    public Boolean apply(IGeneratorNode it) {
                        return (Boolean)this.val$trimmableNodePrefix.apply((Object)it);
                    }
                };
                _xifexpression = (IGeneratorNode)IterableExtensions.findFirst((Iterable)((CompositeGeneratorNode)stmt).getChildren(), (Functions.Function1)_function_1);
            } else {
                Functions.Function1<IGeneratorNode, Boolean> _function_2 = new Functions.Function1<IGeneratorNode, Boolean>((Functions.Function1)trimmableNodePrefix){
                    private final /* synthetic */ Functions.Function1 val$trimmableNodePrefix;
                    {
                        this.val$trimmableNodePrefix = function1;
                    }

                    public Boolean apply(IGeneratorNode it) {
                        return (Boolean)this.val$trimmableNodePrefix.apply((Object)it);
                    }
                };
                _xifexpression = (IGeneratorNode)IterableExtensions.findLast((Iterable)((CompositeGeneratorNode)stmt).getChildren(), (Functions.Function1)_function_2);
            }
            IGeneratorNode child = _xifexpression;
            if (child != null) {
                this.trim(child, lastOccurance, trimmer);
            }
        }
        return stmt;
    }

    public IGeneratorNode noNewline(IGeneratorNode stmt) {
        if (stmt instanceof CompositeGeneratorNode) {
            Functions.Function1<IGeneratorNode, Boolean> _function = new Functions.Function1<IGeneratorNode, Boolean>(){

                public Boolean apply(IGeneratorNode it) {
                    return it instanceof NewLineNode || it instanceof TextNode && Objects.equal((Object)((TextNode)it).getText(), (Object)"");
                }
            };
            Functions.Function1<IGeneratorNode, Boolean> _function_1 = new Functions.Function1<IGeneratorNode, Boolean>(){

                public Boolean apply(IGeneratorNode it) {
                    return it instanceof NewLineNode || it instanceof TextNode && Objects.equal((Object)((TextNode)it).getText(), (Object)"");
                }
            };
            Functions.Function1<IGeneratorNode, IGeneratorNode> _function_2 = new Functions.Function1<IGeneratorNode, IGeneratorNode>(){

                public IGeneratorNode apply(IGeneratorNode it) {
                    return GeneratorUtils.this.noNewline(it);
                }
            };
            List newChildren = ListExtensions.map((List)ListExtensions.reverse((List)IterableExtensions.toList((Iterable)IterableExtensions.dropWhile((Iterable)ListExtensions.reverse((List)IterableExtensions.toList((Iterable)IterableExtensions.dropWhile((Iterable)IterableExtensions.toList((Iterable)((CompositeGeneratorNode)stmt).getChildren()), (Functions.Function1)_function))), (Functions.Function1)_function_1))), (Functions.Function1)_function_2);
            ((CompositeGeneratorNode)stmt).getChildren().clear();
            ((CompositeGeneratorNode)stmt).getChildren().addAll(newChildren);
        }
        return stmt;
    }

    public IGeneratorNode noTerminator(IGeneratorNode stmt) {
        Function<CharSequence, CharSequence> _function = new Function<CharSequence, CharSequence>(){

            @Override
            public CharSequence apply(CharSequence x) {
                return GeneratorUtils.this.trimTerminator(x);
            }
        };
        return this.noNewline(this.trim(stmt, true, _function));
    }

    public CharSequence trimTerminator(CharSequence stmt) {
        if (stmt == null) {
            return null;
        }
        String result = stmt.toString().trim();
        boolean _endsWith = result.endsWith(";");
        if (_endsWith) {
            int _length = result.length();
            int _minus = _length - 1;
            result = result.substring(0, _minus);
        }
        return result;
    }

    protected String trimBraces(CharSequence code) {
        String result = code.toString().trim();
        boolean _startsWith = result.startsWith("{");
        if (_startsWith) {
            result = result.substring(1);
        }
        result = result.replaceAll("\\}$", "");
        return result;
    }

    public IGeneratorNode noBraces(IGeneratorNode stmt) {
        IGeneratorNode _xblockexpression = null;
        Function<CharSequence, CharSequence> _function = new Function<CharSequence, CharSequence>(){

            @Override
            public CharSequence apply(CharSequence x) {
                return GeneratorUtils.this.trimBraces(x);
            }
        };
        this.trim(stmt, false, _function);
        Function<CharSequence, CharSequence> _function_1 = new Function<CharSequence, CharSequence>(){

            @Override
            public CharSequence apply(CharSequence x) {
                return GeneratorUtils.this.trimBraces(x);
            }
        };
        _xblockexpression = this.trim(stmt, true, _function_1);
        return _xblockexpression;
    }

    public Iterable<EventHandlerDeclaration> getAllTimeEvents(CompilationContext context) {
        Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration x) {
                EventSource _event = x.getEvent();
                return _event instanceof TimeIntervalEvent;
            }
        };
        return IterableExtensions.filter(context.getAllEventHandlers(), (Functions.Function1)_function);
    }

    public boolean containsCodeRelevantContent(Program it) {
        return !it.getEventHandlers().isEmpty() || !it.getFunctionDefinitions().isEmpty() || !it.getTypes().isEmpty() || !it.getGlobalVariables().isEmpty();
    }

    private String getUniqueIdentifierInternal(EObject funDef) {
        if (funDef instanceof FunctionDefinition) {
            return this._getUniqueIdentifierInternal((FunctionDefinition)funDef);
        }
        if (funDef instanceof VariableDeclaration) {
            return this._getUniqueIdentifierInternal((VariableDeclaration)funDef);
        }
        if (funDef instanceof ElementReferenceExpression) {
            return this._getUniqueIdentifierInternal((ElementReferenceExpression)funDef);
        }
        if (funDef instanceof FeatureCall) {
            return this._getUniqueIdentifierInternal((FeatureCall)funDef);
        }
        if (funDef instanceof Program) {
            return this._getUniqueIdentifierInternal((Program)funDef);
        }
        if (funDef instanceof ReturnStatement) {
            return this._getUniqueIdentifierInternal((ReturnStatement)funDef);
        }
        if (funDef instanceof EventHandlerDeclaration) {
            return this._getUniqueIdentifierInternal((EventHandlerDeclaration)funDef);
        }
        if (funDef instanceof ProgramBlock) {
            return this._getUniqueIdentifierInternal((ProgramBlock)funDef);
        }
        if (funDef != null) {
            return this._getUniqueIdentifierInternal(funDef);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(funDef).toString());
    }

    public String getHandlerName(EObject event) {
        if (event instanceof EventHandlerDeclaration) {
            return this._getHandlerName((EventHandlerDeclaration)event);
        }
        if (event != null) {
            return this._getHandlerName(event);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(event).toString());
    }

    public String getEnableName(EObject event) {
        if (event instanceof Event) {
            return this._getEnableName((Event)event);
        }
        if (event instanceof AbstractSystemResource) {
            return this._getEnableName((AbstractSystemResource)event);
        }
        if (event instanceof TimeIntervalEvent) {
            return this._getEnableName((TimeIntervalEvent)event);
        }
        if (event instanceof EventHandlerDeclaration) {
            return this._getEnableName((EventHandlerDeclaration)event);
        }
        if (event instanceof SystemResourceSetup) {
            return this._getEnableName((SystemResourceSetup)event);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(event).toString());
    }

    public String getFileBasename(EObject resource) {
        if (resource instanceof AbstractSystemResource) {
            return this._getFileBasename((AbstractSystemResource)resource);
        }
        if (resource instanceof SystemResourceSetup) {
            return this._getFileBasename((SystemResourceSetup)resource);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(resource).toString());
    }

    public String getResourceTypeName(AbstractSystemResource sensor) {
        if (sensor instanceof Bus) {
            return this._getResourceTypeName((Bus)sensor);
        }
        if (sensor instanceof Connectivity) {
            return this._getResourceTypeName((Connectivity)sensor);
        }
        if (sensor instanceof InputOutput) {
            return this._getResourceTypeName((InputOutput)sensor);
        }
        if (sensor instanceof Platform) {
            return this._getResourceTypeName((Platform)sensor);
        }
        if (sensor instanceof Sensor) {
            return this._getResourceTypeName((Sensor)sensor);
        }
        if (sensor instanceof SystemResourceAlias) {
            return this._getResourceTypeName((SystemResourceAlias)sensor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(sensor).toString());
    }

    public String getBaseName(Object fd) {
        if (fd instanceof NativeFunctionDefinition) {
            return this._getBaseName((NativeFunctionDefinition)fd);
        }
        if (fd instanceof SignalInstance) {
            return this._getBaseName((SignalInstance)fd);
        }
        if (fd instanceof Modality) {
            return this._getBaseName((Modality)fd);
        }
        if (fd instanceof Sensor) {
            return this._getBaseName((Sensor)fd);
        }
        if (fd instanceof SystemResourceEvent) {
            return this._getBaseName((SystemResourceEvent)fd);
        }
        if (fd instanceof Event) {
            return this._getBaseName((Event)fd);
        }
        if (fd instanceof ExceptionTypeDeclaration) {
            return this._getBaseName((ExceptionTypeDeclaration)fd);
        }
        if (fd instanceof Operation) {
            return this._getBaseName((Operation)fd);
        }
        if (fd instanceof AbstractSystemResource) {
            return this._getBaseName((AbstractSystemResource)fd);
        }
        if (fd instanceof ElementReferenceExpression) {
            return this._getBaseName((ElementReferenceExpression)fd);
        }
        if (fd instanceof ModalityAccess) {
            return this._getBaseName((ModalityAccess)fd);
        }
        if (fd instanceof ModalityAccessPreparation) {
            return this._getBaseName((ModalityAccessPreparation)fd);
        }
        if (fd instanceof Program) {
            return this._getBaseName((Program)fd);
        }
        if (fd instanceof SystemEventSource) {
            return this._getBaseName((SystemEventSource)fd);
        }
        if (fd instanceof TimeIntervalEvent) {
            return this._getBaseName((TimeIntervalEvent)fd);
        }
        if (fd instanceof NamedElement) {
            return this._getBaseName((NamedElement)fd);
        }
        if (fd instanceof EventHandlerDeclaration) {
            return this._getBaseName((EventHandlerDeclaration)fd);
        }
        if (fd instanceof SystemResourceSetup) {
            return this._getBaseName((SystemResourceSetup)fd);
        }
        if (fd != null) {
            return this._getBaseName(fd);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fd).toString());
    }

    public CodeFragment getEnumName(ComplexType singleton) {
        if (singleton instanceof SumAlternative) {
            return this._getEnumName((SumAlternative)singleton);
        }
        if (singleton instanceof SumType) {
            return this._getEnumName((SumType)singleton);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(singleton).toString());
    }

    public CodeFragment getStructName(ComplexType structureType) {
        if (structureType instanceof StructureType) {
            return this._getStructName((StructureType)structureType);
        }
        if (structureType instanceof SumAlternative) {
            return this._getStructName((SumAlternative)structureType);
        }
        if (structureType instanceof SumType) {
            return this._getStructName((SumType)structureType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(structureType).toString());
    }

    public CodeFragment getStructType(ComplexType productType) {
        if (productType instanceof AnonymousProductType) {
            return this._getStructType((AnonymousProductType)productType);
        }
        if (productType instanceof NamedProductType) {
            return this._getStructType((NamedProductType)productType);
        }
        if (productType instanceof Singleton) {
            return this._getStructType((Singleton)productType);
        }
        if (productType instanceof SumType) {
            return this._getStructType((SumType)productType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(productType).toString());
    }
}

