/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.AssignmentExpression;
import org.eclipse.mita.base.expressions.AssignmentOperator;
import org.eclipse.mita.base.expressions.BinaryExpression;
import org.eclipse.mita.base.expressions.BoolLiteral;
import org.eclipse.mita.base.expressions.ConditionalExpression;
import org.eclipse.mita.base.expressions.DoubleLiteral;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.expressions.FloatLiteral;
import org.eclipse.mita.base.expressions.HexLiteral;
import org.eclipse.mita.base.expressions.IntLiteral;
import org.eclipse.mita.base.expressions.Literal;
import org.eclipse.mita.base.expressions.NullLiteral;
import org.eclipse.mita.base.expressions.ParenthesizedExpression;
import org.eclipse.mita.base.expressions.PostFixUnaryExpression;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.expressions.StringLiteral;
import org.eclipse.mita.base.expressions.TypeCastExpression;
import org.eclipse.mita.base.expressions.UnaryExpression;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.base.types.HasAccessors;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.PrimitiveType;
import org.eclipse.mita.base.types.Property;
import org.eclipse.mita.base.types.Singleton;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.TypesFactory;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.program.AbstractStatement;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.ArrayLiteral;
import org.eclipse.mita.program.ArrayRuntimeCheckStatement;
import org.eclipse.mita.program.CatchStatement;
import org.eclipse.mita.program.ConditionalStatement;
import org.eclipse.mita.program.DereferenceExpression;
import org.eclipse.mita.program.DoWhileStatement;
import org.eclipse.mita.program.ExceptionBaseVariableDeclaration;
import org.eclipse.mita.program.ExpressionStatement;
import org.eclipse.mita.program.ForEachStatement;
import org.eclipse.mita.program.ForStatement;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.GeneratedFunctionDefinition;
import org.eclipse.mita.program.IfStatement;
import org.eclipse.mita.program.InterpolatedStringExpression;
import org.eclipse.mita.program.IsAssignmentCase;
import org.eclipse.mita.program.IsCase;
import org.eclipse.mita.program.IsDeconstructionCase;
import org.eclipse.mita.program.IsDeconstructor;
import org.eclipse.mita.program.IsOtherCase;
import org.eclipse.mita.program.IsTypeMatchCase;
import org.eclipse.mita.program.LoopBreakerStatement;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.NativeFunctionDefinition;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.ReferenceExpression;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SourceCodeComment;
import org.eclipse.mita.program.ThrowExceptionStatement;
import org.eclipse.mita.program.TryStatement;
import org.eclipse.mita.program.ValueRange;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.WhereIsStatement;
import org.eclipse.mita.program.WhileStatement;
import org.eclipse.mita.program.generator.AbstractFunctionGenerator;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.AbstractTypeGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.mita.program.generator.ProgramDslTraceExtensions;
import org.eclipse.mita.program.generator.TypeGenerator;
import org.eclipse.mita.program.generator.internal.GeneratorRegistry;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.Traced;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class StatementGenerator {
    @Inject
    @Extension
    private ProgramDslTraceExtensions _programDslTraceExtensions;
    @Inject
    private ITypeSystemInferrer typeInferrer;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected TypeGenerator typeGenerator;
    @Inject(optional=true)
    protected IPlatformExceptionGenerator exceptionGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected GeneratorRegistry registry;
    @Inject
    protected ElementSizeInferrer sizeInferrer;

    @Traced
    protected IGeneratorNode _code(Argument stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(StringLiteral stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(NullLiteral stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(IntLiteral stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(HexLiteral stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(FloatLiteral stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(DoubleLiteral stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(BoolLiteral stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ArrayLiteral stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(Literal stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(UnaryExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(PostFixUnaryExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(TypeCastExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(PrimitiveValueExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ParenthesizedExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(BinaryExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    protected IGeneratorNode _code(ModalityAccess stmt) {
        CodeFragment _xblockexpression = null;
        AbstractSystemResource sensor = stmt.getPreparation().getSystemResource();
        AbstractSystemResourceGenerator generator = this.registry.getGenerator(sensor);
        CodeFragment _generateModalityAccessFor = generator.generateModalityAccessFor(stmt);
        String _fileBasename = this._generatorUtils.getFileBasename((EObject)stmt.getPreparation().getSystemResource());
        String _plus = String.valueOf(_fileBasename) + ".h";
        _xblockexpression = _generateModalityAccessFor.addHeader(_plus, false);
        return _xblockexpression;
    }

    protected IGeneratorNode _code(ModalityAccessPreparation stmt) {
        CodeFragment _xblockexpression = null;
        AbstractSystemResource sensor = stmt.getSystemResource();
        AbstractSystemResourceGenerator generator = this.registry.getGenerator(sensor);
        generator.prepare(null, sensor, null, null, null);
        CodeFragment _generateAccessPreparationFor = generator.generateAccessPreparationFor(stmt);
        String _fileBasename = this._generatorUtils.getFileBasename((EObject)stmt.getSystemResource());
        String _plus = String.valueOf(_fileBasename) + ".h";
        _xblockexpression = _generateAccessPreparationFor.addHeader(_plus, false);
        return _xblockexpression;
    }

    @Traced
    protected IGeneratorNode _code(ArrayAccessExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ArrayRuntimeCheckStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(FeatureCall stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ElementReferenceExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(DereferenceExpression e) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)e);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(e));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ReferenceExpression e) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)e);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(e));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ReturnStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(AssignmentExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(InterpolatedStringExpression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(Expression stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ExpressionStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    public IGeneratorNode generateFunCallStmt(final IGeneratorNode variableName, TypeSpecifier inferenceResult, final ElementReferenceExpression initialization) {
        final EObject reference = initialization.getReference();
        if (reference instanceof FunctionDefinition) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"&");
                            _builder.append((Object)variableName);
                        }
                    };
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.generateFunctionCall((Operation)reference, (IGeneratorNode)StatementGenerator.this.codeFragmentProvider.create(_client), (ArgumentExpression)initialization));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        if (reference instanceof GeneratedFunctionDefinition) {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator((IGeneratorNode)StatementGenerator.this.registry.getGenerator((GeneratedFunctionDefinition)reference).generate(initialization, variableName));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
            };
            return this.codeFragmentProvider.create(_client_1);
        }
        if (reference instanceof NativeFunctionDefinition) {
            boolean _isChecked = ((NativeFunctionDefinition)reference).isChecked();
            if (_isChecked) {
                StringConcatenationClient _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"&");
                                _builder.append((Object)variableName);
                            }
                        };
                        IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.generateNativeFunctionCallChecked((NativeFunctionDefinition)reference, (IGeneratorNode)StatementGenerator.this.codeFragmentProvider.create(_client), (ArgumentExpression)initialization));
                        _builder.append((Object)_noTerminator);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                };
                return this.codeFragmentProvider.create(_client_2);
            }
            StringConcatenationClient _client_3 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)variableName);
                    _builder.append((Object)" = ");
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.generateNativeFunctionCallUnchecked((NativeFunctionDefinition)reference, (ArgumentExpression)initialization));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)";");
                }
            };
            return this.codeFragmentProvider.create(_client_3);
        }
        return null;
    }

    protected IGeneratorNode _initializationCode(final VariableDeclaration stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = stmt.getName();
                _builder.append((Object)_name);
            }
        };
        return this.initializationCode(stmt, this.inferType(stmt), (IGeneratorNode)this.codeFragmentProvider.create(_client), AssignmentOperator.ASSIGN, stmt.getInitialization(), false);
    }

    protected IGeneratorNode _initializationCode(final AssignmentExpression expr) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)expr.getVarRef()));
                _builder.append((Object)_noTerminator);
            }
        };
        return this.initializationCode((EObject)expr.getVarRef(), this.inferType((EObject)expr), (IGeneratorNode)this.codeFragmentProvider.create(_client), expr.getOperator(), expr.getExpression(), true);
    }

    public IGeneratorNode initializationCode(EObject target, TypeSpecifier typeOf, final IGeneratorNode varName, final AssignmentOperator op, final Expression initialization, boolean alwaysGenerate) {
        Type type;
        Type _type = null;
        if (typeOf != null) {
            _type = typeOf.getType();
        }
        if ((type = _type) instanceof GeneratedType) {
            Literal _value;
            AbstractTypeGenerator generator = this.registry.getGenerator((GeneratedType)type);
            if (initialization instanceof NewInstanceExpression) {
                return generator.generateNewInstance(typeOf, (NewInstanceExpression)initialization);
            }
            if (initialization instanceof ArrayAccessExpression) {
                return generator.generateExpression(typeOf, target, op, (EObject)initialization);
            }
            if (initialization instanceof ElementReferenceExpression && ((ElementReferenceExpression)initialization).isOperationCall()) {
                return this.generateFunCallStmt(varName, typeOf, (ElementReferenceExpression)initialization);
            }
            if (initialization instanceof PrimitiveValueExpression && (_value = ((PrimitiveValueExpression)initialization).getValue()) instanceof ArrayLiteral) {
                return CodeFragment.EMPTY;
            }
            return generator.generateExpression(typeOf, target, op, (EObject)initialization);
        }
        if (initialization instanceof ElementReferenceExpression) {
            boolean _isOperationCall = ((ElementReferenceExpression)initialization).isOperationCall();
            if (_isOperationCall) {
                return this.generateFunCallStmt(varName, typeOf, (ElementReferenceExpression)initialization);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)varName);
                    _builder.append((Object)" ");
                    _builder.append((Object)op);
                    _builder.append((Object)" ");
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)initialization));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)";");
                }
            };
            return this._programDslTraceExtensions.trace(target, _client);
        }
        if (initialization instanceof ModalityAccess) {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)varName);
                    _builder.append((Object)" ");
                    _builder.append((Object)op);
                    _builder.append((Object)" ");
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)initialization));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)";");
                }
            };
            return this._programDslTraceExtensions.trace(target, _client_1);
        }
        if (alwaysGenerate) {
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)varName);
                    _builder.append((Object)" ");
                    _builder.append((Object)op);
                    _builder.append((Object)" ");
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)initialization));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)";");
                }
            };
            return this._programDslTraceExtensions.trace(target, _client_2);
        }
        return CodeFragment.EMPTY;
    }

    protected IGeneratorNode _code(final VariableDeclaration stmt) {
        Expression initialization = stmt.getInitialization();
        final TypeSpecifier inferenceResult = this.inferType(stmt);
        Type _type = null;
        if (inferenceResult != null) {
            _type = inferenceResult.getType();
        }
        Type type = _type;
        CompositeGeneratorNode result = this._programDslTraceExtensions.trace(stmt);
        boolean initializationDone = false;
        if (type instanceof GeneratedType) {
            AbstractTypeGenerator generator = this.registry.getGenerator((GeneratedType)type);
            List _children = result.getChildren();
            CodeFragment _generateVariableDeclaration = generator.generateVariableDeclaration(inferenceResult, stmt);
            _children.add(_generateVariableDeclaration);
            if (Objects.equal((Object)((GeneratedType)type).getName(), (Object)"array") && initialization instanceof ArrayLiteral) {
                initializationDone = true;
            }
        } else if (stmt instanceof ExceptionBaseVariableDeclaration) {
            List _children_1 = result.getChildren();
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    CodeFragment _exceptionType = StatementGenerator.this.exceptionGenerator.getExceptionType();
                    _builder.append((Object)_exceptionType);
                    _builder.append((Object)" ");
                    String _name = ((ExceptionBaseVariableDeclaration)stmt).getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)" = NO_EXCEPTION;");
                    _builder.newLineIfNotEmpty();
                    boolean _isNeedsReturnFromTryCatch = ((ExceptionBaseVariableDeclaration)stmt).isNeedsReturnFromTryCatch();
                    if (_isNeedsReturnFromTryCatch) {
                        _builder.append((Object)"bool returnFromWithinTryCatch = false;");
                        _builder.newLine();
                    }
                    _builder.newLine();
                }
            };
            CodeFragment _addHeader = this.codeFragmentProvider.create(_client).addHeader("stdbool.h", true);
            _children_1.add(_addHeader);
            initializationDone = true;
        } else if (initialization instanceof ElementReferenceExpression) {
            EObject ref = ((ElementReferenceExpression)initialization).getReference();
            if (((ElementReferenceExpression)initialization).isOperationCall() && !(ref instanceof SumAlternative) && !(ref instanceof StructureType)) {
                List _children_2 = result.getChildren();
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        CodeFragment _ctype = StatementGenerator.this.getCtype(inferenceResult);
                        _builder.append((Object)_ctype);
                        _builder.append((Object)" ");
                        String _name = stmt.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)";");
                    }
                };
                CodeFragment _create = this.codeFragmentProvider.create(_client_1);
                _children_2.add(_create);
            } else {
                List _children_3 = result.getChildren();
                StringConcatenationClient _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        CodeFragment _ctype = StatementGenerator.this.getCtype(inferenceResult);
                        _builder.append((Object)_ctype);
                        _builder.append((Object)" ");
                        String _name = stmt.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = ");
                        IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getInitialization()));
                        _builder.append((Object)_noTerminator);
                        _builder.append((Object)";");
                    }
                };
                CodeFragment _create_1 = this.codeFragmentProvider.create(_client_2);
                _children_3.add(_create_1);
                initializationDone = true;
            }
        } else if (initialization instanceof ModalityAccess) {
            List _children_4 = result.getChildren();
            StringConcatenationClient _client_3 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    CodeFragment _ctype = StatementGenerator.this.getCtype(inferenceResult);
                    _builder.append((Object)_ctype);
                    _builder.append((Object)" ");
                    String _name = stmt.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)";");
                }
            };
            CodeFragment _create_2 = this.codeFragmentProvider.create(_client_3);
            _children_4.add(_create_2);
        } else {
            boolean _tripleNotEquals;
            Expression _initialization = stmt.getInitialization();
            boolean bl = _tripleNotEquals = _initialization != null;
            if (_tripleNotEquals) {
                List _children_5 = result.getChildren();
                StringConcatenationClient _client_4 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        CodeFragment _ctype = StatementGenerator.this.getCtype(inferenceResult);
                        _builder.append((Object)_ctype);
                        _builder.append((Object)" ");
                        String _name = stmt.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = ");
                        IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getInitialization()));
                        _builder.append((Object)_noTerminator);
                        _builder.append((Object)";");
                    }
                };
                CodeFragment _create_3 = this.codeFragmentProvider.create(_client_4);
                _children_5.add(_create_3);
            } else if (type instanceof StructureType) {
                List _children_6 = result.getChildren();
                StringConcatenationClient _client_5 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        CodeFragment _ctype = StatementGenerator.this.getCtype(inferenceResult);
                        _builder.append((Object)_ctype);
                        _builder.append((Object)" ");
                        String _name = stmt.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = {0};");
                    }
                };
                CodeFragment _create_4 = this.codeFragmentProvider.create(_client_5);
                _children_6.add(_create_4);
            } else if (type instanceof PrimitiveType) {
                List _children_7 = result.getChildren();
                StringConcatenationClient _client_6 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        CodeFragment _ctype = StatementGenerator.this.getCtype(inferenceResult);
                        _builder.append((Object)_ctype);
                        _builder.append((Object)" ");
                        String _name = stmt.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = 0;");
                    }
                };
                CodeFragment _create_5 = this.codeFragmentProvider.create(_client_6);
                _children_7.add(_create_5);
            } else {
                List _children_8 = result.getChildren();
                StringConcatenationClient _client_7 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        CodeFragment _ctype = StatementGenerator.this.getCtype(inferenceResult);
                        _builder.append((Object)_ctype);
                        _builder.append((Object)" ");
                        String _name = stmt.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = WARNING unsupported initialization;");
                    }
                };
                CodeFragment _create_6 = this.codeFragmentProvider.create(_client_7);
                _children_8.add(_create_6);
            }
            initializationDone = true;
        }
        if (stmt.eContainer() instanceof Program || initializationDone) {
            return result;
        }
        if (!initializationDone) {
            List _children_9 = result.getChildren();
            StringConcatenationClient _client_8 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"\n");
                }
            };
            CodeFragment _create_7 = this.codeFragmentProvider.create(_client_8);
            _children_9.add(_create_7);
            List _children_10 = result.getChildren();
            IGeneratorNode _initializationCode = this.initializationCode(stmt);
            _children_10.add(_initializationCode);
        }
        return result;
    }

    @Traced
    protected IGeneratorNode _code(IfStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ThrowExceptionStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(TryStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(WhileStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ForStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ForEachStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(DoWhileStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ConditionalExpression it) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)it);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(it));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(ProgramBlock stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(FunctionDefinition stmt) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(SourceCodeComment stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(AbstractStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(WhereIsStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(IsTypeMatchCase stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(IsAssignmentCase stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(IsDeconstructionCase stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(IsOtherCase stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    public java.util.function.Function<Integer, String> accessor(final SumAlternative productType, final Parameter preferred, final String prefix, final String suffix) {
        java.util.function.Function<Integer, String> _function = new java.util.function.Function<Integer, String>(){

            @Override
            public String apply(final Integer idx) {
                String _xifexpression = null;
                if (preferred != null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(prefix);
                    String _name = preferred.getName();
                    _builder.append(_name);
                    _builder.append(suffix);
                    _xifexpression = _builder.toString();
                } else {
                    Function<EList<Parameter>, String> _function = new Function<EList<Parameter>, String>(){

                        public String apply(EList<Parameter> parameters) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append(prefix);
                            String _baseName = (this).StatementGenerator.this._generatorUtils.getBaseName(parameters.get(idx.intValue()));
                            _builder.append(_baseName);
                            _builder.append(suffix);
                            return _builder.toString();
                        }
                    };
                    Optional _transform = ModelUtils.getAccessorParameters((EObject)productType).transform((Function)_function);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(prefix);
                    _builder_1.append("_");
                    _builder_1.append((Object)idx);
                    _builder_1.append(suffix);
                    _xifexpression = (String)_transform.or((Object)_builder_1.toString());
                }
                return _xifexpression;
            }
        };
        return _function;
    }

    @Traced
    protected IGeneratorNode _code(IsDeconstructor stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _code(LoopBreakerStatement stmt) {
        ILocationData _location = this._programDslTraceExtensions.location(stmt);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__code(stmt));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _header(FunctionDefinition definition) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)definition);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__header(definition));
        return _traceNode;
    }

    protected IGeneratorNode _header(StructureType definition) {
        return this.structureTypeCode(definition);
    }

    public IGeneratorNode structureTypeCode(StructureType definition) {
        return this.structureTypeCodeDecl((EObject)definition, (List<Parameter>)definition.getParameters(), this._generatorUtils.getStructName((ComplexType)definition));
    }

    public IGeneratorNode structureTypeCodeDecl(EObject obj, List<Parameter> parameters, CodeFragment typeName) {
        Functions.Function1<Parameter, Pair<CodeFragment, String>> _function = new Functions.Function1<Parameter, Pair<CodeFragment, String>>(){

            public Pair<CodeFragment, String> apply(Parameter it) {
                CodeFragment _ctype = StatementGenerator.this.getCtype(StatementGenerator.this.inferType((EObject)it));
                String _baseName = StatementGenerator.this._generatorUtils.getBaseName(it);
                return new Pair((Object)_ctype, (Object)_baseName);
            }
        };
        return this.structureTypeCodeReal(obj, ListExtensions.map(parameters, (Functions.Function1)_function), typeName);
    }

    @Traced
    public IGeneratorNode structureTypeCodeReal(EObject obj, List<Pair<CodeFragment, String>> typesAndNames, CodeFragment typeName) {
        ILocationData _location = this._programDslTraceExtensions.location(obj);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this._structureTypeCodeReal(obj, typesAndNames, typeName));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _header(SumType definition) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)definition);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__header(definition));
        return _traceNode;
    }

    @Traced
    protected IGeneratorNode _header(EnumerationType definition) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)definition);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this.__header(definition));
        return _traceNode;
    }

    @Traced
    public IGeneratorNode generateNativeFunctionCallChecked(NativeFunctionDefinition op, IGeneratorNode firstArg, ArgumentExpression args) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)op);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this._generateNativeFunctionCallChecked(op, firstArg, args));
        return _traceNode;
    }

    @Traced
    public IGeneratorNode generateNativeFunctionCallUnchecked(NativeFunctionDefinition op, ArgumentExpression args) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)op);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this._generateNativeFunctionCallUnchecked(op, args));
        return _traceNode;
    }

    @Traced
    public IGeneratorNode generateFunctionCall(Operation op, IGeneratorNode firstArg, ArgumentExpression args) {
        ILocationData _location = this._programDslTraceExtensions.location((EObject)op);
        CompositeGeneratorNode _traceNode = this._programDslTraceExtensions.trace(_location, false);
        this._programDslTraceExtensions.appendTemplate(_traceNode, this._generateFunctionCall(op, firstArg, args));
        return _traceNode;
    }

    private TypeSpecifier inferType(EObject expr) {
        return ModelUtils.toSpecifier(this.typeInferrer.infer(expr));
    }

    private CodeFragment getCtype(TypeSpecifier type) {
        CodeFragment _xifexpression = null;
        if (type == null) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"void*");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client);
        } else {
            _xifexpression = this.typeGenerator.code(type);
        }
        return _xifexpression;
    }

    public IGeneratorNode code(EObject stmt) {
        if (stmt instanceof FunctionDefinition) {
            return this._code((FunctionDefinition)stmt);
        }
        if (stmt instanceof IsDeconstructor) {
            return this._code((IsDeconstructor)stmt);
        }
        if (stmt instanceof VariableDeclaration) {
            return this._code((VariableDeclaration)stmt);
        }
        if (stmt instanceof ElementReferenceExpression) {
            return this._code((ElementReferenceExpression)stmt);
        }
        if (stmt instanceof FeatureCall) {
            return this._code((FeatureCall)stmt);
        }
        if (stmt instanceof HexLiteral) {
            return this._code((HexLiteral)stmt);
        }
        if (stmt instanceof PostFixUnaryExpression) {
            return this._code((PostFixUnaryExpression)stmt);
        }
        if (stmt instanceof DoWhileStatement) {
            return this._code((DoWhileStatement)stmt);
        }
        if (stmt instanceof ForEachStatement) {
            return this._code((ForEachStatement)stmt);
        }
        if (stmt instanceof ForStatement) {
            return this._code((ForStatement)stmt);
        }
        if (stmt instanceof IfStatement) {
            return this._code((IfStatement)stmt);
        }
        if (stmt instanceof IsAssignmentCase) {
            return this._code((IsAssignmentCase)stmt);
        }
        if (stmt instanceof IsDeconstructionCase) {
            return this._code((IsDeconstructionCase)stmt);
        }
        if (stmt instanceof IsOtherCase) {
            return this._code((IsOtherCase)stmt);
        }
        if (stmt instanceof IsTypeMatchCase) {
            return this._code((IsTypeMatchCase)stmt);
        }
        if (stmt instanceof WhileStatement) {
            return this._code((WhileStatement)stmt);
        }
        if (stmt instanceof AssignmentExpression) {
            return this._code((AssignmentExpression)stmt);
        }
        if (stmt instanceof BinaryExpression) {
            return this._code((BinaryExpression)stmt);
        }
        if (stmt instanceof BoolLiteral) {
            return this._code((BoolLiteral)stmt);
        }
        if (stmt instanceof ConditionalExpression) {
            return this._code((ConditionalExpression)stmt);
        }
        if (stmt instanceof DoubleLiteral) {
            return this._code((DoubleLiteral)stmt);
        }
        if (stmt instanceof FloatLiteral) {
            return this._code((FloatLiteral)stmt);
        }
        if (stmt instanceof IntLiteral) {
            return this._code((IntLiteral)stmt);
        }
        if (stmt instanceof NullLiteral) {
            return this._code((NullLiteral)stmt);
        }
        if (stmt instanceof ParenthesizedExpression) {
            return this._code((ParenthesizedExpression)stmt);
        }
        if (stmt instanceof PrimitiveValueExpression) {
            return this._code((PrimitiveValueExpression)stmt);
        }
        if (stmt instanceof StringLiteral) {
            return this._code((StringLiteral)stmt);
        }
        if (stmt instanceof TypeCastExpression) {
            return this._code((TypeCastExpression)stmt);
        }
        if (stmt instanceof UnaryExpression) {
            return this._code((UnaryExpression)stmt);
        }
        if (stmt instanceof ArrayAccessExpression) {
            return this._code((ArrayAccessExpression)stmt);
        }
        if (stmt instanceof ArrayLiteral) {
            return this._code((ArrayLiteral)stmt);
        }
        if (stmt instanceof ArrayRuntimeCheckStatement) {
            return this._code((ArrayRuntimeCheckStatement)stmt);
        }
        if (stmt instanceof DereferenceExpression) {
            return this._code((DereferenceExpression)stmt);
        }
        if (stmt instanceof ExpressionStatement) {
            return this._code((ExpressionStatement)stmt);
        }
        if (stmt instanceof InterpolatedStringExpression) {
            return this._code((InterpolatedStringExpression)stmt);
        }
        if (stmt instanceof LoopBreakerStatement) {
            return this._code((LoopBreakerStatement)stmt);
        }
        if (stmt instanceof ModalityAccess) {
            return this._code((ModalityAccess)stmt);
        }
        if (stmt instanceof ModalityAccessPreparation) {
            return this._code((ModalityAccessPreparation)stmt);
        }
        if (stmt instanceof ReferenceExpression) {
            return this._code((ReferenceExpression)stmt);
        }
        if (stmt instanceof ReturnStatement) {
            return this._code((ReturnStatement)stmt);
        }
        if (stmt instanceof SourceCodeComment) {
            return this._code((SourceCodeComment)stmt);
        }
        if (stmt instanceof ThrowExceptionStatement) {
            return this._code((ThrowExceptionStatement)stmt);
        }
        if (stmt instanceof TryStatement) {
            return this._code((TryStatement)stmt);
        }
        if (stmt instanceof WhereIsStatement) {
            return this._code((WhereIsStatement)stmt);
        }
        if (stmt instanceof Argument) {
            return this._code((Argument)stmt);
        }
        if (stmt instanceof Expression) {
            return this._code((Expression)stmt);
        }
        if (stmt instanceof Literal) {
            return this._code((Literal)stmt);
        }
        if (stmt instanceof AbstractStatement) {
            return this._code((AbstractStatement)stmt);
        }
        if (stmt instanceof ProgramBlock) {
            return this._code((ProgramBlock)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public IGeneratorNode initializationCode(EObject stmt) {
        if (stmt instanceof VariableDeclaration) {
            return this._initializationCode((VariableDeclaration)stmt);
        }
        if (stmt instanceof AssignmentExpression) {
            return this._initializationCode((AssignmentExpression)stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    public IGeneratorNode header(EObject definition) {
        if (definition instanceof FunctionDefinition) {
            return this._header((FunctionDefinition)definition);
        }
        if (definition instanceof EnumerationType) {
            return this._header((EnumerationType)definition);
        }
        if (definition instanceof StructureType) {
            return this._header((StructureType)definition);
        }
        if (definition instanceof SumType) {
            return this._header((SumType)definition);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(definition).toString());
    }

    public StringConcatenationClient __code(final Argument stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _code = StatementGenerator.this.code((EObject)stmt.getValue());
                _builder.append((Object)_code);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final StringLiteral stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"\"");
                String _value = stmt.getValue();
                _builder.append((Object)_value);
                _builder.append((Object)"\"");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(NullLiteral stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"NULL");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final IntLiteral stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                int _value = stmt.getValue();
                _builder.append((Object)_value);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final HexLiteral stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"0x");
                String _hexString = Integer.toHexString(stmt.getValue());
                _builder.append((Object)_hexString);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final FloatLiteral stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                float _value = stmt.getValue();
                _builder.append((Object)Float.valueOf(_value));
                _builder.append((Object)"f");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final DoubleLiteral stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                double _value = stmt.getValue();
                _builder.append((Object)_value);
                _builder.append((Object)"f");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final BoolLiteral stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _isValue = stmt.isValue();
                if (_isValue) {
                    _builder.append((Object)"true");
                } else {
                    _builder.append((Object)"false");
                }
            }
        };
        final CodeFragment result = this.codeFragmentProvider.create(_client).addHeader("stdbool.h", true);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)result);
            }
        };
        return _client_1;
    }

    public StringConcatenationClient __code(final ArrayLiteral stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"{");
                EList<Literal> _values = stmt.getValues();
                boolean _hasElements = false;
                for (Literal value : _values) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    IGeneratorNode _code = StatementGenerator.this.code((EObject)value);
                    _builder.append((Object)_code);
                }
                _builder.append((Object)"}");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final Literal stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"ERROR: unsupported literal: ");
                _builder.append((Object)stmt);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final UnaryExpression stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _literal = stmt.getOperator().getLiteral();
                _builder.append((Object)_literal);
                IGeneratorNode _code = StatementGenerator.this.code((EObject)stmt.getOperand());
                _builder.append((Object)_code);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final PostFixUnaryExpression stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getOperand()));
                _builder.append((Object)_noTerminator);
                String _literal = stmt.getOperator().getLiteral();
                _builder.append((Object)_literal);
                EObject _eContainer = stmt.eContainer();
                if (_eContainer instanceof ExpressionStatement) {
                    _builder.append((Object)";");
                }
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final TypeCastExpression stmt) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final TypeSpecifier typeSpec = TypesFactory.eINSTANCE.createTypeSpecifier();
        typeSpec.setType(stmt.getType());
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"(");
                CodeFragment _code = StatementGenerator.this.typeGenerator.code(typeSpec);
                _builder.append((Object)_code);
                _builder.append((Object)") (");
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getOperand()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)")");
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final PrimitiveValueExpression stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _code = StatementGenerator.this.code((EObject)stmt.getValue());
                _builder.append((Object)_code);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ParenthesizedExpression stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"(");
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getExpression()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)");");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final BinaryExpression stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getLeftOperand()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)" ");
                String _literal = stmt.getOperator().getLiteral();
                _builder.append((Object)_literal);
                _builder.append((Object)" ");
                IGeneratorNode _noTerminator_1 = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getRightOperand()));
                _builder.append((Object)_noTerminator_1);
                _builder.append((Object)";");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ArrayAccessExpression stmt) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        Expression maybeErefExpr = stmt.getOwner();
        String _xifexpression = null;
        _xifexpression = maybeErefExpr instanceof ElementReferenceExpression ? this._generatorUtils.getBaseName(((ElementReferenceExpression)maybeErefExpr).getReference()) : this._generatorUtils.getUniqueIdentifier((EObject)maybeErefExpr);
        final String id = _xifexpression;
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)id);
                _builder.append((Object)".data[");
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getArraySelector()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)"]");
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final ArrayRuntimeCheckStatement stmt) {
        ArrayAccessExpression accessStatement = stmt.getAccess();
        Expression owner = accessStatement.getOwner();
        String _xifexpression = null;
        _xifexpression = owner instanceof ElementReferenceExpression ? this._generatorUtils.getBaseName(((ElementReferenceExpression)owner).getReference()) : this._generatorUtils.getUniqueIdentifier((EObject)owner);
        String variableName = _xifexpression;
        final LinkedList<CodeFragment> checks = new LinkedList<CodeFragment>();
        final Expression arraySelector = accessStatement.getArraySelector();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(variableName);
        _builder.append(".length");
        final String arrayLength = _builder.toString();
        if (arraySelector instanceof ValueRange) {
            Expression _upperBound;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Expression _lowerBound = ((ValueRange)arraySelector).getLowerBound();
            boolean bl = _tripleNotEquals = _lowerBound != null;
            if (_tripleNotEquals) {
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)((ValueRange)arraySelector).getLowerBound()));
                        _builder.append((Object)_noTerminator);
                        _builder.append((Object)" < 0");
                    }
                };
                CodeFragment _create = this.codeFragmentProvider.create(_client);
                checks.add(_create);
            }
            boolean bl2 = _tripleNotEquals_1 = (_upperBound = ((ValueRange)arraySelector).getUpperBound()) != null;
            if (_tripleNotEquals_1) {
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)((ValueRange)arraySelector).getUpperBound()));
                        _builder.append((Object)_noTerminator);
                        _builder.append((Object)" >= ");
                        _builder.append((Object)arrayLength);
                    }
                };
                CodeFragment _create_1 = this.codeFragmentProvider.create(_client_1);
                checks.add(_create_1);
            }
            if (((ValueRange)arraySelector).getLowerBound() != null && ((ValueRange)arraySelector).getUpperBound() != null) {
                StringConcatenationClient _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)((ValueRange)arraySelector).getLowerBound()));
                        _builder.append((Object)_noTerminator);
                        _builder.append((Object)" > ");
                        IGeneratorNode _noTerminator_1 = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)((ValueRange)arraySelector).getUpperBound()));
                        _builder.append((Object)_noTerminator_1);
                    }
                };
                CodeFragment _create_2 = this.codeFragmentProvider.create(_client_2);
                checks.add(_create_2);
            }
        } else {
            StringConcatenationClient _client_3 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)arrayLength);
                    _builder.append((Object)" <= ");
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)arraySelector));
                    _builder.append((Object)_noTerminator);
                }
            };
            CodeFragment _create_3 = this.codeFragmentProvider.create(_client_3);
            checks.add(_create_3);
        }
        StringConcatenationClient _client_4 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if(");
                boolean _hasElements = false;
                for (CodeFragment check : checks) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)" || ", "");
                    }
                    _builder.append((Object)check);
                }
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                CharSequence _generateExceptionHandler = StatementGenerator.this._generatorUtils.generateExceptionHandler(stmt, "EXCEPTION_INVALIDRANGEEXCEPTION");
                _builder.append((Object)_generateExceptionHandler, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client_4;
    }

    public StringConcatenationClient __code(final FeatureCall stmt) {
        try {
            StringConcatenationClient _xifexpression = null;
            boolean _isOperationCall = stmt.isOperationCall();
            if (_isOperationCall) {
                StringConcatenationClient _xblockexpression = null;
                final EObject feature = stmt.getFeature();
                StringConcatenationClient _xifexpression_1 = null;
                if (feature instanceof SumAlternative) {
                    StringConcatenationClient _client_1;
                    StringConcatenationClient _xblockexpression_1 = null;
                    final CodeFragment altAccessor = this._generatorUtils.getStructName((ComplexType)feature);
                    if (!(stmt.getOwner() instanceof ElementReferenceExpression) || !(((ElementReferenceExpression)stmt.getOwner()).getReference() instanceof SumType)) {
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"UNKNOWN ERROR @FeatureCall");
                            }
                        };
                        return _client;
                    }
                    Expression _owner = stmt.getOwner();
                    EObject _reference = ((ElementReferenceExpression)_owner).getReference();
                    final SumType sumType = (SumType)_reference;
                    CodeFragment _xifexpression_2 = null;
                    if (feature instanceof AnonymousProductType) {
                        CodeFragment _xifexpression_3 = null;
                        int _length = ((Object[])Conversions.unwrapArray((Object)((AnonymousProductType)feature).getTypeSpecifiers(), Object.class)).length;
                        boolean _equals = _length == 1;
                        _xifexpression_3 = _equals ? this.getCtype((TypeSpecifier)IterableExtensions.head((Iterable)((AnonymousProductType)feature).getTypeSpecifiers())) : this._generatorUtils.getStructType((ComplexType)feature);
                        _xifexpression_2 = _xifexpression_3;
                    } else {
                        _xifexpression_2 = this._generatorUtils.getStructType((ComplexType)feature);
                    }
                    final CodeFragment dataType = _xifexpression_2;
                    ProgramBlock _containerOfType = (ProgramBlock)EcoreUtil2.getContainerOfType((EObject)stmt, ProgramBlock.class);
                    final boolean needCast = _containerOfType != null;
                    Type _realType = ((SumAlternative)feature).realType();
                    final boolean hasAccessors = _realType instanceof HasAccessors;
                    _xifexpression_1 = _xblockexpression_1 = (_client_1 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            if (needCast) {
                                _builder.append((Object)"(");
                                CodeFragment _structName = StatementGenerator.this._generatorUtils.getStructName((ComplexType)sumType);
                                _builder.append((Object)_structName);
                                _builder.append((Object)") ");
                            }
                            _builder.append((Object)"{");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".tag = ");
                            CodeFragment _enumName = StatementGenerator.this._generatorUtils.getEnumName((ComplexType)feature);
                            _builder.append((Object)_enumName, "\t");
                            if (!(feature instanceof Singleton)) {
                                _builder.append((Object)", ");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t");
                                _builder.newLine();
                                _builder.append((Object)"\t");
                                _builder.append((Object)".data.");
                                _builder.append((Object)altAccessor, "\t");
                                _builder.append((Object)" = ");
                                if (needCast) {
                                    _builder.append((Object)"(");
                                    _builder.append((Object)dataType, "\t");
                                    _builder.append((Object)") ");
                                }
                                _builder.append((Object)"{");
                                _builder.newLineIfNotEmpty();
                                Iterable _indexed = IterableExtensions.indexed((Iterable)stmt.getArguments());
                                for (Pair i_arg : _indexed) {
                                    boolean _lessThan;
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    if (hasAccessors) {
                                        String _apply = StatementGenerator.this.accessor((SumAlternative)feature, ((Argument)i_arg.getValue()).getParameter(), ".", " = ").apply((Integer)i_arg.getKey());
                                        _builder.append((Object)_apply, "\t\t");
                                    }
                                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)((Argument)i_arg.getValue()).getValue()));
                                    _builder.append((Object)_noTerminator, "\t\t");
                                    Integer _key = (Integer)i_arg.getKey();
                                    int _length = ((Object[])Conversions.unwrapArray((Object)stmt.getArguments(), Object.class)).length;
                                    int _minus = _length - 1;
                                    boolean bl = _lessThan = _key < _minus;
                                    if (_lessThan) {
                                        _builder.append((Object)",");
                                    }
                                    _builder.newLineIfNotEmpty();
                                }
                                _builder.append((Object)"\t");
                                _builder.append((Object)"}");
                                _builder.newLine();
                            } else {
                                _builder.append((Object)"\t");
                                _builder.newLine();
                            }
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                    });
                } else {
                    StringConcatenationClient _client;
                    _xifexpression_1 = _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"// function calls as feature calls are not supported");
                        }
                    };
                }
                _xifexpression = _xblockexpression = _xifexpression_1;
            } else {
                StringConcatenationClient _xifexpression_1 = null;
                boolean _isArrayAccess = stmt.isArrayAccess();
                if (_isArrayAccess) {
                    StringConcatenationClient _client;
                    _xifexpression_1 = _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getOwner()));
                            _builder.append((Object)_noTerminator);
                            _builder.append((Object)"[");
                            IGeneratorNode _noTerminator_1 = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)IterableExtensions.head((Iterable)stmt.getArraySelector())));
                            _builder.append((Object)_noTerminator_1);
                            _builder.append((Object)"];");
                        }
                    };
                } else {
                    StringConcatenationClient _xifexpression_2 = null;
                    EObject _feature = stmt.getFeature();
                    if (_feature instanceof Modality) {
                        Status _status = new Status(4, null, "Sensor access should not be a feature call");
                        throw new CoreException((IStatus)_status);
                    }
                    StringConcatenationClient _xifexpression_3 = null;
                    EObject _feature_1 = stmt.getFeature();
                    if (_feature_1 instanceof SignalInstance) {
                        StringConcatenationClient _client_1;
                        _xifexpression_3 = _client_1 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"/* Signal instance access should have been rewritten by the compiler. */");
                            }
                        };
                    } else {
                        StringConcatenationClient _xifexpression_4 = null;
                        EObject _feature_2 = stmt.getFeature();
                        if (_feature_2 instanceof VariableDeclaration) {
                            StringConcatenationClient _client_2;
                            StringConcatenationClient _xblockexpression_1 = null;
                            EObject _feature_3 = stmt.getFeature();
                            final VariableDeclaration declaration = (VariableDeclaration)_feature_3;
                            _xifexpression_4 = _xblockexpression_1 = (_client_2 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    String _name = declaration.getName();
                                    _builder.append((Object)_name);
                                }
                            });
                        } else {
                            StringConcatenationClient _xifexpression_5 = null;
                            EObject _feature_3 = stmt.getFeature();
                            if (_feature_3 instanceof Property) {
                                StringConcatenationClient _client_2;
                                StringConcatenationClient _xblockexpression_2 = null;
                                EObject _feature_4 = stmt.getFeature();
                                final Property _feature_5 = (Property)_feature_4;
                                _xifexpression_5 = _xblockexpression_2 = (_client_2 = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getOwner()));
                                        _builder.append((Object)_noTerminator);
                                        _builder.append((Object)".");
                                        String _name = _feature_5.getName();
                                        _builder.append((Object)_name);
                                    }
                                });
                            } else {
                                StringConcatenationClient _xifexpression_6 = null;
                                EObject _feature_4 = stmt.getFeature();
                                if (_feature_4 instanceof Parameter) {
                                    StringConcatenationClient _client_2;
                                    StringConcatenationClient _xblockexpression_3 = null;
                                    EObject _feature_5 = stmt.getFeature();
                                    final Parameter _feature_6 = (Parameter)_feature_5;
                                    _xifexpression_6 = _xblockexpression_3 = (_client_2 = new StringConcatenationClient(){

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getOwner()));
                                            _builder.append((Object)_noTerminator);
                                            _builder.append((Object)".");
                                            String _name = _feature_6.getName();
                                            _builder.append((Object)_name);
                                        }
                                    });
                                }
                                _xifexpression_5 = _xifexpression_6;
                            }
                            _xifexpression_4 = _xifexpression_5;
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_1 = _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public StringConcatenationClient __code(final ElementReferenceExpression stmt) {
        StringConcatenationClient _xblockexpression = null;
        final EObject ref = stmt.getReference();
        final String id = this._generatorUtils.getBaseName(ref);
        StringConcatenationClient _xifexpression = null;
        boolean _isOperationCall = stmt.isOperationCall();
        if (_isOperationCall) {
            StringConcatenationClient _xifexpression_1 = null;
            if (ref instanceof FunctionDefinition) {
                StringConcatenationClient _client;
                _xifexpression_1 = _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"NULL");
                            }
                        };
                        IGeneratorNode _generateFunctionCall = StatementGenerator.this.generateFunctionCall((Operation)ref, (IGeneratorNode)StatementGenerator.this.codeFragmentProvider.create(_client).addHeader("stdlib.h", true), (ArgumentExpression)stmt);
                        _builder.append((Object)_generateFunctionCall);
                    }
                };
            } else {
                StringConcatenationClient _xifexpression_2 = null;
                if (ref instanceof GeneratedFunctionDefinition) {
                    StringConcatenationClient _client_1;
                    _xifexpression_2 = _client_1 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            AbstractFunctionGenerator _generator = StatementGenerator.this.registry.getGenerator((GeneratedFunctionDefinition)ref);
                            CodeFragment _generate = null;
                            if (_generator != null) {
                                _generate = _generator.generate(stmt, null);
                            }
                            _builder.append(_generate);
                        }
                    };
                } else {
                    StringConcatenationClient _xifexpression_3 = null;
                    if (ref instanceof NativeFunctionDefinition) {
                        StringConcatenationClient _client_3;
                        StringConcatenationClient _client_2;
                        StringConcatenationClient _xifexpression_4 = null;
                        boolean _isChecked = ((NativeFunctionDefinition)ref).isChecked();
                        _xifexpression_4 = _isChecked ? (_client_2 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                StringConcatenationClient _client = new StringConcatenationClient(){

                                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                        _builder.append((Object)"NULL");
                                    }
                                };
                                IGeneratorNode _generateNativeFunctionCallChecked = StatementGenerator.this.generateNativeFunctionCallChecked((NativeFunctionDefinition)ref, (IGeneratorNode)StatementGenerator.this.codeFragmentProvider.create(_client), (ArgumentExpression)stmt);
                                _builder.append((Object)_generateNativeFunctionCallChecked);
                            }
                        }) : (_client_3 = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                IGeneratorNode _generateNativeFunctionCallUnchecked = StatementGenerator.this.generateNativeFunctionCallUnchecked((NativeFunctionDefinition)ref, (ArgumentExpression)stmt);
                                _builder.append((Object)_generateNativeFunctionCallUnchecked);
                            }
                        });
                        _xifexpression_3 = _xifexpression_4;
                    } else {
                        StringConcatenationClient _xifexpression_5 = null;
                        if (ref instanceof StructureType) {
                            StringConcatenationClient _client_4;
                            StringConcatenationClient _xblockexpression_1 = null;
                            ProgramBlock _containerOfType = (ProgramBlock)EcoreUtil2.getContainerOfType((EObject)stmt, ProgramBlock.class);
                            final boolean needCast = _containerOfType != null;
                            _xifexpression_5 = _xblockexpression_1 = (_client_4 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    if (needCast) {
                                        _builder.append((Object)"(");
                                        String _baseName = StatementGenerator.this._generatorUtils.getBaseName(ref);
                                        _builder.append((Object)_baseName);
                                        _builder.append((Object)") ");
                                    }
                                    _builder.append((Object)"{");
                                    _builder.newLineIfNotEmpty();
                                    Iterable _indexed = IterableExtensions.indexed((Iterable)stmt.getArguments());
                                    boolean _hasElements = false;
                                    for (Pair i_arg : _indexed) {
                                        boolean _tripleNotEquals;
                                        if (!_hasElements) {
                                            _hasElements = true;
                                        } else {
                                            _builder.appendImmediate((Object)",\n", "\t");
                                        }
                                        _builder.append((Object)"\t");
                                        _builder.append((Object)".");
                                        Parameter _parameter = ((Argument)i_arg.getValue()).getParameter();
                                        boolean bl = _tripleNotEquals = _parameter != null;
                                        if (_tripleNotEquals) {
                                            String _name = ((Argument)i_arg.getValue()).getParameter().getName();
                                            _builder.append((Object)_name, "\t");
                                        } else {
                                            String _name_1 = ((Parameter)((StructureType)ref).getParameters().get(((Integer)i_arg.getKey()).intValue())).getName();
                                            _builder.append((Object)_name_1, "\t");
                                        }
                                        _builder.append((Object)" = ");
                                        IGeneratorNode _code = StatementGenerator.this.code((EObject)((Argument)i_arg.getValue()).getValue());
                                        _builder.append((Object)_code, "\t");
                                        _builder.newLineIfNotEmpty();
                                    }
                                    _builder.append((Object)"}");
                                }
                            });
                        } else {
                            StringConcatenationClient _client_4;
                            _xifexpression_5 = _client_4 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)"!UNKNOWN REF < EOBJECT!");
                                }
                            };
                        }
                        _xifexpression_3 = _xifexpression_5;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            StringConcatenationClient _xifexpression_6 = null;
            if (stmt.isArrayAccess() && !(IterableExtensions.head((Iterable)stmt.getArraySelector()) instanceof ValueRange)) {
                _xifexpression_6 = null;
            } else {
                StringConcatenationClient _xifexpression_7 = null;
                if (id == null) {
                    StringConcatenationClient _client_6;
                    StringConcatenationClient _client_5;
                    StringConcatenationClient _xblockexpression_2 = null;
                    Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                        public Boolean apply(EStructuralFeature x) {
                            String _name = x.getName();
                            return Objects.equal((Object)_name, (Object)"name");
                        }
                    };
                    final EStructuralFeature nameFeature = (EStructuralFeature)IterableExtensions.findFirst((Iterable)stmt.getReference().eClass().getEAllStructuralFeatures(), (Functions.Function1)_function);
                    StringConcatenationClient _xifexpression_8 = null;
                    _xifexpression_8 = nameFeature == null ? (_client_5 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"/* unidentified element ");
                            EObject _reference = stmt.getReference();
                            _builder.append((Object)_reference);
                            _builder.append((Object)" */");
                        }
                    }) : (_client_6 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            Object _eGet = stmt.getReference().eGet(nameFeature);
                            _builder.append(_eGet);
                        }
                    });
                    _xifexpression_7 = _xblockexpression_2 = _xifexpression_8;
                } else {
                    StringConcatenationClient _client_5;
                    _xifexpression_7 = _client_5 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)id);
                        }
                    };
                }
                _xifexpression_6 = _xifexpression_7;
            }
            _xifexpression = _xifexpression_6;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final DereferenceExpression e) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"(*");
                IGeneratorNode _code = StatementGenerator.this.code((EObject)e.getExpression());
                _builder.append((Object)_code);
                _builder.append((Object)")");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ReferenceExpression e) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"(&");
                IGeneratorNode _code = StatementGenerator.this.code((EObject)e.getVariable());
                _builder.append((Object)_code);
                _builder.append((Object)")");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ReturnStatement stmt) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        Expression _value = stmt.getValue();
        final boolean hasValue = _value != null;
        AbstractTypeGenerator _generatedTypeGenerator = null;
        TypeSpecifier _resultType = null;
        if (hasValue) {
            Type expressionType;
            Expression value = stmt.getValue();
            ITypeSystemInferrer.InferenceResult inference = this.typeInferrer.infer((EObject)value);
            Type _type = null;
            if (inference != null) {
                _type = inference.getType();
            }
            if ((expressionType = _type) instanceof GeneratedType) {
                _generatedTypeGenerator = this.registry.getGenerator((GeneratedType)expressionType);
                _resultType = ModelUtils.toSpecifier(inference);
            }
        }
        final AbstractTypeGenerator generatedTypeGenerator = _generatedTypeGenerator;
        final TypeSpecifier resultType = _resultType;
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (hasValue && generatedTypeGenerator != null) {
                    CodeFragment _generateExpression = generatedTypeGenerator.generateExpression(resultType, stmt, AssignmentOperator.ASSIGN, (EObject)stmt.getValue());
                    _builder.append((Object)_generateExpression);
                    _builder.newLineIfNotEmpty();
                } else if (hasValue) {
                    _builder.append((Object)"*_result = ");
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getValue()));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                boolean _isInTryCatchFinally = ModelUtils.isInTryCatchFinally(stmt);
                if (_isInTryCatchFinally) {
                    _builder.append((Object)"returnFromWithinTryCatch = true;");
                    _builder.newLine();
                    _builder.append((Object)"break;");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                }
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final AssignmentExpression stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.initializationCode((EObject)stmt));
                _builder.append((Object)_noTerminator);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final InterpolatedStringExpression stmt) {
        try {
            Type type;
            final TypeSpecifier typeSpec = ModelUtils.toSpecifier(this.typeInferrer.infer((EObject)stmt));
            Type _type = null;
            if (typeSpec != null) {
                _type = typeSpec.getType();
            }
            if ((type = _type) instanceof GeneratedType) {
                final AbstractTypeGenerator generator = this.registry.getGenerator((GeneratedType)type);
                if (generator != null && generator.checkExpressionSupport(typeSpec, null, null)) {
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            CodeFragment _generateExpression = generator.generateExpression(typeSpec, (EObject)stmt, null, null);
                            _builder.append((Object)_generateExpression);
                        }
                    };
                    return _client;
                }
                Status _status = new Status(4, "org.eclipse.mita.program", "String generator does not support inline interpolation");
                throw new CoreException((IStatus)_status);
            }
            Status _status_1 = new Status(4, "org.eclipse.mita.program", "Interpolated strings should be a generated type");
            throw new CoreException((IStatus)_status_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public StringConcatenationClient __code(final Expression stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/* ERROR: unsupported expression ");
                _builder.append((Object)stmt);
                _builder.append((Object)" */");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ExpressionStatement stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getExpression()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)";");
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final IfStatement stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _tripleNotEquals;
                _builder.append((Object)"if(");
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getCondition()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                IGeneratorNode _code = StatementGenerator.this.code(stmt.getThen());
                _builder.append((Object)_code);
                _builder.newLineIfNotEmpty();
                EList<ConditionalStatement> _elseIf = stmt.getElseIf();
                for (ConditionalStatement elif : _elseIf) {
                    _builder.append((Object)"else if(");
                    IGeneratorNode _noTerminator_1 = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)elif.getCondition()));
                    _builder.append((Object)_noTerminator_1);
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    IGeneratorNode _code_1 = StatementGenerator.this.code(elif.getThen());
                    _builder.append((Object)_code_1);
                    _builder.newLineIfNotEmpty();
                }
                ProgramBlock _else = stmt.getElse();
                boolean bl = _tripleNotEquals = _else != null;
                if (_tripleNotEquals) {
                    _builder.append((Object)"else");
                    _builder.newLine();
                    IGeneratorNode _code_2 = StatementGenerator.this.code(stmt.getElse());
                    _builder.append((Object)_code_2);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ThrowExceptionStatement stmt) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isInTryCatchFinally = ModelUtils.isInTryCatchFinally(stmt);
        _xifexpression = _isInTryCatchFinally ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"// THROW ");
                String _name = stmt.getExceptionType().getName();
                _builder.append((Object)_name);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = ");
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        String _baseName = (this).StatementGenerator.this._generatorUtils.getBaseName(stmt.getExceptionType());
                        _builder.append((Object)_baseName);
                    }
                };
                CodeFragment _addHeader = StatementGenerator.this.codeFragmentProvider.create(_client).addHeader("MitaExceptions.h", true);
                _builder.append((Object)_addHeader);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"break;");
                _builder.newLine();
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"// THROW ");
                String _name = stmt.getExceptionType().getName();
                _builder.append((Object)_name);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"return ");
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        String _baseName = (this).StatementGenerator.this._generatorUtils.getBaseName(stmt.getExceptionType());
                        _builder.append((Object)_baseName);
                    }
                };
                CodeFragment _addHeader = StatementGenerator.this.codeFragmentProvider.create(_client).addHeader("MitaExceptions.h", true);
                _builder.append((Object)_addHeader);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        });
        return _xifexpression;
    }

    public StringConcatenationClient __code(final TryStatement stmt) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _xblockexpression = null;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"bool");
            }
        };
        CodeFragment bool = this.codeFragmentProvider.create(_client).addHeader("stdbool.h", true);
        _xblockexpression = _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _tripleNotEquals;
                _builder.append((Object)"// TRY");
                _builder.newLine();
                _builder.append((Object)"returnFromWithinTryCatch = false;");
                _builder.newLine();
                _builder.append((Object)"do");
                _builder.newLine();
                IGeneratorNode _code = StatementGenerator.this.code(stmt.getTry());
                _builder.append((Object)_code);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"while(false);");
                _builder.newLine();
                Iterable _indexed = IterableExtensions.indexed(stmt.getCatchStatements());
                for (Pair idx_catchStmt : _indexed) {
                    boolean _greaterThan;
                    _builder.append((Object)"// CATCH ");
                    String _name = ((CatchStatement)idx_catchStmt.getValue()).getExceptionType().getName();
                    _builder.append((Object)_name);
                    _builder.newLineIfNotEmpty();
                    Integer _key = (Integer)idx_catchStmt.getKey();
                    boolean bl = _greaterThan = _key > 0;
                    if (_greaterThan) {
                        _builder.append((Object)"else ");
                    }
                    _builder.append((Object)"if(exception ");
                    String _name_1 = ((CatchStatement)idx_catchStmt.getValue()).getExceptionType().getName();
                    boolean _equals = Objects.equal((Object)_name_1, (Object)"Exception");
                    if (_equals) {
                        _builder.append((Object)"!= NO_EXCEPTION");
                    } else {
                        _builder.append((Object)"== ");
                        String _baseName = StatementGenerator.this._generatorUtils.getBaseName(((CatchStatement)idx_catchStmt.getValue()).getExceptionType());
                        _builder.append((Object)_baseName);
                    }
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = NO_EXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"do");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    IGeneratorNode _code_1 = StatementGenerator.this.code(((CatchStatement)idx_catchStmt.getValue()).getBody());
                    _builder.append((Object)_code_1, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"while(");
                    _builder.append((Object)false, "\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                ProgramBlock _finally = stmt.getFinally();
                boolean bl = _tripleNotEquals = _finally != null;
                if (_tripleNotEquals) {
                    _builder.append((Object)"// FINALLY");
                    _builder.newLine();
                    _builder.append((Object)"do");
                    _builder.newLine();
                    IGeneratorNode _code_2 = StatementGenerator.this.code(stmt.getFinally());
                    _builder.append((Object)_code_2);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"while(false);");
                    _builder.newLine();
                }
                _builder.append((Object)"if(returnFromWithinTryCatch || exception != NO_EXCEPTION) {");
                _builder.newLine();
                boolean _isInTryCatchFinally = ModelUtils.isInTryCatchFinally(stmt.eContainer());
                if (_isInTryCatchFinally) {
                    _builder.append((Object)"break;");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final WhileStatement stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"while(");
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getCondition()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                IGeneratorNode _code = StatementGenerator.this.code(stmt.getBody());
                _builder.append((Object)_code);
                _builder.newLineIfNotEmpty();
                boolean _isInTryCatchFinally = ModelUtils.isInTryCatchFinally(stmt);
                if (_isInTryCatchFinally) {
                    _builder.append((Object)"if(exception != NO_EXCEPTION) break;");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ForStatement stmt) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final IGeneratorNode condition = this._generatorUtils.noTerminator(this.code((EObject)stmt.getCondition()));
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"for(");
                EList<VariableDeclaration> _loopVariables = stmt.getLoopVariables();
                boolean _hasElements = false;
                for (VariableDeclaration x : _loopVariables) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)" ,", "");
                    }
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code(x));
                    _builder.append((Object)_noTerminator);
                }
                _builder.append((Object)"; ");
                _builder.append((Object)condition);
                _builder.append((Object)"; ");
                EList<Expression> _postLoopStatements = stmt.getPostLoopStatements();
                boolean _hasElements_1 = false;
                for (Expression x_1 : _postLoopStatements) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)" ,", "");
                    }
                    IGeneratorNode _noTerminator_1 = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)x_1));
                    _builder.append((Object)_noTerminator_1);
                }
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                IGeneratorNode _code = StatementGenerator.this.code(stmt.getBody());
                _builder.append((Object)_code);
                _builder.newLineIfNotEmpty();
                boolean _isInTryCatchFinally = ModelUtils.isInTryCatchFinally(stmt);
                if (_isInTryCatchFinally) {
                    _builder.append((Object)"if(exception != NO_EXCEPTION) break;");
                    _builder.newLine();
                }
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(ForEachStatement stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"// ERROR: for-each statements are not supported yet");
                _builder.newLine();
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final DoWhileStatement stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"do ");
                _builder.newLine();
                IGeneratorNode _code = StatementGenerator.this.code(stmt.getBody());
                _builder.append((Object)_code);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"while(");
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getCondition()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                boolean _isInTryCatchFinally = ModelUtils.isInTryCatchFinally(stmt);
                if (_isInTryCatchFinally) {
                    _builder.append((Object)"if(exception != NO_EXCEPTION) break;");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ConditionalExpression it) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)it.getCondition()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)" ? ");
                IGeneratorNode _noTerminator_1 = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)it.getTrueCase()));
                _builder.append((Object)_noTerminator_1);
                _builder.append((Object)" : ");
                IGeneratorNode _code = StatementGenerator.this.code((EObject)it.getFalseCase());
                _builder.append((Object)_code);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final ProgramBlock stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"{");
                _builder.newLine();
                EList<AbstractStatement> _content = stmt.getContent();
                boolean _hasElements = false;
                for (AbstractStatement x : _content) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)"\n", "\t");
                    }
                    _builder.append((Object)"\t");
                    IGeneratorNode _code = StatementGenerator.this.code(x);
                    _builder.append((Object)_code, "\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final FunctionDefinition stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.header((EObject)stmt));
                _builder.append((Object)_noTerminator);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                IGeneratorNode _noBraces = StatementGenerator.this._generatorUtils.noBraces(StatementGenerator.this.code(stmt.getBody()));
                _builder.append((Object)_noBraces);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final SourceCodeComment stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/*");
                _builder.newLine();
                String _content = stmt.getContent();
                _builder.append((Object)_content);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"*/");
                _builder.newLine();
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final AbstractStatement stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Unsuported statement: ");
                _builder.append((Object)stmt);
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final WhereIsStatement stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"switch(");
                IGeneratorNode _code = StatementGenerator.this.code((EObject)stmt.getMatchElement());
                _builder.append((Object)_code);
                _builder.append((Object)".tag) {");
                _builder.newLineIfNotEmpty();
                EList<IsCase> _isCases = stmt.getIsCases();
                for (IsCase isCase : _isCases) {
                    _builder.append((Object)"\t");
                    IGeneratorNode _code_1 = StatementGenerator.this.code(isCase);
                    _builder.append((Object)_code_1, "\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final IsTypeMatchCase stmt) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final SumAlternative varType = stmt.getProductType();
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"case ");
                CodeFragment _enumName = StatementGenerator.this._generatorUtils.getEnumName((ComplexType)varType);
                _builder.append((Object)_enumName);
                _builder.append((Object)": {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                IGeneratorNode _noBraces = StatementGenerator.this._generatorUtils.noBraces(StatementGenerator.this.code(stmt.getBody()));
                _builder.append((Object)_noBraces, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final IsAssignmentCase stmt) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final TypeSpecifier varTypeSpec = stmt.getAssignmentVariable().getTypeSpecifier();
        Type _type = varTypeSpec.getType();
        final SumAlternative varType = (SumAlternative)_type;
        EObject _eContainer = stmt.eContainer();
        final WhereIsStatement where = (WhereIsStatement)_eContainer;
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"case ");
                CodeFragment _enumName = StatementGenerator.this._generatorUtils.getEnumName((ComplexType)varType);
                _builder.append((Object)_enumName);
                _builder.append((Object)": {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                CodeFragment _ctype = StatementGenerator.this.getCtype(varTypeSpec);
                _builder.append((Object)_ctype, "\t");
                _builder.append((Object)" ");
                String _name = stmt.getAssignmentVariable().getName();
                _builder.append((Object)_name, "\t");
                _builder.append((Object)" = ");
                IGeneratorNode _code = StatementGenerator.this.code((EObject)where.getMatchElement());
                _builder.append((Object)_code, "\t");
                _builder.append((Object)".data.");
                CodeFragment _structName = StatementGenerator.this._generatorUtils.getStructName((ComplexType)varType);
                _builder.append((Object)_structName, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                IGeneratorNode _noBraces = StatementGenerator.this._generatorUtils.noBraces(StatementGenerator.this.code(stmt.getBody()));
                _builder.append((Object)_noBraces, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final IsDeconstructionCase stmt) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final SumAlternative varType = stmt.getProductType();
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"case ");
                CodeFragment _enumName = StatementGenerator.this._generatorUtils.getEnumName((ComplexType)varType);
                _builder.append((Object)_enumName);
                _builder.append((Object)": {");
                _builder.newLineIfNotEmpty();
                EList<IsDeconstructor> _deconstructors = stmt.getDeconstructors();
                for (IsDeconstructor deconstructor : _deconstructors) {
                    _builder.append((Object)"\t");
                    IGeneratorNode _code = StatementGenerator.this.code(deconstructor);
                    _builder.append((Object)_code, "\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                IGeneratorNode _noBraces = StatementGenerator.this._generatorUtils.noBraces(StatementGenerator.this.code(stmt.getBody()));
                _builder.append((Object)_noBraces, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final IsOtherCase stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"default: {");
                _builder.newLine();
                _builder.append((Object)"\t");
                IGeneratorNode _noBraces = StatementGenerator.this._generatorUtils.noBraces(StatementGenerator.this.code(stmt.getBody()));
                _builder.append((Object)_noBraces, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    public StringConcatenationClient __code(final IsDeconstructor stmt) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final TypeSpecifier varTypeSpec = this.inferType(stmt);
        EObject _eContainer = stmt.eContainer();
        IsDeconstructionCase isDeconstructionCase = (IsDeconstructionCase)_eContainer;
        SumAlternative isDeconstructionCaseType = isDeconstructionCase.getProductType();
        EObject _eContainer_1 = isDeconstructionCase.eContainer();
        final WhereIsStatement where = (WhereIsStatement)_eContainer_1;
        final CodeFragment altAccessor = this._generatorUtils.getStructName((ComplexType)isDeconstructionCaseType);
        int idx = isDeconstructionCase.getDeconstructors().indexOf((Object)stmt);
        SumAlternative productType = isDeconstructionCase.getProductType();
        Type _realType = isDeconstructionCaseType.realType();
        final boolean hasAccessors = _realType instanceof HasAccessors;
        String _xifexpression = null;
        if (hasAccessors) {
            _xifexpression = this.accessor(productType, stmt.getProductMember(), ".", "").apply(idx);
        }
        final String member = _xifexpression;
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _ctype = StatementGenerator.this.getCtype(varTypeSpec);
                _builder.append((Object)_ctype);
                _builder.append((Object)" ");
                String _name = stmt.getName();
                _builder.append((Object)_name);
                _builder.append((Object)" = ");
                IGeneratorNode _code = StatementGenerator.this.code((EObject)where.getMatchElement());
                _builder.append((Object)_code);
                _builder.append((Object)".data.");
                _builder.append((Object)altAccessor);
                if (hasAccessors) {
                    _builder.append((Object)member);
                }
                _builder.append((Object)";");
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __code(final LoopBreakerStatement stmt) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if(");
                IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)stmt.getCondition()));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"// loop condition still holds: continue the loop");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"// loop condition no longer holds: break the loop");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    public StringConcatenationClient __header(final FunctionDefinition definition) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final TypeSpecifier resultType = this.inferType((EObject)definition);
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _not;
                CodeFragment _exceptionType = StatementGenerator.this.exceptionGenerator.getExceptionType();
                _builder.append((Object)_exceptionType);
                _builder.append((Object)" ");
                String _baseName = StatementGenerator.this._generatorUtils.getBaseName(definition);
                _builder.append((Object)_baseName);
                _builder.append((Object)"(");
                CodeFragment _ctype = StatementGenerator.this.getCtype(resultType);
                _builder.append((Object)_ctype);
                _builder.append((Object)"* _result");
                boolean _isEmpty = definition.getParameters().isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append((Object)", ");
                }
                EList _parameters = definition.getParameters();
                boolean _hasElements = false;
                for (Parameter x : _parameters) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    CodeFragment _ctype_1 = StatementGenerator.this.getCtype(StatementGenerator.this.inferType((EObject)x));
                    _builder.append((Object)_ctype_1);
                    _builder.append((Object)" ");
                    String _name = x.getName();
                    _builder.append((Object)_name);
                }
                _builder.append((Object)");");
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient _structureTypeCodeReal(EObject obj, final List<Pair<CodeFragment, String>> typesAndNames, final CodeFragment typeName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"typedef struct {");
                _builder.newLine();
                for (Pair field : typesAndNames) {
                    _builder.append((Object)"\t");
                    CodeFragment _key = (CodeFragment)((Object)field.getKey());
                    _builder.append((Object)_key, "\t");
                    _builder.append((Object)" ");
                    String _value = (String)field.getValue();
                    _builder.append((Object)_value, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"} ");
                _builder.append((Object)typeName);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        };
        return _client;
    }

    public StringConcatenationClient __header(final SumType definition) {
        StringConcatenationClient _client;
        Functions.Function1<SumAlternative, Boolean> _function_1;
        StringConcatenationClient _xblockexpression = null;
        Functions.Function1<SumAlternative, Boolean> _function = new Functions.Function1<SumAlternative, Boolean>(){

            public Boolean apply(SumAlternative it) {
                return !(it instanceof Singleton);
            }
        };
        final Iterable nonSingletonAlternatives = IterableExtensions.filter((Iterable)definition.getAlternatives(), (Functions.Function1)_function);
        Functions.Function1<SumAlternative, Boolean> hasOneMember = _function_1 = new Functions.Function1<SumAlternative, Boolean>(){

            public Boolean apply(SumAlternative alt) {
                if (alt instanceof AnonymousProductType) {
                    int _length = ((Object[])Conversions.unwrapArray((Object)((AnonymousProductType)alt).getTypeSpecifiers(), Object.class)).length;
                    if (_length == 1) {
                        return true;
                    }
                    return false;
                }
                return false;
            }
        };
        _xblockexpression = _client = new StringConcatenationClient((Functions.Function1)hasOneMember){
            private final /* synthetic */ Functions.Function1 val$hasOneMember;
            {
                this.val$hasOneMember = function1;
            }

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _filter = Iterables.filter((Iterable)definition.getAlternatives(), NamedProductType.class);
                for (NamedProductType alternative : _filter) {
                    IGeneratorNode _structureTypeCodeDecl = StatementGenerator.this.structureTypeCodeDecl((EObject)alternative, (List<Parameter>)alternative.getParameters(), StatementGenerator.this._generatorUtils.getStructType((ComplexType)alternative));
                    _builder.append((Object)_structureTypeCodeDecl);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                Iterable _filter_1 = Iterables.filter((Iterable)definition.getAlternatives(), AnonymousProductType.class);
                for (AnonymousProductType alternative_1 : _filter_1) {
                    boolean _greaterThan;
                    int _length = ((Object[])Conversions.unwrapArray((Object)alternative_1.getTypeSpecifiers(), Object.class)).length;
                    boolean bl = _greaterThan = _length > 1;
                    if (!_greaterThan) continue;
                    Functions.Function1<Pair<Integer, TypeSpecifier>, Pair<CodeFragment, String>> _function = new Functions.Function1<Pair<Integer, TypeSpecifier>, Pair<CodeFragment, String>>(){

                        public Pair<CodeFragment, String> apply(Pair<Integer, TypeSpecifier> it) {
                            CodeFragment _ctype = StatementGenerator.this.getCtype(StatementGenerator.this.inferType((EObject)it.getValue()));
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("_");
                            Integer _key = (Integer)it.getKey();
                            _builder.append((Object)_key);
                            return new Pair((Object)_ctype, (Object)_builder.toString());
                        }
                    };
                    IGeneratorNode _structureTypeCodeReal = StatementGenerator.this.structureTypeCodeReal((EObject)alternative_1, IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.indexed((Iterable)alternative_1.getTypeSpecifiers()), (Functions.Function1)_function)), StatementGenerator.this._generatorUtils.getStructType((ComplexType)alternative_1));
                    _builder.append((Object)_structureTypeCodeReal);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append((Object)"typedef enum {");
                _builder.newLine();
                EList _alternatives = definition.getAlternatives();
                boolean _hasElements = false;
                for (SumAlternative alternative_2 : _alternatives) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t");
                    }
                    _builder.append((Object)"\t");
                    CodeFragment _enumName = StatementGenerator.this._generatorUtils.getEnumName((ComplexType)alternative_2);
                    _builder.append((Object)_enumName, "\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"} ");
                CodeFragment _enumName_1 = StatementGenerator.this._generatorUtils.getEnumName((ComplexType)definition);
                _builder.append((Object)_enumName_1);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"typedef struct {");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _enumName_2 = StatementGenerator.this._generatorUtils.getEnumName((ComplexType)definition);
                _builder.append((Object)_enumName_2, "\t");
                _builder.append((Object)" tag;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"union {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                for (SumAlternative alternative_3 : nonSingletonAlternatives) {
                    Boolean _apply = (Boolean)this.val$hasOneMember.apply((Object)alternative_3);
                    if (_apply.booleanValue()) {
                        CodeFragment _ctype = StatementGenerator.this.getCtype((TypeSpecifier)IterableExtensions.head((Iterable)((AnonymousProductType)alternative_3).getTypeSpecifiers()));
                        _builder.append((Object)_ctype, "\t\t");
                    } else {
                        CodeFragment _structType = StatementGenerator.this._generatorUtils.getStructType((ComplexType)alternative_3);
                        _builder.append((Object)_structType, "\t\t");
                    }
                    _builder.append((Object)" ");
                    CodeFragment _structName = StatementGenerator.this._generatorUtils.getStructName((ComplexType)alternative_3);
                    _builder.append((Object)_structName, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"} data;");
                _builder.newLine();
                _builder.append((Object)"} ");
                CodeFragment _structName_1 = StatementGenerator.this._generatorUtils.getStructName((ComplexType)definition);
                _builder.append((Object)_structName_1);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient __header(final EnumerationType definition) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"typedef enum {");
                _builder.newLine();
                _builder.append((Object)"\t");
                EList _enumerator = definition.getEnumerator();
                boolean _hasElements = false;
                for (Enumerator item : _enumerator) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",\n", "\t");
                    }
                    String _baseName = StatementGenerator.this._generatorUtils.getBaseName(item);
                    _builder.append((Object)_baseName, "\t");
                }
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"} ");
                String _baseName_1 = StatementGenerator.this._generatorUtils.getBaseName(definition);
                _builder.append((Object)_baseName_1);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        };
        return _client;
    }

    public StringConcatenationClient _generateNativeFunctionCallChecked(NativeFunctionDefinition op, IGeneratorNode firstArg, ArgumentExpression args) {
        IGeneratorNode _generateFunctionCall = this.generateFunctionCall(op, firstArg, args);
        final CodeFragment call = this.codeFragmentProvider.create((CompositeGeneratorNode)_generateFunctionCall).addHeader(op.getHeader(), true);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)call);
            }
        };
        return _client;
    }

    public StringConcatenationClient _generateNativeFunctionCallUnchecked(final NativeFunctionDefinition op, final ArgumentExpression args) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = op.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"(");
                Iterable<Argument> _sortedArguments = ModelUtils.getSortedArguments((Iterable<Parameter>)op.getParameters(), (Iterable<Argument>)args.getArguments());
                boolean _hasElements = false;
                for (Argument arg : _sortedArguments) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)arg.getValue()));
                    _builder.append((Object)_noTerminator);
                }
                _builder.append((Object)")");
            }
        };
        final CodeFragment call = this.codeFragmentProvider.create(_client).addHeader(op.getHeader(), true);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)call);
            }
        };
        return _client_1;
    }

    public StringConcatenationClient _generateFunctionCall(final Operation op, final IGeneratorNode firstArg, final ArgumentExpression args) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"exception = ");
                String _baseName = StatementGenerator.this._generatorUtils.getBaseName(op);
                _builder.append((Object)_baseName);
                _builder.append((Object)"(");
                if (firstArg != null) {
                    boolean _not;
                    IGeneratorNode _noTerminator = StatementGenerator.this._generatorUtils.noTerminator(firstArg);
                    _builder.append((Object)_noTerminator);
                    boolean _isEmpty = args.getArguments().isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        _builder.append((Object)", ");
                    }
                }
                Iterable<Argument> _sortedArguments = ModelUtils.getSortedArguments((Iterable<Parameter>)op.getParameters(), (Iterable<Argument>)args.getArguments());
                boolean _hasElements = false;
                for (Argument arg : _sortedArguments) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    IGeneratorNode _noTerminator_1 = StatementGenerator.this._generatorUtils.noTerminator(StatementGenerator.this.code((EObject)arg.getValue()));
                    _builder.append((Object)_noTerminator_1);
                }
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler = StatementGenerator.this._generatorUtils.generateExceptionHandler((EObject)args, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        return _client;
    }
}

